/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.ConcurrentLinkedHashCache;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService
implements CacheServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=Caches";
    public static final int AVERAGE_KEY_CACHE_ROW_SIZE = 48;
    public static final CacheService instance = new CacheService();
    public final AutoSavingCache<KeyCacheKey, Long> keyCache;
    public final AutoSavingCache<RowCacheKey, ColumnFamily> rowCache;
    private int rowCacheSavePeriod;
    private int keyCacheSavePeriod;

    private CacheService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.rowCacheSavePeriod = DatabaseDescriptor.getRowCacheSavePeriod();
        this.keyCacheSavePeriod = DatabaseDescriptor.getKeyCacheSavePeriod();
        this.keyCache = this.initKeyCache();
        this.rowCache = this.initRowCache();
    }

    private AutoSavingCache<KeyCacheKey, Long> initKeyCache() {
        logger.info("Initializing key cache with capacity of {} MBs.", (Object)DatabaseDescriptor.getKeyCacheSizeInMB());
        int keyCacheInMemoryCapacity = DatabaseDescriptor.getKeyCacheSizeInMB() * 1024 * 1024;
        ConcurrentLinkedHashCache kc = ConcurrentLinkedHashCache.create(keyCacheInMemoryCapacity / 48);
        AutoSavingCache<KeyCacheKey, Long> keyCache = new AutoSavingCache<KeyCacheKey, Long>(kc, CacheType.KEY_CACHE);
        int keyCacheKeysToSave = DatabaseDescriptor.getKeyCacheKeysToSave();
        logger.info("Scheduling key cache save to each {} seconds (going to save {} keys).", (Object)this.keyCacheSavePeriod, keyCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(keyCacheKeysToSave));
        keyCache.scheduleSaving(this.keyCacheSavePeriod, keyCacheKeysToSave);
        return keyCache;
    }

    private AutoSavingCache<RowCacheKey, ColumnFamily> initRowCache() {
        logger.info("Initializing row cache with capacity of {} MBs and provider {}", (Object)DatabaseDescriptor.getRowCacheSizeInMB(), (Object)DatabaseDescriptor.getRowCacheProvider().getClass().getName());
        int rowCacheInMemoryCapacity = DatabaseDescriptor.getRowCacheSizeInMB() * 1024 * 1024;
        ICache<RowCacheKey, ColumnFamily> rc = DatabaseDescriptor.getRowCacheProvider().create(rowCacheInMemoryCapacity, true);
        AutoSavingCache<RowCacheKey, ColumnFamily> rowCache = new AutoSavingCache<RowCacheKey, ColumnFamily>(rc, CacheType.ROW_CACHE);
        int rowCacheKeysToSave = DatabaseDescriptor.getRowCacheKeysToSave();
        logger.info("Scheduling row cache save to each {} seconds (going to save {} keys).", (Object)this.rowCacheSavePeriod, rowCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(rowCacheKeysToSave));
        rowCache.scheduleSaving(this.rowCacheSavePeriod, rowCacheKeysToSave);
        return rowCache;
    }

    @Override
    public long getKeyCacheHits() {
        return this.keyCache.getHits();
    }

    @Override
    public long getRowCacheHits() {
        return this.rowCache.getHits();
    }

    @Override
    public long getKeyCacheRequests() {
        return this.keyCache.getRequests();
    }

    @Override
    public long getRowCacheRequests() {
        return this.rowCache.getRequests();
    }

    @Override
    public double getKeyCacheRecentHitRate() {
        return this.keyCache.getRecentHitRate();
    }

    @Override
    public double getRowCacheRecentHitRate() {
        return this.rowCache.getRecentHitRate();
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSavePeriod;
    }

    @Override
    public void setRowCacheSavePeriodInSeconds(int rcspis) {
        if (rcspis < 0) {
            throw new RuntimeException("RowCacheSavePeriodInSeconds must be non-negative.");
        }
        this.rowCacheSavePeriod = rcspis;
        this.rowCache.scheduleSaving(this.rowCacheSavePeriod, DatabaseDescriptor.getRowCacheKeysToSave());
    }

    @Override
    public int getKeyCacheSavePeriodInSeconds() {
        return this.keyCacheSavePeriod;
    }

    @Override
    public void setKeyCacheSavePeriodInSeconds(int kcspis) {
        if (kcspis < 0) {
            throw new RuntimeException("KeyCacheSavePeriodInSeconds must be non-negative.");
        }
        this.keyCacheSavePeriod = kcspis;
        this.keyCache.scheduleSaving(this.keyCacheSavePeriod, DatabaseDescriptor.getKeyCacheKeysToSave());
    }

    @Override
    public void invalidateKeyCache() {
        this.keyCache.clear();
    }

    @Override
    public void invalidateRowCache() {
        this.rowCache.clear();
    }

    @Override
    public int getRowCacheCapacityInBytes() {
        return this.rowCache.getCapacity();
    }

    @Override
    public int getRowCacheCapacityInMB() {
        return this.getRowCacheCapacityInBytes() / 1024 / 1024;
    }

    @Override
    public void setRowCacheCapacityInMB(int capacity) {
        if (capacity < 0) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.rowCache.setCapacity(capacity * 1024 * 1024);
    }

    @Override
    public int getKeyCacheCapacityInBytes() {
        return this.keyCache.getCapacity() * 48;
    }

    @Override
    public int getKeyCacheCapacityInMB() {
        return this.getKeyCacheCapacityInBytes() / 1024 / 1024;
    }

    @Override
    public void setKeyCacheCapacityInMB(int capacity) {
        if (capacity < 0) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.keyCache.setCapacity(capacity * 1024 * 1024 / 48);
    }

    @Override
    public int getRowCacheSize() {
        return this.rowCache.weightedSize();
    }

    @Override
    public int getKeyCacheSize() {
        return this.keyCache.weightedSize() * 48;
    }

    @Override
    public void reduceCacheSizes() {
        this.reduceRowCacheSize();
        this.reduceKeyCacheSize();
    }

    public void reduceRowCacheSize() {
        this.rowCache.reduceCacheSize();
    }

    public void reduceKeyCacheSize() {
        this.keyCache.reduceCacheSize();
    }

    @Override
    public void saveCaches() throws ExecutionException, InterruptedException {
        ArrayList futures = new ArrayList();
        logger.debug("submitting cache saves");
        futures.add(this.keyCache.submitWrite(DatabaseDescriptor.getKeyCacheKeysToSave()));
        futures.add(this.rowCache.submitWrite(DatabaseDescriptor.getRowCacheKeysToSave()));
        FBUtilities.waitOnFutures(futures);
        logger.debug("cache saves completed");
    }

    public static enum CacheType {
        KEY_CACHE("KeyCache"),
        ROW_CACHE("RowCache");

        private final String name;

        private CacheType(String typeName) {
            this.name = typeName;
        }

        public String toString() {
            return this.name;
        }
    }
}

