/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterMutationVerbHandler;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefinitionsUpdateVerbHandler;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.MigrationRequestVerbHandler;
import org.apache.cassandra.db.ReadRepairVerbHandler;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.RowMutationVerbHandler;
import org.apache.cassandra.db.SchemaCheckVerbHandler;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.TruncateVerbHandler;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.StringToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigestAck2VerbHandler;
import org.apache.cassandra.gms.GossipDigestAckVerbHandler;
import org.apache.cassandra.gms.GossipDigestSynVerbHandler;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ResponseVerbHandler;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.IndexScanVerbHandler;
import org.apache.cassandra.service.LoadBroadcaster;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.RangeSliceVerbHandler;
import org.apache.cassandra.service.SnapshotVerbHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.ReplicationFinishedVerbHandler;
import org.apache.cassandra.streaming.StreamIn;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamReplyVerbHandler;
import org.apache.cassandra.streaming.StreamRequestVerbHandler;
import org.apache.cassandra.streaming.StreamingRepairTask;
import org.apache.cassandra.streaming.StreamingService;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService
implements IEndpointStateChangeSubscriber,
StorageServiceMBean {
    private static Logger logger_ = LoggerFactory.getLogger(StorageService.class);
    public static final int RING_DELAY = StorageService.getRingDelay();
    public static final Verb[] VERBS = Verb.values();
    public static final EnumMap<Verb, Stage> verbStages = new EnumMap<Verb, Stage>(Verb.class){
        {
            this.put(Verb.MUTATION, Stage.MUTATION);
            this.put(Verb.BINARY, Stage.MUTATION);
            this.put(Verb.READ_REPAIR, Stage.MUTATION);
            this.put(Verb.TRUNCATE, Stage.MUTATION);
            this.put(Verb.READ, Stage.READ);
            this.put(Verb.REQUEST_RESPONSE, Stage.REQUEST_RESPONSE);
            this.put(Verb.STREAM_REPLY, Stage.MISC);
            this.put(Verb.STREAM_REQUEST, Stage.STREAM);
            this.put(Verb.RANGE_SLICE, Stage.READ);
            this.put(Verb.BOOTSTRAP_TOKEN, Stage.MISC);
            this.put(Verb.TREE_REQUEST, Stage.ANTI_ENTROPY);
            this.put(Verb.TREE_RESPONSE, Stage.ANTI_ENTROPY);
            this.put(Verb.STREAMING_REPAIR_REQUEST, Stage.ANTI_ENTROPY);
            this.put(Verb.STREAMING_REPAIR_RESPONSE, Stage.ANTI_ENTROPY);
            this.put(Verb.GOSSIP_DIGEST_ACK, Stage.GOSSIP);
            this.put(Verb.GOSSIP_DIGEST_ACK2, Stage.GOSSIP);
            this.put(Verb.GOSSIP_DIGEST_SYN, Stage.GOSSIP);
            this.put(Verb.DEFINITIONS_UPDATE, Stage.MIGRATION);
            this.put(Verb.SCHEMA_CHECK, Stage.MIGRATION);
            this.put(Verb.MIGRATION_REQUEST, Stage.MIGRATION);
            this.put(Verb.INDEX_SCAN, Stage.READ);
            this.put(Verb.REPLICATION_FINISHED, Stage.MISC);
            this.put(Verb.INTERNAL_RESPONSE, Stage.INTERNAL_RESPONSE);
            this.put(Verb.COUNTER_MUTATION, Stage.MUTATION);
            this.put(Verb.SNAPSHOT, Stage.MISC);
            this.put(Verb.UNUSED_1, Stage.INTERNAL_RESPONSE);
            this.put(Verb.UNUSED_2, Stage.INTERNAL_RESPONSE);
            this.put(Verb.UNUSED_3, Stage.INTERNAL_RESPONSE);
        }
    };
    public static final DebuggableScheduledThreadPoolExecutor scheduledTasks = new DebuggableScheduledThreadPoolExecutor("ScheduledTasks");
    public static final DebuggableScheduledThreadPoolExecutor tasks = new DebuggableScheduledThreadPoolExecutor("NonPeriodicTasks");
    public static final DebuggableScheduledThreadPoolExecutor optionalTasks = new DebuggableScheduledThreadPoolExecutor("OptionalTasks");
    private TokenMetadata tokenMetadata_ = new TokenMetadata();
    public VersionedValue.VersionedValueFactory valueFactory = new VersionedValue.VersionedValueFactory(StorageService.getPartitioner());
    public static final StorageService instance;
    private final Set<InetAddress> replicatingNodes = Collections.synchronizedSet(new HashSet());
    private CassandraDaemon daemon;
    private InetAddress removingNode;
    private boolean isBootstrapMode;
    private boolean isSurveyMode = Boolean.parseBoolean(System.getProperty("cassandra.write_survey", "false"));
    private boolean isClientMode;
    private boolean initialized;
    private volatile boolean joined = false;
    private Mode operationMode;
    private final MigrationManager migrationManager = new MigrationManager();
    private volatile int totalCFs;
    private volatile int remainingCFs;
    private static final AtomicInteger nextRepairCommand;

    private static int getRingDelay() {
        String newdelay = System.getProperty("cassandra.ring_delay_ms");
        if (newdelay != null) {
            logger_.warn("Overriding RING_DELAY to {}ms", (Object)newdelay);
            return Integer.parseInt(newdelay);
        }
        return 30000;
    }

    public static IPartitioner getPartitioner() {
        return DatabaseDescriptor.getPartitioner();
    }

    public Collection<Range<Token>> getLocalRanges(String table) {
        return this.getRangesForEndpoint(table, FBUtilities.getBroadcastAddress());
    }

    public Range<Token> getLocalPrimaryRange() {
        return this.getPrimaryRangeForEndpoint(FBUtilities.getBroadcastAddress());
    }

    public void finishBootstrapping() {
        this.isBootstrapMode = false;
    }

    public void setToken(Token token) {
        if (logger_.isDebugEnabled()) {
            logger_.debug("Setting token to {}", (Object)token);
        }
        SystemTable.updateToken(token);
        this.tokenMetadata_.updateNormalToken(token, FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.normal(this.getLocalToken()));
        this.setMode(Mode.NORMAL, false);
    }

    public StorageService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.db:type=StorageService"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MessagingService.instance().registerVerbHandlers(Verb.MUTATION, new RowMutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.READ_REPAIR, new ReadRepairVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.READ, new ReadVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.RANGE_SLICE, new RangeSliceVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.INDEX_SCAN, new IndexScanVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.COUNTER_MUTATION, new CounterMutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.TRUNCATE, new TruncateVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.BOOTSTRAP_TOKEN, new BootStrapper.BootstrapTokenVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.STREAM_REQUEST, new StreamRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.STREAM_REPLY, new StreamReplyVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.REPLICATION_FINISHED, new ReplicationFinishedVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.REQUEST_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.INTERNAL_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.TREE_REQUEST, new AntiEntropyService.TreeRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.TREE_RESPONSE, new AntiEntropyService.TreeResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.STREAMING_REPAIR_REQUEST, new StreamingRepairTask.StreamingRepairRequest());
        MessagingService.instance().registerVerbHandlers(Verb.STREAMING_REPAIR_RESPONSE, new StreamingRepairTask.StreamingRepairResponse());
        MessagingService.instance().registerVerbHandlers(Verb.GOSSIP_DIGEST_SYN, new GossipDigestSynVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.GOSSIP_DIGEST_ACK, new GossipDigestAckVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.GOSSIP_DIGEST_ACK2, new GossipDigestAck2VerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.DEFINITIONS_UPDATE, new DefinitionsUpdateVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.SCHEMA_CHECK, new SchemaCheckVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.MIGRATION_REQUEST, new MigrationRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(Verb.SNAPSHOT, new SnapshotVerbHandler());
        if (StreamingService.instance == null) {
            throw new RuntimeException("Streaming service is unavailable.");
        }
    }

    public void registerDaemon(CassandraDaemon daemon) {
        this.daemon = daemon;
    }

    @Override
    public void stopGossiping() {
        if (this.initialized) {
            logger_.warn("Stopping gossip by operator request");
            Gossiper.instance.stop();
            this.initialized = false;
        }
    }

    @Override
    public void startGossiping() {
        if (!this.initialized) {
            logger_.warn("Starting gossip by operator request");
            Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
            this.initialized = true;
        }
    }

    @Override
    public void startRPCServer() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured RPC daemon");
        }
        this.daemon.startRPCServer();
    }

    @Override
    public void stopRPCServer() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured RPC daemon");
        }
        this.daemon.stopRPCServer();
    }

    @Override
    public boolean isRPCServerRunning() {
        if (this.daemon == null) {
            return false;
        }
        return this.daemon.isRPCServerRunning();
    }

    public void stopClient() {
        Gossiper.instance.unregister(this.migrationManager);
        Gossiper.instance.unregister(this);
        Gossiper.instance.stop();
        MessagingService.instance().shutdown();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        StageManager.shutdownNow();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initClient() throws IOException, ConfigurationException {
        this.initClient(RING_DELAY);
    }

    public synchronized void initClient(int delay) throws IOException, ConfigurationException {
        if (this.initialized) {
            if (!this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = true;
        logger_.info("Starting up client gossip");
        this.setMode(Mode.CLIENT, false);
        Gossiper.instance.register(this);
        Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
        MessagingService.instance().listen(FBUtilities.getLocalAddress());
        try {
            Thread.sleep(delay);
        }
        catch (Exception ex) {
            throw new IOError(ex);
        }
        Schema.instance.updateVersion();
        MigrationManager.passiveAnnounce(Schema.instance.getVersion());
    }

    public synchronized void initServer() throws IOException, ConfigurationException {
        this.initServer(RING_DELAY);
    }

    public synchronized void initServer(int delay) throws IOException, ConfigurationException {
        logger_.info("Cassandra version: " + FBUtilities.getReleaseVersionString());
        logger_.info("Thrift API version: 19.28.0");
        logger_.info("CQL supported versions: " + StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)",") + " (default: " + ClientState.DEFAULT_CQL_VERSION + ")");
        if (this.initialized) {
            if (this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = false;
        if (Boolean.parseBoolean(System.getProperty("cassandra.load_ring_state", "true"))) {
            logger_.info("Loading persisted ring state");
            for (Map.Entry<Token, InetAddress> entry : SystemTable.loadTokens().entrySet()) {
                if (entry.getValue() == FBUtilities.getLocalAddress()) {
                    SystemTable.removeToken(entry.getKey());
                    continue;
                }
                this.tokenMetadata_.updateNormalToken(entry.getKey(), entry.getValue());
                Gossiper.instance.addSavedEndpoint(entry.getValue());
            }
        }
        if (Boolean.parseBoolean(System.getProperty("cassandra.renew_counter_id", "false"))) {
            logger_.info("Renewing local node id (as requested)");
            NodeId.renewLocalId();
        }
        Thread drainOnShutdown = new Thread((Runnable)new WrappedRunnable(){

            @Override
            public void runMayThrow() throws ExecutionException, InterruptedException, IOException {
                ThreadPoolExecutor mutationStage = StageManager.getStage(Stage.MUTATION);
                if (mutationStage.isShutdown()) {
                    return;
                }
                StorageService.this.stopRPCServer();
                optionalTasks.shutdown();
                Gossiper.instance.stop();
                MessagingService.instance().shutdown();
                mutationStage.shutdown();
                mutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
                StorageProxy.instance.verifyNoHintsInProgress();
                ArrayList flushes = new ArrayList();
                for (Table table : Table.all()) {
                    KSMetaData ksm = Schema.instance.getKSMetaData(table.name);
                    if (ksm.durableWrites) continue;
                    for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                        Future<?> future = cfs.forceFlush();
                        if (future == null) continue;
                        flushes.add(future);
                    }
                }
                FBUtilities.waitOnFutures(flushes);
                CommitLog.instance.shutdownBlocking();
                tasks.shutdown();
                if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
                    logger_.warn("Miscellaneous task executor still busy after one minute; proceeding with shutdown");
                }
            }
        }, "StorageServiceShutdownHook");
        Runtime.getRuntime().addShutdownHook(drainOnShutdown);
        if (Boolean.parseBoolean(System.getProperty("cassandra.join_ring", "true"))) {
            this.joinTokenRing(delay);
        } else {
            logger_.info("Not joining ring as requested. Use JMX (StorageService->joinRing()) to initiate ring joining");
        }
    }

    private void joinTokenRing(int delay) throws IOException, ConfigurationException {
        Token token;
        logger_.info("Starting up server gossip");
        this.joined = true;
        Schema.instance.updateVersion();
        Gossiper.instance.register(this);
        Gossiper.instance.register(this.migrationManager);
        Gossiper.instance.start(SystemTable.incrementAndGetGeneration());
        Gossiper.instance.addLocalApplicationState(ApplicationState.RPC_ADDRESS, this.valueFactory.rpcaddress(DatabaseDescriptor.getRpcAddress()));
        if (null != DatabaseDescriptor.getReplaceToken()) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.hibernate(true));
        }
        MessagingService.instance().listen(FBUtilities.getLocalAddress());
        LoadBroadcaster.instance.startBroadcasting();
        MigrationManager.passiveAnnounce(Schema.instance.getVersion());
        Gossiper.instance.addLocalApplicationState(ApplicationState.RELEASE_VERSION, this.valueFactory.releaseVersion());
        HintedHandOffManager.instance.start();
        if (DatabaseDescriptor.isAutoBootstrap() && DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress()) && !SystemTable.isBootstrapped()) {
            logger_.info("This node will not auto bootstrap because it is configured to be a seed node.");
        }
        InetAddress current = null;
        if (DatabaseDescriptor.isAutoBootstrap() && !SystemTable.isBootstrapped() && !DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress()) && Schema.instance.getNonSystemTables().isEmpty()) {
            this.setMode(Mode.JOINING, "waiting for ring and schema information", true);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            while (!MigrationManager.isReadyForBootstrap()) {
                this.setMode(Mode.JOINING, "waiting for schema information to complete", true);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.setMode(Mode.JOINING, "schema complete, ready to bootstrap", true);
            if (logger_.isDebugEnabled()) {
                logger_.debug("... got ring + schema info");
            }
            if (DatabaseDescriptor.getReplaceToken() == null) {
                if (this.tokenMetadata_.isMember(FBUtilities.getBroadcastAddress())) {
                    String s = "This node is already a member of the token ring; bootstrap aborted. (If replacing a dead node, remove the old one from the ring first.)";
                    throw new UnsupportedOperationException(s);
                }
                this.setMode(Mode.JOINING, "getting bootstrap token", true);
                token = BootStrapper.getBootstrapToken(this.tokenMetadata_, LoadBroadcaster.instance.getLoadInfo());
            } else {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                token = StorageService.getPartitioner().getTokenFactory().fromString(DatabaseDescriptor.getReplaceToken());
                current = this.tokenMetadata_.getEndpoint(token);
                if (null != current && Gossiper.instance.getEndpointStateForEndpoint(current).getUpdateTimestamp() > System.currentTimeMillis() - (long)delay) {
                    throw new UnsupportedOperationException("Cannnot replace a token for a Live node... ");
                }
                this.setMode(Mode.JOINING, "Replacing a node with token: " + token, true);
            }
            this.bootstrap(token);
            assert (!this.isBootstrapMode);
        } else {
            token = SystemTable.getSavedToken();
            if (token == null) {
                String initialToken = DatabaseDescriptor.getInitialToken();
                if (initialToken == null) {
                    token = StorageService.getPartitioner().getRandomToken();
                    logger_.warn("Generated random token " + token + ". Random tokens will result in an unbalanced ring; see http://wiki.apache.org/cassandra/Operations");
                } else {
                    token = StorageService.getPartitioner().getTokenFactory().fromString(initialToken);
                    logger_.info("Saved token not found. Using " + token + " from configuration");
                }
            } else {
                logger_.info("Using saved token " + token);
            }
        }
        if (!this.isSurveyMode) {
            SystemTable.setBootstrapped(true);
            this.setToken(token);
            if (current != null) {
                Gossiper.instance.replacedEndpoint(current);
            }
            logger_.info("Bootstrap/Replace/Move completed! Now serving reads.");
            assert (this.tokenMetadata_.sortedTokens().size() > 0);
        } else {
            logger_.info("Bootstrap complete, but write survey mode is active, not becoming an active ring member. Use JMX (StorageService->joinRing()) to finalize ring joining.");
        }
    }

    @Override
    public synchronized void joinRing() throws IOException, ConfigurationException {
        if (!this.joined) {
            logger_.info("Joining ring by operator request");
            this.joinTokenRing(0);
        } else if (this.isSurveyMode) {
            this.setToken(SystemTable.getSavedToken());
            SystemTable.setBootstrapped(true);
            this.isSurveyMode = false;
            logger_.info("Leaving write survey mode and joining ring at operator request");
            assert (this.tokenMetadata_.sortedTokens().size() > 0);
        }
    }

    @Override
    public boolean isJoined() {
        return this.joined;
    }

    @Override
    public void rebuild(String sourceDc) {
        logger_.info("rebuild from dc: {}", (Object)(sourceDc == null ? "(any dc)" : sourceDc));
        RangeStreamer streamer = new RangeStreamer(this.tokenMetadata_, FBUtilities.getBroadcastAddress(), OperationType.REBUILD);
        streamer.addSourceFilter(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance));
        if (sourceDc != null) {
            streamer.addSourceFilter(new RangeStreamer.SingleDatacenterFilter(DatabaseDescriptor.getEndpointSnitch(), sourceDc));
        }
        for (String table : Schema.instance.getNonSystemTables()) {
            streamer.addRanges(table, this.getLocalRanges(table));
        }
        streamer.fetch();
    }

    @Override
    public void setStreamThroughputMbPerSec(int value) {
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(value);
        logger_.info("setstreamthroughput: throttle set to {}", (Object)value);
    }

    @Override
    public int getStreamThroughputMbPerSec() {
        return DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec();
    }

    @Override
    public int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.getCompactionThroughputMbPerSec();
    }

    @Override
    public void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.setCompactionThroughputMbPerSec(value);
    }

    @Override
    public boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.isIncrementalBackupsEnabled();
    }

    @Override
    public void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.setIncrementalBackupsEnabled(value);
    }

    private void setMode(Mode m, boolean log) {
        this.setMode(m, null, log);
    }

    private void setMode(Mode m, String msg, boolean log) {
        String logMsg;
        this.operationMode = m;
        String string = logMsg = msg == null ? m.toString() : String.format("%s: %s", new Object[]{m, msg});
        if (log) {
            logger_.info(logMsg);
        } else {
            logger_.debug(logMsg);
        }
    }

    private void bootstrap(Token token) throws IOException {
        this.isBootstrapMode = true;
        SystemTable.updateToken(token);
        if (null == DatabaseDescriptor.getReplaceToken()) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.bootstrapping(token));
            this.setMode(Mode.JOINING, "sleeping " + RING_DELAY + " ms for pending range setup", true);
            try {
                Thread.sleep(RING_DELAY);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.tokenMetadata_.updateNormalToken(token, FBUtilities.getBroadcastAddress());
        }
        this.setMode(Mode.JOINING, "Starting to bootstrap...", true);
        new BootStrapper(FBUtilities.getBroadcastAddress(), token, this.tokenMetadata_).bootstrap();
    }

    public boolean isBootstrapMode() {
        return this.isBootstrapMode;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMetadata_;
    }

    @Override
    public Map<List<String>, List<String>> getRangeToEndpointMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            map.put(entry.getKey().asList(), this.stringify((Iterable<InetAddress>)entry.getValue()));
        }
        return map;
    }

    public String getRpcaddress(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return DatabaseDescriptor.getRpcAddress().getHostAddress();
        }
        if (Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.RPC_ADDRESS) == null) {
            return endpoint.getHostAddress();
        }
        return Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.RPC_ADDRESS).value;
    }

    @Override
    public Map<List<String>, List<String>> getRangeToRpcaddressMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            ArrayList<String> rpcaddrs = new ArrayList<String>();
            for (InetAddress endpoint : entry.getValue()) {
                rpcaddrs.add(this.getRpcaddress(endpoint));
            }
            map.put(entry.getKey().asList(), rpcaddrs);
        }
        return map;
    }

    @Override
    public Map<List<String>, List<String>> getPendingRangeToEndpointMap(String keyspace) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemTables().get(0);
        }
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, Collection<InetAddress>> entry : this.tokenMetadata_.getPendingRanges(keyspace).entrySet()) {
            ArrayList<InetAddress> l = new ArrayList<InetAddress>(entry.getValue());
            map.put(entry.getKey().asList(), this.stringify(l));
        }
        return map;
    }

    public Map<Range<Token>, List<InetAddress>> getRangeToAddressMap(String keyspace) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemTables().get(0);
        }
        List<Range<Token>> ranges = this.getAllRanges(this.tokenMetadata_.sortedTokens());
        return this.constructRangeToEndpointMap(keyspace, ranges);
    }

    @Override
    public List<String> describeRingJMX(String keyspace) throws InvalidRequestException {
        ArrayList<String> result = new ArrayList<String>();
        for (TokenRange tokenRange : this.describeRing(keyspace)) {
            result.add(tokenRange.toString());
        }
        return result;
    }

    public List<TokenRange> describeRing(String keyspace) throws InvalidRequestException {
        if (keyspace == null || !Schema.instance.getNonSystemTables().contains(keyspace)) {
            throw new InvalidRequestException("There is no ring for the keyspace: " + keyspace);
        }
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            Range<Token> range = entry.getKey();
            ArrayList<String> endpoints = new ArrayList<String>();
            ArrayList<String> rpc_endpoints = new ArrayList<String>();
            ArrayList<EndpointDetails> epDetails = new ArrayList<EndpointDetails>();
            for (InetAddress endpoint : entry.getValue()) {
                EndpointDetails details = new EndpointDetails();
                details.host = endpoint.getHostAddress();
                details.datacenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(endpoint);
                details.rack = DatabaseDescriptor.getEndpointSnitch().getRack(endpoint);
                endpoints.add(details.host);
                rpc_endpoints.add(this.getRpcaddress(endpoint));
                epDetails.add(details);
            }
            TokenRange tr = new TokenRange(tf.toString(range.left.getToken()), tf.toString(range.right.getToken()), endpoints).setEndpoint_details(epDetails).setRpc_endpoints(rpc_endpoints);
            ranges.add(tr);
        }
        return ranges;
    }

    @Override
    public Map<String, String> getTokenToEndpointMap() {
        Map<Token, InetAddress> mapInetAddress = this.tokenMetadata_.getNormalAndBootstrappingTokenToEndpointMap();
        LinkedHashMap<String, String> mapString = new LinkedHashMap<String, String>(mapInetAddress.size());
        ArrayList<Token> tokens = new ArrayList<Token>(mapInetAddress.keySet());
        Collections.sort(tokens);
        for (Token token : tokens) {
            mapString.put(token.toString(), mapInetAddress.get(token).getHostAddress());
        }
        return mapString;
    }

    private Map<Range<Token>, List<InetAddress>> constructRangeToEndpointMap(String keyspace, List<Range<Token>> ranges) {
        HashMap<Range<Token>, List<InetAddress>> rangeToEndpointMap = new HashMap<Range<Token>, List<InetAddress>>();
        for (Range<Token> range : ranges) {
            rangeToEndpointMap.put(range, Table.open(keyspace).getReplicationStrategy().getNaturalEndpoints(range.right));
        }
        return rangeToEndpointMap;
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        switch (state) {
            case STATUS: {
                String apStateValue = value.value;
                String[] pieces = apStateValue.split(VersionedValue.DELIMITER_STR, -1);
                assert (pieces.length > 0);
                String moveName = pieces[0];
                if (moveName.equals("BOOT")) {
                    this.handleStateBootstrap(endpoint, pieces);
                    break;
                }
                if (moveName.equals("NORMAL")) {
                    this.handleStateNormal(endpoint, pieces);
                    break;
                }
                if (moveName.equals("removing") || moveName.equals("removed")) {
                    this.handleStateRemoving(endpoint, pieces);
                    break;
                }
                if (moveName.equals("LEAVING")) {
                    this.handleStateLeaving(endpoint, pieces);
                    break;
                }
                if (moveName.equals("LEFT")) {
                    this.handleStateLeft(endpoint, pieces);
                    break;
                }
                if (!moveName.equals("MOVING")) break;
                this.handleStateMoving(endpoint, pieces);
            }
        }
    }

    private void handleStateBootstrap(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(pieces[1]);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Node " + endpoint + " state bootstrapping, token " + token);
        }
        if (this.tokenMetadata_.isMember(endpoint)) {
            if (!this.tokenMetadata_.isLeaving(endpoint)) {
                logger_.info("Node " + endpoint + " state jump to bootstrap");
            }
            this.tokenMetadata_.removeEndpoint(endpoint);
        }
        this.tokenMetadata_.addBootstrapToken(token, endpoint);
        this.calculatePendingRanges();
    }

    private void handleStateNormal(InetAddress endpoint, String[] pieces) {
        InetAddress currentOwner;
        assert (pieces.length >= 2);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(pieces[1]);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Node " + endpoint + " state normal, token " + token);
        }
        if (this.tokenMetadata_.isMember(endpoint)) {
            logger_.info("Node " + endpoint + " state jump to normal");
        }
        if ((currentOwner = this.tokenMetadata_.getEndpoint(token)) == null) {
            logger_.debug("New node " + endpoint + " at token " + token);
            this.tokenMetadata_.updateNormalToken(token, endpoint);
            if (!this.isClientMode) {
                SystemTable.updateToken(endpoint, token);
            }
        } else if (endpoint.equals(currentOwner)) {
            this.tokenMetadata_.updateNormalToken(token, endpoint);
        } else if (Gossiper.instance.compareEndpointStartup(endpoint, currentOwner) > 0) {
            logger_.info(String.format("Nodes %s and %s have the same token %s.  %s is the new owner", endpoint, currentOwner, token, endpoint));
            this.tokenMetadata_.updateNormalToken(token, endpoint);
            Gossiper.instance.removeEndpoint(currentOwner);
            if (!this.isClientMode) {
                SystemTable.updateToken(endpoint, token);
            }
        } else {
            logger_.info(String.format("Nodes %s and %s have the same token %s.  Ignoring %s", endpoint, currentOwner, token, endpoint));
        }
        if (this.tokenMetadata_.isMoving(endpoint)) {
            this.tokenMetadata_.removeFromMoving(endpoint);
        }
        this.calculatePendingRanges();
    }

    private void handleStateLeaving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        String moveValue = pieces[1];
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(moveValue);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Node " + endpoint + " state leaving, token " + token);
        }
        if (!this.tokenMetadata_.isMember(endpoint)) {
            logger_.info("Node " + endpoint + " state jump to leaving");
            this.tokenMetadata_.updateNormalToken(token, endpoint);
        } else if (!this.tokenMetadata_.getToken(endpoint).equals(token)) {
            logger_.warn("Node " + endpoint + " 'leaving' token mismatch. Long network partition?");
            this.tokenMetadata_.updateNormalToken(token, endpoint);
        }
        this.tokenMetadata_.addLeavingEndpoint(endpoint);
        this.calculatePendingRanges();
    }

    private void handleStateLeft(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(pieces[1]);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Node " + endpoint + " state left, token " + token);
        }
        this.excise(token, endpoint, this.extractExpireTime(pieces));
    }

    private void handleStateMoving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(pieces[1]);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Node " + endpoint + " state moving, new token " + token);
        }
        this.tokenMetadata_.addMovingEndpoint(token, endpoint);
        this.calculatePendingRanges();
    }

    private void handleStateRemoving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length > 0);
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            logger_.info("Received removeToken gossip about myself. Is this node rejoining after an explicit removetoken?");
            try {
                this.drain();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (this.tokenMetadata_.isMember(endpoint)) {
            String state = pieces[0];
            Token removeToken = this.tokenMetadata_.getToken(endpoint);
            if ("removed".equals(state)) {
                this.excise(removeToken, endpoint, this.extractExpireTime(pieces));
            } else if ("removing".equals(state)) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug("Token " + removeToken + " removed manually (endpoint was " + endpoint + ")");
                }
                this.tokenMetadata_.addLeavingEndpoint(endpoint);
                this.calculatePendingRanges();
                String[] coordinator = Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.REMOVAL_COORDINATOR).value.split(VersionedValue.DELIMITER_STR, -1);
                Token coordtoken = StorageService.getPartitioner().getTokenFactory().fromString(coordinator[1]);
                this.restoreReplicaCount(endpoint, this.tokenMetadata_.getEndpoint(coordtoken));
            }
        }
    }

    private void excise(Token token, InetAddress endpoint) {
        HintedHandOffManager.instance.deleteHintsForEndpoint(endpoint);
        Gossiper.instance.removeEndpoint(endpoint);
        this.tokenMetadata_.removeEndpoint(endpoint);
        this.tokenMetadata_.removeBootstrapToken(token);
        this.calculatePendingRanges();
        if (!this.isClientMode) {
            logger_.info("Removing token " + token + " for " + endpoint);
            SystemTable.removeToken(token);
        }
    }

    private void excise(Token token, InetAddress endpoint, long expireTime) {
        this.addExpireTimeIfFound(endpoint, expireTime);
        this.excise(token, endpoint);
    }

    protected void addExpireTimeIfFound(InetAddress endpoint, long expireTime) {
        if (expireTime != 0L) {
            Gossiper.instance.addExpireTimeForEndpoint(endpoint, expireTime);
        }
    }

    protected long extractExpireTime(String[] pieces) {
        long expireTime = 0L;
        if (pieces.length >= 3) {
            expireTime = Long.parseLong(pieces[2]);
        }
        return expireTime;
    }

    private void calculatePendingRanges() {
        for (String table : Schema.instance.getNonSystemTables()) {
            StorageService.calculatePendingRanges(Table.open(table).getReplicationStrategy(), table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String table) {
        TokenMetadata tm = instance.getTokenMetadata();
        HashMultimap pendingRanges = HashMultimap.create();
        Map<Token, InetAddress> bootstrapTokens = tm.getBootstrapTokens();
        Set<InetAddress> leavingEndpoints = tm.getLeavingEndpoints();
        if (bootstrapTokens.isEmpty() && leavingEndpoints.isEmpty() && tm.getMovingEndpoints().isEmpty()) {
            if (logger_.isDebugEnabled()) {
                logger_.debug("No bootstrapping, leaving or moving nodes -> empty pending ranges for {}", (Object)table);
            }
            tm.setPendingRanges(table, (Multimap<Range<Token>, InetAddress>)pendingRanges);
            return;
        }
        Multimap<InetAddress, Range<Token>> addressRanges = strategy.getAddressRanges();
        TokenMetadata allLeftMetadata = tm.cloneAfterAllLeft();
        HashSet affectedRanges = new HashSet();
        for (InetAddress endpoint : leavingEndpoints) {
            affectedRanges.addAll(addressRanges.get((Object)endpoint));
        }
        for (Range range : affectedRanges) {
            ImmutableSet currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, tm));
            ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, allLeftMetadata));
            pendingRanges.putAll((Object)range, (Iterable)Sets.difference((Set)newEndpoints, (Set)currentEndpoints));
        }
        Iterator<Pair<Token, InetAddress>> i$ = bootstrapTokens;
        synchronized (i$) {
            for (Map.Entry<Token, InetAddress> entry : bootstrapTokens.entrySet()) {
                InetAddress endpoint = entry.getValue();
                allLeftMetadata.updateNormalToken(entry.getKey(), endpoint);
                for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)endpoint)) {
                    pendingRanges.put((Object)range, (Object)endpoint);
                }
                allLeftMetadata.removeEndpoint(endpoint);
            }
        }
        for (Pair<Token, InetAddress> moving : tm.getMovingEndpoints()) {
            InetAddress endpoint = (InetAddress)moving.right;
            allLeftMetadata.updateNormalToken((Token)moving.left, endpoint);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)endpoint)) {
                pendingRanges.put((Object)range, (Object)endpoint);
            }
            allLeftMetadata.removeEndpoint(endpoint);
        }
        tm.setPendingRanges(table, (Multimap<Range<Token>, InetAddress>)pendingRanges);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Pending ranges:\n" + (pendingRanges.isEmpty() ? "<empty>" : tm.printPendingRanges()));
        }
    }

    private Multimap<InetAddress, Range<Token>> getNewSourceRanges(String table, Set<Range<Token>> ranges) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        Multimap<Range<Token>, InetAddress> rangeAddresses = Table.open(table).getReplicationStrategy().getRangeAddresses(this.tokenMetadata_);
        HashMultimap sourceRanges = HashMultimap.create();
        IFailureDetector failureDetector = FailureDetector.instance;
        block0: for (Range<Token> range : ranges) {
            Collection possibleRanges = rangeAddresses.get(range);
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            List<InetAddress> sources = snitch.getSortedListByProximity(myAddress, possibleRanges);
            assert (!sources.contains(myAddress));
            for (InetAddress source : sources) {
                if (!failureDetector.isAlive(source)) continue;
                sourceRanges.put((Object)source, range);
                continue block0;
            }
        }
        return sourceRanges;
    }

    private void sendReplicationNotification(InetAddress local, InetAddress remote) {
        Message msg = new Message(local, Verb.REPLICATION_FINISHED, new byte[0], Gossiper.instance.getVersion(remote));
        IFailureDetector failureDetector = FailureDetector.instance;
        if (logger_.isDebugEnabled()) {
            logger_.debug("Notifying " + remote.toString() + " of replication completion\n");
        }
        while (failureDetector.isAlive(remote)) {
            IAsyncResult iar = MessagingService.instance().sendRR(msg, remote);
            try {
                iar.get(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
            }
        }
    }

    private void restoreReplicaCount(InetAddress endpoint, InetAddress notifyEndpoint) {
        HashMultimap fetchSources = HashMultimap.create();
        HashMultimap rangesToFetch = HashMultimap.create();
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        for (String table : Schema.instance.getNonSystemTables()) {
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(table, endpoint);
            HashSet<Range<Token>> myNewRanges = new HashSet<Range<Token>>();
            for (Map.Entry entry : changedRanges.entries()) {
                if (!((InetAddress)entry.getValue()).equals(myAddress)) continue;
                myNewRanges.add((Range<Token>)entry.getKey());
            }
            Multimap<InetAddress, Range<Token>> sourceRanges = this.getNewSourceRanges(table, myNewRanges);
            for (Map.Entry entry : sourceRanges.asMap().entrySet()) {
                fetchSources.put(entry.getKey(), (Object)table);
                rangesToFetch.put((Object)table, entry);
            }
        }
        for (String table : rangesToFetch.keySet()) {
            for (Map.Entry entry : rangesToFetch.get((Object)table)) {
                InetAddress source = (InetAddress)entry.getKey();
                Collection ranges = (Collection)entry.getValue();
                Runnable callback = new Runnable((Multimap)fetchSources, source, table, myAddress, notifyEndpoint){
                    final /* synthetic */ Multimap val$fetchSources;
                    final /* synthetic */ InetAddress val$source;
                    final /* synthetic */ String val$table;
                    final /* synthetic */ InetAddress val$myAddress;
                    final /* synthetic */ InetAddress val$notifyEndpoint;
                    {
                        this.val$fetchSources = multimap;
                        this.val$source = inetAddress;
                        this.val$table = string;
                        this.val$myAddress = inetAddress2;
                        this.val$notifyEndpoint = inetAddress3;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Multimap multimap = this.val$fetchSources;
                        synchronized (multimap) {
                            this.val$fetchSources.remove((Object)this.val$source, (Object)this.val$table);
                            if (this.val$fetchSources.isEmpty()) {
                                StorageService.this.sendReplicationNotification(this.val$myAddress, this.val$notifyEndpoint);
                            }
                        }
                    }
                };
                if (logger_.isDebugEnabled()) {
                    logger_.debug("Requesting from " + source + " ranges " + StringUtils.join((Collection)ranges, (String)", "));
                }
                StreamIn.requestRanges(source, table, ranges, callback, OperationType.RESTORE_REPLICA_COUNT);
            }
        }
    }

    private Multimap<Range<Token>, InetAddress> getChangedRangesForLeaving(String table, InetAddress endpoint) {
        Collection<Range<Token>> ranges = this.getRangesForEndpoint(table, endpoint);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Node " + endpoint + " ranges [" + StringUtils.join(ranges, (String)", ") + "]");
        }
        HashMap<Range<Token>, List<InetAddress>> currentReplicaEndpoints = new HashMap<Range<Token>, List<InetAddress>>();
        for (Range<Token> range : ranges) {
            currentReplicaEndpoints.put(range, Table.open(table).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, this.tokenMetadata_));
        }
        TokenMetadata temp = this.tokenMetadata_.cloneAfterAllLeft();
        if (temp.isMember(endpoint)) {
            temp.removeEndpoint(endpoint);
        }
        HashMultimap changedRanges = HashMultimap.create();
        for (Range<Token> range : ranges) {
            List<InetAddress> newReplicaEndpoints = Table.open(table).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, temp);
            newReplicaEndpoints.removeAll((Collection)currentReplicaEndpoints.get(range));
            if (logger_.isDebugEnabled()) {
                if (newReplicaEndpoints.isEmpty()) {
                    logger_.debug("Range " + range + " already in all replicas");
                } else {
                    logger_.debug("Range " + range + " will be responsibility of " + StringUtils.join(newReplicaEndpoints, (String)", "));
                }
            }
            changedRanges.putAll(range, newReplicaEndpoints);
        }
        return changedRanges;
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.getApplicationStateMap().entrySet()) {
            this.onChange(endpoint, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
        if (!this.isClientMode && this.getTokenMetadata().isMember(endpoint)) {
            HintedHandOffManager.instance.scheduleHintDelivery(endpoint);
        }
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.tokenMetadata_.removeEndpoint(endpoint);
        this.calculatePendingRanges();
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
        MessagingService.instance().convict(endpoint);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
        if (state.isAlive()) {
            this.onDead(endpoint, state);
        }
    }

    @Override
    public double getLoad() {
        double bytes = 0.0;
        for (String tableName : Schema.instance.getTables()) {
            Table table = Table.open(tableName);
            for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                bytes += (double)cfs.getLiveDiskSpaceUsed();
            }
        }
        return bytes;
    }

    @Override
    public String getLoadString() {
        return FileUtils.stringifyFileSize(this.getLoad());
    }

    @Override
    public Map<String, String> getLoadMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<InetAddress, Double> entry : LoadBroadcaster.instance.getLoadInfo().entrySet()) {
            map.put(entry.getKey().getHostAddress(), FileUtils.stringifyFileSize(entry.getValue()));
        }
        map.put(FBUtilities.getBroadcastAddress().getHostAddress(), this.getLoadString());
        return map;
    }

    public final void deliverHints(String host) throws UnknownHostException {
        HintedHandOffManager.instance.scheduleHintDelivery(host);
    }

    public Token getLocalToken() {
        Token token = SystemTable.getSavedToken();
        assert (token != null);
        return token;
    }

    @Override
    public String getToken() {
        return this.getLocalToken().toString();
    }

    @Override
    public String getReleaseVersion() {
        return FBUtilities.getReleaseVersionString();
    }

    @Override
    public List<String> getLeavingNodes() {
        return this.stringify(this.tokenMetadata_.getLeavingEndpoints());
    }

    @Override
    public List<String> getMovingNodes() {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Pair<Token, InetAddress> node : this.tokenMetadata_.getMovingEndpoints()) {
            endpoints.add(((InetAddress)node.right).getHostAddress());
        }
        return endpoints;
    }

    @Override
    public List<String> getJoiningNodes() {
        return this.stringify(this.tokenMetadata_.getBootstrapTokens().values());
    }

    @Override
    public List<String> getLiveNodes() {
        return this.stringify(Gossiper.instance.getLiveMembers());
    }

    @Override
    public List<String> getUnreachableNodes() {
        return this.stringify(Gossiper.instance.getUnreachableMembers());
    }

    private static String getCanonicalPath(String filename) {
        try {
            return new File(filename).getCanonicalPath();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public String[] getAllDataFileLocations() {
        String[] locations = DatabaseDescriptor.getAllDataFileLocations();
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = StorageService.getCanonicalPath(locations[i]);
        }
        return locations;
    }

    @Override
    public String getCommitLogLocation() {
        return StorageService.getCanonicalPath(DatabaseDescriptor.getCommitLogLocation());
    }

    @Override
    public String getSavedCachesLocation() {
        return StorageService.getCanonicalPath(DatabaseDescriptor.getSavedCachesLocation());
    }

    private List<String> stringify(Iterable<InetAddress> endpoints) {
        ArrayList<String> stringEndpoints = new ArrayList<String>();
        for (InetAddress ep : endpoints) {
            stringEndpoints.add(ep.getHostAddress());
        }
        return stringEndpoints;
    }

    @Override
    public int getCurrentGenerationNumber() {
        return Gossiper.instance.getCurrentGenerationNumber(FBUtilities.getBroadcastAddress());
    }

    @Override
    public void forceTableCleanup(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        if (tableName.equals("system")) {
            throw new RuntimeException("Cleanup of the system table is neither necessary nor wise");
        }
        NodeId.OneShotRenewer nodeIdRenewer = new NodeId.OneShotRenewer();
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            cfStore.forceCleanup(nodeIdRenewer);
        }
    }

    @Override
    public void scrub(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            cfStore.scrub();
        }
    }

    @Override
    public void upgradeSSTables(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            cfStore.sstablesRewrite();
        }
    }

    @Override
    public void forceTableCompaction(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            cfStore.forceMajorCompaction();
        }
    }

    @Override
    public void takeSnapshot(String tag, String ... tableNames) throws IOException {
        Iterable<Table> tables;
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        if (tableNames.length == 0) {
            tables = Table.all();
        } else {
            ArrayList<Table> t = new ArrayList<Table>();
            for (String table : tableNames) {
                t.add(this.getValidTable(table));
            }
            tables = t;
        }
        for (Table table : tables) {
            if (!table.snapshotExists(tag)) continue;
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        for (Table table : tables) {
            table.snapshot(tag);
        }
    }

    private Table getValidTable(String tableName) throws IOException {
        if (!Schema.instance.getTables().contains(tableName)) {
            throw new IOException("Table " + tableName + "does not exist");
        }
        return Table.open(tableName);
    }

    @Override
    public void clearSnapshot(String tag, String ... tableNames) throws IOException {
        Iterable<Table> tables;
        if (tag == null) {
            tag = "";
        }
        if (tableNames.length == 0) {
            tables = Table.all();
        } else {
            ArrayList<Table> tempTables = new ArrayList<Table>();
            for (String table : tableNames) {
                tempTables.add(this.getValidTable(table));
            }
            tables = tempTables;
        }
        for (Table table : tables) {
            table.clearSnapshot(tag);
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug("Cleared out snapshot directories");
        }
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(String tableName, String ... cfNames) throws IOException {
        Table table = this.getValidTable(tableName);
        if (cfNames.length == 0) {
            return table.getColumnFamilyStores();
        }
        HashSet<ColumnFamilyStore> valid = new HashSet<ColumnFamilyStore>();
        for (String cfName : cfNames) {
            ColumnFamilyStore cfStore = table.getColumnFamilyStore(cfName);
            if (cfStore == null) {
                logger_.warn(String.format("Invalid column family specified: %s. Proceeding with others.", cfName));
                continue;
            }
            valid.add(cfStore);
        }
        return valid;
    }

    @Override
    public void forceTableFlush(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            logger_.debug("Forcing flush on keyspace " + tableName + ", CF " + cfStore.getColumnFamilyName());
            cfStore.forceBlockingFlush();
        }
    }

    @Override
    public void forceTableRepair(String tableName, String ... columnFamilies) throws IOException {
        if ("system".equals(tableName)) {
            return;
        }
        Collection<Range<Token>> ranges = this.getLocalRanges(tableName);
        int cmd = nextRepairCommand.incrementAndGet();
        logger_.info("Starting repair command #{}, repairing {} ranges.", (Object)cmd, (Object)ranges.size());
        ArrayList<AntiEntropyService.RepairFuture> futures = new ArrayList<AntiEntropyService.RepairFuture>(ranges.size());
        for (Range<Token> range : ranges) {
            AntiEntropyService.RepairFuture future = this.forceTableRepair(range, tableName, columnFamilies);
            futures.add(future);
            try {
                future.session.differencingDone.await();
            }
            catch (InterruptedException e) {
                logger_.error("Interrupted while waiting for the differencing of repair session " + future.session + " to be done. Repair may be imprecise.", (Throwable)e);
            }
        }
        boolean failedSession = false;
        for (AntiEntropyService.RepairFuture future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                logger_.error("Repair session " + future.session.getName() + " failed.", (Throwable)e);
                failedSession = true;
            }
        }
        if (failedSession) {
            throw new IOException("Repair command #" + cmd + ": some repair session(s) failed (see log for details).");
        }
        logger_.info("Repair command #{} completed successfully", (Object)cmd);
    }

    @Override
    public void forceTableRepairPrimaryRange(String tableName, String ... columnFamilies) throws IOException {
        if ("system".equals(tableName)) {
            return;
        }
        AntiEntropyService.RepairFuture future = this.forceTableRepair(this.getLocalPrimaryRange(), tableName, columnFamilies);
        try {
            future.get();
        }
        catch (Exception e) {
            logger_.error("Repair session " + future.session.getName() + " failed.", (Throwable)e);
            throw new IOException("Some repair session(s) failed (see log for details).");
        }
    }

    public AntiEntropyService.RepairFuture forceTableRepair(Range<Token> range, String tableName, String ... columnFamilies) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            names.add(cfStore.getColumnFamilyName());
        }
        return AntiEntropyService.instance.submitRepairSession(range, tableName, names.toArray(new String[names.size()]));
    }

    @Override
    public void forceTerminateAllRepairSessions() {
        AntiEntropyService.instance.terminateSessions();
    }

    InetAddress getPredecessor(InetAddress ep) {
        Token token = this.tokenMetadata_.getToken(ep);
        return this.tokenMetadata_.getEndpoint(this.tokenMetadata_.getPredecessor(token));
    }

    public InetAddress getSuccessor(InetAddress ep) {
        Token token = this.tokenMetadata_.getToken(ep);
        return this.tokenMetadata_.getEndpoint(this.tokenMetadata_.getSuccessor(token));
    }

    public Range<Token> getPrimaryRangeForEndpoint(InetAddress ep) {
        return this.tokenMetadata_.getPrimaryRangeFor(this.tokenMetadata_.getToken(ep));
    }

    Collection<Range<Token>> getRangesForEndpoint(String table, InetAddress ep) {
        return Table.open(table).getReplicationStrategy().getAddressRanges().get((Object)ep);
    }

    public List<Range<Token>> getAllRanges(List<Token> sortedTokens) {
        if (logger_.isDebugEnabled()) {
            logger_.debug("computing ranges for " + StringUtils.join(sortedTokens, (String)", "));
        }
        if (sortedTokens.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
        int size = sortedTokens.size();
        for (int i = 1; i < size; ++i) {
            Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(i - 1), sortedTokens.get(i));
            ranges.add(range);
        }
        Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(size - 1), sortedTokens.get(0));
        ranges.add(range);
        return ranges;
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String table, String cf, String key) {
        CFMetaData cfMetaData = Schema.instance.getTableDefinition(table).cfMetaData().get(cf);
        return this.getNaturalEndpoints(table, (RingPosition)StorageService.getPartitioner().getToken(cfMetaData.getKeyValidator().fromString(key)));
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String table, ByteBuffer key) {
        return this.getNaturalEndpoints(table, (RingPosition)StorageService.getPartitioner().getToken(key));
    }

    public List<InetAddress> getNaturalEndpoints(String table, RingPosition pos) {
        return Table.open(table).getReplicationStrategy().getNaturalEndpoints(pos);
    }

    public List<InetAddress> getLiveNaturalEndpoints(String table, ByteBuffer key) {
        return this.getLiveNaturalEndpoints(table, StorageService.getPartitioner().decorateKey(key));
    }

    public List<InetAddress> getLiveNaturalEndpoints(String table, RingPosition pos) {
        ArrayList<InetAddress> liveEps = new ArrayList<InetAddress>();
        ArrayList<InetAddress> endpoints = Table.open(table).getReplicationStrategy().getNaturalEndpoints(pos);
        for (InetAddress endpoint : endpoints) {
            if (!FailureDetector.instance.isAlive(endpoint)) continue;
            liveEps.add(endpoint);
        }
        return liveEps;
    }

    @Override
    public void setLog4jLevel(String classQualifier, String rawLevel) {
        Level level = Level.toLevel((String)rawLevel);
        org.apache.log4j.Logger.getLogger((String)classQualifier).setLevel(level);
        logger_.info("set log level to " + level + " for classes under '" + classQualifier + "' (if the level doesn't look like '" + rawLevel + "' then log4j couldn't parse '" + rawLevel + "')");
    }

    public List<Token> getSplits(String table, String cfName, Range<Token> range, int keysPerSplit) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        tokens.add((Token)range.left);
        Table t = Table.open(table);
        ColumnFamilyStore cfs = t.getColumnFamilyStore(cfName);
        List<DecoratedKey> keys = this.keySamples(Collections.singleton(cfs), range);
        int splits = keys.size() * DatabaseDescriptor.getIndexInterval() / keysPerSplit;
        if (keys.size() >= splits) {
            for (int i = 1; i < splits; ++i) {
                int index = i * (keys.size() / splits);
                tokens.add((Token)keys.get((int)index).token);
            }
        }
        tokens.add((Token)range.right);
        return tokens;
    }

    private List<DecoratedKey> keySamples(Iterable<ColumnFamilyStore> cfses, Range<Token> range) {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (ColumnFamilyStore cfs : cfses) {
            Iterables.addAll(keys, cfs.keySamples(range));
        }
        FBUtilities.sortSampledKeys(keys, range);
        return keys;
    }

    public Token getBootstrapToken() {
        Token token;
        Range<Token> range = this.getLocalPrimaryRange();
        List<DecoratedKey> keys = this.keySamples(ColumnFamilyStore.allUserDefined(), range);
        if (keys.size() < 3) {
            token = StorageService.getPartitioner().midpoint((Token)range.left, (Token)range.right);
            logger_.debug("Used midpoint to assign token " + token);
        } else {
            token = keys.get((int)(keys.size() / 2)).token;
            logger_.debug("Used key sample of size " + keys.size() + " to assign token " + token);
        }
        if (this.tokenMetadata_.getEndpoint(token) != null && this.tokenMetadata_.isMember(this.tokenMetadata_.getEndpoint(token))) {
            throw new RuntimeException("Chose token " + token + " which is already in use by " + this.tokenMetadata_.getEndpoint(token) + " -- specify one manually with initial_token");
        }
        if (token instanceof StringToken) {
            token = new StringToken(((String)token.token).replaceAll(VersionedValue.DELIMITER_STR, ""));
            if (this.tokenMetadata_.getNormalAndBootstrappingTokenToEndpointMap().containsKey(token)) {
                throw new RuntimeException("Unable to compute unique token for new node -- specify one manually with initial_token");
            }
        }
        return token;
    }

    private void startLeaving() {
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.leaving(this.getLocalToken()));
        this.tokenMetadata_.addLeavingEndpoint(FBUtilities.getBroadcastAddress());
        this.calculatePendingRanges();
    }

    @Override
    public void decommission() throws InterruptedException {
        if (!this.tokenMetadata_.isMember(FBUtilities.getBroadcastAddress())) {
            throw new UnsupportedOperationException("local node is not a member of the token ring yet");
        }
        if (this.tokenMetadata_.cloneAfterAllLeft().sortedTokens().size() < 2) {
            throw new UnsupportedOperationException("no other normal nodes in the ring; decommission would be pointless");
        }
        for (String table : Schema.instance.getNonSystemTables()) {
            if (this.tokenMetadata_.getPendingRanges(table, FBUtilities.getBroadcastAddress()).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug("DECOMMISSIONING");
        }
        this.startLeaving();
        this.setMode(Mode.LEAVING, "sleeping " + RING_DELAY + " ms for pending range setup", true);
        Thread.sleep(RING_DELAY);
        Runnable finishLeaving = new Runnable(){

            @Override
            public void run() {
                Gossiper.instance.stop();
                MessagingService.instance().shutdown();
                StageManager.shutdownNow();
                StorageService.this.setMode(Mode.DECOMMISSIONED, true);
            }
        };
        this.unbootstrap(finishLeaving);
    }

    private void leaveRing() {
        SystemTable.setBootstrapped(false);
        this.tokenMetadata_.removeEndpoint(FBUtilities.getBroadcastAddress());
        this.calculatePendingRanges();
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.left(this.getLocalToken(), Gossiper.computeExpireTime()));
        logger_.info("Announcing that I have left the ring for " + RING_DELAY + "ms");
        try {
            Thread.sleep(RING_DELAY);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void unbootstrap(Runnable onFinish) {
        HashMap<String, Multimap<Range<Token>, InetAddress>> rangesToStream = new HashMap<String, Multimap<Range<Token>, InetAddress>>();
        for (String table : Schema.instance.getNonSystemTables()) {
            Multimap<Range<Token>, InetAddress> rangesMM = this.getChangedRangesForLeaving(table, FBUtilities.getBroadcastAddress());
            if (logger_.isDebugEnabled()) {
                logger_.debug("Ranges needing transfer are [" + StringUtils.join((Collection)rangesMM.keySet(), (String)",") + "]");
            }
            rangesToStream.put(table, rangesMM);
        }
        this.setMode(Mode.LEAVING, "streaming data to other nodes", true);
        CountDownLatch latch = this.streamRanges(rangesToStream);
        logger_.debug("waiting for stream aks.");
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger_.debug("stream acks all received.");
        this.leaveRing();
        onFinish.run();
    }

    @Override
    public void move(String newToken) throws IOException, InterruptedException, ConfigurationException {
        StorageService.getPartitioner().getTokenFactory().validate(newToken);
        this.move(StorageService.getPartitioner().getTokenFactory().fromString(newToken));
    }

    private void move(Token newToken) throws IOException {
        if (newToken == null) {
            throw new IOException("Can't move to the undefined (null) token.");
        }
        if (this.tokenMetadata_.sortedTokens().contains(newToken)) {
            throw new IOException("target token " + newToken + " is already owned by another node.");
        }
        InetAddress localAddress = FBUtilities.getBroadcastAddress();
        List<String> tablesToProcess = Schema.instance.getNonSystemTables();
        for (String table : tablesToProcess) {
            if (this.tokenMetadata_.getPendingRanges(table, localAddress).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.moving(newToken));
        logger_.info(String.format("Moving %s from %s to %s.", localAddress, this.getLocalToken(), newToken));
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        HashMap<String, Multimap<InetAddress, Range<Token>>> rangesToFetch = new HashMap<String, Multimap<InetAddress, Range<Token>>>();
        HashMap<String, Multimap<Range<Token>, InetAddress>> rangesToStreamByTable = new HashMap<String, Multimap<Range<Token>, InetAddress>>();
        TokenMetadata tokenMetaClone = this.tokenMetadata_.cloneAfterAllSettled();
        for (String table : tablesToProcess) {
            AbstractReplicationStrategy strategy = Table.open(table).getReplicationStrategy();
            Collection<Range<Token>> currentRanges = this.getRangesForEndpoint(table, localAddress);
            Collection<Range<Token>> updatedRanges = strategy.getPendingAddressRanges(this.tokenMetadata_, newToken, localAddress);
            Multimap<Range<Token>, InetAddress> rangeAddresses = strategy.getRangeAddresses(this.tokenMetadata_);
            Pair<Set<Range<Token>>, Set<Range<Token>>> rangesPerTable = this.calculateStreamAndFetchRanges(currentRanges, updatedRanges);
            ArrayListMultimap rangesToFetchWithPreferredEndpoints = ArrayListMultimap.create();
            for (Range toFetch : (Set)rangesPerTable.right) {
                for (Range range : rangeAddresses.keySet()) {
                    if (!range.contains(toFetch)) continue;
                    List<InetAddress> endpoints = snitch.getSortedListByProximity(localAddress, rangeAddresses.get((Object)range));
                    rangesToFetchWithPreferredEndpoints.putAll((Object)toFetch, endpoints);
                }
            }
            HashMultimap rangeWithEndpoints = HashMultimap.create();
            for (Range toStream : (Set)rangesPerTable.left) {
                ImmutableSet currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, this.tokenMetadata_));
                ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, tokenMetaClone));
                rangeWithEndpoints.putAll((Object)toStream, (Iterable)Sets.difference((Set)newEndpoints, (Set)currentEndpoints));
            }
            rangesToStreamByTable.put(table, (Multimap<Range<Token>, InetAddress>)rangeWithEndpoints);
            Multimap<InetAddress, Range<Token>> workMap = RangeStreamer.getWorkMap((Multimap<Range<Token>, InetAddress>)rangesToFetchWithPreferredEndpoints);
            rangesToFetch.put(table, workMap);
            if (!logger_.isDebugEnabled()) continue;
            logger_.debug("Table {}: work map {}.", (Object)table, workMap);
        }
        if (!rangesToStreamByTable.isEmpty() || !rangesToFetch.isEmpty()) {
            logger_.info("Sleeping {} ms before start streaming/fetching ranges.", (Object)RING_DELAY);
            try {
                Thread.sleep(RING_DELAY);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Sleep interrupted " + e.getMessage());
            }
            this.setMode(Mode.MOVING, "fetching new ranges and streaming old ranges", true);
            if (logger_.isDebugEnabled()) {
                logger_.debug("[Move->STREAMING] Work Map: " + rangesToStreamByTable);
            }
            CountDownLatch streamLatch = this.streamRanges(rangesToStreamByTable);
            if (logger_.isDebugEnabled()) {
                logger_.debug("[Move->FETCHING] Work Map: " + rangesToFetch);
            }
            CountDownLatch fetchLatch = this.requestRanges(rangesToFetch);
            try {
                streamLatch.await();
                fetchLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted latch while waiting for stream/fetch ranges to finish: " + e.getMessage());
            }
        }
        this.setToken(newToken);
        if (logger_.isDebugEnabled()) {
            logger_.debug("Successfully moved to new token {}", (Object)this.getLocalToken());
        }
    }

    @Override
    public String getRemovalStatus() {
        if (this.removingNode == null) {
            return "No token removals in process.";
        }
        return String.format("Removing token (%s). Waiting for replication confirmation from [%s].", this.tokenMetadata_.getToken(this.removingNode), StringUtils.join(this.replicatingNodes, (String)","));
    }

    @Override
    public void forceRemoveCompletion() {
        if (!this.replicatingNodes.isEmpty() || !this.tokenMetadata_.getLeavingEndpoints().isEmpty()) {
            logger_.warn("Removal not confirmed for for " + StringUtils.join(this.replicatingNodes, (String)","));
            for (InetAddress endpoint : this.tokenMetadata_.getLeavingEndpoints()) {
                Token token = this.tokenMetadata_.getToken(endpoint);
                Gossiper.instance.advertiseTokenRemoved(endpoint, token);
                this.excise(token, endpoint);
            }
        } else {
            throw new UnsupportedOperationException("No tokens to force removal on, call 'removetoken' first");
        }
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    @Override
    public void removeToken(String tokenString) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        Token localToken = this.tokenMetadata_.getToken(myAddress);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(tokenString);
        InetAddress endpoint = this.tokenMetadata_.getEndpoint(token);
        if (endpoint == null) {
            throw new UnsupportedOperationException("Token not found.");
        }
        if (endpoint.equals(myAddress)) {
            throw new UnsupportedOperationException("Cannot remove node's own token");
        }
        if (Gossiper.instance.getLiveMembers().contains(endpoint)) {
            throw new UnsupportedOperationException("Node " + endpoint + " is alive and owns this token. Use decommission command to remove it from the ring");
        }
        if (this.tokenMetadata_.isLeaving(endpoint)) {
            logger_.warn("Node " + endpoint + " is already being removed, continuing removal anyway");
        }
        if (!this.replicatingNodes.isEmpty()) {
            throw new UnsupportedOperationException("This node is already processing a removal. Wait for it to complete, or use 'removetoken force' if this has failed.");
        }
        for (String table : Schema.instance.getNonSystemTables()) {
            if (Table.open(table).getReplicationStrategy().getReplicationFactor() == 1) continue;
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(table, endpoint);
            IFailureDetector failureDetector = FailureDetector.instance;
            for (InetAddress ep : changedRanges.values()) {
                if (failureDetector.isAlive(ep)) {
                    this.replicatingNodes.add(ep);
                    continue;
                }
                logger_.warn("Endpoint " + ep + " is down and will not receive data for re-replication of " + endpoint);
            }
        }
        this.removingNode = endpoint;
        this.tokenMetadata_.addLeavingEndpoint(endpoint);
        this.calculatePendingRanges();
        Gossiper.instance.advertiseRemoving(endpoint, token, localToken);
        this.restoreReplicaCount(endpoint, myAddress);
        while (!this.replicatingNodes.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.excise(token, endpoint);
        Gossiper.instance.advertiseTokenRemoved(endpoint, token);
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    public void confirmReplication(InetAddress node) {
        if (!this.replicatingNodes.isEmpty()) {
            this.replicatingNodes.remove(node);
        } else {
            logger_.info("Received unexpected REPLICATION_FINISHED message from " + node + ". Was this node recently a removal coordinator?");
        }
    }

    public boolean isClientMode() {
        return this.isClientMode;
    }

    public synchronized void requestGC() {
        if (this.hasUnreclaimedSpace()) {
            logger_.info("requesting GC to free disk space");
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private boolean hasUnreclaimedSpace() {
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (!cfs.hasUnreclaimedSpace()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOperationMode() {
        return this.operationMode.toString();
    }

    @Override
    public String getDrainProgress() {
        return String.format("Drained %s/%s ColumnFamilies", this.remainingCFs, this.totalCFs);
    }

    @Override
    public synchronized void drain() throws IOException, InterruptedException, ExecutionException {
        ThreadPoolExecutor mutationStage = StageManager.getStage(Stage.MUTATION);
        if (mutationStage.isTerminated()) {
            logger_.warn("Cannot drain node (did it already happen?)");
            return;
        }
        this.setMode(Mode.DRAINING, "starting drain process", true);
        this.stopRPCServer();
        optionalTasks.shutdown();
        Gossiper.instance.stop();
        this.setMode(Mode.DRAINING, "shutting down MessageService", false);
        MessagingService.instance().shutdown();
        this.setMode(Mode.DRAINING, "waiting for streaming", false);
        MessagingService.instance().waitForStreaming();
        this.setMode(Mode.DRAINING, "clearing mutation stage", false);
        mutationStage.shutdown();
        mutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
        StorageProxy.instance.verifyNoHintsInProgress();
        this.setMode(Mode.DRAINING, "flushing column families", false);
        ArrayList<ColumnFamilyStore> cfses = new ArrayList<ColumnFamilyStore>();
        for (String tableName : Schema.instance.getNonSystemTables()) {
            Table table = Table.open(tableName);
            cfses.addAll(table.getColumnFamilyStores());
        }
        this.totalCFs = this.remainingCFs = cfses.size();
        for (ColumnFamilyStore cfs : cfses) {
            cfs.forceBlockingFlush();
            --this.remainingCFs;
        }
        ColumnFamilyStore.postFlushExecutor.shutdown();
        ColumnFamilyStore.postFlushExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        CommitLog.instance.shutdownBlocking();
        tasks.shutdown();
        if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
            logger_.warn("Miscellaneous task executor still busy after one minute; proceeding with shutdown");
        }
        this.setMode(Mode.DRAINED, true);
    }

    IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner oldPartitioner = DatabaseDescriptor.getPartitioner();
        DatabaseDescriptor.setPartitioner(newPartitioner);
        this.valueFactory = new VersionedValue.VersionedValueFactory(StorageService.getPartitioner());
        return oldPartitioner;
    }

    TokenMetadata setTokenMetadataUnsafe(TokenMetadata tmd) {
        TokenMetadata old = this.tokenMetadata_;
        this.tokenMetadata_ = tmd;
        return old;
    }

    @Override
    public void truncate(String keyspace, String columnFamily) throws UnavailableException, TimeoutException, IOException {
        StorageProxy.truncateBlocking(keyspace, columnFamily);
    }

    @Override
    public Map<String, Float> getOwnership() {
        ArrayList<Token> sortedTokens = new ArrayList<Token>(this.tokenMetadata_.getTokenToEndpointMapForReading().keySet());
        Collections.sort(sortedTokens);
        Map<Token, Float> token_map = StorageService.getPartitioner().describeOwnership(sortedTokens);
        HashMap<String, Float> string_map = new HashMap<String, Float>();
        for (Map.Entry<Token, Float> entry : token_map.entrySet()) {
            string_map.put(entry.getKey().toString(), entry.getValue());
        }
        return string_map;
    }

    @Override
    public List<String> getKeyspaces() {
        ArrayList<String> tableslist = new ArrayList<String>(Schema.instance.getTables());
        return Collections.unmodifiableList(tableslist);
    }

    @Override
    public void updateSnitch(String epSnitchClassName, Boolean dynamic, Integer dynamicUpdateInterval, Integer dynamicResetInterval, Double dynamicBadnessThreshold) throws ConfigurationException {
        IEndpointSnitch oldSnitch = DatabaseDescriptor.getEndpointSnitch();
        IEndpointSnitch newSnitch = (IEndpointSnitch)FBUtilities.construct(epSnitchClassName, "snitch");
        if (dynamic.booleanValue()) {
            DatabaseDescriptor.setDynamicUpdateInterval(dynamicUpdateInterval);
            DatabaseDescriptor.setDynamicResetInterval(dynamicResetInterval);
            DatabaseDescriptor.setDynamicBadnessThreshold(dynamicBadnessThreshold);
            newSnitch = new DynamicEndpointSnitch(newSnitch);
        }
        DatabaseDescriptor.setEndpointSnitch(newSnitch);
        for (String ks : Schema.instance.getTables()) {
            Table.open((String)ks).getReplicationStrategy().snitch = newSnitch;
        }
        if (oldSnitch instanceof DynamicEndpointSnitch) {
            ((DynamicEndpointSnitch)oldSnitch).unregisterMBean();
        }
    }

    public void flushLargestMemtables() {
        ColumnFamilyStore largest = null;
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            long total = cfs.getTotalMemtableLiveSize();
            if (total <= 0L || largest != null && total <= largest.getTotalMemtableLiveSize()) continue;
            logger_.debug(total + " estimated memtable size for " + cfs);
            largest = cfs;
        }
        if (largest == null) {
            logger_.info("Unable to reduce heap usage since there are no dirty column families");
            return;
        }
        logger_.warn("Flushing " + largest + " to relieve memory pressure");
        largest.forceFlush();
    }

    private CountDownLatch streamRanges(Map<String, Multimap<Range<Token>, InetAddress>> rangesToStreamByTable) {
        final CountDownLatch latch = new CountDownLatch(rangesToStreamByTable.keySet().size());
        for (Map.Entry<String, Multimap<Range<Token>, InetAddress>> entry : rangesToStreamByTable.entrySet()) {
            Multimap<Range<Token>, InetAddress> rangesWithEndpoints = entry.getValue();
            if (rangesWithEndpoints.isEmpty()) {
                latch.countDown();
                continue;
            }
            final String table = entry.getKey();
            final HashSet pending = new HashSet(rangesWithEndpoints.entries());
            for (final Map.Entry endPointEntry : rangesWithEndpoints.entries()) {
                final Range range = (Range)endPointEntry.getKey();
                final InetAddress newEndpoint = (InetAddress)endPointEntry.getValue();
                final Runnable callback = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set set = pending;
                        synchronized (set) {
                            pending.remove(endPointEntry);
                            if (pending.isEmpty()) {
                                latch.countDown();
                            }
                        }
                    }
                };
                StageManager.getStage(Stage.STREAM).execute(new Runnable(){

                    @Override
                    public void run() {
                        StreamOut.transferRanges(newEndpoint, Table.open(table), Arrays.asList(range), callback, OperationType.UNBOOTSTRAP);
                    }
                });
            }
        }
        return latch;
    }

    private CountDownLatch requestRanges(Map<String, Multimap<InetAddress, Range<Token>>> ranges) {
        final CountDownLatch latch = new CountDownLatch(ranges.keySet().size());
        for (Map.Entry<String, Multimap<InetAddress, Range<Token>>> entry : ranges.entrySet()) {
            Multimap<InetAddress, Range<Token>> endpointWithRanges = entry.getValue();
            if (endpointWithRanges.isEmpty()) {
                latch.countDown();
                continue;
            }
            String table = entry.getKey();
            final HashSet pending = new HashSet(endpointWithRanges.keySet());
            for (final InetAddress source : endpointWithRanges.keySet()) {
                Collection toFetch = endpointWithRanges.get((Object)source);
                Runnable callback = new Runnable(){

                    @Override
                    public void run() {
                        pending.remove(source);
                        if (pending.isEmpty()) {
                            latch.countDown();
                        }
                    }
                };
                if (logger_.isDebugEnabled()) {
                    logger_.debug("Requesting from " + source + " ranges " + StringUtils.join((Collection)toFetch, (String)", "));
                }
                StreamIn.requestRanges(source, table, toFetch, callback, OperationType.BOOTSTRAP);
            }
        }
        return latch;
    }

    public Pair<Set<Range<Token>>, Set<Range<Token>>> calculateStreamAndFetchRanges(Collection<Range<Token>> current, Collection<Range<Token>> updated) {
        boolean intersect;
        HashSet<Range<Token>> toStream = new HashSet<Range<Token>>();
        HashSet<Range<Token>> toFetch = new HashSet<Range<Token>>();
        for (Range<Token> r1 : current) {
            intersect = false;
            for (Range<Token> r2 : updated) {
                if (!r1.intersects(r2)) continue;
                toStream.addAll(r1.subtract(r2));
                intersect = true;
                break;
            }
            if (intersect) continue;
            toStream.add(r1);
        }
        for (Range<Token> r2 : updated) {
            intersect = false;
            for (Range<Token> r1 : current) {
                if (!r2.intersects(r1)) continue;
                toFetch.addAll(r2.subtract(r1));
                intersect = true;
                break;
            }
            if (intersect) continue;
            toFetch.add(r2);
        }
        return new Pair<Set<Range<Token>>, Set<Range<Token>>>(toStream, toFetch);
    }

    @Override
    public void bulkLoad(String directory) {
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory " + directory);
        }
        SSTableLoader.Client client = new SSTableLoader.Client(){

            @Override
            public void init(String keyspace) {
                for (Map.Entry<Range<Token>, List<InetAddress>> entry : instance.getRangeToAddressMap(keyspace).entrySet()) {
                    Range<Token> range = entry.getKey();
                    for (InetAddress endpoint : entry.getValue()) {
                        this.addRangeForEndpoint(range, endpoint);
                    }
                }
            }

            @Override
            public boolean validateColumnFamily(String keyspace, String cfName) {
                return Schema.instance.getCFMetaData(keyspace, cfName) != null;
            }
        };
        SSTableLoader.OutputHandler oh = new SSTableLoader.OutputHandler(){

            @Override
            public void output(String msg) {
                logger_.info(msg);
            }

            @Override
            public void debug(String msg) {
                logger_.debug(msg);
            }
        };
        SSTableLoader loader = new SSTableLoader(dir, client, oh);
        try {
            loader.stream().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getExceptionCount() {
        return AbstractCassandraDaemon.exceptions.get();
    }

    @Override
    public void rescheduleFailedDeletions() {
        SSTableDeletingTask.rescheduleFailedTasks();
    }

    @Override
    public void loadNewSSTables(String ksName, String cfName) {
        ColumnFamilyStore.loadNewSSTables(ksName, cfName);
    }

    @Override
    public List<String> getRangeKeySample() {
        List<DecoratedKey> keys = this.keySamples(ColumnFamilyStore.allUserDefined(), this.getLocalPrimaryRange());
        ArrayList<String> sampledKeys = new ArrayList<String>();
        for (DecoratedKey key : keys) {
            sampledKeys.add(((Token)key.getToken()).toString());
        }
        return sampledKeys;
    }

    @Override
    public void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore.rebuildSecondaryIndex(ksName, cfName, idxNames);
    }

    static {
        tasks.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        instance = new StorageService();
        nextRepairCommand = new AtomicInteger();
    }

    private static enum Mode {
        NORMAL,
        CLIENT,
        JOINING,
        LEAVING,
        DECOMMISSIONED,
        MOVING,
        DRAINING,
        DRAINED;

    }

    public static enum Verb {
        MUTATION,
        BINARY,
        READ_REPAIR,
        READ,
        REQUEST_RESPONSE,
        STREAM_INITIATE,
        STREAM_INITIATE_DONE,
        STREAM_REPLY,
        STREAM_REQUEST,
        RANGE_SLICE,
        BOOTSTRAP_TOKEN,
        TREE_REQUEST,
        TREE_RESPONSE,
        JOIN,
        GOSSIP_DIGEST_SYN,
        GOSSIP_DIGEST_ACK,
        GOSSIP_DIGEST_ACK2,
        DEFINITIONS_ANNOUNCE,
        DEFINITIONS_UPDATE,
        MIGRATION_REQUEST,
        TRUNCATE,
        SCHEMA_CHECK,
        INDEX_SCAN,
        REPLICATION_FINISHED,
        INTERNAL_RESPONSE,
        COUNTER_MUTATION,
        STREAMING_REPAIR_REQUEST,
        STREAMING_REPAIR_RESPONSE,
        SNAPSHOT,
        UNUSED_1,
        UNUSED_2,
        UNUSED_3;

    }
}

