/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import org.apache.cassandra.cli.CliSessionState;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliOptions {
    private static CLIOptions options = null;
    private static final String TOOL_NAME = "cassandra-cli";
    private static final String HOST_OPTION = "host";
    private static final String PORT_OPTION = "port";
    private static final String UNFRAME_OPTION = "unframed";
    private static final String DEBUG_OPTION = "debug";
    private static final String USERNAME_OPTION = "username";
    private static final String PASSWORD_OPTION = "password";
    private static final String KEYSPACE_OPTION = "keyspace";
    private static final String BATCH_OPTION = "batch";
    private static final String HELP_OPTION = "help";
    private static final String FILE_OPTION = "file";
    private static final String JMX_PORT_OPTION = "jmxport";
    private static final String JMX_USERNAME_OPTION = "jmxusername";
    private static final String JMX_PASSWORD_OPTION = "jmxpassword";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String SCHEMA_MIGRATION_WAIT_TIME = "schema-mwt";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_THRIFT_PORT = 9160;

    private static void printUsage() {
        new HelpFormatter().printHelp(TOOL_NAME, (Options)options);
    }

    public void processArgs(CliSessionState css, String[] args) {
        GnuParser parser = new GnuParser();
        try {
            CommandLine cmd = parser.parse((Options)options, args, false);
            css.hostName = cmd.hasOption(HOST_OPTION) ? cmd.getOptionValue(HOST_OPTION) : DEFAULT_HOST;
            if (cmd.hasOption(UNFRAME_OPTION)) {
                css.framed = false;
            }
            if (cmd.hasOption(DEBUG_OPTION)) {
                css.debug = true;
            }
            css.thriftPort = cmd.hasOption(PORT_OPTION) ? Integer.parseInt(cmd.getOptionValue(PORT_OPTION)) : 9160;
            css.username = cmd.hasOption(USERNAME_OPTION) ? cmd.getOptionValue(USERNAME_OPTION) : "default";
            css.password = cmd.hasOption(PASSWORD_OPTION) ? cmd.getOptionValue(PASSWORD_OPTION) : "";
            if (cmd.hasOption(KEYSPACE_OPTION)) {
                css.keyspace = cmd.getOptionValue(KEYSPACE_OPTION);
            }
            if (cmd.hasOption(BATCH_OPTION)) {
                css.batch = true;
            }
            if (cmd.hasOption(FILE_OPTION)) {
                css.filename = cmd.getOptionValue(FILE_OPTION);
            }
            if (cmd.hasOption(JMX_PORT_OPTION)) {
                css.jmxPort = Integer.parseInt(cmd.getOptionValue(JMX_PORT_OPTION));
            }
            if (cmd.hasOption(JMX_USERNAME_OPTION)) {
                css.jmxUsername = cmd.getOptionValue(JMX_USERNAME_OPTION);
            }
            if (cmd.hasOption(JMX_PASSWORD_OPTION)) {
                css.jmxPassword = cmd.getOptionValue(JMX_PASSWORD_OPTION);
            }
            if (cmd.hasOption(HELP_OPTION)) {
                CliOptions.printUsage();
                System.exit(1);
            }
            if (cmd.hasOption(VERBOSE_OPTION)) {
                css.verbose = true;
            }
            if (cmd.hasOption(SCHEMA_MIGRATION_WAIT_TIME)) {
                css.schema_mwt = Integer.parseInt(cmd.getOptionValue(SCHEMA_MIGRATION_WAIT_TIME)) * 1000;
            }
            if (cmd.getArgs().length > 0) {
                System.err.printf("Unknown argument: %s\n", cmd.getArgs()[0]);
                System.err.println();
                CliOptions.printUsage();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.err.println();
            CliOptions.printUsage();
            System.exit(1);
        }
    }

    static {
        options = new CLIOptions();
        options.addOption("h", HOST_OPTION, "HOSTNAME", "cassandra server's host name");
        options.addOption("p", PORT_OPTION, "PORT", "cassandra server's thrift port");
        options.addOption("u", USERNAME_OPTION, "USERNAME", "user name for cassandra authentication");
        options.addOption("pw", PASSWORD_OPTION, "PASSWORD", "password for cassandra authentication");
        options.addOption("k", KEYSPACE_OPTION, "KEYSPACE", "cassandra keyspace user is authenticated against");
        options.addOption("f", FILE_OPTION, "FILENAME", "load statements from the specific file");
        options.addOption(null, JMX_PORT_OPTION, "JMX-PORT", "JMX service port");
        options.addOption(null, JMX_USERNAME_OPTION, "JMX-USERNAME", "JMX service username");
        options.addOption(null, JMX_PASSWORD_OPTION, "JMX-PASSWORD", "JMX service password");
        options.addOption(null, SCHEMA_MIGRATION_WAIT_TIME, "TIME", "Schema migration wait time (secs.), default is 10 secs");
        options.addOption("B", BATCH_OPTION, "enabled batch mode (suppress output; errors are fatal)");
        options.addOption(null, UNFRAME_OPTION, "use cassandra server's unframed transport");
        options.addOption(null, DEBUG_OPTION, "display stack-traces (NOTE: We print strack-traces in the places where it makes sense even without --debug)");
        options.addOption("?", HELP_OPTION, "usage help");
        options.addOption("v", VERBOSE_OPTION, "verbose output when using batch mode");
    }

    private static class CLIOptions
    extends Options {
        private CLIOptions() {
        }

        public Options addOption(String opt, String longOpt, String argName, String description) {
            Option option = new Option(opt, longOpt, true, description);
            option.setArgName(argName);
            return this.addOption(option);
        }

        public Options addOption(String opt, String longOpt, String description) {
            return this.addOption(new Option(opt, longOpt, false, description));
        }
    }
}

