/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class ColumnDefinition {
    public final ByteBuffer name;
    private AbstractType<?> validator;
    private IndexType index_type;
    private Map<String, String> index_options;
    private String index_name;
    public final Integer componentIndex;

    public ColumnDefinition(ByteBuffer name, AbstractType<?> validator, IndexType index_type, Map<String, String> index_options, String index_name, Integer componentIndex) {
        assert (name != null && validator != null);
        this.name = name;
        this.index_name = index_name;
        this.validator = validator;
        this.componentIndex = componentIndex;
        this.setIndexType(index_type, index_options);
    }

    public static ColumnDefinition ascii(String name, Integer cidx) {
        return new ColumnDefinition(ByteBufferUtil.bytes(name), AsciiType.instance, null, null, null, cidx);
    }

    public static ColumnDefinition bool(String name, Integer cidx) {
        return new ColumnDefinition(ByteBufferUtil.bytes(name), BooleanType.instance, null, null, null, cidx);
    }

    public static ColumnDefinition utf8(String name, Integer cidx) {
        return new ColumnDefinition(ByteBufferUtil.bytes(name), UTF8Type.instance, null, null, null, cidx);
    }

    public static ColumnDefinition int32(String name, Integer cidx) {
        return new ColumnDefinition(ByteBufferUtil.bytes(name), Int32Type.instance, null, null, null, cidx);
    }

    public static ColumnDefinition double_(String name, Integer cidx) {
        return new ColumnDefinition(ByteBufferUtil.bytes(name), DoubleType.instance, null, null, null, cidx);
    }

    public ColumnDefinition clone() {
        return new ColumnDefinition(this.name, this.validator, this.index_type, this.index_options, this.index_name, this.componentIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        if (this.index_name != null ? !this.index_name.equals(that.index_name) : that.index_name != null) {
            return false;
        }
        if (this.index_type != that.index_type) {
            return false;
        }
        if (this.index_options != null ? !((Object)this.index_options).equals(that.index_options) : that.index_options != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.componentIndex != null ? !this.componentIndex.equals(that.componentIndex) : that.componentIndex != null) {
            return false;
        }
        return !(this.validator == null ? that.validator != null : !this.validator.equals(that.validator));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.validator != null ? this.validator.hashCode() : 0);
        result = 31 * result + (this.index_type != null ? this.index_type.hashCode() : 0);
        result = 31 * result + (this.index_options != null ? ((Object)this.index_options).hashCode() : 0);
        result = 31 * result + (this.index_name != null ? this.index_name.hashCode() : 0);
        result = 31 * result + (this.componentIndex != null ? this.componentIndex.hashCode() : 0);
        return result;
    }

    public ColumnDef toThrift() {
        ColumnDef cd = new ColumnDef();
        cd.setName(ByteBufferUtil.clone(this.name));
        cd.setValidation_class(this.validator.toString());
        cd.setIndex_type(this.index_type == null ? null : IndexType.valueOf((String)this.index_type.name()));
        cd.setIndex_name(this.index_name == null ? null : this.index_name);
        cd.setIndex_options(this.index_options == null ? null : Maps.newHashMap(this.index_options));
        return cd;
    }

    public static ColumnDefinition fromThrift(ColumnDef thriftColumnDef) throws ConfigurationException {
        return new ColumnDefinition(ByteBufferUtil.clone(thriftColumnDef.name), TypeParser.parse(thriftColumnDef.validation_class), thriftColumnDef.index_type, thriftColumnDef.index_options, thriftColumnDef.index_name, null);
    }

    public static Map<ByteBuffer, ColumnDefinition> fromThrift(List<ColumnDef> thriftDefs) throws ConfigurationException {
        if (thriftDefs == null) {
            return new HashMap<ByteBuffer, ColumnDefinition>();
        }
        TreeMap<ByteBuffer, ColumnDefinition> cds = new TreeMap<ByteBuffer, ColumnDefinition>();
        for (ColumnDef thriftColumnDef : thriftDefs) {
            cds.put(ByteBufferUtil.clone(thriftColumnDef.name), ColumnDefinition.fromThrift(thriftColumnDef));
        }
        return cds;
    }

    public void deleteFromSchema(RowMutation rm, String cfName, AbstractType<?> comparator, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_columns");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "validator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_type"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_options"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_name"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "component_index"));
    }

    public void toSchema(RowMutation rm, String cfName, AbstractType<?> comparator, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_columns");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(Column.create(this.validator.toString(), timestamp, cfName, comparator.getString(this.name), "validator"));
        cf.addColumn(this.index_type == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_type") : Column.create(this.index_type.toString(), timestamp, cfName, comparator.getString(this.name), "index_type"));
        cf.addColumn(this.index_options == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_options") : Column.create(FBUtilities.json(this.index_options), timestamp, cfName, comparator.getString(this.name), "index_options"));
        cf.addColumn(this.index_name == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "index_name") : Column.create(this.index_name, timestamp, cfName, comparator.getString(this.name), "index_name"));
        cf.addColumn(this.componentIndex == null ? DeletedColumn.create(ldt, timestamp, cfName, comparator.getString(this.name), "component_index") : Column.create(this.componentIndex, timestamp, cfName, comparator.getString(this.name), "component_index"));
    }

    public void apply(ColumnDefinition def, AbstractType<?> comparator) throws ConfigurationException {
        if (this.getIndexType() != null && def.getIndexType() != null) {
            if (!def.getValidator().isCompatibleWith(this.getValidator())) {
                throw new ConfigurationException(String.format("Cannot modify validator to a non-compatible one for column %s since an index is set", comparator.getString(this.name)));
            }
            assert (this.getIndexName() != null);
            if (!this.getIndexName().equals(def.getIndexName())) {
                throw new ConfigurationException("Cannot modify index name");
            }
        }
        if (this.componentIndex != null && !this.componentIndex.equals(def.componentIndex) || this.componentIndex == null && def.componentIndex != null) {
            throw new ConfigurationException(String.format("Cannot modify component index for column %s", comparator.getString(this.name)));
        }
        this.setValidator(def.getValidator());
        this.setIndexType(def.getIndexType(), def.getIndexOptions());
        this.setIndexName(def.getIndexName());
    }

    public static List<ColumnDefinition> fromSchema(Row row, CFMetaData cfm) {
        if (row.cf == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDefinition> cds = new ArrayList<ColumnDefinition>();
        for (UntypedResultSet.Row result : QueryProcessor.resultify("SELECT * FROM system.schema_columns", row)) {
            try {
                IndexType index_type = null;
                Map<String, String> index_options = null;
                String index_name = null;
                Integer componentIndex = null;
                if (result.has("index_type")) {
                    index_type = IndexType.valueOf((String)result.getString("index_type"));
                }
                if (result.has("index_options")) {
                    index_options = FBUtilities.fromJsonMap(result.getString("index_options"));
                }
                if (result.has("index_name")) {
                    index_name = result.getString("index_name");
                }
                if (result.has("component_index")) {
                    componentIndex = result.getInt("component_index");
                }
                cds.add(new ColumnDefinition(cfm.getColumnDefinitionComparator(componentIndex).fromString(result.getString("column")), TypeParser.parse(result.getString("validator")), index_type, index_options, index_name, componentIndex));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return cds;
    }

    public static Row readSchema(String ksName, String cfName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemTable.getSchemaKSKey(ksName));
        ColumnFamilyStore columnsStore = SystemTable.schemaCFS("schema_columns");
        ColumnFamily cf = columnsStore.getColumnFamily(key, new QueryPath("schema_columns"), DefsTable.searchComposite(cfName, true), DefsTable.searchComposite(cfName, false), false, Integer.MAX_VALUE);
        return new Row(key, cf);
    }

    public String toString() {
        return "ColumnDefinition{name=" + ByteBufferUtil.bytesToHex(this.name) + ", validator=" + this.validator + ", index_type=" + this.index_type + ", index_name='" + this.index_name + '\'' + (this.componentIndex != null ? ", component_index=" + this.componentIndex : "") + '}';
    }

    public String getIndexName() {
        return this.index_name;
    }

    public void setIndexName(String s) {
        this.index_name = s;
    }

    public void setIndexType(IndexType index_type, Map<String, String> index_options) {
        this.index_type = index_type;
        this.index_options = index_options;
    }

    public IndexType getIndexType() {
        return this.index_type;
    }

    public Map<String, String> getIndexOptions() {
        return this.index_options;
    }

    public AbstractType<?> getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractType<?> validator) {
        this.validator = validator;
    }

    public static Map<String, String> getStringMap(Map<CharSequence, CharSequence> charMap) {
        if (charMap == null) {
            return null;
        }
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charMap.entrySet()) {
            stringMap.put(((Object)entry.getKey()).toString(), ((Object)entry.getValue()).toString());
        }
        return stringMap;
    }
}

