/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class TBinaryProtocol
extends org.apache.thrift.protocol.TBinaryProtocol {
    public TBinaryProtocol(TTransport trans) {
        this(trans, false, true);
    }

    public TBinaryProtocol(TTransport trans, int readLength) {
        this(trans);
        if (readLength > 0) {
            this.setReadLength(readLength);
        }
    }

    public TBinaryProtocol(TTransport trans, boolean strictRead, boolean strictWrite) {
        super(trans);
        this.strictRead_ = strictRead;
        this.strictWrite_ = strictWrite;
    }

    public void writeBinary(ByteBuffer buffer) throws TException {
        this.writeI32(buffer.remaining());
        if (buffer.hasArray()) {
            this.trans_.write(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
        } else {
            byte[] bytes = new byte[buffer.remaining()];
            int j = 0;
            for (int i = buffer.position(); i < buffer.limit(); ++i) {
                bytes[j++] = buffer.get(i);
            }
            this.trans_.write(bytes);
        }
    }

    public static class Factory
    extends TBinaryProtocol.Factory {
        public Factory() {
            super(false, true);
        }

        public Factory(boolean strictRead, boolean strictWrite) {
            super(strictRead, strictWrite, 0);
        }

        public Factory(boolean strictRead, boolean strictWrite, int readLength) {
            super(strictRead, strictWrite, readLength);
        }

        public TProtocol getProtocol(TTransport trans) {
            TBinaryProtocol protocol = new TBinaryProtocol(trans, this.strictRead_, this.strictWrite_);
            if (this.readLength_ != 0) {
                protocol.setReadLength(this.readLength_);
            }
            return protocol;
        }
    }
}

