/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.HeapAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnContainer
implements IColumnContainer,
IIterableColumns {
    private static Logger logger = LoggerFactory.getLogger(AbstractColumnContainer.class);
    protected final ISortedColumns columns;

    protected AbstractColumnContainer(ISortedColumns columns) {
        this.columns = columns;
    }

    @Deprecated
    public void delete(int localtime, long timestamp) {
        this.columns.delete(new ISortedColumns.DeletionInfo(timestamp, localtime));
    }

    public void delete(AbstractColumnContainer cc2) {
        this.columns.delete(cc2.columns.getDeletionInfo());
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.getMarkedForDeleteAt() > Long.MIN_VALUE;
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.columns.getDeletionInfo().markedForDeleteAt;
    }

    public int getLocalDeletionTime() {
        return this.columns.getDeletionInfo().localDeletionTime;
    }

    @Override
    public AbstractType<?> getComparator() {
        return this.columns.getComparator();
    }

    public void maybeResetDeletionTimes(int gcBefore) {
        this.columns.maybeResetDeletionTimes(gcBefore);
    }

    public long addAllWithSizeDelta(AbstractColumnContainer cc, Allocator allocator, Function<IColumn, IColumn> transformation) {
        return this.columns.addAllWithSizeDelta(cc.columns, allocator, transformation);
    }

    public void addAll(AbstractColumnContainer cc, Allocator allocator, Function<IColumn, IColumn> transformation) {
        this.columns.addAll(cc.columns, allocator, transformation);
    }

    public void addAll(AbstractColumnContainer cc, Allocator allocator) {
        this.addAll(cc, allocator, (Function<IColumn, IColumn>)Functions.identity());
    }

    @Override
    public void addColumn(IColumn column) {
        this.addColumn(column, HeapAllocator.instance);
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        this.columns.addColumn(column, allocator);
    }

    public IColumn getColumn(ByteBuffer name) {
        return this.columns.getColumn(name);
    }

    @Override
    public boolean replace(IColumn oldColumn, IColumn newColumn) {
        return this.columns.replace(oldColumn, newColumn);
    }

    public SortedSet<ByteBuffer> getColumnNames() {
        return this.columns.getColumnNames();
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.columns.getSortedColumns();
    }

    public Collection<IColumn> getReverseSortedColumns() {
        return this.columns.getReverseSortedColumns();
    }

    @Override
    public void remove(ByteBuffer columnName) {
        this.columns.removeColumn(columnName);
    }

    public void retainAll(AbstractColumnContainer container) {
        this.columns.retainAll(container.columns);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.getColumnCount();
    }

    public int getLiveColumnCount() {
        int count = 0;
        for (IColumn column : this.columns) {
            if (!column.isLive()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.columns.iterator();
    }

    public Iterator<IColumn> reverseIterator() {
        return this.columns.reverseIterator();
    }

    public Iterator<IColumn> iterator(ByteBuffer start) {
        return this.columns.iterator(start);
    }

    public Iterator<IColumn> reverseIterator(ByteBuffer start) {
        return this.columns.reverseIterator(start);
    }

    @Override
    public boolean hasIrrelevantData(int gcBefore) {
        if (this.getLocalDeletionTime() < gcBefore) {
            return true;
        }
        long deletedAt = this.getMarkedForDeleteAt();
        for (IColumn column : this.columns) {
            if (column.mostRecentLiveChangeAt() > deletedAt && !column.hasIrrelevantData(gcBefore)) continue;
            return true;
        }
        return false;
    }
}

