/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.collect.Iterables;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.FastByteArrayOutputStream;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.utils.FBUtilities;

class StreamRequestMessage
implements MessageProducer {
    private static IVersionedSerializer<StreamRequestMessage> serializer_ = new StreamRequestMessageSerializer();
    protected final long sessionId;
    protected final InetAddress target;
    protected final PendingFile file;
    protected final Collection<Range<Token>> ranges;
    protected final String table;
    protected final Iterable<ColumnFamilyStore> columnFamilies;
    protected final OperationType type;

    protected static IVersionedSerializer<StreamRequestMessage> serializer() {
        return serializer_;
    }

    StreamRequestMessage(InetAddress target, Collection<Range<Token>> ranges, String table, Iterable<ColumnFamilyStore> columnFamilies, long sessionId, OperationType type) {
        this.target = target;
        this.ranges = ranges;
        this.table = table;
        this.columnFamilies = columnFamilies;
        this.sessionId = sessionId;
        this.type = type;
        this.file = null;
    }

    StreamRequestMessage(InetAddress target, PendingFile file, long sessionId) {
        this.target = target;
        this.file = file;
        this.sessionId = sessionId;
        this.type = file.type;
        this.ranges = null;
        this.table = null;
        this.columnFamilies = null;
    }

    @Override
    public Message getMessage(Integer version) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            StreamRequestMessage.serializer().serialize(this, dos, version);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.STREAM_REQUEST, bos.toByteArray(), version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        if (this.file == null) {
            sb.append(this.table);
            sb.append("@");
            sb.append(this.columnFamilies.toString());
            sb.append("@");
            sb.append(this.target);
            sb.append("------->");
            for (Range<Token> range : this.ranges) {
                sb.append(range);
                sb.append(" ");
            }
            sb.append((Object)this.type);
        } else {
            sb.append(this.file.toString());
        }
        return sb.toString();
    }

    private static class StreamRequestMessageSerializer
    implements IVersionedSerializer<StreamRequestMessage> {
        private StreamRequestMessageSerializer() {
        }

        @Override
        public void serialize(StreamRequestMessage srm, DataOutput dos, int version) throws IOException {
            dos.writeLong(srm.sessionId);
            CompactEndpointSerializationHelper.serialize(srm.target, dos);
            if (srm.file != null) {
                dos.writeBoolean(true);
                PendingFile.serializer().serialize(srm.file, dos, version);
            } else {
                dos.writeBoolean(false);
                dos.writeUTF(srm.table);
                dos.writeInt(srm.ranges.size());
                for (Range<Token> range : srm.ranges) {
                    AbstractBounds.serializer().serialize((AbstractBounds<?>)range, dos, version);
                }
                if (version > 1) {
                    dos.writeUTF(srm.type.name());
                }
                if (version > 2) {
                    dos.writeInt(Iterables.size(srm.columnFamilies));
                    for (ColumnFamilyStore cfs : srm.columnFamilies) {
                        dos.writeInt(cfs.metadata.cfId);
                    }
                }
            }
        }

        @Override
        public StreamRequestMessage deserialize(DataInput dis, int version) throws IOException {
            long sessionId = dis.readLong();
            InetAddress target = CompactEndpointSerializationHelper.deserialize(dis);
            boolean singleFile = dis.readBoolean();
            if (singleFile) {
                PendingFile file = PendingFile.serializer().deserialize(dis, version);
                return new StreamRequestMessage(target, file, sessionId);
            }
            String table = dis.readUTF();
            int size = dis.readInt();
            ArrayList<Range<Token>> ranges = size == 0 ? null : new ArrayList<Range<Token>>(size);
            for (int i = 0; i < size; ++i) {
                ranges.add((Range)((AbstractBounds)AbstractBounds.serializer().deserialize(dis, version)).toTokenBounds());
            }
            OperationType type = OperationType.RESTORE_REPLICA_COUNT;
            if (version > 1) {
                type = OperationType.valueOf(dis.readUTF());
            }
            ArrayList<ColumnFamilyStore> stores = new ArrayList<ColumnFamilyStore>();
            if (version > 2) {
                int cfsSize = dis.readInt();
                for (int i = 0; i < cfsSize; ++i) {
                    stores.add(Table.open(table).getColumnFamilyStore(dis.readInt()));
                }
            }
            return new StreamRequestMessage(target, ranges, table, stores, sessionId, type);
        }

        @Override
        public long serializedSize(StreamRequestMessage streamRequestMessage, int version) {
            throw new UnsupportedOperationException();
        }
    }
}

