/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcBoolean
extends AbstractJdbcType<Boolean> {
    public static final JdbcBoolean instance = new JdbcBoolean();

    JdbcBoolean() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Boolean obj) {
        return -1;
    }

    @Override
    public int getPrecision(Boolean obj) {
        return -1;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public String toString(Boolean obj) {
        return obj.toString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return Boolean.FALSE.toString();
        }
        if (bytes.remaining() != 1) {
            throw new MarshalException("A boolean is stored in exactly 1 byte: " + bytes.remaining());
        }
        byte value = bytes.get(bytes.position());
        return value == 0 ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public int getJdbcType() {
        return 16;
    }

    @Override
    public Boolean compose(ByteBuffer bytes) {
        byte value = bytes.get(bytes.position());
        return value != 0;
    }

    @Override
    public ByteBuffer decompose(Boolean value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : (value != false ? ByteBuffer.wrap(new byte[]{1}) : ByteBuffer.wrap(new byte[]{0}));
    }
}

