/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public abstract class PoolingSegmentedFile
extends SegmentedFile {
    public final Queue<RandomAccessReader> pool = new ConcurrentLinkedQueue<RandomAccessReader>();

    protected PoolingSegmentedFile(String path, long length) {
        super(path, length);
    }

    protected PoolingSegmentedFile(String path, long length, long onDiskLength) {
        super(path, length, onDiskLength);
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = this.pool.poll();
        if (reader == null) {
            reader = this.createReader(this.path);
        }
        reader.seek(position);
        return reader;
    }

    protected abstract RandomAccessReader createReader(String var1);

    public void recycle(RandomAccessReader reader) {
        this.pool.add(reader);
    }

    @Override
    public void cleanup() {
        for (RandomAccessReader reader : this.pool) {
            reader.deallocate();
        }
    }
}

