/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.streaming.IStreamCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamSession
implements IEndpointStateChangeSubscriber,
IFailureDetectionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStreamSession.class);
    protected final InetAddress host;
    protected final UUID sessionId;
    protected String table;
    protected final IStreamCallback callback;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    protected AbstractStreamSession(String table, InetAddress host, UUID sessionId, IStreamCallback callback) {
        this.host = host;
        this.sessionId = sessionId;
        this.table = table;
        this.callback = callback;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void close(boolean success) {
        if (!this.isClosed.compareAndSet(false, true)) {
            logger.debug("Stream session {} already closed", (Object)this.getSessionId());
            return;
        }
        this.closeInternal(success);
        Gossiper.instance.unregister(this);
        FailureDetector.instance.unregisterFailureDetectionEventListener(this);
        logger.debug("closing with status " + success);
        if (this.callback != null) {
            if (success) {
                this.callback.onSuccess();
            } else {
                this.callback.onFailure();
            }
        }
    }

    protected abstract void closeInternal(boolean var1);

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState epState) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress endpoint, double phi) {
        if (!endpoint.equals(this.getHost())) {
            return;
        }
        if (phi < 2.0 * DatabaseDescriptor.getPhiConvictThreshold()) {
            return;
        }
        logger.error("Stream failed because {} died or was restarted/removed (streams may still be active in background, but further streams won't be started)", (Object)endpoint);
        this.close(false);
    }
}

