/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;

public class CounterUpdateColumn
extends Column {
    public CounterUpdateColumn(ByteBuffer name, long value, long timestamp) {
        this(name, ByteBufferUtil.bytes(value), timestamp);
    }

    public CounterUpdateColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    public long delta() {
        return this.value().getLong(this.value().position());
    }

    @Override
    public Column diff(Column column) {
        throw new UnsupportedOperationException("This operation is unsupported on CounterUpdateColumn.");
    }

    @Override
    public CounterUpdateColumn withUpdatedName(ByteBuffer newName) {
        return new CounterUpdateColumn(newName, this.value, this.timestamp);
    }

    @Override
    public Column reconcile(Column column, Allocator allocator) {
        assert (column instanceof CounterUpdateColumn || column instanceof DeletedColumn) : "Wrong class type.";
        if (column.isMarkedForDelete(Long.MIN_VALUE)) {
            return this.timestamp() > column.timestamp() ? this : column;
        }
        CounterUpdateColumn c = (CounterUpdateColumn)column;
        return new CounterUpdateColumn(this.name(), this.delta() + c.delta(), Math.max(this.timestamp(), c.timestamp()));
    }

    @Override
    public int serializationFlags() {
        return 8;
    }

    @Override
    public CounterColumn localCopy(ColumnFamilyStore cfs) {
        return new CounterColumn(cfs.internOrCopy(this.name, HeapAllocator.instance), CounterContext.instance().createLocal(this.delta(), HeapAllocator.instance), this.timestamp(), Long.MIN_VALUE);
    }

    @Override
    public Column localCopy(ColumnFamilyStore cfs, Allocator allocator) {
        return new CounterColumn(cfs.internOrCopy(this.name, allocator), CounterContext.instance().createLocal(this.delta(), allocator), this.timestamp(), Long.MIN_VALUE);
    }
}

