/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.SuperColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

class SliceFromReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    SliceFromReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand rm, DataOutput out, int version) throws IOException {
        this.serialize(rm, null, out, version);
    }

    public void serialize(ReadCommand rm, ByteBuffer superColumn, DataOutput out, int version) throws IOException {
        SliceFromReadCommand realRM = (SliceFromReadCommand)rm;
        out.writeBoolean(realRM.isDigestQuery());
        out.writeUTF(realRM.ksName);
        ByteBufferUtil.writeWithShortLength(realRM.key, out);
        if (version < 7) {
            new QueryPath(realRM.cfName, superColumn).serialize(out);
        } else {
            out.writeUTF(realRM.cfName);
        }
        if (version >= 7) {
            out.writeLong(realRM.timestamp);
        }
        SliceQueryFilter.serializer.serialize(realRM.filter, out, version);
    }

    @Override
    public ReadCommand deserialize(DataInput in, int version) throws IOException {
        SliceQueryFilter filter;
        String cfName;
        boolean isDigest = in.readBoolean();
        String keyspaceName = in.readUTF();
        ByteBuffer key = ByteBufferUtil.readWithShortLength(in);
        ByteBuffer sc = null;
        if (version < 7) {
            QueryPath path = QueryPath.deserialize(in);
            cfName = path.columnFamilyName;
            sc = path.superColumnName;
        } else {
            cfName = in.readUTF();
        }
        long timestamp = version < 7 ? System.currentTimeMillis() : in.readLong();
        CFMetaData metadata = Schema.instance.getCFMetaData(keyspaceName, cfName);
        if (metadata == null) {
            String message = String.format("Got slice command for nonexistent table %s.%s.  If the table was just created, this is likely due to the schema not being fully propagated.  Please wait for schema agreement on table creation.", keyspaceName, cfName);
            throw new UnknownColumnFamilyException(message, null);
        }
        if (version < 7) {
            filter = SliceQueryFilter.serializer.deserialize(in, version);
            if (metadata.cfType == ColumnFamilyType.Super) {
                filter = SuperColumns.fromSCSliceFilter((CompositeType)metadata.comparator, sc, filter);
            }
        } else {
            filter = SliceQueryFilter.serializer.deserialize(in, version);
        }
        SliceFromReadCommand command = new SliceFromReadCommand(keyspaceName, key, cfName, timestamp, filter);
        command.setDigestQuery(isDigest);
        return command;
    }

    @Override
    public long serializedSize(ReadCommand cmd, int version) {
        return this.serializedSize(cmd, null, version);
    }

    public long serializedSize(ReadCommand cmd, ByteBuffer superColumn, int version) {
        TypeSizes sizes = TypeSizes.NATIVE;
        SliceFromReadCommand command = (SliceFromReadCommand)cmd;
        int keySize = command.key.remaining();
        int size = sizes.sizeof(cmd.isDigestQuery());
        size += sizes.sizeof(command.ksName);
        size += sizes.sizeof((short)keySize) + keySize;
        size = version < 7 ? (size += new QueryPath(command.cfName, superColumn).serializedSize(sizes)) : (size += sizes.sizeof(command.cfName));
        if (version >= 7) {
            size += sizes.sizeof(cmd.timestamp);
        }
        size = (int)((long)size + SliceQueryFilter.serializer.serializedSize(command.filter, version));
        return size;
    }
}

