/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractType<T>
implements Comparator<ByteBuffer> {
    public final Comparator<IndexHelper.IndexInfo> indexComparator = new Comparator<IndexHelper.IndexInfo>(){

        @Override
        public int compare(IndexHelper.IndexInfo o1, IndexHelper.IndexInfo o2) {
            return AbstractType.this.compare(o1.lastName, o2.lastName);
        }
    };
    public final Comparator<IndexHelper.IndexInfo> indexReverseComparator = new Comparator<IndexHelper.IndexInfo>(){

        @Override
        public int compare(IndexHelper.IndexInfo o1, IndexHelper.IndexInfo o2) {
            return AbstractType.this.compare(o1.firstName, o2.firstName);
        }
    };
    public final Comparator<Column> columnComparator = new Comparator<Column>(){

        @Override
        public int compare(Column c1, Column c2) {
            return AbstractType.this.compare(c1.name(), c2.name());
        }
    };
    public final Comparator<Column> columnReverseComparator = new Comparator<Column>(){

        @Override
        public int compare(Column c1, Column c2) {
            return AbstractType.this.compare(c2.name(), c1.name());
        }
    };
    public final Comparator<OnDiskAtom> onDiskAtomComparator = new Comparator<OnDiskAtom>(){

        @Override
        public int compare(OnDiskAtom c1, OnDiskAtom c2) {
            int comp = AbstractType.this.compare(c1.name(), c2.name());
            if (comp != 0) {
                return comp;
            }
            if (c1 instanceof RangeTombstone) {
                if (c2 instanceof RangeTombstone) {
                    RangeTombstone t1 = (RangeTombstone)c1;
                    RangeTombstone t2 = (RangeTombstone)c2;
                    int comp2 = AbstractType.this.compare(t1.max, t2.max);
                    if (comp2 == 0) {
                        return ((DeletionTime)t1.data).compareTo((DeletionTime)t2.data);
                    }
                    return comp2;
                }
                return -1;
            }
            if (c2 instanceof RangeTombstone) {
                return 1;
            }
            return 0;
        }
    };
    public final Comparator<ByteBuffer> reverseComparator = new Comparator<ByteBuffer>(){

        @Override
        public int compare(ByteBuffer o1, ByteBuffer o2) {
            if (o1.remaining() == 0) {
                return o2.remaining() == 0 ? 0 : -1;
            }
            if (o2.remaining() == 0) {
                return 1;
            }
            return AbstractType.this.compare(o2, o1);
        }
    };

    protected AbstractType() {
    }

    public T compose(ByteBuffer bytes) {
        return this.getSerializer().deserialize(bytes);
    }

    public ByteBuffer decompose(T value) {
        return this.getSerializer().serialize(value);
    }

    public String getString(ByteBuffer bytes) {
        TypeSerializer<T> serializer = this.getSerializer();
        serializer.validate(bytes);
        return serializer.toString(serializer.deserialize(bytes));
    }

    public abstract ByteBuffer fromString(String var1) throws MarshalException;

    public ByteBuffer fromStringCQL2(String source) throws MarshalException {
        return this.fromString(source);
    }

    public void validate(ByteBuffer bytes) throws MarshalException {
        this.getSerializer().validate(bytes);
    }

    public CQL3Type asCQL3Type() {
        return new CQL3Type.Custom(this);
    }

    public abstract TypeSerializer<T> getSerializer();

    public Comparator<ByteBuffer> getReverseComparator() {
        return this.reverseComparator;
    }

    public String getString(Collection<ByteBuffer> names) {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer name : names) {
            builder.append(this.getString(name)).append(",");
        }
        return builder.toString();
    }

    public String getColumnsString(Iterable<Column> columns) {
        StringBuilder builder = new StringBuilder();
        for (Column column : columns) {
            builder.append(column.getString(this)).append(",");
        }
        return builder.toString();
    }

    public boolean isCommutative() {
        return false;
    }

    public boolean isCounter() {
        return false;
    }

    public static AbstractType<?> parseDefaultParameters(AbstractType<?> baseType, TypeParser parser) throws SyntaxException {
        Map<String, String> parameters = parser.getKeyValueParameters();
        String reversed = parameters.get("reversed");
        if (reversed != null && (reversed.isEmpty() || reversed.equals("true"))) {
            return ReversedType.getInstance(baseType);
        }
        return baseType;
    }

    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this.equals(previous);
    }

    public boolean isValueCompatibleWith(AbstractType<?> otherType) {
        return this.isValueCompatibleWithInternal(otherType instanceof ReversedType ? ((ReversedType)otherType).baseType : otherType);
    }

    protected boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this.isCompatibleWith(otherType);
    }

    public int compareCollectionMembers(ByteBuffer v1, ByteBuffer v2, ByteBuffer collectionName) {
        return this.compare(v1, v2);
    }

    public void validateCollectionMember(ByteBuffer bytes, ByteBuffer collectionName) throws MarshalException {
        this.validate(bytes);
    }

    public boolean isCollection() {
        return false;
    }

    public int componentsCount() {
        return 1;
    }

    public List<AbstractType<?>> getComponents() {
        return Collections.singletonList(this);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected boolean intersects(ByteBuffer minColName, ByteBuffer maxColName, ByteBuffer sliceStart, ByteBuffer sliceEnd) {
        return !(!sliceStart.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && this.compare(maxColName, sliceStart) < 0 || !sliceEnd.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && this.compare(sliceEnd, minColName) < 0);
    }

    public boolean intersects(List<ByteBuffer> minColumnNames, List<ByteBuffer> maxColumnNames, SliceQueryFilter filter) {
        assert (minColumnNames.size() == 1);
        for (ColumnSlice slice : filter.slices) {
            ByteBuffer finish;
            ByteBuffer start = filter.isReversed() ? slice.finish : slice.start;
            ByteBuffer byteBuffer = finish = filter.isReversed() ? slice.start : slice.finish;
            if (!this.intersects(minColumnNames.get(0), maxColumnNames.get(0), start, finish)) continue;
            return true;
        }
        return false;
    }
}

