/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnCondition {
    public final ColumnDefinition column;
    private final Term collectionElement;
    private final Term value;

    private ColumnCondition(ColumnDefinition column, Term collectionElement, Term value) {
        this.column = column;
        this.collectionElement = collectionElement;
        this.value = value;
    }

    public static ColumnCondition equal(ColumnDefinition column, Term value) {
        return new ColumnCondition(column, null, value);
    }

    public static ColumnCondition equal(ColumnDefinition column, Term collectionElement, Term value) {
        return new ColumnCondition(column, collectionElement, value);
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.collectionElement != null) {
            this.collectionElement.collectMarkerSpecification(boundNames);
        }
        this.value.collectMarkerSpecification(boundNames);
    }

    public Bound bind(QueryOptions options) throws InvalidRequestException {
        return this.column.type instanceof CollectionType ? (this.collectionElement == null ? new CollectionBound(this, options) : new ElementAccessBound(this, options)) : new SimpleBound(this, options);
    }

    public static class Raw {
        private final Term.Raw value;
        private final Term.Raw collectionElement;

        private Raw(Term.Raw value, Term.Raw collectionElement) {
            this.value = value;
            this.collectionElement = collectionElement;
        }

        public static Raw simpleEqual(Term.Raw value) {
            return new Raw(value, null);
        }

        public static Raw collectionEqual(Term.Raw value, Term.Raw collectionElement) {
            return new Raw(value, collectionElement);
        }

        public ColumnCondition prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Condtions on counters are not supported");
            }
            if (this.collectionElement == null) {
                return ColumnCondition.equal(receiver, this.value.prepare(keyspace, receiver));
            }
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid element access syntax for non-collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(keyspace, Lists.indexSpecOf(receiver)), this.value.prepare(keyspace, Lists.valueSpecOf(receiver)));
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid element access syntax for set column %s", receiver.name));
                }
                case MAP: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(keyspace, Maps.keySpecOf(receiver)), this.value.prepare(keyspace, Maps.valueSpecOf(receiver)));
                }
            }
            throw new AssertionError();
        }
    }

    private static class CollectionBound
    extends Bound {
        public final Term.Terminal value;

        private CollectionBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column);
            assert (this.column.type instanceof CollectionType && condition.collectionElement == null);
            this.value = condition.value.bind(options);
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            Iterator<Cell> iter = this.collectionColumns(current.metadata().comparator.create(rowPrefix, this.column), current, now);
            if (this.value == null) {
                return !iter.hasNext();
            }
            switch (type.kind) {
                case LIST: {
                    return this.listAppliesTo((ListType)type, iter, ((Lists.Value)this.value).elements);
                }
                case SET: {
                    return this.setAppliesTo((SetType)type, iter, ((Sets.Value)this.value).elements);
                }
                case MAP: {
                    return this.mapAppliesTo((MapType)type, iter, ((Maps.Value)this.value).map);
                }
            }
            throw new AssertionError();
        }

        private boolean listAppliesTo(ListType type, Iterator<Cell> iter, List<ByteBuffer> elements) {
            for (ByteBuffer e : elements) {
                if (iter.hasNext() && type.elements.compare(iter.next().value(), e) == 0) continue;
                return false;
            }
            return !iter.hasNext();
        }

        private boolean setAppliesTo(SetType type, Iterator<Cell> iter, Set<ByteBuffer> elements) {
            TreeSet<ByteBuffer> remaining = new TreeSet<ByteBuffer>(type.elements);
            remaining.addAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                if (remaining.remove(iter.next().name().collectionElement())) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        private boolean mapAppliesTo(MapType type, Iterator<Cell> iter, Map<ByteBuffer, ByteBuffer> elements) {
            TreeMap<ByteBuffer, ByteBuffer> remaining = new TreeMap<ByteBuffer, ByteBuffer>(type.keys);
            remaining.putAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                Cell c = iter.next();
                ByteBuffer previous = (ByteBuffer)remaining.remove(c.name().collectionElement());
                if (previous != null && type.values.compare(previous, c.value()) == 0) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CollectionBound)) {
                return false;
            }
            CollectionBound that = (CollectionBound)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            if (this.value == null || that.value == null) {
                return this.value == null && that.value == null;
            }
            switch (((CollectionType)this.column.type).kind) {
                case LIST: {
                    return ((Lists.Value)this.value).equals((ListType)this.column.type, (Lists.Value)that.value);
                }
                case SET: {
                    return ((Sets.Value)this.value).equals((SetType)this.column.type, (Sets.Value)that.value);
                }
                case MAP: {
                    return ((Maps.Value)this.value).equals((MapType)this.column.type, (Maps.Value)that.value);
                }
            }
            throw new AssertionError();
        }

        public int hashCode() {
            Integer val = null;
            if (this.value != null) {
                switch (((CollectionType)this.column.type).kind) {
                    case LIST: {
                        val = ((Lists.Value)this.value).elements.hashCode();
                        break;
                    }
                    case SET: {
                        val = ((Sets.Value)this.value).elements.hashCode();
                        break;
                    }
                    case MAP: {
                        val = ((Maps.Value)this.value).map.hashCode();
                    }
                }
            }
            return Objects.hashCode((Object[])new Object[]{this.column, val});
        }
    }

    private static class ElementAccessBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final ByteBuffer value;

        private ElementAccessBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            this.collectionElement = condition.collectionElement.bindAndGet(options);
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            if (this.column.type instanceof MapType) {
                return this.equalsValue(this.value, current.getColumn(current.metadata().comparator.create(rowPrefix, this.column, this.collectionElement)), ((MapType)this.column.type).values, now);
            }
            assert (this.column.type instanceof ListType);
            int idx = ByteBufferUtil.toInt(this.collectionElement);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Invalid negative list index %d", idx));
            }
            Iterator<Cell> iter = this.collectionColumns(current.metadata().comparator.create(rowPrefix, this.column), current, now);
            int adv = Iterators.advance(iter, (int)idx);
            if (adv != idx || !iter.hasNext()) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, adv));
            }
            if (this.value == null) {
                return false;
            }
            return ((ListType)this.column.type).elements.compare(iter.next().value(), this.value) == 0;
        }

        @Override
        public ByteBuffer getCollectionElementValue() {
            return this.collectionElement;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ElementAccessBound)) {
                return false;
            }
            ElementAccessBound that = (ElementAccessBound)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            if (this.collectionElement == null != (that.collectionElement == null)) {
                return false;
            }
            if (this.collectionElement != null) {
                Int32Type comparator;
                assert (this.column.type instanceof ListType || this.column.type instanceof MapType);
                AbstractType abstractType = comparator = this.column.type instanceof ListType ? Int32Type.instance : ((MapType)this.column.type).keys;
                if (comparator.compare(this.collectionElement, that.collectionElement) != 0) {
                    return false;
                }
            }
            return this.column.type.compare(this.value, that.value) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.collectionElement, this.value});
        }
    }

    private static class SimpleBound
    extends Bound {
        public final ByteBuffer value;

        private SimpleBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column);
            assert (!(this.column.type instanceof CollectionType) && condition.collectionElement == null);
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            CellName name = current.metadata().comparator.create(rowPrefix, this.column);
            return this.equalsValue(this.value, current.getColumn(name), this.column.type, now);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleBound)) {
                return false;
            }
            SimpleBound that = (SimpleBound)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            return this.value == null || that.value == null ? this.value == null && that.value == null : this.column.type.compare(this.value, that.value) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.value});
        }
    }

    public static abstract class Bound {
        public final ColumnDefinition column;

        protected Bound(ColumnDefinition column) {
            this.column = column;
        }

        public abstract boolean appliesTo(Composite var1, ColumnFamily var2, long var3) throws InvalidRequestException;

        public ByteBuffer getCollectionElementValue() {
            return null;
        }

        protected boolean equalsValue(ByteBuffer value, Cell c, AbstractType<?> type, long now) {
            return value == null ? c == null || !c.isLive(now) : c != null && c.isLive(now) && type.compare(c.value(), value) == 0;
        }

        protected Iterator<Cell> collectionColumns(CellName collection, ColumnFamily cf, final long now) {
            ColumnSlice[] collectionSlice = new ColumnSlice[]{collection.slice()};
            return Iterators.filter(cf.iterator(collectionSlice), (Predicate)new Predicate<Cell>(){

                public boolean apply(Cell c) {
                    return c.isLive(now);
                }
            });
        }
    }
}

