/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CQL3CasConditions;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private final int boundTerms;
    public final Type type;
    private final List<ModificationStatement> statements;
    private final Attributes attrs;
    private final boolean hasConditions;
    private static final Logger logger = LoggerFactory.getLogger(BatchStatement.class);

    public BatchStatement(int boundTerms, Type type, List<ModificationStatement> statements, Attributes attrs) {
        boolean hasConditions = false;
        for (ModificationStatement statement : statements) {
            hasConditions |= statement.hasConditions();
        }
        this.boundTerms = boundTerms;
        this.type = type;
        this.statements = statements;
        this.attrs = attrs;
        this.hasConditions = hasConditions;
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        long size = meter.measure((Object)this) + meter.measureDeep((Object)this.type) + meter.measure(this.statements) + meter.measureDeep((Object)this.attrs);
        for (ModificationStatement stmt : this.statements) {
            size += stmt.measureForPreparedCache(meter);
        }
        return size;
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        for (ModificationStatement statement : this.statements) {
            statement.checkAccess(state);
        }
    }

    public void validate() throws InvalidRequestException {
        if (this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        boolean timestampSet = this.attrs.isTimestampSet();
        if (timestampSet) {
            if (this.hasConditions) {
                throw new InvalidRequestException("Cannot provide custom timestamp for conditional BATCH");
            }
            if (this.type == Type.COUNTER) {
                throw new InvalidRequestException("Cannot provide custom timestamp for counter BATCH");
            }
        }
        boolean hasCounters = false;
        boolean hasNonCounters = false;
        for (ModificationStatement statement : this.statements) {
            if (timestampSet && statement.isCounter()) {
                throw new InvalidRequestException("Cannot provide custom timestamp for a BATCH containing counters");
            }
            if (timestampSet && statement.isTimestampSet()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            if (this.type == Type.COUNTER && !statement.isCounter()) {
                throw new InvalidRequestException("Cannot include non-counter statement in a counter batch");
            }
            if (this.type == Type.LOGGED && statement.isCounter()) {
                throw new InvalidRequestException("Cannot include a counter statement in a logged batch");
            }
            if (statement.isCounter()) {
                hasCounters = true;
                continue;
            }
            hasNonCounters = true;
        }
        if (hasCounters && hasNonCounters) {
            throw new InvalidRequestException("Counter and non-counter mutations cannot exist in the same batch");
        }
        if (this.hasConditions) {
            String ksName = null;
            String cfName = null;
            for (ModificationStatement stmt : this.statements) {
                if (!(ksName == null || stmt.keyspace().equals(ksName) && stmt.columnFamily().equals(cfName))) {
                    throw new InvalidRequestException("Batch with conditions cannot span multiple tables");
                }
                ksName = stmt.keyspace();
                cfName = stmt.columnFamily();
            }
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.validate(state);
        }
    }

    public List<ModificationStatement> getStatements() {
        return this.statements;
    }

    private Collection<? extends IMutation> getMutations(BatchQueryOptions options, boolean local, long now, Frame sourceFrame) throws RequestExecutionException, RequestValidationException {
        HashMap<String, Map<ByteBuffer, IMutation>> mutations = new HashMap<String, Map<ByteBuffer, IMutation>>();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementOptions);
            this.addStatementMutations(statement, statementOptions, local, timestamp, mutations, sourceFrame);
        }
        return this.unzipMutations(mutations);
    }

    private Collection<? extends IMutation> unzipMutations(Map<String, Map<ByteBuffer, IMutation>> mutations) {
        if (mutations.size() == 1) {
            return mutations.values().iterator().next().values();
        }
        ArrayList<IMutation> ms = new ArrayList<IMutation>();
        for (Map<ByteBuffer, IMutation> ksMap : mutations.values()) {
            ms.addAll(ksMap.values());
        }
        return ms;
    }

    private void addStatementMutations(ModificationStatement statement, QueryOptions options, boolean local, long now, Map<String, Map<ByteBuffer, IMutation>> mutations, Frame sourceFrame) throws RequestExecutionException, RequestValidationException {
        String ksName = statement.keyspace();
        Map<ByteBuffer, IMutation> ksMap = mutations.get(ksName);
        if (ksMap == null) {
            ksMap = new HashMap<ByteBuffer, IMutation>();
            mutations.put(ksName, ksMap);
        }
        List<ByteBuffer> keys = statement.buildPartitionKeyNames(options);
        Composite clusteringPrefix = statement.createClusteringPrefix(options);
        UpdateParameters params = statement.makeUpdateParameters(keys, clusteringPrefix, options, local, now);
        for (ByteBuffer key : keys) {
            Mutation mut;
            IMutation mutation = ksMap.get(key);
            if (mutation == null) {
                mut = new Mutation(ksName, key);
                mut.setSourceFrame(sourceFrame);
                mutation = statement.cfm.isCounter() ? new CounterMutation(mut, options.getConsistency()) : mut;
                ksMap.put(key, mutation);
            } else {
                mut = statement.cfm.isCounter() ? ((CounterMutation)mutation).getMutation() : (Mutation)mutation;
            }
            statement.addUpdateForKey(mut.addOrGet(statement.cfm), key, clusteringPrefix, params);
        }
    }

    private void verifyBatchSize(Iterable<ColumnFamily> cfs) {
        long size = 0L;
        long warnThreshold = DatabaseDescriptor.getBatchSizeWarnThreshold();
        for (ColumnFamily cf : cfs) {
            size += cf.dataSize();
        }
        if (size > warnThreshold) {
            HashSet<String> ksCfPairs = new HashSet<String>();
            for (ColumnFamily cf : cfs) {
                ksCfPairs.add(cf.metadata().ksName + "." + cf.metadata().cfName);
            }
            String format = "Batch of prepared statements for {} is of size {}, exceeding specified threshold of {} by {}.";
            logger.warn(format, new Object[]{ksCfPairs, size, warnThreshold, size - warnThreshold});
        }
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(queryState, BatchQueryOptions.withoutPerStatementVariables(options));
    }

    public ResultMessage execute(QueryState queryState, BatchQueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(queryState, options, false, options.getTimestamp(queryState));
    }

    private ResultMessage execute(QueryState queryState, BatchQueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (options.getSerialConsistency() == null) {
            throw new InvalidRequestException("Invalid empty serial consistency level");
        }
        if (this.hasConditions) {
            return this.executeWithConditions(options, now);
        }
        this.executeWithoutConditions(this.getMutations(options, local, now, queryState.getSourceFrame()), options.getConsistency());
        return new ResultMessage.Void();
    }

    private void executeWithoutConditions(Collection<? extends IMutation> mutations, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        Iterable cfs = Iterables.concat((Iterable)Iterables.transform(mutations, (Function)new Function<IMutation, Collection<ColumnFamily>>(){

            public Collection<ColumnFamily> apply(IMutation im) {
                return im.getColumnFamilies();
            }
        }));
        this.verifyBatchSize(cfs);
        boolean mutateAtomic = this.type == Type.LOGGED && mutations.size() > 1;
        StorageProxy.mutateWithTriggers(mutations, cl, mutateAtomic);
    }

    private ResultMessage executeWithConditions(BatchQueryOptions options, long now) throws RequestExecutionException, RequestValidationException {
        ByteBuffer key = null;
        String ksName = null;
        String cfName = null;
        ArrayBackedSortedColumns updates = null;
        CQL3CasConditions conditions = null;
        LinkedHashSet<ColumnDefinition> columnsWithConditions = new LinkedHashSet<ColumnDefinition>();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementOptions);
            List<ByteBuffer> pks = statement.buildPartitionKeyNames(statementOptions);
            if (pks.size() > 1) {
                throw new IllegalArgumentException("Batch with conditions cannot span multiple partitions (you cannot use IN on the partition key)");
            }
            if (key == null) {
                key = pks.get(0);
                ksName = statement.cfm.ksName;
                cfName = statement.cfm.cfName;
                conditions = new CQL3CasConditions(statement.cfm, now);
                updates = ArrayBackedSortedColumns.factory.create(statement.cfm);
            } else if (!key.equals(pks.get(0))) {
                throw new InvalidRequestException("Batch with conditions cannot span multiple partitions");
            }
            Composite clusteringPrefix = statement.createClusteringPrefix(statementOptions);
            if (statement.hasConditions()) {
                statement.addUpdatesAndConditions(key, clusteringPrefix, updates, conditions, statementOptions, timestamp);
                if (statement.hasIfNotExistCondition() || statement.hasIfExistCondition()) {
                    columnsWithConditions = null;
                    continue;
                }
                if (columnsWithConditions == null) continue;
                Iterables.addAll(columnsWithConditions, statement.getColumnsWithConditions());
                continue;
            }
            UpdateParameters params = statement.makeUpdateParameters(Collections.singleton(key), clusteringPrefix, statementOptions, false, now);
            statement.addUpdateForKey(updates, key, clusteringPrefix, params);
        }
        this.verifyBatchSize(Collections.singleton(updates));
        ColumnFamily result = StorageProxy.cas(ksName, cfName, key, conditions, updates, options.getSerialConsistency(), options.getConsistency());
        return new ResultMessage.Rows(ModificationStatement.buildCasResultSet(ksName, key, cfName, result, columnsWithConditions, true, options.forStatement(0)));
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        assert (!this.hasConditions);
        for (IMutation iMutation : this.getMutations(BatchQueryOptions.withoutPerStatementVariables(options), true, queryState.getTimestamp(), queryState.getSourceFrame())) {
            assert (iMutation instanceof Mutation);
            ((Mutation)iMutation).apply();
        }
        return null;
    }

    public String toString() {
        return String.format("BatchStatement(type=%s, statements=%s)", new Object[]{this.type, this.statements});
    }

    public static class Parsed
    extends CFStatement {
        private final Type type;
        private final Attributes.Raw attrs;
        private final List<ModificationStatement.Parsed> parsedStatements;

        public Parsed(Type type, Attributes.Raw attrs, List<ModificationStatement.Parsed> parsedStatements) {
            super(null);
            this.type = type;
            this.attrs = attrs;
            this.parsedStatements = parsedStatements;
        }

        @Override
        public void prepareKeyspace(ClientState state) throws InvalidRequestException {
            for (ModificationStatement.Parsed statement : this.parsedStatements) {
                statement.prepareKeyspace(state);
            }
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.parsedStatements.size());
            for (ModificationStatement.Parsed parsed : this.parsedStatements) {
                statements.add(parsed.prepare(boundNames));
            }
            Attributes prepAttrs = this.attrs.prepare("[batch]", "[batch]");
            prepAttrs.collectMarkerSpecification(boundNames);
            BatchStatement batchStatement = new BatchStatement(boundNames.size(), this.type, statements, prepAttrs);
            batchStatement.validate();
            return new ParsedStatement.Prepared((CQLStatement)batchStatement, boundNames);
        }
    }

    public static interface BatchVariables {
        public List<ByteBuffer> getVariablesForStatement(int var1);
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

