/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.BufferDeletedCell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

public class CFRowAdder {
    public final ColumnFamily cf;
    public final Composite prefix;
    public final long timestamp;
    private final int ldt;

    public CFRowAdder(ColumnFamily cf, Composite prefix, long timestamp) {
        this.cf = cf;
        this.prefix = prefix;
        this.timestamp = timestamp;
        this.ldt = (int)(System.currentTimeMillis() / 1000L);
        if (cf.metadata().isCQL3Table() && !prefix.isStatic()) {
            cf.addColumn(new BufferCell(cf.getComparator().rowMarker(prefix), ByteBufferUtil.EMPTY_BYTE_BUFFER, timestamp));
        }
    }

    public CFRowAdder add(String cql3ColumnName, Object value) {
        ColumnDefinition def = this.getDefinition(cql3ColumnName);
        return this.add(this.cf.getComparator().create(this.prefix, def), def, value);
    }

    public CFRowAdder resetCollection(String cql3ColumnName) {
        ColumnDefinition def = this.getDefinition(cql3ColumnName);
        assert (def.type.isCollection());
        CellName name = this.cf.getComparator().create(this.prefix, def);
        this.cf.addAtom(new RangeTombstone(name.start(), name.end(), this.timestamp - 1L, this.ldt));
        return this;
    }

    public CFRowAdder addMapEntry(String cql3ColumnName, Object key, Object value) {
        ColumnDefinition def = this.getDefinition(cql3ColumnName);
        assert (def.type instanceof MapType);
        MapType mt = (MapType)def.type;
        CellName name = this.cf.getComparator().create(this.prefix, def, mt.keys.decompose(key));
        return this.add(name, def, value);
    }

    public CFRowAdder addListEntry(String cql3ColumnName, Object value) {
        ColumnDefinition def = this.getDefinition(cql3ColumnName);
        assert (def.type instanceof ListType);
        CellName name = this.cf.getComparator().create(this.prefix, def, ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes()));
        return this.add(name, def, value);
    }

    private ColumnDefinition getDefinition(String name) {
        return this.cf.metadata().getColumnDefinition(new ColumnIdentifier(name, false));
    }

    private CFRowAdder add(CellName name, ColumnDefinition def, Object value) {
        if (value == null) {
            this.cf.addColumn(new BufferDeletedCell(name, this.ldt, this.timestamp));
        } else {
            AbstractType<?> valueType = def.type.isCollection() ? ((CollectionType)def.type).valueComparator() : def.type;
            this.cf.addColumn(new BufferCell(name, value instanceof ByteBuffer ? (ByteBuffer)value : valueType.decompose(value), this.timestamp));
        }
        return this;
    }
}

