/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.Interval;

public class RangeTombstone
extends Interval<Composite, DeletionTime>
implements OnDiskAtom {
    public RangeTombstone(Composite start, Composite stop, long markedForDeleteAt, int localDeletionTime) {
        this(start, stop, new DeletionTime(markedForDeleteAt, localDeletionTime));
    }

    public RangeTombstone(Composite start, Composite stop, DeletionTime delTime) {
        super(start, stop, delTime);
    }

    @Override
    public Composite name() {
        return (Composite)this.min;
    }

    @Override
    public int getLocalDeletionTime() {
        return ((DeletionTime)this.data).localDeletionTime;
    }

    @Override
    public long timestamp() {
        return ((DeletionTime)this.data).markedForDeleteAt;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate((Composite)this.min);
        metadata.comparator.validate((Composite)this.max);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(((Composite)this.min).toByteBuffer().duplicate());
        digest.update(((Composite)this.max).toByteBuffer().duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(((DeletionTime)this.data).markedForDeleteAt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    public boolean supersedes(RangeTombstone rt, Comparator<Composite> comparator) {
        if (((DeletionTime)rt.data).markedForDeleteAt > ((DeletionTime)this.data).markedForDeleteAt) {
            return false;
        }
        return comparator.compare((Composite)this.min, (Composite)rt.min) <= 0 && comparator.compare((Composite)this.max, (Composite)rt.max) >= 0;
    }

    public boolean includes(Comparator<Composite> comparator, Composite name) {
        return comparator.compare(name, (Composite)this.min) >= 0 && comparator.compare(name, (Composite)this.max) <= 0;
    }

    public static class Serializer
    implements ISSTableSerializer<RangeTombstone> {
        private final CType type;

        public Serializer(CType type) {
            this.type = type;
        }

        @Override
        public void serializeForSSTable(RangeTombstone t, DataOutputPlus out) throws IOException {
            this.type.serializer().serialize(t.min, out);
            out.writeByte(16);
            this.type.serializer().serialize(t.max, out);
            DeletionTime.serializer.serialize((DeletionTime)t.data, out);
        }

        @Override
        public RangeTombstone deserializeFromSSTable(DataInput in, Descriptor.Version version) throws IOException {
            Composite min = (Composite)this.type.serializer().deserialize(in);
            int b = in.readUnsignedByte();
            assert ((b & 0x10) != 0);
            return this.deserializeBody(in, min, version);
        }

        public RangeTombstone deserializeBody(DataInput in, Composite min, Descriptor.Version version) throws IOException {
            Composite max = (Composite)this.type.serializer().deserialize(in);
            DeletionTime dt = DeletionTime.serializer.deserialize(in);
            return new RangeTombstone(min, max, dt);
        }

        public void skipBody(DataInput in, Descriptor.Version version) throws IOException {
            this.type.serializer().skip(in);
            DeletionTime.serializer.skip(in);
        }

        public long serializedSizeForSSTable(RangeTombstone t) {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            return this.type.serializer().serializedSize(t.min, typeSizes) + 1L + this.type.serializer().serializedSize(t.max, typeSizes) + DeletionTime.serializer.serializedSize((DeletionTime)t.data, typeSizes);
        }
    }

    public static class Tracker {
        private final Comparator<Composite> comparator;
        private final Deque<RangeTombstone> ranges = new ArrayDeque<RangeTombstone>();
        private final SortedSet<RangeTombstone> maxOrderingSet = new TreeSet<RangeTombstone>(new Comparator<RangeTombstone>(){

            @Override
            public int compare(RangeTombstone t1, RangeTombstone t2) {
                return Tracker.this.comparator.compare(t1.max, t2.max);
            }
        });
        private int atomCount;

        public Tracker(Comparator<Composite> comparator) {
            this.comparator = comparator;
        }

        public long writeOpenedMarker(OnDiskAtom firstColumn, DataOutputPlus out, OnDiskAtom.Serializer atomSerializer) throws IOException {
            long size = 0L;
            if (this.ranges.isEmpty()) {
                return size;
            }
            LinkedList<RangeTombstone> toWrite = new LinkedList<RangeTombstone>();
            block0: for (RangeTombstone tombstone : this.ranges) {
                if (this.comparator.compare(firstColumn.name(), (Composite)tombstone.max) > 0) continue;
                RangeTombstone updated = new RangeTombstone(firstColumn.name(), (Composite)tombstone.max, (DeletionTime)tombstone.data);
                Iterator iter = toWrite.iterator();
                while (iter.hasNext()) {
                    RangeTombstone other = (RangeTombstone)iter.next();
                    if (other.supersedes(updated, this.comparator)) break block0;
                    if (!updated.supersedes(other, this.comparator)) continue;
                    iter.remove();
                }
                toWrite.add(tombstone);
            }
            for (RangeTombstone tombstone : toWrite) {
                size += atomSerializer.serializedSizeForSSTable(tombstone);
                ++this.atomCount;
                if (out == null) continue;
                atomSerializer.serializeForSSTable(tombstone, out);
            }
            return size;
        }

        public int writtenAtom() {
            return this.atomCount;
        }

        public void update(OnDiskAtom atom) {
            if (atom instanceof RangeTombstone) {
                RangeTombstone t = (RangeTombstone)atom;
                for (RangeTombstone tombstone : this.maxOrderingSet.tailSet(t)) {
                    if (this.comparator.compare((Composite)t.max, (Composite)tombstone.max) > 0) break;
                    if (!((DeletionTime)tombstone.data).equals(t.data)) continue;
                    return;
                }
                this.ranges.addLast(t);
                this.maxOrderingSet.add(t);
            } else {
                assert (atom instanceof Cell);
                Iterator iter = this.maxOrderingSet.iterator();
                while (iter.hasNext()) {
                    RangeTombstone tombstone = (RangeTombstone)iter.next();
                    if (this.comparator.compare(atom.name(), (Composite)tombstone.max) > 0) {
                        iter.remove();
                        this.ranges.remove(tombstone);
                        continue;
                    }
                    return;
                }
            }
        }

        public boolean isDeleted(Cell cell) {
            for (RangeTombstone tombstone : this.ranges) {
                if (this.comparator.compare(cell.name(), (Composite)tombstone.min) < 0 || this.comparator.compare(cell.name(), (Composite)tombstone.max) > 0 || tombstone.timestamp() < cell.timestamp()) continue;
                return true;
            }
            return false;
        }
    }
}

