/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerRowSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryIndexManager {
    private static final Logger logger = LoggerFactory.getLogger(SecondaryIndexManager.class);
    public static final Updater nullUpdater = new Updater(){

        @Override
        public void insert(Cell cell) {
        }

        @Override
        public void update(Cell oldCell, Cell cell) {
        }

        @Override
        public void remove(Cell current) {
        }

        @Override
        public void updateRowLevelIndexes() {
        }
    };
    private final ConcurrentNavigableMap<ByteBuffer, SecondaryIndex> indexesByColumn = new ConcurrentSkipListMap<ByteBuffer, SecondaryIndex>();
    private final ConcurrentMap<Class<? extends SecondaryIndex>, SecondaryIndex> rowLevelIndexMap = new ConcurrentHashMap<Class<? extends SecondaryIndex>, SecondaryIndex>();
    private final Set<SecondaryIndex> allIndexes = Collections.newSetFromMap(new ConcurrentHashMap());
    public final ColumnFamilyStore baseCfs;

    public SecondaryIndexManager(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
    }

    public void reload() {
        Set indexedColumnNames = this.indexesByColumn.keySet();
        for (ByteBuffer indexedColumn : indexedColumnNames) {
            ColumnDefinition def = this.baseCfs.metadata.getColumnDefinition(indexedColumn);
            if (def != null && def.getIndexType() != null) continue;
            this.removeIndexedColumn(indexedColumn);
        }
        for (ColumnDefinition cdef : this.baseCfs.metadata.allColumns()) {
            if (cdef.getIndexType() == null || indexedColumnNames.contains(cdef.name.bytes)) continue;
            this.addIndexedColumn(cdef);
        }
        for (SecondaryIndex index : this.allIndexes) {
            index.reload();
        }
    }

    public Set<String> allIndexesNames() {
        HashSet<String> names = new HashSet<String>(this.allIndexes.size());
        for (SecondaryIndex index : this.allIndexes) {
            names.add(index.getIndexName());
        }
        return names;
    }

    public void maybeBuildSecondaryIndexes(Collection<SSTableReader> sstables, Set<String> idxNames) {
        if (idxNames.isEmpty()) {
            return;
        }
        logger.info(String.format("Submitting index build of %s for data in %s", idxNames, StringUtils.join(sstables, (String)", ")));
        SecondaryIndexBuilder builder = new SecondaryIndexBuilder(this.baseCfs, idxNames, new ReducingKeyIterator(sstables));
        Future<?> future = CompactionManager.instance.submitIndexBuild(builder);
        FBUtilities.waitOnFuture(future);
        this.flushIndexesBlocking();
        logger.info("Index build of {} complete", idxNames);
    }

    public boolean indexes(CellName name, Set<SecondaryIndex> indexes) {
        boolean matching = false;
        for (SecondaryIndex index : indexes) {
            if (!index.indexes(name)) continue;
            matching = true;
            break;
        }
        return matching;
    }

    public Set<SecondaryIndex> indexFor(CellName name, Set<SecondaryIndex> indexes) {
        HashSet<SecondaryIndex> matching = null;
        for (SecondaryIndex index : indexes) {
            if (!index.indexes(name)) continue;
            if (matching == null) {
                matching = new HashSet<SecondaryIndex>();
            }
            matching.add(index);
        }
        return matching == null ? Collections.emptySet() : matching;
    }

    public boolean indexes(Cell cell) {
        return this.indexes(cell.name());
    }

    public boolean indexes(CellName name) {
        return this.indexes(name, this.allIndexes);
    }

    public Set<SecondaryIndex> indexFor(CellName name) {
        return this.indexFor(name, this.allIndexes);
    }

    public boolean hasIndexFor(List<IndexExpression> clause) {
        if (clause == null || clause.isEmpty()) {
            return false;
        }
        List<SecondaryIndexSearcher> searchers = this.getIndexSearchersForQuery(clause);
        if (searchers.isEmpty()) {
            return false;
        }
        for (SecondaryIndexSearcher searcher : searchers) {
            if (searcher.isIndexing(clause)) continue;
            return false;
        }
        return true;
    }

    public void removeIndexedColumn(ByteBuffer column) {
        SecondaryIndex index = (SecondaryIndex)this.indexesByColumn.remove(column);
        if (index == null) {
            return;
        }
        if (index instanceof PerRowSecondaryIndex) {
            index.removeColumnDef(column);
            if (index.getColumnDefs().isEmpty()) {
                this.allIndexes.remove(index);
                this.rowLevelIndexMap.remove(index.getClass());
            }
        } else {
            this.allIndexes.remove(index);
        }
        index.removeIndex(column);
        SystemKeyspace.setIndexRemoved(this.baseCfs.metadata.ksName, index.getNameForSystemKeyspace(column));
    }

    public synchronized Future<?> addIndexedColumn(ColumnDefinition cdef) {
        SecondaryIndex index;
        if (this.indexesByColumn.containsKey(cdef.name.bytes)) {
            return null;
        }
        assert (cdef.getIndexType() != null);
        try {
            index = SecondaryIndex.createInstance(this.baseCfs, cdef);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        if (index instanceof PerRowSecondaryIndex) {
            SecondaryIndex currentIndex = (SecondaryIndex)this.rowLevelIndexMap.get(index.getClass());
            if (currentIndex == null) {
                this.rowLevelIndexMap.put(index.getClass(), index);
                index.init();
            } else {
                index = currentIndex;
                index.addColumnDef(cdef);
                logger.info("Creating new index : {}", (Object)cdef);
            }
        } else {
            if (cdef.getIndexType() == IndexType.CUSTOM && index instanceof AbstractSimplePerColumnSecondaryIndex) {
                throw new RuntimeException("Cannot use a subclass of AbstractSimplePerColumnSecondaryIndex as a CUSTOM index, as they assume they are CFS backed");
            }
            index.init();
        }
        this.indexesByColumn.put(cdef.name.bytes, index);
        this.allIndexes.add(index);
        if (index.isIndexBuilt(cdef.name.bytes)) {
            return null;
        }
        return index.buildIndexAsync();
    }

    public SecondaryIndex getIndexForColumn(ByteBuffer column) {
        return (SecondaryIndex)this.indexesByColumn.get(column);
    }

    public void invalidate() {
        for (SecondaryIndex index : this.allIndexes) {
            index.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIndexesBlocking() {
        ArrayList wait = new ArrayList();
        DataTracker dataTracker = this.baseCfs.getDataTracker();
        synchronized (dataTracker) {
            for (SecondaryIndex index : this.allIndexes) {
                if (index.getIndexCfs() == null) continue;
                wait.add((Future<?>)index.getIndexCfs().forceFlush());
            }
        }
        for (SecondaryIndex index : this.allIndexes) {
            if (index.getIndexCfs() != null) continue;
            index.forceBlockingFlush();
        }
        FBUtilities.waitOnFutures(wait);
    }

    public List<String> getBuiltIndexes() {
        ArrayList<String> indexList = new ArrayList<String>();
        for (Map.Entry entry : this.indexesByColumn.entrySet()) {
            SecondaryIndex index = (SecondaryIndex)entry.getValue();
            if (!index.isIndexBuilt((ByteBuffer)entry.getKey())) continue;
            indexList.add(((SecondaryIndex)entry.getValue()).getIndexName());
        }
        return indexList;
    }

    public Set<ColumnFamilyStore> getIndexesBackedByCfs() {
        HashSet<ColumnFamilyStore> cfsList = new HashSet<ColumnFamilyStore>();
        for (SecondaryIndex index : this.allIndexes) {
            ColumnFamilyStore cfs = index.getIndexCfs();
            if (cfs == null) continue;
            cfsList.add(cfs);
        }
        return cfsList;
    }

    public Set<SecondaryIndex> getIndexesNotBackedByCfs() {
        Set<SecondaryIndex> indexes = Collections.newSetFromMap(new IdentityHashMap());
        for (SecondaryIndex index : this.allIndexes) {
            if (index.getIndexCfs() != null) continue;
            indexes.add(index);
        }
        return indexes;
    }

    public Set<SecondaryIndex> getIndexes() {
        return this.allIndexes;
    }

    public boolean hasIndexes() {
        return !this.indexesByColumn.isEmpty();
    }

    public void indexRow(ByteBuffer key, ColumnFamily cf, OpOrder.Group opGroup) {
        HashSet appliedRowLevelIndexes = null;
        for (SecondaryIndex index : this.allIndexes) {
            if (index instanceof PerRowSecondaryIndex) {
                if (appliedRowLevelIndexes == null) {
                    appliedRowLevelIndexes = new HashSet();
                }
                if (!appliedRowLevelIndexes.add(index.getClass())) continue;
                ((PerRowSecondaryIndex)index).index(key, cf);
                continue;
            }
            for (Cell cell : cf) {
                if (!index.indexes(cell.name())) continue;
                ((PerColumnSecondaryIndex)index).insert(key, cell, opGroup);
            }
        }
    }

    public void deleteFromIndexes(DecoratedKey key, List<Cell> indexedColumnsInRow, OpOrder.Group opGroup) {
        HashSet cleanedRowLevelIndexes = null;
        for (Cell cell : indexedColumnsInRow) {
            ColumnDefinition cDef = this.baseCfs.metadata.getColumnDefinition(cell.name());
            SecondaryIndex index = (SecondaryIndex)this.indexesByColumn.get(cDef.name.bytes);
            if (index == null) continue;
            if (index instanceof PerRowSecondaryIndex) {
                if (cleanedRowLevelIndexes == null) {
                    cleanedRowLevelIndexes = new HashSet();
                }
                if (!cleanedRowLevelIndexes.add(index.getClass())) continue;
                ((PerRowSecondaryIndex)index).delete(key, opGroup);
                continue;
            }
            ((PerColumnSecondaryIndex)index).delete(key.getKey(), cell, opGroup);
        }
    }

    public Updater updaterFor(DecoratedKey key, ColumnFamily cf, OpOrder.Group opGroup) {
        return this.indexesByColumn.isEmpty() && this.rowLevelIndexMap.isEmpty() ? nullUpdater : new StandardUpdater(key, cf, opGroup);
    }

    public Updater updaterFor(DecoratedKey key, OpOrder.Group opGroup) {
        return this.updaterFor(key, null, opGroup);
    }

    public Updater gcUpdaterFor(DecoratedKey key) {
        return new GCUpdater(key);
    }

    public List<SecondaryIndexSearcher> getIndexSearchersForQuery(List<IndexExpression> clause) {
        HashMap<String, HashSet<ByteBuffer>> groupByIndexType = new HashMap<String, HashSet<ByteBuffer>>();
        for (IndexExpression ix : clause) {
            SecondaryIndex index = this.getIndexForColumn(ix.column);
            if (index == null) continue;
            HashSet<ByteBuffer> columns = (HashSet<ByteBuffer>)groupByIndexType.get(index.getClass().getCanonicalName());
            if (columns == null) {
                columns = new HashSet<ByteBuffer>();
                groupByIndexType.put(index.getClass().getCanonicalName(), columns);
            }
            columns.add(ix.column);
        }
        ArrayList<SecondaryIndexSearcher> indexSearchers = new ArrayList<SecondaryIndexSearcher>(groupByIndexType.size());
        for (Set column : groupByIndexType.values()) {
            indexSearchers.add(this.getIndexForColumn((ByteBuffer)column.iterator().next()).createSecondaryIndexSearcher(column));
        }
        return indexSearchers;
    }

    public List<Row> search(ExtendedFilter filter) {
        List<SecondaryIndexSearcher> indexSearchers = this.getIndexSearchersForQuery(filter.getClause());
        if (indexSearchers.isEmpty()) {
            return Collections.emptyList();
        }
        if (indexSearchers.size() > 1) {
            throw new RuntimeException("Unable to search across multiple secondary index types");
        }
        return indexSearchers.get(0).search(filter);
    }

    public Set<SecondaryIndex> getIndexesByNames(Set<String> idxNames) {
        HashSet<SecondaryIndex> result = new HashSet<SecondaryIndex>();
        for (SecondaryIndex index : this.allIndexes) {
            if (!idxNames.contains(index.getIndexName())) continue;
            result.add(index);
        }
        return result;
    }

    public void setIndexBuilt(Set<String> idxNames) {
        for (SecondaryIndex index : this.getIndexesByNames(idxNames)) {
            index.setIndexBuilt();
        }
    }

    public void setIndexRemoved(Set<String> idxNames) {
        for (SecondaryIndex index : this.getIndexesByNames(idxNames)) {
            index.setIndexRemoved();
        }
    }

    public boolean validate(Cell cell) {
        for (SecondaryIndex index : this.indexFor(cell.name())) {
            if (index.validate(cell)) continue;
            return false;
        }
        return true;
    }

    static boolean shouldCleanupOldValue(Cell oldCell, Cell newCell) {
        return !oldCell.name().equals(newCell.name()) || !oldCell.value().equals(newCell.value()) || oldCell.timestamp() != newCell.timestamp();
    }

    private final class StandardUpdater
    implements Updater {
        private final DecoratedKey key;
        private final ColumnFamily cf;
        private final OpOrder.Group opGroup;

        public StandardUpdater(DecoratedKey key, ColumnFamily cf, OpOrder.Group opGroup) {
            this.key = key;
            this.cf = cf;
            this.opGroup = opGroup;
        }

        @Override
        public void insert(Cell cell) {
            if (!cell.isLive()) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                ((PerColumnSecondaryIndex)index).insert(this.key.getKey(), cell, this.opGroup);
            }
        }

        @Override
        public void update(Cell oldCell, Cell cell) {
            if (oldCell.equals(cell)) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                if (cell.isLive()) {
                    ((PerColumnSecondaryIndex)index).update(this.key.getKey(), oldCell, cell, this.opGroup);
                    continue;
                }
                if (!SecondaryIndexManager.shouldCleanupOldValue(oldCell, cell)) continue;
                ((PerColumnSecondaryIndex)index).delete(this.key.getKey(), oldCell, this.opGroup);
            }
        }

        @Override
        public void remove(Cell cell) {
            if (!cell.isLive()) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                ((PerColumnSecondaryIndex)index).delete(this.key.getKey(), cell, this.opGroup);
            }
        }

        @Override
        public void updateRowLevelIndexes() {
            for (SecondaryIndex index : SecondaryIndexManager.this.rowLevelIndexMap.values()) {
                ((PerRowSecondaryIndex)index).index(this.key.getKey(), this.cf);
            }
        }
    }

    private final class GCUpdater
    implements Updater {
        private final DecoratedKey key;

        public GCUpdater(DecoratedKey key) {
            this.key = key;
        }

        @Override
        public void insert(Cell cell) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(Cell oldCell, Cell newCell) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Cell cell) {
            if (!cell.isLive()) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.name())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                OpOrder.Group opGroup = SecondaryIndexManager.this.baseCfs.keyspace.writeOrder.start();
                Throwable throwable = null;
                try {
                    ((PerColumnSecondaryIndex)index).delete(this.key.getKey(), cell, opGroup);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (opGroup == null) continue;
                    if (throwable != null) {
                        try {
                            opGroup.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    opGroup.close();
                }
            }
        }

        @Override
        public void updateRowLevelIndexes() {
            for (SecondaryIndex index : SecondaryIndexManager.this.rowLevelIndexMap.values()) {
                ((PerRowSecondaryIndex)index).index(this.key.getKey(), null);
            }
        }
    }

    public static interface Updater {
        public void insert(Cell var1);

        public void update(Cell var1, Cell var2);

        public void remove(Cell var1);

        public void updateRowLevelIndexes();
    }
}

