/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.DataOutputStreamAndChannel;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.StreamingHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableWriter
extends SSTable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableWriter.class);
    public static final int END_OF_ROW = 0;
    private IndexWriter iwriter;
    private SegmentedFile.Builder dbuilder;
    private final SequentialWriter dataFile;
    private DecoratedKey lastWrittenKey;
    private FileMark dataMark;
    private final MetadataCollector sstableMetadataCollector;
    private final long repairedAt;

    public SSTableWriter(String filename, long keyCount, long repairedAt) {
        this(filename, keyCount, repairedAt, Schema.instance.getCFMetaData(Descriptor.fromFilename(filename)), StorageService.getPartitioner(), new MetadataCollector(Schema.instance.getCFMetaData((Descriptor)Descriptor.fromFilename((String)filename)).comparator));
    }

    private static Set<Component> components(CFMetaData metadata) {
        HashSet<Component> components = new HashSet<Component>(Arrays.asList(Component.DATA, Component.PRIMARY_INDEX, Component.STATS, Component.SUMMARY, Component.TOC, Component.DIGEST));
        if (metadata.getBloomFilterFpChance() < 1.0) {
            components.add(Component.FILTER);
        }
        if (metadata.compressionParameters().sstableCompressor != null) {
            components.add(Component.COMPRESSION_INFO);
        } else {
            components.add(Component.CRC);
        }
        return components;
    }

    public SSTableWriter(String filename, long keyCount, long repairedAt, CFMetaData metadata, IPartitioner<?> partitioner, MetadataCollector sstableMetadataCollector) {
        super(Descriptor.fromFilename(filename), SSTableWriter.components(metadata), metadata, partitioner);
        this.repairedAt = repairedAt;
        this.iwriter = new IndexWriter(keyCount);
        if (this.compression) {
            this.dataFile = SequentialWriter.open(this.getFilename(), this.descriptor.filenameFor(Component.COMPRESSION_INFO), metadata.compressionParameters(), sstableMetadataCollector);
            this.dbuilder = SegmentedFile.getCompressedBuilder((CompressedSequentialWriter)this.dataFile);
        } else {
            this.dataFile = SequentialWriter.open(new File(this.getFilename()), new File(this.descriptor.filenameFor(Component.CRC)));
            this.dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode());
        }
        this.sstableMetadataCollector = sstableMetadataCollector;
    }

    public void mark() {
        this.dataMark = this.dataFile.mark();
        this.iwriter.mark();
    }

    public void resetAndTruncate() {
        this.dataFile.resetAndTruncate(this.dataMark);
        this.iwriter.resetAndTruncate();
    }

    private long beforeAppend(DecoratedKey decoratedKey) {
        assert (decoratedKey != null) : "Keys must not be null";
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) >= 0) {
            throw new RuntimeException("Last written key " + this.lastWrittenKey + " >= current key " + decoratedKey + " writing into " + this.getFilename());
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.getFilePointer();
    }

    private void afterAppend(DecoratedKey decoratedKey, long dataPosition, RowIndexEntry index) {
        this.sstableMetadataCollector.addKey(decoratedKey.getKey());
        this.last = this.lastWrittenKey = decoratedKey;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote " + decoratedKey + " at " + dataPosition);
        }
        this.iwriter.append(decoratedKey, index);
        this.dbuilder.addPotentialBoundary(dataPosition);
    }

    public RowIndexEntry append(AbstractCompactedRow row) {
        RowIndexEntry entry;
        long currentPosition = this.beforeAppend(row.key);
        try {
            entry = row.write(currentPosition, this.dataFile.stream);
            if (entry == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.update(this.dataFile.getFilePointer() - currentPosition, row.columnStats());
        this.afterAppend(row.key, currentPosition, entry);
        return entry;
    }

    public void append(DecoratedKey decoratedKey, ColumnFamily cf) {
        long startPosition = this.beforeAppend(decoratedKey);
        try {
            RowIndexEntry entry = SSTableWriter.rawAppend(cf, startPosition, decoratedKey, this.dataFile.stream);
            this.afterAppend(decoratedKey, startPosition, entry);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.update(this.dataFile.getFilePointer() - startPosition, cf.getColumnStats());
    }

    public static RowIndexEntry rawAppend(ColumnFamily cf, long startPosition, DecoratedKey key, DataOutputPlus out) throws IOException {
        assert (cf.hasColumns() || cf.isMarkedForDelete());
        ColumnIndex.Builder builder = new ColumnIndex.Builder(cf, key.getKey(), out);
        ColumnIndex index = builder.build(cf);
        out.writeShort(0);
        return RowIndexEntry.create(startPosition, cf.deletionInfo().getTopLevelDeletion(), index);
    }

    public long appendFromStream(DecoratedKey key, CFMetaData metadata, DataInput in, Descriptor.Version version) throws IOException {
        long currentPosition = this.beforeAppend(key);
        long minTimestamp = Long.MAX_VALUE;
        long maxTimestamp = Long.MIN_VALUE;
        int maxLocalDeletionTime = Integer.MIN_VALUE;
        List<ByteBuffer> minColumnNames = Collections.emptyList();
        List<ByteBuffer> maxColumnNames = Collections.emptyList();
        StreamingHistogram tombstones = new StreamingHistogram(100);
        boolean hasLegacyCounterShards = false;
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(metadata);
        ((ColumnFamily)cf).delete(DeletionTime.serializer.deserialize(in));
        ColumnIndex.Builder columnIndexer = new ColumnIndex.Builder(cf, key.getKey(), this.dataFile.stream);
        if (((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime < Integer.MAX_VALUE) {
            tombstones.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime);
        }
        Iterator<RangeTombstone> rangeTombstoneIterator = ((ColumnFamily)cf).deletionInfo().rangeIterator();
        while (rangeTombstoneIterator.hasNext()) {
            RangeTombstone rangeTombstone = rangeTombstoneIterator.next();
            tombstones.update(rangeTombstone.getLocalDeletionTime());
            minColumnNames = ColumnNameHelper.minComponents(minColumnNames, (Composite)rangeTombstone.min, metadata.comparator);
            maxColumnNames = ColumnNameHelper.maxComponents(maxColumnNames, (Composite)rangeTombstone.max, metadata.comparator);
        }
        Iterator<OnDiskAtom> iter = metadata.getOnDiskIterator(in, ColumnSerializer.Flag.PRESERVE_SIZE, Integer.MIN_VALUE, version);
        try {
            OnDiskAtom atom;
            while (iter.hasNext() && (atom = iter.next()) != null) {
                int deletionTime;
                if (atom instanceof CounterCell) {
                    atom = ((CounterCell)atom).markLocalToBeCleared();
                    boolean bl = hasLegacyCounterShards = hasLegacyCounterShards || ((CounterCell)atom).hasLegacyShards();
                }
                if ((deletionTime = atom.getLocalDeletionTime()) < Integer.MAX_VALUE) {
                    tombstones.update(deletionTime);
                }
                minTimestamp = Math.min(minTimestamp, atom.timestamp());
                maxTimestamp = Math.max(maxTimestamp, atom.timestamp());
                minColumnNames = ColumnNameHelper.minComponents(minColumnNames, atom.name(), metadata.comparator);
                maxColumnNames = ColumnNameHelper.maxComponents(maxColumnNames, atom.name(), metadata.comparator);
                maxLocalDeletionTime = Math.max(maxLocalDeletionTime, atom.getLocalDeletionTime());
                columnIndexer.add(atom);
            }
            columnIndexer.maybeWriteEmptyRowHeader();
            this.dataFile.stream.writeShort(0);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.updateMinTimestamp(minTimestamp).updateMaxTimestamp(maxTimestamp).updateMaxLocalDeletionTime(maxLocalDeletionTime).addRowSize(this.dataFile.getFilePointer() - currentPosition).addColumnCount(columnIndexer.writtenAtomCount()).mergeTombstoneHistogram(tombstones).updateMinColumnNames(minColumnNames).updateMaxColumnNames(maxColumnNames).updateHasLegacyCounterShards(hasLegacyCounterShards);
        this.afterAppend(key, currentPosition, RowIndexEntry.create(currentPosition, ((ColumnFamily)cf).deletionInfo().getTopLevelDeletion(), columnIndexer.build()));
        return currentPosition;
    }

    public void abort() {
        this.abort(true);
    }

    public void abort(boolean closeBf) {
        assert (this.descriptor.type.isTemporary);
        if (this.iwriter == null && this.dataFile == null) {
            return;
        }
        if (this.iwriter != null) {
            FileUtils.closeQuietly(this.iwriter.indexFile);
            if (closeBf) {
                this.iwriter.bf.close();
            }
        }
        if (this.dataFile != null) {
            FileUtils.closeQuietly(this.dataFile);
        }
        Set<Component> components = SSTable.componentsFor(this.descriptor);
        try {
            if (!components.isEmpty()) {
                SSTable.delete(this.descriptor, components);
            }
        }
        catch (FSWriteError e) {
            logger.error(String.format("Failed deleting temp components for %s", this.descriptor), (Throwable)e);
            throw e;
        }
    }

    public void isolateReferences() {
        this.first = SSTableWriter.getMinimalKey(this.first);
        this.last = this.lastWrittenKey = SSTableWriter.getMinimalKey(this.last);
    }

    public SSTableReader openEarly(long maxDataAge) {
        RowIndexEntry indexEntry;
        StatsMetadata sstableMetadata = (StatsMetadata)this.sstableMetadataCollector.finalizeMetadata(this.partitioner.getClass().getCanonicalName(), this.metadata.getBloomFilterFpChance(), this.repairedAt).get((Object)MetadataType.STATS);
        DecoratedKey exclusiveUpperBoundOfReadableIndex = this.iwriter.getMaxReadableKey(0);
        if (exclusiveUpperBoundOfReadableIndex == null) {
            return null;
        }
        Descriptor link = this.descriptor.asType(Descriptor.Type.TEMPLINK);
        if (!new File(link.filenameFor(Component.PRIMARY_INDEX)).exists()) {
            FileUtils.createHardLink(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)), new File(link.filenameFor(Component.PRIMARY_INDEX)));
            FileUtils.createHardLink(new File(this.descriptor.filenameFor(Component.DATA)), new File(link.filenameFor(Component.DATA)));
        }
        SegmentedFile ifile = this.iwriter.builder.openEarly(link.filenameFor(Component.PRIMARY_INDEX));
        SegmentedFile dfile = this.dbuilder.openEarly(link.filenameFor(Component.DATA));
        SSTableReader sstable = SSTableReader.internalOpen(this.descriptor.asType(Descriptor.Type.FINAL), this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner, exclusiveUpperBoundOfReadableIndex), this.iwriter.bf, maxDataAge, sstableMetadata, true);
        sstable.first = SSTableWriter.getMinimalKey(this.first);
        sstable.last = SSTableWriter.getMinimalKey(exclusiveUpperBoundOfReadableIndex);
        DecoratedKey inclusiveUpperBoundOfReadableData = this.iwriter.getMaxReadableKey(1);
        if (inclusiveUpperBoundOfReadableData == null) {
            return null;
        }
        int offset = 2;
        while ((indexEntry = sstable.getPosition(inclusiveUpperBoundOfReadableData, SSTableReader.Operator.GT)) == null || indexEntry.position > this.dataFile.getLastFlushOffset()) {
            if ((inclusiveUpperBoundOfReadableData = this.iwriter.getMaxReadableKey(offset++)) != null) continue;
            return null;
        }
        sstable.last = SSTableWriter.getMinimalKey(inclusiveUpperBoundOfReadableData);
        return sstable;
    }

    public SSTableReader closeAndOpenReader() {
        return this.closeAndOpenReader(System.currentTimeMillis());
    }

    public SSTableReader closeAndOpenReader(long maxDataAge) {
        return this.closeAndOpenReader(maxDataAge, this.repairedAt);
    }

    public SSTableReader closeAndOpenReader(long maxDataAge, long repairedAt) {
        Pair<Descriptor, StatsMetadata> p = this.close(repairedAt);
        Descriptor newdesc = (Descriptor)p.left;
        StatsMetadata sstableMetadata = (StatsMetadata)p.right;
        SegmentedFile ifile = this.iwriter.builder.complete(newdesc.filenameFor(Component.PRIMARY_INDEX));
        SegmentedFile dfile = this.dbuilder.complete(newdesc.filenameFor(Component.DATA));
        SSTableReader sstable = SSTableReader.internalOpen(newdesc, this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner), this.iwriter.bf, maxDataAge, sstableMetadata, false);
        sstable.first = SSTableWriter.getMinimalKey(this.first);
        sstable.last = SSTableWriter.getMinimalKey(this.last);
        sstable.saveSummary(this.iwriter.builder, this.dbuilder);
        this.iwriter = null;
        this.dbuilder = null;
        return sstable;
    }

    public Pair<Descriptor, StatsMetadata> close() {
        return this.close(this.repairedAt);
    }

    private Pair<Descriptor, StatsMetadata> close(long repairedAt) {
        this.iwriter.close();
        this.dataFile.close();
        this.dataFile.writeFullChecksum(this.descriptor);
        Map<MetadataType, MetadataComponent> metadataComponents = this.sstableMetadataCollector.finalizeMetadata(this.partitioner.getClass().getCanonicalName(), this.metadata.getBloomFilterFpChance(), repairedAt);
        SSTableWriter.writeMetadata(this.descriptor, metadataComponents);
        SSTable.appendTOC(this.descriptor, this.components);
        return Pair.create(SSTableWriter.rename(this.descriptor, this.components), (StatsMetadata)metadataComponents.get((Object)MetadataType.STATS));
    }

    private static void writeMetadata(Descriptor desc, Map<MetadataType, MetadataComponent> components) {
        try (SequentialWriter out = SequentialWriter.open(new File(desc.filenameFor(Component.STATS)));){
            desc.getMetadataSerializer().serialize(components, out.stream);
        }
    }

    static Descriptor rename(Descriptor tmpdesc, Set<Component> components) {
        Descriptor newdesc = tmpdesc.asType(Descriptor.Type.FINAL);
        SSTableWriter.rename(tmpdesc, newdesc, components);
        return newdesc;
    }

    public static void rename(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, (Set)Sets.newHashSet((Object[])new Component[]{Component.DATA, Component.SUMMARY}))) {
            FileUtils.renameWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.renameWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.renameWithOutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public long getFilePointer() {
        return this.dataFile.getFilePointer();
    }

    public long getOnDiskFilePointer() {
        return this.dataFile.getOnDiskFilePointer();
    }

    class IndexWriter
    implements Closeable {
        private final SequentialWriter indexFile;
        public final SegmentedFile.Builder builder;
        public final IndexSummaryBuilder summary;
        public final IFilter bf;
        private FileMark mark;

        IndexWriter(long keyCount) {
            this.indexFile = SequentialWriter.open(new File(SSTableWriter.this.descriptor.filenameFor(Component.PRIMARY_INDEX)));
            this.builder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode());
            this.summary = new IndexSummaryBuilder(keyCount, SSTableWriter.this.metadata.getMinIndexInterval(), 128);
            this.bf = FilterFactory.getFilter(keyCount, SSTableWriter.this.metadata.getBloomFilterFpChance(), true);
        }

        DecoratedKey getMaxReadableKey(int offset) {
            long maxIndexLength = this.indexFile.getLastFlushOffset();
            return this.summary.getMaxReadableKey(maxIndexLength, offset);
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry) {
            this.bf.add(key.getKey());
            long indexPosition = this.indexFile.getFilePointer();
            try {
                ByteBufferUtil.writeWithShortLength(key.getKey(), this.indexFile.stream);
                SSTableWriter.this.metadata.comparator.rowIndexEntrySerializer().serialize(indexEntry, this.indexFile.stream);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.indexFile.getPath());
            }
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: " + indexEntry + " at " + indexPosition);
            }
            this.summary.maybeAddEntry(key, indexPosition);
            this.builder.addPotentialBoundary(indexPosition);
        }

        @Override
        public void close() {
            if (SSTableWriter.this.components.contains(Component.FILTER)) {
                String path = SSTableWriter.this.descriptor.filenameFor(Component.FILTER);
                try {
                    FileOutputStream fos = new FileOutputStream(path);
                    DataOutputStreamAndChannel stream = new DataOutputStreamAndChannel(fos);
                    FilterFactory.serialize(this.bf, stream);
                    stream.flush();
                    fos.getFD().sync();
                    stream.close();
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, path);
                }
            }
            long position = this.indexFile.getFilePointer();
            this.indexFile.close();
            FileUtils.truncate(this.indexFile.getPath(), position);
        }

        public void mark() {
            this.mark = this.indexFile.mark();
        }

        public void resetAndTruncate() {
            this.indexFile.resetAndTruncate(this.mark);
        }

        public String toString() {
            return "IndexWriter(" + SSTableWriter.this.descriptor + ")";
        }
    }
}

