/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.EstimatedHistogram;

public class LatencyMetrics {
    public final Timer latency;
    public final Counter totalLatency;
    private List<LatencyMetrics> parents = Lists.newArrayList();
    protected final MetricNameFactory factory;
    protected final String namePrefix;
    @Deprecated
    public final EstimatedHistogram totalLatencyHistogram = new EstimatedHistogram();
    @Deprecated
    public final EstimatedHistogram recentLatencyHistogram = new EstimatedHistogram();
    protected long lastLatency;
    protected long lastOpCount;

    public LatencyMetrics(String type, String scope) {
        this(type, "", scope);
    }

    public LatencyMetrics(String type, String namePrefix, String scope) {
        this(new DefaultNameFactory(type, scope), namePrefix);
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix) {
        this.factory = factory;
        this.namePrefix = namePrefix;
        this.latency = Metrics.newTimer((MetricName)factory.createMetricName(namePrefix + "Latency"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.totalLatency = Metrics.newCounter((MetricName)factory.createMetricName(namePrefix + "TotalLatency"));
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix, LatencyMetrics ... parents) {
        this(factory, namePrefix);
        this.parents.addAll((Collection<LatencyMetrics>)ImmutableList.copyOf((Object[])parents));
    }

    public void addNano(long nanos) {
        this.latency.update(nanos, TimeUnit.NANOSECONDS);
        this.totalLatency.inc(nanos / 1000L);
        this.totalLatencyHistogram.add(nanos / 1000L);
        this.recentLatencyHistogram.add(nanos / 1000L);
        for (LatencyMetrics parent : this.parents) {
            parent.addNano(nanos);
        }
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName(this.namePrefix + "Latency"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName(this.namePrefix + "TotalLatency"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized double getRecentLatency() {
        long ops = this.latency.count();
        long n = this.totalLatency.count();
        if (ops == this.lastOpCount) {
            return 0.0;
        }
        try {
            double d = ((double)n - (double)this.lastLatency) / (double)(ops - this.lastOpCount);
            return d;
        }
        finally {
            this.lastLatency = n;
            this.lastOpCount = ops;
        }
    }
}

