/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangeTransfer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RangeTransfer.class);

    RangeTransfer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        UntypedResultSet res = QueryProcessor.executeInternal("SELECT * FROM system.range_xfers", new Object[0]);
        if (res.size() < 1) {
            LOG.info("No queued ranges to transfer, shuffle complete.  Run 'cassandra-shuffle disable' to stop this message.");
            return;
        }
        if (!this.isReady()) {
            return;
        }
        UntypedResultSet.Row row = (UntypedResultSet.Row)res.iterator().next();
        Date requestedAt = row.getTimestamp("requested_at");
        ByteBuffer tokenBytes = row.getBytes("token_bytes");
        Token token = StorageService.getPartitioner().getTokenFactory().fromByteArray(tokenBytes);
        LOG.info("Initiating transfer of {} (scheduled at {})", token, (Object)requestedAt.toString());
        try {
            StorageService.instance.relocateTokens(Collections.singleton(token));
        }
        catch (Exception e) {
            try {
                LOG.error("Error removing {}: {}", token, (Object)e);
            }
            catch (Throwable throwable) {
                LOG.debug("Removing queued entry for transfer of {}", token);
                QueryProcessor.executeInternal(String.format("DELETE FROM system.%s WHERE token_bytes = ?", "range_xfers"), tokenBytes);
                throw throwable;
            }
            LOG.debug("Removing queued entry for transfer of {}", token);
            QueryProcessor.executeInternal(String.format("DELETE FROM system.%s WHERE token_bytes = ?", "range_xfers"), tokenBytes);
        }
        LOG.debug("Removing queued entry for transfer of {}", token);
        QueryProcessor.executeInternal(String.format("DELETE FROM system.%s WHERE token_bytes = ?", "range_xfers"), tokenBytes);
    }

    private boolean isReady() {
        int targetTokens = DatabaseDescriptor.getNumTokens();
        int highMark = (int)Math.ceil((double)targetTokens + (double)targetTokens * 0.1);
        int actualTokens = StorageService.instance.getTokens().size();
        if (actualTokens >= highMark) {
            LOG.warn("Pausing until token count stabilizes (target={}, actual={})", (Object)targetTokens, (Object)actualTokens);
            return false;
        }
        return true;
    }
}

