/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.serializers.TimestampSerializer;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tools.AbstractJmxClient;
import org.apache.cassandra.tools.JMXConnection;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFastFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class Shuffle
extends AbstractJmxClient {
    private static final String ssObjName = "org.apache.cassandra.db:type=StorageService";
    private static final String epSnitchObjName = "org.apache.cassandra.db:type=EndpointSnitchInfo";
    private StorageServiceMBean ssProxy = null;
    private Random rand = new Random(System.currentTimeMillis());
    private final String thriftHost;
    private final int thriftPort;
    private final boolean thriftFramed;
    private final String thriftUsername;
    private final String thriftPassword;

    public Shuffle(String host, int port, String thriftHost, int thriftPort, boolean thriftFramed, String jmxUsername, String jmxPassword, String thriftUsername, String thriftPassword) throws IOException {
        super(host, port, jmxUsername, jmxPassword);
        this.thriftHost = thriftHost;
        this.thriftPort = thriftPort;
        this.thriftFramed = thriftFramed;
        this.thriftUsername = thriftUsername;
        this.thriftPassword = thriftPassword;
        this.ssProxy = this.getSSProxy(this.jmxConn.getMbeanServerConn());
    }

    private StorageServiceMBean getSSProxy(MBeanServerConnection mbeanConn) {
        StorageServiceMBean proxy;
        try {
            ObjectName name = new ObjectName(ssObjName);
            proxy = JMX.newMBeanProxy(mbeanConn, name, StorageServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        return proxy;
    }

    private EndpointSnitchInfoMBean getEpSnitchProxy(MBeanServerConnection mbeanConn) {
        EndpointSnitchInfoMBean proxy;
        try {
            ObjectName name = new ObjectName(epSnitchObjName);
            proxy = JMX.newMBeanProxy(mbeanConn, name, EndpointSnitchInfoMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        return proxy;
    }

    private Multimap<String, String> calculateRelocations(Multimap<String, String> endpointMap) {
        HashMultimap relocations = HashMultimap.create();
        HashSet endpoints = new HashSet(endpointMap.keySet());
        HashMap<String, Integer> endpointToNumTokens = new HashMap<String, Integer>(endpoints.size());
        HashMap iterMap = new HashMap(endpoints.size());
        for (String endpoint : endpoints) {
            try {
                endpointToNumTokens.put(endpoint, this.ssProxy.getTokens(endpoint).size());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("What that...?", e);
            }
            iterMap.put(endpoint, endpointMap.get((Object)endpoint).iterator());
        }
        int epsToComplete = endpoints.size();
        HashSet<String> endpointsCompleted = new HashSet<String>();
        do {
            endpoints.removeAll(endpointsCompleted);
            for (String endpoint : endpoints) {
                boolean choiceMade = false;
                if (!((Iterator)iterMap.get(endpoint)).hasNext()) {
                    endpointsCompleted.add(endpoint);
                    continue;
                }
                String token = (String)((Iterator)iterMap.get(endpoint)).next();
                ArrayList subSet = new ArrayList(endpoints);
                subSet.remove(endpoint);
                Collections.shuffle(subSet, this.rand);
                for (String choice : subSet) {
                    if (relocations.get((Object)choice).size() >= (Integer)endpointToNumTokens.get(choice)) continue;
                    relocations.put((Object)choice, (Object)token);
                    choiceMade = true;
                    break;
                }
                if (choiceMade) continue;
                relocations.put((Object)endpoint, (Object)token);
            }
        } while (endpointsCompleted.size() != epsToComplete);
        return relocations;
    }

    private void enableRelocations(Collection<String> endpoints) {
        for (String endpoint : endpoints) {
            try {
                JMXConnection conn = new JMXConnection(endpoint, this.port, this.username, this.password);
                this.getSSProxy(conn.getMbeanServerConn()).enableScheduledRangeXfers();
                conn.close();
            }
            catch (IOException e) {
                this.writeln("Failed to enable shuffling on %s!", endpoint);
            }
        }
    }

    private void disableRelocations(Collection<String> endpoints) {
        for (String endpoint : endpoints) {
            try {
                JMXConnection conn = new JMXConnection(endpoint, this.port, this.username, this.password);
                this.getSSProxy(conn.getMbeanServerConn()).disableScheduledRangeXfers();
                conn.close();
            }
            catch (IOException e) {
                this.writeln("Failed to enable shuffling on %s!", endpoint);
            }
        }
    }

    private Collection<String> getLiveNodes() throws ShuffleError {
        try {
            JMXConnection conn = new JMXConnection(this.host, this.port, this.username, this.password);
            return this.getSSProxy(conn.getMbeanServerConn()).getLiveNodes();
        }
        catch (IOException e) {
            throw new ShuffleError("Error retrieving list of nodes from JMX interface");
        }
    }

    public void shuffle(boolean enable, String onlyDc) throws ShuffleError {
        Map<String, String> tokenMap;
        HashMultimap endpointMap = HashMultimap.create();
        EndpointSnitchInfoMBean epSnitchProxy = this.getEpSnitchProxy(this.jmxConn.getMbeanServerConn());
        try {
            CassandraClient seedClient = this.getThriftClient(this.thriftHost);
            tokenMap = seedClient.describe_token_map();
            for (Map.Entry<String, String> entry : tokenMap.entrySet()) {
                String endpoint = entry.getValue();
                String token = entry.getKey();
                try {
                    if (onlyDc != null) {
                        if (!onlyDc.equals(epSnitchProxy.getDatacenter(endpoint))) continue;
                        endpointMap.put((Object)endpoint, (Object)token);
                        continue;
                    }
                    endpointMap.put((Object)endpoint, (Object)token);
                }
                catch (UnknownHostException e) {
                    this.writeln("Warning: %s unknown to EndpointSnitch!", endpoint);
                }
            }
        }
        catch (InvalidRequestException ire) {
            throw new RuntimeException("What that...?", ire);
        }
        catch (TException e) {
            throw new ShuffleError(String.format("Thrift request to %s:%d failed: %s", this.thriftHost, this.thriftPort, e.getMessage()));
        }
        Multimap<String, String> relocations = this.calculateRelocations((Multimap<String, String>)endpointMap);
        this.writeln("%-42s %-15s %-15s", "Token", "From", "To");
        this.writeln("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+~~~~~~~~~~~~~~~+~~~~~~~~~~~~~~~");
        IPartitioner<?> partitioner = this.getPartitioner();
        for (String endpoint : relocations.keySet()) {
            for (String tok : relocations.get((Object)endpoint)) {
                this.writeln("%-42s %-15s %-15s", tok, tokenMap.get(tok), endpoint);
            }
            this.executeCqlQuery(endpoint, this.createShuffleBatchInsert(relocations.get((Object)endpoint), partitioner));
        }
        if (enable) {
            this.enableRelocations(relocations.keySet());
        }
    }

    public void ls() throws ShuffleError {
        Map<String, List<CqlRow>> queuedRelocations = this.listRelocations();
        boolean justOnce = false;
        IPartitioner<?> partitioner = this.getPartitioner();
        for (String host : queuedRelocations.keySet()) {
            for (CqlRow row : queuedRelocations.get(host)) {
                assert (row.getColumns().size() == 2);
                if (!justOnce) {
                    this.writeln("%-42s %-15s %s", "Token", "Endpoint", "Requested at");
                    this.writeln("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+~~~~~~~~~~~~~~~+~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                    justOnce = true;
                }
                ByteBuffer tokenBytes = ByteBuffer.wrap(((Column)row.getColumns().get(0)).getValue());
                ByteBuffer requestedAt = ByteBuffer.wrap(((Column)row.getColumns().get(1)).getValue());
                Date time = TimestampSerializer.instance.deserialize(requestedAt);
                Token token = partitioner.getTokenFactory().fromByteArray(tokenBytes);
                this.writeln("%-42s %-15s %s", token.toString(), host, time.toString());
            }
        }
    }

    private Map<String, List<CqlRow>> listRelocations() throws ShuffleError {
        String cqlQuery = "SELECT token_bytes,requested_at FROM system.range_xfers";
        HashMap<String, List<CqlRow>> results = new HashMap<String, List<CqlRow>>();
        for (String host : this.getLiveNodes()) {
            CqlResult result = this.executeCqlQuery(host, cqlQuery);
            results.put(host, result.getRows());
        }
        return results;
    }

    public void clear() throws ShuffleError {
        Map<String, List<CqlRow>> queuedRelocations = this.listRelocations();
        for (String host : queuedRelocations.keySet()) {
            for (CqlRow row : queuedRelocations.get(host)) {
                assert (row.getColumns().size() == 2);
                ByteBuffer tokenBytes = ByteBuffer.wrap(((Column)row.getColumns().get(0)).getValue());
                String query = String.format("DELETE FROM system.range_xfers WHERE token_bytes = 0x%s", ByteBufferUtil.bytesToHex(tokenBytes));
                this.executeCqlQuery(host, query);
            }
        }
    }

    public void enable() throws ShuffleError {
        this.enableRelocations(this.getLiveNodes());
    }

    public void disable() throws ShuffleError {
        this.disableRelocations(this.getLiveNodes());
    }

    private CassandraClient getThriftClient(String hostName) throws ShuffleError {
        try {
            return new CassandraClient(hostName, this.thriftPort, this.thriftFramed, this.thriftUsername, this.thriftPassword);
        }
        catch (TException e) {
            throw new ShuffleError(String.format("Unable to connect to %s/%d: %s", hostName, this.port, e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CqlResult executeCqlQuery(String hostName, String cqlQuery) throws ShuffleError {
        try (CassandraClient client = this.getThriftClient(hostName);){
            CqlResult cqlResult = client.execute_cql_query(ByteBuffer.wrap(cqlQuery.getBytes()), Compression.NONE);
            return cqlResult;
        }
        catch (UnavailableException e) {
            throw new ShuffleError(String.format("Unable to write shuffle entries to %s. Reason: UnavailableException", hostName));
        }
        catch (TimedOutException e) {
            throw new ShuffleError(String.format("Unable to write shuffle entries to %s. Reason: TimedOutException", hostName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IPartitioner<?> getPartitioner() throws ShuffleError {
        String partitionerName;
        try {
            partitionerName = this.getThriftClient(this.thriftHost).describe_partitioner();
        }
        catch (TException e) {
            throw new ShuffleError(String.format("Thrift request to %s:%d failed: %s", this.thriftHost, this.port, e.getMessage()));
        }
        try {
            return (IPartitioner)Class.forName(partitionerName).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ShuffleError("Unable to locate class for partitioner: " + partitionerName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String createShuffleBatchInsert(Collection<String> tokens, IPartitioner<?> partitioner) {
        StringBuilder query = new StringBuilder();
        query.append("BEGIN BATCH").append("\n");
        for (String tokenStr : tokens) {
            Token token = partitioner.getTokenFactory().fromString(tokenStr);
            String hexToken = ByteBufferUtil.bytesToHex(partitioner.getTokenFactory().toByteArray(token));
            query.append("INSERT INTO system.range_xfers (token_bytes, requested_at) ").append("VALUES (").append("0x").append(hexToken).append(", 'now');").append("\n");
        }
        query.append("APPLY BATCH").append("\n");
        return query.toString();
    }

    private static void printShuffleHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sub-commands:").append(String.format("%n", new Object[0]));
        sb.append(" create           Initialize a new shuffle operation").append(String.format("%n", new Object[0]));
        sb.append(" ls               List pending relocations").append(String.format("%n", new Object[0]));
        sb.append(" clear            Clear pending relocations").append(String.format("%n", new Object[0]));
        sb.append(" en[able]         Enable shuffling").append(String.format("%n", new Object[0]));
        sb.append(" dis[able]        Disable shuffling").append(String.format("%n%n", new Object[0]));
        Shuffle.printHelp("shuffle [options] <sub-command>", sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CommandLine cmd = null;
        try {
            cmd = Shuffle.processArguments(args);
        }
        catch (MissingArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (cmd.getArgList().size() < 1) {
            System.err.println("Missing sub-command argument.");
            Shuffle.printShuffleHelp();
            System.exit(1);
        }
        String subCommand = (String)cmd.getArgList().get(0);
        String hostName = cmd.getOptionValue("host") != null ? cmd.getOptionValue("host") : "localhost";
        String port = cmd.getOptionValue("port") != null ? cmd.getOptionValue("port") : Integer.toString(7199);
        String username = cmd.getOptionValue("username");
        String password = cmd.getOptionValue("password");
        String thriftHost = cmd.getOptionValue("thrift-host") != null ? cmd.getOptionValue("thrift-host") : hostName;
        String thriftPort = cmd.getOptionValue("thrift-port") != null ? cmd.getOptionValue("thrift-port") : "9160";
        String thriftUsername = cmd.getOptionValue("thrift-user") != null ? cmd.getOptionValue("thrift-user") : null;
        String thriftPassword = cmd.getOptionValue("thrift-password") != null ? cmd.getOptionValue("thrift-password") : null;
        String onlyDc = cmd.getOptionValue("only-dc");
        boolean thriftFramed = cmd.hasOption("thrift-framed");
        boolean andEnable = cmd.hasOption("and-enable");
        int portNum = -1;
        int thriftPortNum = -1;
        if (port != null) {
            try {
                portNum = Integer.parseInt(port);
            }
            catch (NumberFormatException ferr) {
                System.err.printf("%s is not a valid JMX port number.%n", port);
                System.exit(1);
            }
        } else {
            portNum = 7199;
        }
        if (thriftPort != null) {
            try {
                thriftPortNum = Integer.parseInt(thriftPort);
            }
            catch (NumberFormatException ferr) {
                System.err.printf("%s is not a valid port number.%n", thriftPort);
                System.exit(1);
            }
        } else {
            thriftPortNum = 9160;
        }
        try (Shuffle shuffler = new Shuffle(hostName, portNum, thriftHost, thriftPortNum, thriftFramed, username, password, thriftUsername, thriftPassword);){
            if (subCommand.equals("create")) {
                shuffler.shuffle(andEnable, onlyDc);
            } else if (subCommand.equals("ls")) {
                shuffler.ls();
            } else if (subCommand.startsWith("en")) {
                shuffler.enable();
            } else if (subCommand.startsWith("dis")) {
                shuffler.disable();
            } else if (subCommand.equals("clear")) {
                shuffler.clear();
            } else {
                System.err.println("Unknown subcommand: " + subCommand);
                Shuffle.printShuffleHelp();
                System.exit(1);
            }
        }
        System.exit(0);
    }

    static {
        Shuffle.addCmdOption("th", "thrift-host", true, "Thrift hostname or IP address (Default: JMX host)");
        Shuffle.addCmdOption("tp", "thrift-port", true, "Thrift port number (Default: 9160)");
        Shuffle.addCmdOption("tf", "thrift-framed", false, "Enable framed transport for Thrift (Default: false)");
        Shuffle.addCmdOption("tu", "thrift-user", true, "Thrift username");
        Shuffle.addCmdOption("tpw", "thrift-password", true, "Thrift password");
        Shuffle.addCmdOption("en", "and-enable", true, "Immediately enable shuffling (create only)");
        Shuffle.addCmdOption("dc", "only-dc", true, "Apply only to named DC (create only)");
    }

    class ShuffleError
    extends Exception {
        ShuffleError(String msg) {
            super(msg);
        }
    }

    private static class CassandraClient
    implements Closeable {
        TTransport transport;
        Cassandra.Client client;

        CassandraClient(String hostName, int port, boolean framed, String username, String password) throws TException {
            TSocket socket = new TSocket(hostName, port);
            this.transport = framed ? socket : new TFastFramedTransport((TTransport)socket);
            this.transport.open();
            this.client = new Cassandra.Client((TProtocol)new TBinaryProtocol(this.transport));
            if (username != null && password != null) {
                AuthenticationRequest request = new AuthenticationRequest();
                request.putToCredentials("username", username);
                request.putToCredentials("password", password);
                this.client.login(request);
            }
            this.client.set_cql_version("3.0.0");
        }

        CqlResult execute_cql_query(ByteBuffer cqlQuery, Compression compression) throws Exception {
            return this.client.execute_cql3_query(cqlQuery, compression, ConsistencyLevel.ONE);
        }

        String describe_partitioner() throws TException {
            return this.client.describe_partitioner();
        }

        Map<String, String> describe_token_map() throws TException {
            return this.client.describe_token_map();
        }

        @Override
        public void close() {
            this.transport.close();
        }
    }
}

