/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferCounterCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.NativeCell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.NativeAllocator;

public class NativeCounterCell
extends NativeCell
implements CounterCell {
    private static final long SIZE = ObjectSizes.measure(new NativeCounterCell());

    private NativeCounterCell() {
    }

    public NativeCounterCell(NativeAllocator allocator, OpOrder.Group writeOp, CounterCell copyOf) {
        super(allocator, writeOp, copyOf);
    }

    @Override
    protected void construct(Cell from) {
        super.construct(from);
        this.setLong(this.internalSize() - 8L, ((CounterCell)from).timestampOfLastDelete());
    }

    @Override
    protected int postfixSize() {
        return 8;
    }

    @Override
    protected int sizeOf(Cell cell) {
        return 8 + super.sizeOf(cell);
    }

    @Override
    public long timestampOfLastDelete() {
        return this.getLong(this.internalSize() - 8L);
    }

    @Override
    public long total() {
        return contextManager.total(this.value());
    }

    @Override
    public boolean hasLegacyShards() {
        return contextManager.hasLegacyShards(this.value());
    }

    @Override
    public Cell markLocalToBeCleared() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell diff(Cell cell) {
        return this.diffCounter(cell);
    }

    @Override
    public Cell reconcile(Cell cell) {
        return this.reconcileCounter(cell);
    }

    @Override
    public int serializationFlags() {
        return 4;
    }

    @Override
    public int cellDataSize() {
        return super.cellDataSize() + TypeSizes.NATIVE.sizeof(this.timestampOfLastDelete());
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        return super.serializedSize(type, typeSizes) + typeSizes.sizeof(this.timestampOfLastDelete());
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        contextManager.validateContext(this.value());
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        this.updateWithName(digest);
        contextManager.updateDigest(digest, this.value());
        FBUtilities.updateWithLong(digest, this.timestamp());
        FBUtilities.updateWithByte(digest, this.serializationFlags());
        FBUtilities.updateWithLong(digest, this.timestampOfLastDelete());
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s(%s:false:%s@%d!%d)", this.getClass().getSimpleName(), comparator.getString(this.name()), contextManager.toString(this.value()), this.timestamp(), this.timestampOfLastDelete());
    }

    @Override
    public CounterCell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferCounterCell(this.copy(metadata, allocator), allocator.clone(this.value()), this.timestamp(), this.timestampOfLastDelete());
    }

    @Override
    public CounterCell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return SIZE;
    }

    @Override
    public long unsharedHeapSize() {
        return SIZE;
    }

    @Override
    public boolean equals(Cell cell) {
        return cell instanceof CounterCell && this.equals((CounterCell)cell);
    }

    public boolean equals(CounterCell cell) {
        return super.equals(cell) && this.timestampOfLastDelete() == cell.timestampOfLastDelete();
    }
}

