/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.WriteCallbackInfo;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResponseVerbHandler.class);

    public void doVerb(MessageIn message, int id) {
        long latency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - MessagingService.instance().getRegisteredCallbackAge(id));
        CallbackInfo callbackInfo = MessagingService.instance().removeRegisteredCallback(id);
        if (callbackInfo == null) {
            String msg = "Callback already removed for {} (from {})";
            logger.debug(msg, (Object)id, (Object)message.from);
            Tracing.trace(msg, id, message.from);
            return;
        }
        Tracing.trace("Processing response from {}", message.from);
        IAsyncCallback cb = callbackInfo.callback;
        if (message.isFailureResponse()) {
            ((IAsyncCallbackWithFailure)cb).onFailure(message.from);
        } else {
            MessagingService.instance().maybeAddLatency(cb, message.from, latency);
            cb.response(message);
        }
        if (callbackInfo instanceof WriteCallbackInfo) {
            ((IMutation)((WriteCallbackInfo)callbackInfo).sentMessage.payload).release();
        }
    }
}

