/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Array;
import java.util.EnumMap;
import java.util.Map;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.Pair;

public class OptionCodec<T extends Enum<T>> {
    private final Class<T> klass;
    private final T[] ids;

    public OptionCodec(Class<T> klass) {
        this.klass = klass;
        Enum[] values = (Enum[])klass.getEnumConstants();
        int maxId = -1;
        for (Enum opt : values) {
            maxId = Math.max(maxId, ((Codecable)((Object)opt)).getId());
        }
        this.ids = (Enum[])Array.newInstance(klass, maxId + 1);
        for (Enum opt : values) {
            if (this.ids[((Codecable)((Object)opt)).getId()] != null) {
                throw new IllegalStateException(String.format("Duplicate option id %d", ((Codecable)((Object)opt)).getId()));
            }
            this.ids[((Codecable)((Object)opt)).getId()] = opt;
        }
    }

    private T fromId(int id) {
        T opt = this.ids[id];
        if (opt == null) {
            throw new ProtocolException(String.format("Unknown option id %d", id));
        }
        return opt;
    }

    public Map<T, Object> decode(ByteBuf body, int version) {
        EnumMap<T, Object> options = new EnumMap<T, Object>(this.klass);
        int n = body.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            T opt = this.fromId(body.readUnsignedShort());
            Object value = ((Codecable)opt).readValue(body, version);
            if (options.containsKey(opt)) {
                throw new ProtocolException(String.format("Duplicate option %s in message", ((Enum)opt).name()));
            }
            options.put(opt, value);
        }
        return options;
    }

    public ByteBuf encode(Map<T, Object> options, int version) {
        int optLength = 2;
        for (Map.Entry<T, Object> entry : options.entrySet()) {
            optLength += 2 + ((Codecable)((Object)((Enum)entry.getKey()))).serializedValueSize(entry.getValue(), version);
        }
        ByteBuf cb = Unpooled.buffer((int)optLength);
        cb.writeShort(options.size());
        for (Map.Entry<T, Object> entry : options.entrySet()) {
            Enum opt = (Enum)entry.getKey();
            cb.writeShort(((Codecable)((Object)opt)).getId());
            ((Codecable)((Object)opt)).writeValue(entry.getValue(), cb, version);
        }
        return cb;
    }

    public Pair<T, Object> decodeOne(ByteBuf body, int version) {
        T opt = this.fromId(body.readUnsignedShort());
        Object value = ((Codecable)opt).readValue(body, version);
        return Pair.create(opt, value);
    }

    public void writeOne(Pair<T, Object> option, ByteBuf dest, int version) {
        Enum opt = (Enum)option.left;
        Object obj = option.right;
        dest.writeShort(((Codecable)((Object)opt)).getId());
        ((Codecable)((Object)opt)).writeValue(obj, dest, version);
    }

    public int oneSerializedSize(Pair<T, Object> option, int version) {
        Enum opt = (Enum)option.left;
        Object obj = option.right;
        return 2 + ((Codecable)((Object)opt)).serializedValueSize(obj, version);
    }

    public static interface Codecable<T extends Enum<T>> {
        public int getId();

        public Object readValue(ByteBuf var1, int var2);

        public void writeValue(Object var1, ByteBuf var2, int var3);

        public int serializedValueSize(Object var1, int var2);
    }
}

