/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class ColumnDefinition
extends ColumnSpecification {
    private static final String COLUMN_NAME = "column_name";
    private static final String TYPE = "validator";
    private static final String INDEX_TYPE = "index_type";
    private static final String INDEX_OPTIONS = "index_options";
    private static final String INDEX_NAME = "index_name";
    private static final String COMPONENT_INDEX = "component_index";
    private static final String KIND = "type";
    public final Kind kind;
    private String indexName;
    private IndexType indexType;
    private Map<String, String> indexOptions;
    private final Integer componentIndex;

    public static ColumnDefinition partitionKeyDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.PARTITION_KEY);
    }

    public static ColumnDefinition partitionKeyDef(String ksName, String cfName, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(ksName, cfName, new ColumnIdentifier(name, UTF8Type.instance), validator, null, null, null, componentIndex, Kind.PARTITION_KEY);
    }

    public static ColumnDefinition clusteringKeyDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.CLUSTERING_COLUMN);
    }

    public static ColumnDefinition regularDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.REGULAR);
    }

    public static ColumnDefinition staticDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex) {
        return new ColumnDefinition(cfm, name, validator, componentIndex, Kind.STATIC);
    }

    public static ColumnDefinition compactValueDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator) {
        return new ColumnDefinition(cfm, name, validator, null, Kind.COMPACT_VALUE);
    }

    public ColumnDefinition(CFMetaData cfm, ByteBuffer name, AbstractType<?> validator, Integer componentIndex, Kind kind) {
        this(cfm.ksName, cfm.cfName, new ColumnIdentifier(name, cfm.getComponentComparator(componentIndex, kind)), validator, null, null, null, componentIndex, kind);
    }

    @VisibleForTesting
    public ColumnDefinition(String ksName, String cfName, ColumnIdentifier name, AbstractType<?> validator, IndexType indexType, Map<String, String> indexOptions, String indexName, Integer componentIndex, Kind kind) {
        super(ksName, cfName, name, validator);
        assert (name != null && validator != null);
        this.kind = kind;
        this.indexName = indexName;
        this.componentIndex = componentIndex;
        this.setIndexType(indexType, indexOptions);
    }

    public ColumnDefinition copy() {
        return new ColumnDefinition(this.ksName, this.cfName, this.name, this.type, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.kind);
    }

    public ColumnDefinition withNewName(ColumnIdentifier newName) {
        return new ColumnDefinition(this.ksName, this.cfName, newName, this.type, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.kind);
    }

    public ColumnDefinition withNewType(AbstractType<?> newType) {
        return new ColumnDefinition(this.ksName, this.cfName, this.name, newType, this.indexType, this.indexOptions, this.indexName, this.componentIndex, this.kind);
    }

    public boolean isOnAllComponents() {
        return this.componentIndex == null;
    }

    public boolean isStatic() {
        return this.kind == Kind.STATIC;
    }

    public int position() {
        return this.componentIndex == null ? 0 : this.componentIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition cd = (ColumnDefinition)o;
        return Objects.equal((Object)this.ksName, (Object)cd.ksName) && Objects.equal((Object)this.cfName, (Object)cd.cfName) && Objects.equal((Object)this.name, (Object)cd.name) && Objects.equal((Object)this.type, (Object)cd.type) && Objects.equal((Object)((Object)this.kind), (Object)((Object)cd.kind)) && Objects.equal((Object)this.componentIndex, (Object)cd.componentIndex) && Objects.equal((Object)this.indexName, (Object)cd.indexName) && Objects.equal((Object)((Object)this.indexType), (Object)((Object)cd.indexType)) && Objects.equal(this.indexOptions, cd.indexOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ksName, this.cfName, this.name, this.type, this.kind, this.componentIndex, this.indexName, this.indexType, this.indexOptions});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add(KIND, (Object)this.type).add("kind", (Object)this.kind).add("componentIndex", (Object)this.componentIndex).add("indexName", (Object)this.indexName).add("indexType", (Object)this.indexType).toString();
    }

    public boolean isThriftCompatible() {
        return this.kind == Kind.REGULAR && this.componentIndex == null;
    }

    public boolean isPrimaryKeyColumn() {
        return this.kind == Kind.PARTITION_KEY || this.kind == Kind.CLUSTERING_COLUMN;
    }

    public static List<ColumnDef> toThrift(Map<ByteBuffer, ColumnDefinition> columns) {
        ArrayList<ColumnDef> thriftDefs = new ArrayList<ColumnDef>(columns.size());
        for (ColumnDefinition def : columns.values()) {
            if (def.kind != Kind.REGULAR) continue;
            thriftDefs.add(def.toThrift());
        }
        return thriftDefs;
    }

    public boolean isPartOfCellName() {
        return this.kind == Kind.REGULAR || this.kind == Kind.STATIC;
    }

    public ColumnDef toThrift() {
        ColumnDef cd = new ColumnDef();
        cd.setName(ByteBufferUtil.clone(this.name.bytes));
        cd.setValidation_class(this.type.toString());
        cd.setIndex_type(this.indexType == null ? null : org.apache.cassandra.thrift.IndexType.valueOf((String)this.indexType.name()));
        cd.setIndex_name(this.indexName == null ? null : this.indexName);
        cd.setIndex_options(this.indexOptions == null ? null : Maps.newHashMap(this.indexOptions));
        return cd;
    }

    public static ColumnDefinition fromThrift(String ksName, String cfName, AbstractType<?> thriftComparator, AbstractType<?> thriftSubcomparator, ColumnDef thriftColumnDef) throws SyntaxException, ConfigurationException {
        Integer componentIndex = thriftSubcomparator != null ? Integer.valueOf(1) : null;
        AbstractType<?> comparator = thriftSubcomparator == null ? thriftComparator : thriftSubcomparator;
        try {
            comparator.validate(thriftColumnDef.name);
        }
        catch (MarshalException e) {
            throw new ConfigurationException(String.format("Column name %s is not valid for comparator %s", ByteBufferUtil.bytesToHex(thriftColumnDef.name), comparator));
        }
        return new ColumnDefinition(ksName, cfName, new ColumnIdentifier(ByteBufferUtil.clone(thriftColumnDef.name), comparator), TypeParser.parse(thriftColumnDef.validation_class), thriftColumnDef.index_type == null ? null : IndexType.valueOf(thriftColumnDef.index_type.name()), thriftColumnDef.index_options, thriftColumnDef.index_name, componentIndex, Kind.REGULAR);
    }

    public static List<ColumnDefinition> fromThrift(String ksName, String cfName, AbstractType<?> thriftComparator, AbstractType<?> thriftSubcomparator, List<ColumnDef> thriftDefs) throws SyntaxException, ConfigurationException {
        if (thriftDefs == null) {
            return new ArrayList<ColumnDefinition>();
        }
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>(thriftDefs.size());
        for (ColumnDef thriftColumnDef : thriftDefs) {
            defs.add(ColumnDefinition.fromThrift(ksName, cfName, thriftComparator, thriftSubcomparator, thriftColumnDef));
        }
        return defs;
    }

    public void deleteFromSchema(Mutation mutation, long timestamp) {
        ColumnFamily cf = mutation.addOrGet(CFMetaData.SchemaColumnsCf);
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        Composite prefix = CFMetaData.SchemaColumnsCf.comparator.make(this.cfName, this.name.toString());
        cf.addAtom(new RangeTombstone(prefix, prefix.end(), timestamp, ldt));
    }

    public void toSchema(Mutation mutation, long timestamp) {
        ColumnFamily cf = mutation.addOrGet(CFMetaData.SchemaColumnsCf);
        Composite prefix = CFMetaData.SchemaColumnsCf.comparator.make(this.cfName, this.name.toString());
        CFRowAdder adder = new CFRowAdder(cf, prefix, timestamp);
        adder.add(TYPE, this.type.toString());
        adder.add(INDEX_TYPE, this.indexType == null ? null : this.indexType.toString());
        adder.add(INDEX_OPTIONS, FBUtilities.json(this.indexOptions));
        adder.add(INDEX_NAME, this.indexName);
        adder.add(COMPONENT_INDEX, this.componentIndex);
        adder.add(KIND, this.kind.serialize());
    }

    public ColumnDefinition apply(ColumnDefinition def) throws ConfigurationException {
        assert (this.kind == def.kind && Objects.equal((Object)this.componentIndex, (Object)def.componentIndex));
        if (this.getIndexType() != null && def.getIndexType() != null) {
            if (!def.type.isCompatibleWith(this.type)) {
                throw new ConfigurationException(String.format("Cannot modify validator to a non-order-compatible one for column %s since an index is set", this.name));
            }
            assert (this.getIndexName() != null);
            if (!this.getIndexName().equals(def.getIndexName())) {
                throw new ConfigurationException("Cannot modify index name");
            }
        }
        return new ColumnDefinition(this.ksName, this.cfName, this.name, def.type, def.getIndexType(), def.getIndexOptions(), def.getIndexName(), this.componentIndex, this.kind);
    }

    public static UntypedResultSet resultify(Row serializedColumns) {
        String query = String.format("SELECT * FROM %s.%s", "system", "schema_columns");
        return QueryProcessor.resultify(query, serializedColumns);
    }

    public static List<ColumnDefinition> fromSchema(UntypedResultSet serializedColumns, String ksName, String cfName, AbstractType<?> rawComparator, boolean isSuper) {
        ArrayList<ColumnDefinition> cds = new ArrayList<ColumnDefinition>();
        for (UntypedResultSet.Row row : serializedColumns) {
            AbstractType<?> validator;
            Kind kind = row.has(KIND) ? Kind.deserialize(row.getString(KIND)) : Kind.REGULAR;
            Integer componentIndex = null;
            if (kind == Kind.REGULAR && isSuper) {
                componentIndex = 1;
            } else if (row.has(COMPONENT_INDEX)) {
                componentIndex = row.getInt(COMPONENT_INDEX);
            }
            AbstractType<?> comparator = ColumnDefinition.getComponentComparator(rawComparator, componentIndex, kind);
            ColumnIdentifier name = new ColumnIdentifier(comparator.fromString(row.getString(COLUMN_NAME)), comparator);
            try {
                validator = TypeParser.parse(row.getString(TYPE));
            }
            catch (RequestValidationException e) {
                throw new RuntimeException(e);
            }
            IndexType indexType = null;
            if (row.has(INDEX_TYPE)) {
                indexType = IndexType.valueOf(row.getString(INDEX_TYPE));
            }
            Map<String, String> indexOptions = null;
            if (row.has(INDEX_OPTIONS)) {
                indexOptions = FBUtilities.fromJsonMap(row.getString(INDEX_OPTIONS));
            }
            String indexName = null;
            if (row.has(INDEX_NAME)) {
                indexName = row.getString(INDEX_NAME);
            }
            cds.add(new ColumnDefinition(ksName, cfName, name, validator, indexType, indexOptions, indexName, componentIndex, kind));
        }
        return cds;
    }

    public static AbstractType<?> getComponentComparator(AbstractType<?> rawComparator, Integer componentIndex, Kind kind) {
        switch (kind) {
            case REGULAR: {
                if (componentIndex == null || componentIndex == 0 && !(rawComparator instanceof CompositeType)) {
                    return rawComparator;
                }
                return ((CompositeType)rawComparator).types.get(componentIndex);
            }
        }
        return UTF8Type.instance;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ColumnDefinition setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ColumnDefinition setIndexType(IndexType indexType, Map<String, String> indexOptions) {
        this.indexType = indexType;
        this.indexOptions = indexOptions;
        return this;
    }

    public ColumnDefinition setIndex(String indexName, IndexType indexType, Map<String, String> indexOptions) {
        return this.setIndexName(indexName).setIndexType(indexType, indexOptions);
    }

    public boolean isIndexed() {
        return this.indexType != null;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public Map<String, String> getIndexOptions() {
        return this.indexOptions;
    }

    public boolean hasIndexOption(String name) {
        return this.indexOptions != null && this.indexOptions.containsKey(name);
    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING_COLUMN,
        REGULAR,
        STATIC,
        COMPACT_VALUE;


        public String serialize() {
            return this == CLUSTERING_COLUMN ? "clustering_key" : this.toString().toLowerCase();
        }

        public static Kind deserialize(String value) {
            if (value.equalsIgnoreCase("clustering_key")) {
                return CLUSTERING_COLUMN;
            }
            return Enum.valueOf(Kind.class, value.toUpperCase());
        }
    }
}

