/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.utils.FBUtilities;

public class WriteCallbackInfo
extends CallbackInfo {
    private final MessageOut sentMessage;
    private final ConsistencyLevel consistencyLevel;
    private final boolean allowHints;

    public WriteCallbackInfo(InetAddress target, IAsyncCallback callback, MessageOut message, IVersionedSerializer<?> serializer, ConsistencyLevel consistencyLevel, boolean allowHints) {
        super(target, callback, serializer);
        assert (message != null);
        this.sentMessage = message;
        this.consistencyLevel = consistencyLevel;
        this.allowHints = allowHints;
        assert (!target.equals(FBUtilities.getBroadcastAddress()));
    }

    Mutation mutation() {
        return this.sentMessage.verb == MessagingService.Verb.PAXOS_COMMIT ? ((Commit)this.sentMessage.payload).makeMutation() : (Mutation)this.sentMessage.payload;
    }

    @Override
    public boolean shouldHint() {
        return this.allowHints && this.sentMessage.verb != MessagingService.Verb.COUNTER_MUTATION && this.consistencyLevel != ConsistencyLevel.ANY && StorageProxy.shouldHint(this.target);
    }
}

