/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Comparator;
import org.apache.cassandra.utils.btree.BTree;

class Path {
    Object[][] path;
    byte[] indexes;
    byte depth;

    Path() {
    }

    Path(int depth) {
        this.path = new Object[depth][];
        this.indexes = new byte[depth];
    }

    void ensureDepth(Object[] btree) {
        int depth = BTree.depth(btree);
        if (this.path == null || this.path.length < depth) {
            this.path = new Object[depth][];
            this.indexes = new byte[depth];
        }
    }

    void moveEnd(Object[] node, boolean forwards) {
        this.push(node, BTree.getKeyEnd(node));
        if (!forwards) {
            this.predecessor();
        }
    }

    void moveStart(Object[] node, boolean forwards) {
        this.push(node, -1);
        if (forwards) {
            this.successor();
        }
    }

    <V> void find(Object[] node, Comparator<V> comparator, Object target, Op mode, boolean forwards) {
        int keyEnd;
        int i;
        this.depth = (byte)-1;
        if (target instanceof BTree.Special) {
            if (target == BTree.POSITIVE_INFINITY) {
                this.moveEnd(node, forwards);
            } else if (target == BTree.NEGATIVE_INFINITY) {
                this.moveStart(node, forwards);
            } else {
                throw new AssertionError();
            }
            return;
        }
        while (true) {
            if ((i = BTree.find(comparator, target, node, 0, keyEnd = BTree.getKeyEnd(node))) >= 0) {
                this.push(node, i);
                switch (mode) {
                    case HIGHER: {
                        this.successor();
                        break;
                    }
                    case LOWER: {
                        this.predecessor();
                    }
                }
                return;
            }
            i = -i - 1;
            if (BTree.isLeaf(node)) break;
            this.push(node, forwards ? i - 1 : i);
            node = (Object[])node[keyEnd + i];
        }
        switch (mode) {
            case LOWER: 
            case FLOOR: {
                --i;
            }
        }
        if (i < 0) {
            this.push(node, 0);
            this.predecessor();
        } else if (i >= keyEnd) {
            this.push(node, keyEnd - 1);
            this.successor();
        } else {
            this.push(node, i);
        }
    }

    private boolean isRoot() {
        return this.depth == 0;
    }

    private void pop() {
        this.depth = (byte)(this.depth - 1);
    }

    Object[] currentNode() {
        return this.path[this.depth];
    }

    byte currentIndex() {
        return this.indexes[this.depth];
    }

    private void push(Object[] node, int index) {
        this.depth = (byte)(this.depth + 1);
        this.path[this.depth] = node;
        this.indexes[this.depth] = (byte)index;
    }

    void setIndex(int index) {
        this.indexes[this.depth] = (byte)index;
    }

    void successor() {
        Object[] node = this.currentNode();
        int i = this.currentIndex();
        if (!BTree.isLeaf(node)) {
            node = (Object[])node[BTree.getBranchKeyEnd(node) + i + 1];
            while (!BTree.isLeaf(node)) {
                this.push(node, -1);
                node = (Object[])node[BTree.getBranchKeyEnd(node)];
            }
            this.push(node, 0);
            return;
        }
        if (++i < BTree.getLeafKeyEnd(node)) {
            this.setIndex(i);
            return;
        }
        while (!this.isRoot()) {
            this.pop();
            i = this.currentIndex() + 1;
            if (i >= BTree.getKeyEnd(node = this.currentNode())) continue;
            this.setIndex(i);
            return;
        }
        this.setIndex(BTree.getKeyEnd(node));
    }

    void predecessor() {
        Object[] node = this.currentNode();
        int i = this.currentIndex();
        if (!BTree.isLeaf(node)) {
            node = (Object[])node[BTree.getBranchKeyEnd(node) + i];
            while (!BTree.isLeaf(node)) {
                i = BTree.getBranchKeyEnd(node);
                this.push(node, i);
                node = (Object[])node[i * 2];
            }
            this.push(node, BTree.getLeafKeyEnd(node) - 1);
            return;
        }
        if (--i >= 0) {
            this.setIndex(i);
            return;
        }
        while (!this.isRoot()) {
            this.pop();
            i = this.currentIndex() - 1;
            if (i < 0) continue;
            this.setIndex(i);
            return;
        }
        this.setIndex(-1);
    }

    Object currentKey() {
        return this.currentNode()[this.currentIndex()];
    }

    int compareTo(Path that, boolean forwards) {
        int d = Math.min(this.depth, that.depth);
        for (int i = 0; i <= d; ++i) {
            int c = this.indexes[i] - that.indexes[i];
            if (c == 0) continue;
            return c;
        }
        d = this.depth - that.depth;
        return forwards ? d : -d;
    }

    static enum Op {
        CEIL,
        FLOOR,
        HIGHER,
        LOWER;

    }
}

