/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.RateLimiter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.BloomFilterTracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.metrics.RestorableMeter;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SelfRefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableReader
extends SSTable
implements SelfRefCounted<SSTableReader> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReader.class);
    private static final ScheduledThreadPoolExecutor syncExecutor = new ScheduledThreadPoolExecutor(1);
    private static final RateLimiter meterSyncThrottle = RateLimiter.create((double)100.0);
    public static final Comparator<SSTableReader> maxTimestampComparator = new Comparator<SSTableReader>(){

        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            long ts2;
            long ts1 = o1.getMaxTimestamp();
            return ts1 > (ts2 = o2.getMaxTimestamp()) ? -1 : (ts1 == ts2 ? 0 : 1);
        }
    };
    public static final Comparator<SSTableReader> sstableComparator = new Comparator<SSTableReader>(){

        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            return o1.first.compareTo(o2.first);
        }
    };
    public static final Ordering<SSTableReader> sstableOrdering = Ordering.from(sstableComparator);
    public final long maxDataAge;
    public final OpenReason openReason;
    protected SegmentedFile ifile;
    protected SegmentedFile dfile;
    protected IndexSummary indexSummary;
    protected IFilter bf;
    protected final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    protected InstrumentingCache<KeyCacheKey, RowIndexEntry> keyCache;
    protected final BloomFilterTracker bloomFilterTracker = new BloomFilterTracker();
    protected final AtomicBoolean isSuspect = new AtomicBoolean(false);
    protected volatile StatsMetadata sstableMetadata;
    protected final AtomicLong keyCacheHit = new AtomicLong(0L);
    protected final AtomicLong keyCacheRequest = new AtomicLong(0L);
    private final InstanceTidier tidy = new InstanceTidier(this.descriptor, this.metadata);
    private final Ref<SSTableReader> selfRef = new Ref<SSTableReader>(this, this.tidy);
    private RestorableMeter readMeter;

    public static long getApproximateKeyCount(Collection<SSTableReader> sstables) {
        boolean cardinalityAvailable;
        long count = -1L;
        boolean bl = cardinalityAvailable = !sstables.isEmpty() && Iterators.all(sstables.iterator(), (Predicate)new Predicate<SSTableReader>(){

            public boolean apply(SSTableReader sstable) {
                return sstable.descriptor.version.hasNewStatsFile();
            }
        });
        if (cardinalityAvailable) {
            boolean failed = false;
            ICardinality cardinality = null;
            for (SSTableReader sstable : sstables) {
                try {
                    CompactionMetadata metadata = (CompactionMetadata)sstable.descriptor.getMetadataSerializer().deserialize(sstable.descriptor, MetadataType.COMPACTION);
                    assert (metadata != null) : sstable.getFilename();
                    if (cardinality == null) {
                        cardinality = metadata.cardinalityEstimator;
                        continue;
                    }
                    cardinality = cardinality.merge(new ICardinality[]{metadata.cardinalityEstimator});
                }
                catch (IOException e) {
                    logger.warn("Reading cardinality from Statistics.db failed.", (Throwable)e);
                    failed = true;
                    break;
                }
                catch (CardinalityMergeException e) {
                    logger.warn("Cardinality merge failed.", (Throwable)e);
                    failed = true;
                    break;
                }
            }
            if (cardinality != null && !failed) {
                count = cardinality.cardinality();
            }
        }
        if (count < 0L) {
            for (SSTableReader sstable : sstables) {
                count += sstable.estimatedKeys();
            }
        }
        return count;
    }

    public static double estimateCompactionGain(Set<SSTableReader> overlapping) {
        HashSet<ICardinality> cardinalities = new HashSet<ICardinality>(overlapping.size());
        for (SSTableReader sstable : overlapping) {
            try {
                ICardinality cardinality = ((CompactionMetadata)sstable.descriptor.getMetadataSerializer().deserialize((Descriptor)sstable.descriptor, (MetadataType)MetadataType.COMPACTION)).cardinalityEstimator;
                if (cardinality != null) {
                    cardinalities.add(cardinality);
                    continue;
                }
                logger.debug("Got a null cardinality estimator in: {}", (Object)sstable.getFilename());
            }
            catch (IOException e) {
                logger.warn("Could not read up compaction metadata for {}", (Object)sstable, (Object)e);
            }
        }
        long totalKeyCountBefore = 0L;
        for (ICardinality cardinality : cardinalities) {
            totalKeyCountBefore += cardinality.cardinality();
        }
        if (totalKeyCountBefore == 0L) {
            return 1.0;
        }
        long totalKeyCountAfter = SSTableReader.mergeCardinalities(cardinalities).cardinality();
        logger.debug("Estimated compaction gain: {}/{}={}", new Object[]{totalKeyCountAfter, totalKeyCountBefore, (double)totalKeyCountAfter / (double)totalKeyCountBefore});
        return (double)totalKeyCountAfter / (double)totalKeyCountBefore;
    }

    private static ICardinality mergeCardinalities(Collection<ICardinality> cardinalities) {
        HyperLogLogPlus base = new HyperLogLogPlus(13, 25);
        try {
            base = base.merge(cardinalities.toArray(new ICardinality[cardinalities.size()]));
        }
        catch (CardinalityMergeException e) {
            logger.warn("Could not merge cardinalities", (Throwable)e);
        }
        return base;
    }

    public static SSTableReader open(Descriptor descriptor) throws IOException {
        CFMetaData metadata;
        if (descriptor.cfname.contains(".")) {
            int i = descriptor.cfname.indexOf(".");
            String parentName = descriptor.cfname.substring(0, i);
            CFMetaData parent = Schema.instance.getCFMetaData(descriptor.ksname, parentName);
            ColumnDefinition def = parent.getColumnDefinitionForIndex(descriptor.cfname.substring(i + 1));
            metadata = CFMetaData.newIndexMetadata(parent, def, SecondaryIndex.getIndexComparator(parent, def));
        } else {
            metadata = Schema.instance.getCFMetaData(descriptor.ksname, descriptor.cfname);
        }
        return SSTableReader.open(descriptor, metadata);
    }

    public static SSTableReader open(Descriptor desc, CFMetaData metadata) throws IOException {
        IPartitioner p = desc.cfname.contains(".") ? new LocalPartitioner(metadata.getKeyValidator()) : StorageService.getPartitioner();
        return SSTableReader.open(desc, SSTableReader.componentsFor(desc), metadata, p);
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) throws IOException {
        return SSTableReader.open(descriptor, components, metadata, partitioner, true);
    }

    public static SSTableReader openNoValidation(Descriptor descriptor, Set<Component> components, ColumnFamilyStore cfs) throws IOException {
        return SSTableReader.open(descriptor, components, cfs.metadata, cfs.partitioner, false);
    }

    /*
     * Exception decompiling
     */
    public static SSTableReader openForBatch(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, boolean validate) throws IOException {
        assert (components.contains(Component.DATA)) : "Data component is missing for sstable" + descriptor;
        assert (components.contains(Component.PRIMARY_INDEX)) : "Primary index component is missing for sstable " + descriptor;
        Map<MetadataType, MetadataComponent> sstableMetadata = descriptor.getMetadataSerializer().deserialize(descriptor, EnumSet.of(MetadataType.VALIDATION, MetadataType.STATS));
        ValidationMetadata validationMetadata = (ValidationMetadata)sstableMetadata.get((Object)MetadataType.VALIDATION);
        StatsMetadata statsMetadata = (StatsMetadata)sstableMetadata.get((Object)MetadataType.STATS);
        String partitionerName = partitioner.getClass().getCanonicalName();
        if (validationMetadata != null && !partitionerName.equals(validationMetadata.partitioner)) {
            logger.error(String.format("Cannot open %s; partitioner %s does not match system partitioner %s.  Note that the default partitioner starting with Cassandra 1.2 is Murmur3Partitioner, so you will need to edit that to match your old partitioner if upgrading.", descriptor, validationMetadata.partitioner, partitionerName));
            System.exit(1);
        }
        logger.info("Opening {} ({} bytes)", (Object)descriptor, (Object)new File(descriptor.filenameFor(Component.DATA)).length());
        SSTableReader sstable = SSTableReader.internalOpen(descriptor, components, metadata, partitioner, System.currentTimeMillis(), statsMetadata, OpenReason.NORMAL);
        long start = System.nanoTime();
        sstable.load(validationMetadata);
        logger.debug("INDEX LOAD TIME for {}: {} ms.", (Object)descriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        sstable.setup(!validate);
        if (validate) {
            sstable.validate();
        }
        if (sstable.getKeyCache() != null) {
            logger.debug("key cache contains {}/{} keys", (Object)sstable.getKeyCache().size(), (Object)sstable.getKeyCache().getCapacity());
        }
        return sstable;
    }

    public static void logOpenException(Descriptor descriptor, IOException e) {
        if (e instanceof FileNotFoundException) {
            logger.error("Missing sstable component in {}; skipped because of {}", (Object)descriptor, (Object)e.getMessage());
        } else {
            logger.error("Corrupt sstable {}; skipped", (Object)descriptor, (Object)e);
        }
    }

    public static Collection<SSTableReader> openAll(Set<Map.Entry<Descriptor, Set<Component>>> entries, final CFMetaData metadata, final IPartitioner partitioner) {
        final LinkedBlockingQueue<SSTableReader> sstables = new LinkedBlockingQueue<SSTableReader>();
        DebuggableThreadPoolExecutor executor = DebuggableThreadPoolExecutor.createWithFixedPoolSize("SSTableBatchOpen", FBUtilities.getAvailableProcessors());
        for (final Map.Entry<Descriptor, Set<Component>> entry : entries) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SSTableReader sstable;
                    try {
                        sstable = SSTableReader.open((Descriptor)entry.getKey(), (Set)entry.getValue(), metadata, partitioner);
                    }
                    catch (IOException ex) {
                        logger.error("Corrupt sstable {}; skipped", (Object)entry, (Object)ex);
                        return;
                    }
                    sstables.add(sstable);
                }
            };
            executor.submit(runnable);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return sstables;
    }

    public static SSTableReader internalOpen(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, SegmentedFile ifile, SegmentedFile dfile, IndexSummary isummary, IFilter bf, long maxDataAge, StatsMetadata sstableMetadata, OpenReason openReason) {
        assert (desc != null && partitioner != null && ifile != null && dfile != null && isummary != null && bf != null && sstableMetadata != null);
        SSTableReader reader = SSTableReader.internalOpen(desc, components, metadata, partitioner, maxDataAge, sstableMetadata, openReason);
        reader.bf = bf;
        reader.ifile = ifile;
        reader.dfile = dfile;
        reader.indexSummary = isummary;
        reader.setup(false);
        return reader;
    }

    private static SSTableReader internalOpen(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, Long maxDataAge, StatsMetadata sstableMetadata, OpenReason openReason) {
        Factory readerFactory = descriptor.getFormat().getReaderFactory();
        return readerFactory.open(descriptor, components, metadata, partitioner, maxDataAge, sstableMetadata, openReason);
    }

    protected SSTableReader(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, long maxDataAge, StatsMetadata sstableMetadata, OpenReason openReason) {
        super(desc, components, metadata, partitioner);
        this.sstableMetadata = sstableMetadata;
        this.maxDataAge = maxDataAge;
        this.openReason = openReason;
        this.rowIndexEntrySerializer = this.descriptor.version.getSSTableFormat().getIndexSerializer(metadata);
    }

    public static long getTotalBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.onDiskLength();
        }
        return sum;
    }

    public static long getTotalUncompressedBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.uncompressedLength();
        }
        return sum;
    }

    public boolean equals(Object that) {
        return that instanceof SSTableReader && ((SSTableReader)that).descriptor.equals(this.descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public String getFilename() {
        return this.dfile.path();
    }

    @Override
    public String getIndexFilename() {
        return this.ifile.path();
    }

    public void setTrackedBy(DataTracker tracker) {
        this.tidy.type.deletingTask.setTracker(tracker);
        this.keyCache = CacheService.instance.keyCache;
    }

    private void load(ValidationMetadata validation) throws IOException {
        if (this.metadata.getBloomFilterFpChance() == 1.0) {
            this.load(false, true);
            this.bf = FilterFactory.AlwaysPresent;
        } else if (!this.components.contains(Component.FILTER) || validation == null) {
            this.load(true, true);
        } else if (validation.bloomFilterFPChance != this.metadata.getBloomFilterFpChance()) {
            this.load(true, true);
        } else {
            this.load(false, true);
            this.loadBloomFilter();
        }
    }

    private void loadBloomFilter() throws IOException {
        DataInputStream stream = null;
        try {
            stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.descriptor.filenameFor(Component.FILTER))));
            this.bf = FilterFactory.deserialize(stream, true);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(stream);
            throw throwable;
        }
        FileUtils.closeQuietly(stream);
    }

    private void load(boolean recreateBloomFilter, boolean saveSummaryIfCreated) throws IOException {
        block51: {
            try (SegmentedFile.Builder ibuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode(), false);
                 SegmentedFile.Builder dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode(), this.compression);){
                boolean summaryLoaded = this.loadSummary(ibuilder, dbuilder);
                boolean builtSummary = false;
                if (recreateBloomFilter || !summaryLoaded) {
                    this.buildSummary(recreateBloomFilter, ibuilder, dbuilder, summaryLoaded, 128);
                    builtSummary = true;
                }
                this.ifile = ibuilder.complete(this.descriptor.filenameFor(Component.PRIMARY_INDEX));
                this.dfile = dbuilder.complete(this.descriptor.filenameFor(Component.DATA));
                if (!(this.descriptor.version.hasSamplingLevel() || builtSummary || this.validateSummarySamplingLevel())) {
                    this.indexSummary.close();
                    this.ifile.close();
                    this.dfile.close();
                    logger.info("Detected erroneously downsampled index summary; will rebuild summary at full sampling");
                    FileUtils.deleteWithConfirm(new File(this.descriptor.filenameFor(Component.SUMMARY)));
                    try (SegmentedFile.Builder ibuilderRebuild = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode(), false);
                         SegmentedFile.Builder dbuilderRebuild = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode(), this.compression);){
                        this.buildSummary(false, ibuilderRebuild, dbuilderRebuild, false, 128);
                        this.ifile = ibuilderRebuild.complete(this.descriptor.filenameFor(Component.PRIMARY_INDEX));
                        this.dfile = dbuilderRebuild.complete(this.descriptor.filenameFor(Component.DATA));
                        this.saveSummary(ibuilderRebuild, dbuilderRebuild);
                        break block51;
                    }
                }
                if (saveSummaryIfCreated && builtSummary) {
                    this.saveSummary(ibuilder, dbuilder);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSummary(boolean recreateBloomFilter, SegmentedFile.Builder ibuilder, SegmentedFile.Builder dbuilder, boolean summaryLoaded, int samplingLevel) throws IOException {
        RandomAccessReader primaryIndex = RandomAccessReader.open(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)));
        try {
            long estimatedKeys;
            long indexSize = primaryIndex.length();
            long histogramCount = this.sstableMetadata.estimatedRowSize.count();
            long l = estimatedKeys = histogramCount > 0L && !this.sstableMetadata.estimatedRowSize.isOverflowed() ? histogramCount : this.estimateRowsFromIndex(primaryIndex);
            if (recreateBloomFilter) {
                this.bf = FilterFactory.getFilter(estimatedKeys, this.metadata.getBloomFilterFpChance(), true);
            }
            try (IndexSummaryBuilder summaryBuilder = summaryLoaded ? null : new IndexSummaryBuilder(estimatedKeys, this.metadata.getMinIndexInterval(), samplingLevel);){
                long indexPosition;
                RowIndexEntry.IndexSerializer<?> rowIndexSerializer = this.descriptor.getFormat().getIndexSerializer(this.metadata);
                while ((indexPosition = primaryIndex.getFilePointer()) != indexSize) {
                    ByteBuffer key = ByteBufferUtil.readWithShortLength(primaryIndex);
                    RowIndexEntry<?> indexEntry = rowIndexSerializer.deserialize(primaryIndex, this.descriptor.version);
                    DecoratedKey decoratedKey = this.partitioner.decorateKey(key);
                    if (this.first == null) {
                        this.first = decoratedKey;
                    }
                    this.last = decoratedKey;
                    if (recreateBloomFilter) {
                        this.bf.add(decoratedKey);
                    }
                    if (summaryLoaded) continue;
                    summaryBuilder.maybeAddEntry(decoratedKey, indexPosition);
                    ibuilder.addPotentialBoundary(indexPosition);
                    dbuilder.addPotentialBoundary(indexEntry.position);
                }
                if (!summaryLoaded) {
                    this.indexSummary = summaryBuilder.build(this.partitioner);
                }
            }
        }
        finally {
            FileUtils.closeQuietly(primaryIndex);
        }
        this.first = SSTableReader.getMinimalKey(this.first);
        this.last = SSTableReader.getMinimalKey(this.last);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSummary(SegmentedFile.Builder ibuilder, SegmentedFile.Builder dbuilder) {
        File summariesFile = new File(this.descriptor.filenameFor(Component.SUMMARY));
        if (!summariesFile.exists()) {
            return false;
        }
        DataInputStream iStream = null;
        try {
            iStream = new DataInputStream(new FileInputStream(summariesFile));
            this.indexSummary = IndexSummary.serializer.deserialize(iStream, this.partitioner, this.descriptor.version.hasSamplingLevel(), this.metadata.getMinIndexInterval(), this.metadata.getMaxIndexInterval());
            this.first = this.partitioner.decorateKey(ByteBufferUtil.readWithLength(iStream));
            this.last = this.partitioner.decorateKey(ByteBufferUtil.readWithLength(iStream));
            ibuilder.deserializeBounds(iStream);
            dbuilder.deserializeBounds(iStream);
        }
        catch (IOException e) {
            boolean bl;
            try {
                if (this.indexSummary != null) {
                    this.indexSummary.close();
                }
                logger.debug("Cannot deserialize SSTable Summary File {}: {}", (Object)summariesFile.getPath(), (Object)e.getMessage());
                FileUtils.closeQuietly(iStream);
                FileUtils.deleteWithConfirm(summariesFile);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(iStream);
                throw throwable;
            }
            FileUtils.closeQuietly(iStream);
            return bl;
        }
        FileUtils.closeQuietly(iStream);
        return true;
    }

    private boolean validateSummarySamplingLevel() {
        Iterator<FileDataInput> segments = this.ifile.iterator(0L);
        int i = 0;
        int summaryEntriesChecked = 0;
        int expectedIndexInterval = this.getMinIndexInterval();
        while (segments.hasNext()) {
            FileDataInput in = segments.next();
            try {
                while (!in.isEOF()) {
                    ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                    if (i % expectedIndexInterval == 0) {
                        ByteBuffer summaryKey = ByteBuffer.wrap(this.indexSummary.getKey(i / expectedIndexInterval));
                        if (!summaryKey.equals(indexKey)) {
                            boolean bl = false;
                            return bl;
                        }
                        if (++summaryEntriesChecked == 128) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    RowIndexEntry.Serializer.skip(in);
                    ++i;
                }
            }
            catch (IOException e) {
                this.markSuspect();
                throw new CorruptSSTableException((Exception)e, in.getPath());
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }
        return true;
    }

    public void saveSummary(SegmentedFile.Builder ibuilder, SegmentedFile.Builder dbuilder) {
        SSTableReader.saveSummary(this.descriptor, this.first, this.last, ibuilder, dbuilder, this.indexSummary);
    }

    private void saveSummary(SegmentedFile.Builder ibuilder, SegmentedFile.Builder dbuilder, IndexSummary newSummary) {
        SSTableReader.saveSummary(this.descriptor, this.first, this.last, ibuilder, dbuilder, newSummary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSummary(Descriptor descriptor, DecoratedKey first, DecoratedKey last, SegmentedFile.Builder ibuilder, SegmentedFile.Builder dbuilder, IndexSummary summary) {
        File summariesFile = new File(descriptor.filenameFor(Component.SUMMARY));
        if (summariesFile.exists()) {
            FileUtils.deleteWithConfirm(summariesFile);
        }
        BufferedDataOutputStreamPlus oStream = null;
        try {
            oStream = new BufferedDataOutputStreamPlus(new FileOutputStream(summariesFile));
            IndexSummary.serializer.serialize(summary, oStream, descriptor.version.hasSamplingLevel());
            ByteBufferUtil.writeWithLength(first.getKey(), oStream);
            ByteBufferUtil.writeWithLength(last.getKey(), oStream);
            ibuilder.serializeBounds(oStream);
            dbuilder.serializeBounds(oStream);
        }
        catch (IOException e) {
            block5: {
                try {
                    logger.debug("Cannot save SSTable Summary: ", (Throwable)e);
                    if (!summariesFile.exists()) break block5;
                    FileUtils.deleteWithConfirm(summariesFile);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(oStream);
                    throw throwable;
                }
            }
            FileUtils.closeQuietly(oStream);
        }
        FileUtils.closeQuietly(oStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplacedBy(SSTableReader replacement) {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (replacement != null);
            assert (!this.tidy.isReplaced);
            assert (this.tidy.global.live == this);
            this.tidy.isReplaced = true;
            this.tidy.global.live = replacement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableReader cloneWithNewStart(DecoratedKey newStart, final Runnable runOnClose) {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (this.openReason != OpenReason.EARLY);
            SSTableReader replacement = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, this.partitioner, this.ifile.sharedCopy(), this.dfile.sharedCopy(), this.indexSummary.sharedCopy(), this.bf.sharedCopy(), this.maxDataAge, this.sstableMetadata, OpenReason.MOVED_START);
            if (newStart.compareTo(this.first) > 0) {
                final long dataStart = this.getPosition((RowPosition)newStart, (Operator)Operator.EQ).position;
                final long indexStart = this.getIndexScanPosition(newStart);
                this.tidy.runOnClose = new Runnable(){

                    @Override
                    public void run() {
                        SSTableReader.this.dfile.dropPageCache(dataStart);
                        SSTableReader.this.ifile.dropPageCache(indexStart);
                        if (runOnClose != null) {
                            runOnClose.run();
                        }
                    }
                };
            }
            replacement.first = newStart;
            replacement.last = this.last;
            this.setReplacedBy(replacement);
            return replacement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableReader cloneAsShadowed(final Runnable runOnClose) {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (this.openReason != OpenReason.EARLY);
            this.tidy.runOnClose = new Runnable(){

                @Override
                public void run() {
                    SSTableReader.this.dfile.dropPageCache(0L);
                    SSTableReader.this.ifile.dropPageCache(0L);
                    runOnClose.run();
                }
            };
            SSTableReader replacement = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, this.partitioner, this.ifile.sharedCopy(), this.dfile.sharedCopy(), this.indexSummary.sharedCopy(), this.bf.sharedCopy(), this.maxDataAge, this.sstableMetadata, OpenReason.SHADOWED);
            replacement.first = this.first;
            replacement.last = this.last;
            this.setReplacedBy(replacement);
            return replacement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableReader cloneWithNewSummarySamplingLevel(ColumnFamilyStore parent, int samplingLevel) throws IOException {
        assert (this.descriptor.version.hasSamplingLevel());
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            IndexSummary newSummary;
            long oldSize;
            block32: {
                assert (this.openReason != OpenReason.EARLY);
                int minIndexInterval = this.metadata.getMinIndexInterval();
                int maxIndexInterval = this.metadata.getMaxIndexInterval();
                double effectiveInterval = this.indexSummary.getEffectiveIndexInterval();
                oldSize = this.bytesOnDisk();
                if (samplingLevel > this.indexSummary.getSamplingLevel() || this.indexSummary.getMinIndexInterval() != minIndexInterval || effectiveInterval > (double)maxIndexInterval) {
                    newSummary = this.buildSummaryAtLevel(samplingLevel);
                } else {
                    if (samplingLevel < this.indexSummary.getSamplingLevel()) {
                        newSummary = IndexSummaryBuilder.downsample(this.indexSummary, samplingLevel, minIndexInterval, this.partitioner);
                        try (SegmentedFile.Builder ibuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode(), false);
                             SegmentedFile.Builder dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode(), this.compression);){
                            this.saveSummary(ibuilder, dbuilder, newSummary);
                            break block32;
                        }
                    }
                    throw new AssertionError((Object)"Attempted to clone SSTableReader with the same index summary sampling level and no adjustments to min/max_index_interval");
                }
            }
            long newSize = this.bytesOnDisk();
            StorageMetrics.load.inc(newSize - oldSize);
            parent.metric.liveDiskSpaceUsed.inc(newSize - oldSize);
            SSTableReader replacement = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, this.partitioner, this.ifile.sharedCopy(), this.dfile.sharedCopy(), newSummary, this.bf.sharedCopy(), this.maxDataAge, this.sstableMetadata, OpenReason.METADATA_CHANGE);
            replacement.first = this.first;
            replacement.last = this.last;
            this.setReplacedBy(replacement);
            return replacement;
        }
    }

    /*
     * Loose catch block
     */
    private IndexSummary buildSummaryAtLevel(int newSamplingLevel) throws IOException {
        RandomAccessReader primaryIndex = RandomAccessReader.open(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)));
        try {
            long indexSize = primaryIndex.length();
            try (IndexSummaryBuilder summaryBuilder = new IndexSummaryBuilder(this.estimatedKeys(), this.metadata.getMinIndexInterval(), newSamplingLevel);){
                long indexPosition;
                while ((indexPosition = primaryIndex.getFilePointer()) != indexSize) {
                    summaryBuilder.maybeAddEntry(this.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(primaryIndex)), indexPosition);
                    RowIndexEntry.Serializer.skip(primaryIndex);
                }
                IndexSummary indexSummary = summaryBuilder.build(this.partitioner);
                return indexSummary;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtils.closeQuietly(primaryIndex);
        }
    }

    public RestorableMeter getReadMeter() {
        return this.readMeter;
    }

    public int getIndexSummarySamplingLevel() {
        return this.indexSummary.getSamplingLevel();
    }

    public long getIndexSummaryOffHeapSize() {
        return this.indexSummary.getOffHeapSize();
    }

    public int getMinIndexInterval() {
        return this.indexSummary.getMinIndexInterval();
    }

    public double getEffectiveIndexInterval() {
        return this.indexSummary.getEffectiveIndexInterval();
    }

    public void releaseSummary() {
        this.tidy.releaseSummary();
        this.indexSummary = null;
    }

    private void validate() {
        if (this.first.compareTo(this.last) > 0) {
            this.selfRef().release();
            throw new IllegalStateException(String.format("SSTable first key %s > last key %s", this.first, this.last));
        }
    }

    public long getIndexScanPosition(RowPosition key) {
        if (this.openReason == OpenReason.MOVED_START && key.compareTo(this.first) < 0) {
            key = this.first;
        }
        return SSTableReader.getIndexScanPositionFromBinarySearchResult(this.indexSummary.binarySearch(key), this.indexSummary);
    }

    @VisibleForTesting
    public static long getIndexScanPositionFromBinarySearchResult(int binarySearchResult, IndexSummary referencedIndexSummary) {
        if (binarySearchResult == -1) {
            return 0L;
        }
        return referencedIndexSummary.getPosition(SSTableReader.getIndexSummaryIndexFromBinarySearchResult(binarySearchResult));
    }

    public static int getIndexSummaryIndexFromBinarySearchResult(int binarySearchResult) {
        if (binarySearchResult < 0) {
            int greaterThan = (binarySearchResult + 1) * -1;
            if (greaterThan == 0) {
                return -1;
            }
            return greaterThan - 1;
        }
        return binarySearchResult;
    }

    public CompressionMetadata getCompressionMetadata() {
        if (!this.compression) {
            throw new IllegalStateException(this + " is not compressed");
        }
        CompressionMetadata cmd = ((ICompressedFile)((Object)this.dfile)).getMetadata();
        String cfName = this.metadata.isSecondaryIndex() ? this.metadata.getParentColumnFamilyName() : this.metadata.cfName;
        cmd.parameters.setLiveMetadata(Schema.instance.getCFMetaData(this.metadata.ksName, cfName));
        return cmd;
    }

    public long getCompressionMetadataOffHeapSize() {
        if (!this.compression) {
            return 0L;
        }
        return this.getCompressionMetadata().offHeapSize();
    }

    public void forceFilterFailures() {
        this.bf = FilterFactory.AlwaysPresent;
    }

    public IFilter getBloomFilter() {
        return this.bf;
    }

    public long getBloomFilterSerializedSize() {
        return this.bf.serializedSize();
    }

    public long getBloomFilterOffHeapSize() {
        return this.bf.offHeapSize();
    }

    public long estimatedKeys() {
        return this.indexSummary.getEstimatedKeyCount();
    }

    public long estimatedKeysForRanges(Collection<Range<Token>> ranges) {
        long sampleKeyCount = 0L;
        List<Pair<Integer, Integer>> sampleIndexes = SSTableReader.getSampleIndexesForRanges(this.indexSummary, ranges);
        for (Pair<Integer, Integer> sampleIndexRange : sampleIndexes) {
            sampleKeyCount += (long)((Integer)sampleIndexRange.right - (Integer)sampleIndexRange.left + 1);
        }
        long estimatedKeys = sampleKeyCount * (128L * (long)this.indexSummary.getMinIndexInterval()) / (long)this.indexSummary.getSamplingLevel();
        return Math.max(1L, estimatedKeys);
    }

    public int getIndexSummarySize() {
        return this.indexSummary.size();
    }

    public int getMaxIndexSummarySize() {
        return this.indexSummary.getMaxNumberOfEntries();
    }

    public byte[] getIndexSummaryKey(int index) {
        return this.indexSummary.getKey(index);
    }

    private static List<Pair<Integer, Integer>> getSampleIndexesForRanges(IndexSummary summary, Collection<Range<Token>> ranges) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        for (Range range : Range.normalize(ranges)) {
            int right;
            Token.KeyBound leftPosition = ((Token)range.left).maxKeyBound();
            Token.KeyBound rightPosition = ((Token)range.right).maxKeyBound();
            int left = summary.binarySearch(leftPosition);
            left = left < 0 ? (left + 1) * -1 : ++left;
            if (left == summary.size()) continue;
            int n = right = Range.isWrapAround(range.left, range.right) ? summary.size() - 1 : summary.binarySearch(rightPosition);
            if (right < 0) {
                if ((right = (right + 1) * -1) == 0) continue;
                --right;
            }
            if (left > right) continue;
            positions.add(Pair.create(left, right));
        }
        return positions;
    }

    public Iterable<DecoratedKey> getKeySamples(Range<Token> range) {
        final List<Pair<Integer, Integer>> indexRanges = SSTableReader.getSampleIndexesForRanges(this.indexSummary, Collections.singletonList(range));
        if (indexRanges.isEmpty()) {
            return Collections.emptyList();
        }
        return new Iterable<DecoratedKey>(){

            @Override
            public Iterator<DecoratedKey> iterator() {
                return new Iterator<DecoratedKey>(){
                    private Iterator<Pair<Integer, Integer>> rangeIter;
                    private Pair<Integer, Integer> current;
                    private int idx;
                    {
                        this.rangeIter = indexRanges.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current == null || this.idx > (Integer)this.current.right) {
                            if (this.rangeIter.hasNext()) {
                                this.current = this.rangeIter.next();
                                this.idx = (Integer)this.current.left;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public DecoratedKey next() {
                        byte[] bytes = SSTableReader.this.indexSummary.getKey(this.idx++);
                        return SSTableReader.this.partitioner.decorateKey(ByteBuffer.wrap(bytes));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<Pair<Long, Long>> getPositionsForRanges(Collection<Range<Token>> ranges) {
        ArrayList<Pair<Long, Long>> positions = new ArrayList<Pair<Long, Long>>();
        for (Range<Token> range : Range.normalize(ranges)) {
            RowPosition rightBound;
            assert (!range.isWrapAround() || ((Token)range.right).isMinimum());
            Range<RowPosition> bounds = Range.makeRowRange(range);
            RowPosition leftBound = ((RowPosition)bounds.left).compareTo(this.first) > 0 ? (RowPosition)bounds.left : this.first.getToken().minKeyBound();
            RowPosition rowPosition = rightBound = ((RowPosition)bounds.right).isMinimum() ? this.last.getToken().maxKeyBound() : (RowPosition)bounds.right;
            if (leftBound.compareTo(this.last) > 0 || rightBound.compareTo(this.first) < 0) continue;
            long left = this.getPosition((RowPosition)leftBound, (Operator)Operator.GT).position;
            long right = rightBound.compareTo(this.last) > 0 ? this.uncompressedLength() : this.getPosition((RowPosition)rightBound, (Operator)Operator.GT).position;
            if (left == right) continue;
            assert (left < right) : String.format("Range=%s openReason=%s first=%s last=%s left=%d right=%d", new Object[]{range, this.openReason, this.first, this.last, left, right});
            positions.add(Pair.create(left, right));
        }
        return positions;
    }

    public void invalidateCacheKey(DecoratedKey key) {
        KeyCacheKey cacheKey = new KeyCacheKey(this.metadata.cfId, this.descriptor, key.getKey());
        this.keyCache.remove(cacheKey);
    }

    public void cacheKey(DecoratedKey key, RowIndexEntry info) {
        CachingOptions caching = this.metadata.getCaching();
        if (!caching.keyCache.isEnabled() || this.keyCache == null || this.keyCache.getCapacity() == 0L) {
            return;
        }
        KeyCacheKey cacheKey = new KeyCacheKey(this.metadata.cfId, this.descriptor, key.getKey());
        logger.trace("Adding cache entry for {} -> {}", (Object)cacheKey, (Object)info);
        this.keyCache.put(cacheKey, info);
    }

    public RowIndexEntry getCachedPosition(DecoratedKey key, boolean updateStats) {
        return this.getCachedPosition(new KeyCacheKey(this.metadata.cfId, this.descriptor, key.getKey()), updateStats);
    }

    protected RowIndexEntry getCachedPosition(KeyCacheKey unifiedKey, boolean updateStats) {
        if (this.keyCache != null && this.keyCache.getCapacity() > 0L) {
            if (updateStats) {
                RowIndexEntry cachedEntry = this.keyCache.get(unifiedKey);
                this.keyCacheRequest.incrementAndGet();
                if (cachedEntry != null) {
                    this.keyCacheHit.incrementAndGet();
                    this.bloomFilterTracker.addTruePositive();
                }
                return cachedEntry;
            }
            return this.keyCache.getInternal(unifiedKey);
        }
        return null;
    }

    public RowIndexEntry getPosition(RowPosition key, Operator op) {
        return this.getPosition(key, op, true, false);
    }

    public RowIndexEntry getPosition(RowPosition key, Operator op, boolean updateCacheAndStats) {
        return this.getPosition(key, op, updateCacheAndStats, false);
    }

    protected abstract RowIndexEntry getPosition(RowPosition var1, Operator var2, boolean var3, boolean var4);

    public abstract OnDiskAtomIterator iterator(DecoratedKey var1, SortedSet<CellName> var2);

    public abstract OnDiskAtomIterator iterator(FileDataInput var1, DecoratedKey var2, SortedSet<CellName> var3, RowIndexEntry var4);

    public abstract OnDiskAtomIterator iterator(DecoratedKey var1, ColumnSlice[] var2, boolean var3);

    public abstract OnDiskAtomIterator iterator(FileDataInput var1, DecoratedKey var2, ColumnSlice[] var3, boolean var4, RowIndexEntry var5);

    public DecoratedKey firstKeyBeyond(RowPosition token) {
        if (token.compareTo(this.first) < 0) {
            return this.first;
        }
        long sampledPosition = this.getIndexScanPosition(token);
        Iterator<FileDataInput> segments = this.ifile.iterator(sampledPosition);
        while (segments.hasNext()) {
            FileDataInput in = segments.next();
            try {
                while (!in.isEOF()) {
                    ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                    DecoratedKey indexDecoratedKey = this.partitioner.decorateKey(indexKey);
                    if (indexDecoratedKey.compareTo(token) > 0) {
                        DecoratedKey decoratedKey = indexDecoratedKey;
                        return decoratedKey;
                    }
                    RowIndexEntry.Serializer.skip(in);
                }
            }
            catch (IOException e) {
                this.markSuspect();
                throw new CorruptSSTableException((Exception)e, in.getPath());
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }
        return null;
    }

    public long uncompressedLength() {
        return this.dfile.length;
    }

    public long onDiskLength() {
        return this.dfile.onDiskLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markObsolete() {
        if (logger.isDebugEnabled()) {
            logger.debug("Marking {} compacted", (Object)this.getFilename());
        }
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (!this.tidy.isReplaced);
        }
        return !this.tidy.global.isCompacted.getAndSet(true);
    }

    public boolean isMarkedCompacted() {
        return this.tidy.global.isCompacted.get();
    }

    public void markSuspect() {
        if (logger.isDebugEnabled()) {
            logger.debug("Marking {} as a suspect for blacklisting.", (Object)this.getFilename());
        }
        this.isSuspect.getAndSet(true);
    }

    public boolean isMarkedSuspect() {
        return this.isSuspect.get();
    }

    public ISSTableScanner getScanner() {
        return this.getScanner((RateLimiter)null);
    }

    public ISSTableScanner getScanner(RateLimiter limiter) {
        return this.getScanner(DataRange.allData(this.partitioner), limiter);
    }

    public ISSTableScanner getScanner(DataRange dataRange) {
        return this.getScanner(dataRange, null);
    }

    public ISSTableScanner getScanner(Range<Token> range, RateLimiter limiter) {
        if (range == null) {
            return this.getScanner(limiter);
        }
        return this.getScanner(Collections.singletonList(range), limiter);
    }

    public abstract ISSTableScanner getScanner(Collection<Range<Token>> var1, RateLimiter var2);

    public abstract ISSTableScanner getScanner(DataRange var1, RateLimiter var2);

    public FileDataInput getFileDataInput(long position) {
        return this.dfile.getSegment(position);
    }

    public boolean newSince(long age) {
        return this.maxDataAge > age;
    }

    public void createLinks(String snapshotDirectoryPath) {
        for (Component component : this.components) {
            File sourceFile = new File(this.descriptor.filenameFor(component));
            File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            FileUtils.createHardLink(sourceFile, targetLink);
        }
    }

    public boolean isRepaired() {
        return this.sstableMetadata.repairedAt != 0L;
    }

    public SSTableReader getCurrentReplacement() {
        return this.tidy.global.live;
    }

    public long getBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getFalsePositiveCount();
    }

    public long getRecentBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getRecentFalsePositiveCount();
    }

    public long getBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getTruePositiveCount();
    }

    public long getRecentBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getRecentTruePositiveCount();
    }

    public InstrumentingCache<KeyCacheKey, RowIndexEntry> getKeyCache() {
        return this.keyCache;
    }

    public EstimatedHistogram getEstimatedRowSize() {
        return this.sstableMetadata.estimatedRowSize;
    }

    public EstimatedHistogram getEstimatedColumnCount() {
        return this.sstableMetadata.estimatedColumnCount;
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        return this.sstableMetadata.getEstimatedDroppableTombstoneRatio(gcBefore);
    }

    public double getDroppableTombstonesBefore(int gcBefore) {
        return this.sstableMetadata.getDroppableTombstonesBefore(gcBefore);
    }

    public double getCompressionRatio() {
        return this.sstableMetadata.compressionRatio;
    }

    public ReplayPosition getReplayPosition() {
        return this.sstableMetadata.replayPosition;
    }

    public long getMinTimestamp() {
        return this.sstableMetadata.minTimestamp;
    }

    public long getMaxTimestamp() {
        return this.sstableMetadata.maxTimestamp;
    }

    public Set<Integer> getAncestors() {
        try {
            CompactionMetadata compactionMetadata = (CompactionMetadata)this.descriptor.getMetadataSerializer().deserialize(this.descriptor, MetadataType.COMPACTION);
            return compactionMetadata.ancestors;
        }
        catch (IOException e) {
            SSTableReader.logOpenException(this.descriptor, e);
            return Collections.emptySet();
        }
    }

    public int getSSTableLevel() {
        return this.sstableMetadata.sstableLevel;
    }

    public void reloadSSTableMetadata() throws IOException {
        this.sstableMetadata = (StatsMetadata)this.descriptor.getMetadataSerializer().deserialize(this.descriptor, MetadataType.STATS);
    }

    public StatsMetadata getSSTableMetadata() {
        return this.sstableMetadata;
    }

    public RandomAccessReader openDataReader(RateLimiter limiter) {
        assert (limiter != null);
        return this.dfile.createThrottledReader(limiter);
    }

    public RandomAccessReader openDataReader() {
        return this.dfile.createReader();
    }

    public RandomAccessReader openIndexReader() {
        return this.ifile.createReader();
    }

    public long getCreationTimeFor(Component component) {
        return new File(this.descriptor.filenameFor(component)).lastModified();
    }

    public long getKeyCacheHit() {
        return this.keyCacheHit.get();
    }

    public long getKeyCacheRequest() {
        return this.keyCacheRequest.get();
    }

    public void incrementReadCount() {
        if (this.readMeter != null) {
            this.readMeter.mark();
        }
    }

    @Override
    public Ref<SSTableReader> tryRef() {
        return this.selfRef.tryRef();
    }

    @Override
    public Ref<SSTableReader> selfRef() {
        return this.selfRef;
    }

    @Override
    public Ref<SSTableReader> ref() {
        return this.selfRef.ref();
    }

    void setup(boolean isOffline) {
        this.tidy.setup(this, isOffline);
        this.readMeter = this.tidy.global.readMeter;
    }

    @VisibleForTesting
    public void overrideReadMeter(RestorableMeter readMeter) {
        this.readMeter = this.tidy.global.readMeter = readMeter;
    }

    public static abstract class Factory {
        public abstract SSTableReader open(Descriptor var1, Set<Component> var2, CFMetaData var3, IPartitioner var4, Long var5, StatsMetadata var6, OpenReason var7);
    }

    static final class GlobalTidy
    implements RefCounted.Tidy {
        static final ConcurrentMap<Descriptor, Ref<GlobalTidy>> lookup = new ConcurrentHashMap<Descriptor, Ref<GlobalTidy>>();
        private final Descriptor desc;
        private SSTableReader live;
        private RestorableMeter readMeter;
        private ScheduledFuture readMeterSyncFuture;
        private final AtomicBoolean isCompacted;

        GlobalTidy(SSTableReader reader) {
            this.desc = reader.descriptor;
            this.isCompacted = new AtomicBoolean();
            this.live = reader;
        }

        void ensureReadMeter() {
            if (this.readMeter != null) {
                return;
            }
            if ("system".equals(this.desc.ksname)) {
                this.readMeter = null;
                this.readMeterSyncFuture = null;
                return;
            }
            this.readMeter = SystemKeyspace.getSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.generation);
            this.readMeterSyncFuture = syncExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!GlobalTidy.this.isCompacted.get()) {
                        meterSyncThrottle.acquire();
                        SystemKeyspace.persistSSTableReadMeter(((GlobalTidy)GlobalTidy.this).desc.ksname, ((GlobalTidy)GlobalTidy.this).desc.cfname, ((GlobalTidy)GlobalTidy.this).desc.generation, GlobalTidy.this.readMeter);
                    }
                }
            }, 1L, 5L, TimeUnit.MINUTES);
        }

        @Override
        public void tidy() {
            lookup.remove(this.desc);
            if (this.readMeterSyncFuture != null) {
                this.readMeterSyncFuture.cancel(true);
            }
            if (this.isCompacted.get()) {
                SystemKeyspace.clearSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.generation);
            }
            CLibrary.trySkipCache(this.desc.filenameFor(Component.DATA), 0L, 0L);
            CLibrary.trySkipCache(this.desc.filenameFor(Component.PRIMARY_INDEX), 0L, 0L);
        }

        @Override
        public String name() {
            return this.desc.toString();
        }

        public static Ref<GlobalTidy> get(SSTableReader sstable) {
            Descriptor descriptor = sstable.descriptor;
            Ref<GlobalTidy> refc = (Ref<GlobalTidy>)lookup.get(descriptor);
            if (refc != null) {
                return refc.ref();
            }
            GlobalTidy tidy = new GlobalTidy(sstable);
            refc = new Ref<GlobalTidy>(tidy, tidy);
            Ref<GlobalTidy> ex = lookup.putIfAbsent(descriptor, refc);
            assert (ex == null);
            return refc;
        }
    }

    static final class DescriptorTypeTidy
    implements RefCounted.Tidy {
        static final ConcurrentMap<Descriptor, Ref<DescriptorTypeTidy>> lookup = new ConcurrentHashMap<Descriptor, Ref<DescriptorTypeTidy>>();
        private final Descriptor desc;
        private final Ref<GlobalTidy> globalRef;
        private final SSTableDeletingTask deletingTask;

        DescriptorTypeTidy(Descriptor desc, SSTableReader sstable) {
            this.desc = desc;
            this.deletingTask = new SSTableDeletingTask(desc, sstable);
            this.globalRef = GlobalTidy.get(sstable);
        }

        @Override
        public void tidy() {
            lookup.remove(this.desc);
            boolean isCompacted = this.globalRef.get().isCompacted.get();
            this.globalRef.release();
            switch (this.desc.type) {
                case FINAL: {
                    if (!isCompacted) break;
                    this.deletingTask.run();
                    break;
                }
                case TEMPLINK: {
                    this.deletingTask.run();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public String name() {
            return this.desc.toString();
        }

        public static Ref<DescriptorTypeTidy> get(SSTableReader sstable) {
            Ref<DescriptorTypeTidy> refc;
            Descriptor desc = sstable.descriptor;
            if (sstable.openReason == OpenReason.EARLY) {
                desc = desc.asType(Descriptor.Type.TEMPLINK);
            }
            if ((refc = (Ref<DescriptorTypeTidy>)lookup.get(desc)) != null) {
                return refc.ref();
            }
            DescriptorTypeTidy tidy = new DescriptorTypeTidy(desc, sstable);
            refc = new Ref<DescriptorTypeTidy>(tidy, tidy);
            Ref<DescriptorTypeTidy> ex = lookup.putIfAbsent(desc, refc);
            assert (ex == null);
            return refc;
        }
    }

    private static final class InstanceTidier
    implements RefCounted.Tidy {
        private final Descriptor descriptor;
        private final CFMetaData metadata;
        private IFilter bf;
        private IndexSummary summary;
        private SegmentedFile dfile;
        private SegmentedFile ifile;
        private Runnable runOnClose;
        private boolean isReplaced = false;
        private Ref<DescriptorTypeTidy> typeRef;
        private DescriptorTypeTidy type;
        private GlobalTidy global;
        private boolean setup;

        void setup(SSTableReader reader, boolean isOffline) {
            this.setup = true;
            this.bf = reader.bf;
            this.summary = reader.indexSummary;
            this.dfile = reader.dfile;
            this.ifile = reader.ifile;
            this.typeRef = DescriptorTypeTidy.get(reader);
            this.type = this.typeRef.get();
            this.global = (GlobalTidy)this.type.globalRef.get();
            if (!isOffline) {
                this.global.ensureReadMeter();
            }
        }

        InstanceTidier(Descriptor descriptor, CFMetaData metadata) {
            this.descriptor = descriptor;
            this.metadata = metadata;
        }

        @Override
        public void tidy() {
            OpOrder.Barrier barrier;
            if (!this.setup) {
                return;
            }
            ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(this.metadata.cfId);
            if (cfs != null) {
                barrier = cfs.readOrdering.newBarrier();
                barrier.issue();
            } else {
                barrier = null;
            }
            ScheduledExecutors.nonPeriodicTasks.execute(new Runnable(){

                @Override
                public void run() {
                    if (barrier != null) {
                        barrier.await();
                    }
                    InstanceTidier.this.bf.close();
                    if (InstanceTidier.this.summary != null) {
                        InstanceTidier.this.summary.close();
                    }
                    if (InstanceTidier.this.runOnClose != null) {
                        InstanceTidier.this.runOnClose.run();
                    }
                    InstanceTidier.this.dfile.close();
                    InstanceTidier.this.ifile.close();
                    InstanceTidier.this.typeRef.release();
                }
            });
        }

        @Override
        public String name() {
            return this.descriptor.toString();
        }

        void releaseSummary() {
            this.summary.close();
            assert (this.summary.isCleanedUp());
            this.summary = null;
        }
    }

    public static class SizeComparator
    implements Comparator<SSTableReader> {
        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            return Longs.compare((long)o1.onDiskLength(), (long)o2.onDiskLength());
        }
    }

    public static abstract class Operator {
        public static final Operator EQ = new Equals();
        public static final Operator GE = new GreaterThanOrEqualTo();
        public static final Operator GT = new GreaterThan();

        public abstract int apply(int var1);

        static final class GreaterThan
        extends Operator {
            GreaterThan() {
            }

            @Override
            public int apply(int comparison) {
                return comparison > 0 ? 0 : 1;
            }
        }

        static final class GreaterThanOrEqualTo
        extends Operator {
            GreaterThanOrEqualTo() {
            }

            @Override
            public int apply(int comparison) {
                return comparison >= 0 ? 0 : 1;
            }
        }

        static final class Equals
        extends Operator {
            Equals() {
            }

            @Override
            public int apply(int comparison) {
                return -comparison;
            }
        }
    }

    public static enum OpenReason {
        NORMAL,
        EARLY,
        METADATA_CHANGE,
        MOVED_START,
        SHADOWED;

    }
}

