/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventNotifier;
import org.apache.cassandra.utils.progress.ProgressListener;
import org.slf4j.helpers.MessageFormatter;

public class TraceState
implements ProgressEventNotifier {
    public final UUID sessionId;
    public final InetAddress coordinator;
    public final Stopwatch watch;
    public final ByteBuffer sessionIdBytes;
    public final Tracing.TraceType traceType;
    public final int ttl;
    private boolean notify;
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private String tag;
    private final boolean withFinishEvent;
    private final AtomicInteger pendingMutations = new AtomicInteger();
    private final Connection connection;
    private volatile Status status;
    private final AtomicInteger references = new AtomicInteger(1);

    public TraceState(InetAddress coordinator, UUID sessionId, Tracing.TraceType traceType) {
        this(coordinator, null, sessionId, traceType, false);
    }

    public TraceState(InetAddress coordinator, Connection connection, UUID sessionId, Tracing.TraceType traceType, boolean withFinishEvent) {
        assert (coordinator != null);
        assert (sessionId != null);
        this.coordinator = coordinator;
        this.connection = connection;
        this.sessionId = sessionId;
        this.sessionIdBytes = ByteBufferUtil.bytes(sessionId);
        this.traceType = traceType;
        this.ttl = traceType.getTTL();
        this.watch = Stopwatch.createStarted();
        this.status = Status.IDLE;
        this.withFinishEvent = withFinishEvent;
    }

    public void enableActivityNotification(String tag) {
        assert (this.traceType == Tracing.TraceType.REPAIR);
        this.notify = true;
        this.tag = tag;
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        assert (this.traceType == Tracing.TraceType.REPAIR);
        this.listeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        assert (this.traceType == Tracing.TraceType.REPAIR);
        this.listeners.remove(listener);
    }

    public int elapsed() {
        long elapsed = this.watch.elapsed(TimeUnit.MICROSECONDS);
        return elapsed < Integer.MAX_VALUE ? (int)elapsed : Integer.MAX_VALUE;
    }

    public synchronized void stop() {
        this.status = Status.STOPPED;
        this.notifyAll();
        this.pushEventIfStopped();
    }

    private void pushEventIfStopped() {
        if (this.status == Status.STOPPED && this.pendingMutations.get() == 0) {
            this.pendingMutations.set(Integer.MIN_VALUE);
            if (this.connection != null && this.withFinishEvent) {
                this.connection.sendIfRegistered(new Event.TraceComplete(this.sessionId));
            }
        }
    }

    public synchronized Status waitActivity(long timeout) {
        if (this.status == Status.IDLE) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }
        if (this.status == Status.ACTIVE) {
            this.status = Status.IDLE;
            return Status.ACTIVE;
        }
        return this.status;
    }

    private synchronized void notifyActivity() {
        this.status = Status.ACTIVE;
        this.notifyAll();
    }

    public void trace(String format, Object arg) {
        this.trace(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void trace(String format, Object[] args) {
        this.trace(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void trace(String message) {
        if (this.notify) {
            this.notifyActivity();
        }
        String threadName = Thread.currentThread().getName();
        int elapsed = this.elapsed();
        this.executeMutation(TraceKeyspace.makeEventMutation(this.sessionIdBytes, message, elapsed, threadName, this.ttl));
        for (ProgressListener listener : this.listeners) {
            listener.progress(this.tag, ProgressEvent.createNotification(message));
        }
    }

    void executeMutation(final Mutation mutation) {
        this.pendingMutations.incrementAndGet();
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                try {
                    TraceState.mutateWithCatch(mutation);
                }
                finally {
                    if (TraceState.this.pendingMutations.decrementAndGet() == 0) {
                        TraceState.this.pushEventIfStopped();
                    }
                }
            }
        });
    }

    public static void mutateWithTracing(final ByteBuffer sessionId, final String message, final int elapsed, final int ttl) {
        final String threadName = Thread.currentThread().getName();
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() {
                TraceState.mutateWithCatch(TraceKeyspace.makeEventMutation(sessionId, message, elapsed, threadName, ttl));
            }
        });
    }

    static void mutateWithCatch(Mutation mutation) {
        try {
            StorageProxy.mutate(Collections.singletonList(mutation), ConsistencyLevel.ANY);
        }
        catch (OverloadedException e) {
            Tracing.logger.warn("Too many nodes are overloaded to save trace events");
        }
    }

    public boolean acquireReference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public int releaseReference() {
        return this.references.decrementAndGet();
    }

    public static enum Status {
        IDLE,
        ACTIVE,
        STOPPED;

    }
}

