/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.ProtocolException;

public abstract class Event {
    public final Type type;

    private Event(Type type) {
        this.type = type;
    }

    public static Event deserialize(ByteBuf cb, int version) {
        Type eventType = CBUtil.readEnumValue(Type.class, cb);
        if (eventType.minimumVersion > version) {
            throw new ProtocolException("Event " + eventType.name() + " not valid for protocol version " + version);
        }
        switch (eventType) {
            case TOPOLOGY_CHANGE: {
                return TopologyChange.deserializeEvent(cb, version);
            }
            case STATUS_CHANGE: {
                return StatusChange.deserializeEvent(cb, version);
            }
            case SCHEMA_CHANGE: {
                return SchemaChange.deserializeEvent(cb, version);
            }
            case TRACE_COMPLETE: {
                return TraceComplete.deserializeEvent(cb, version);
            }
        }
        throw new AssertionError();
    }

    public void serialize(ByteBuf dest, int version) {
        if (this.type.minimumVersion > version) {
            throw new ProtocolException("Event " + this.type.name() + " not valid for protocol version " + version);
        }
        CBUtil.writeEnumValue(this.type, dest);
        this.serializeEvent(dest, version);
    }

    public int serializedSize(int version) {
        return CBUtil.sizeOfEnumValue(this.type) + this.eventSerializedSize(version);
    }

    protected abstract void serializeEvent(ByteBuf var1, int var2);

    protected abstract int eventSerializedSize(int var1);

    public static class TraceComplete
    extends Event {
        public final UUID traceSessionId;

        public TraceComplete(UUID traceSessionId) {
            super(Type.TRACE_COMPLETE);
            this.traceSessionId = traceSessionId;
        }

        public static Event deserializeEvent(ByteBuf cb, int version) {
            UUID traceSessionId = CBUtil.readUUID(cb);
            return new TraceComplete(traceSessionId);
        }

        @Override
        protected void serializeEvent(ByteBuf dest, int version) {
            CBUtil.writeUUID(this.traceSessionId, dest);
        }

        @Override
        protected int eventSerializedSize(int version) {
            return CBUtil.sizeOfUUID(this.traceSessionId);
        }

        public String toString() {
            return this.traceSessionId.toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.traceSessionId});
        }

        public boolean equals(Object other) {
            if (!(other instanceof TraceComplete)) {
                return false;
            }
            TraceComplete tf = (TraceComplete)other;
            return Objects.equal((Object)this.traceSessionId, (Object)tf.traceSessionId);
        }
    }

    public static class SchemaChange
    extends Event {
        public final Change change;
        public final Target target;
        public final String keyspace;
        public final String name;
        public final List<String> argTypes;

        public SchemaChange(Change change, Target target, String keyspace, String name, List<String> argTypes) {
            super(Type.SCHEMA_CHANGE);
            this.change = change;
            this.target = target;
            this.keyspace = keyspace;
            this.name = name;
            if (target != Target.KEYSPACE) assert (this.name != null) : "Table, type, function or aggregate name should be set for non-keyspace schema change events";
            this.argTypes = argTypes;
        }

        public SchemaChange(Change change, Target target, String keyspace, String name) {
            this(change, target, keyspace, name, null);
        }

        public SchemaChange(Change change, String keyspace) {
            this(change, Target.KEYSPACE, keyspace, null);
        }

        public static SchemaChange deserializeEvent(ByteBuf cb, int version) {
            Change change = CBUtil.readEnumValue(Change.class, cb);
            if (version >= 3) {
                Target target = CBUtil.readEnumValue(Target.class, cb);
                String keyspace = CBUtil.readString(cb);
                String tableOrType = target == Target.KEYSPACE ? null : CBUtil.readString(cb);
                List<String> argTypes = null;
                if (target == Target.FUNCTION || target == Target.AGGREGATE) {
                    argTypes = CBUtil.readStringList(cb);
                }
                return new SchemaChange(change, target, keyspace, tableOrType, argTypes);
            }
            String keyspace = CBUtil.readString(cb);
            String table = CBUtil.readString(cb);
            return new SchemaChange(change, table.isEmpty() ? Target.KEYSPACE : Target.TABLE, keyspace, table.isEmpty() ? null : table);
        }

        @Override
        public void serializeEvent(ByteBuf dest, int version) {
            if (this.target == Target.FUNCTION || this.target == Target.AGGREGATE) {
                if (version >= 4) {
                    CBUtil.writeEnumValue(this.change, dest);
                    CBUtil.writeEnumValue(this.target, dest);
                    CBUtil.writeString(this.keyspace, dest);
                    CBUtil.writeString(this.name, dest);
                    CBUtil.writeStringList(this.argTypes, dest);
                } else {
                    CBUtil.writeEnumValue(Change.UPDATED, dest);
                    if (version >= 3) {
                        CBUtil.writeEnumValue(Target.KEYSPACE, dest);
                    }
                    CBUtil.writeString(this.keyspace, dest);
                    CBUtil.writeString("", dest);
                }
                return;
            }
            if (version >= 3) {
                CBUtil.writeEnumValue(this.change, dest);
                CBUtil.writeEnumValue(this.target, dest);
                CBUtil.writeString(this.keyspace, dest);
                if (this.target != Target.KEYSPACE) {
                    CBUtil.writeString(this.name, dest);
                }
            } else if (this.target == Target.TYPE) {
                CBUtil.writeEnumValue(Change.UPDATED, dest);
                CBUtil.writeString(this.keyspace, dest);
                CBUtil.writeString("", dest);
            } else {
                CBUtil.writeEnumValue(this.change, dest);
                CBUtil.writeString(this.keyspace, dest);
                CBUtil.writeString(this.target == Target.KEYSPACE ? "" : this.name, dest);
            }
        }

        @Override
        public int eventSerializedSize(int version) {
            if (this.target == Target.FUNCTION || this.target == Target.AGGREGATE) {
                if (version >= 4) {
                    return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfEnumValue(this.target) + CBUtil.sizeOfString(this.keyspace) + CBUtil.sizeOfString(this.name) + CBUtil.sizeOfStringList(this.argTypes);
                }
                if (version >= 3) {
                    return CBUtil.sizeOfEnumValue(Change.UPDATED) + CBUtil.sizeOfEnumValue(Target.KEYSPACE) + CBUtil.sizeOfString(this.keyspace);
                }
                return CBUtil.sizeOfEnumValue(Change.UPDATED) + CBUtil.sizeOfString(this.keyspace) + CBUtil.sizeOfString("");
            }
            if (version >= 3) {
                int size = CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfEnumValue(this.target) + CBUtil.sizeOfString(this.keyspace);
                if (this.target != Target.KEYSPACE) {
                    size += CBUtil.sizeOfString(this.name);
                }
                return size;
            }
            if (this.target == Target.TYPE) {
                return CBUtil.sizeOfEnumValue(Change.UPDATED) + CBUtil.sizeOfString(this.keyspace) + CBUtil.sizeOfString("");
            }
            return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfString(this.keyspace) + CBUtil.sizeOfString(this.target == Target.KEYSPACE ? "" : this.name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append((Object)this.change).append(' ').append((Object)this.target).append(' ').append(this.keyspace);
            if (this.name != null) {
                sb.append('.').append(this.name);
            }
            if (this.argTypes != null) {
                sb.append(" (");
                Iterator<String> iter = this.argTypes.iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next());
                    if (!iter.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(')');
            }
            return sb.toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.change, this.target, this.keyspace, this.name, this.argTypes});
        }

        public boolean equals(Object other) {
            if (!(other instanceof SchemaChange)) {
                return false;
            }
            SchemaChange scc = (SchemaChange)other;
            return Objects.equal((Object)((Object)this.change), (Object)((Object)scc.change)) && Objects.equal((Object)((Object)this.target), (Object)((Object)scc.target)) && Objects.equal((Object)this.keyspace, (Object)scc.keyspace) && Objects.equal((Object)this.name, (Object)scc.name) && Objects.equal(this.argTypes, scc.argTypes);
        }

        public static enum Target {
            KEYSPACE,
            TABLE,
            TYPE,
            FUNCTION,
            AGGREGATE;

        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class StatusChange
    extends Event {
        public final Status status;
        public final InetSocketAddress node;

        private StatusChange(Status status, InetSocketAddress node) {
            super(Type.STATUS_CHANGE);
            this.status = status;
            this.node = node;
        }

        public static StatusChange nodeUp(InetAddress host, int port) {
            return new StatusChange(Status.UP, new InetSocketAddress(host, port));
        }

        public static StatusChange nodeDown(InetAddress host, int port) {
            return new StatusChange(Status.DOWN, new InetSocketAddress(host, port));
        }

        private static StatusChange deserializeEvent(ByteBuf cb, int version) {
            Status status = CBUtil.readEnumValue(Status.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new StatusChange(status, node);
        }

        @Override
        protected void serializeEvent(ByteBuf dest, int version) {
            CBUtil.writeEnumValue(this.status, dest);
            CBUtil.writeInet(this.node, dest);
        }

        @Override
        protected int eventSerializedSize(int version) {
            return CBUtil.sizeOfEnumValue(this.status) + CBUtil.sizeOfInet(this.node);
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.node;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.status, this.node});
        }

        public boolean equals(Object other) {
            if (!(other instanceof StatusChange)) {
                return false;
            }
            StatusChange stc = (StatusChange)other;
            return Objects.equal((Object)((Object)this.status), (Object)((Object)stc.status)) && Objects.equal((Object)this.node, (Object)stc.node);
        }

        public static enum Status {
            UP,
            DOWN;

        }
    }

    public static class TopologyChange
    extends Event {
        public final Change change;
        public final InetSocketAddress node;

        private TopologyChange(Change change, InetSocketAddress node) {
            super(Type.TOPOLOGY_CHANGE);
            this.change = change;
            this.node = node;
        }

        public static TopologyChange newNode(InetAddress host, int port) {
            return new TopologyChange(Change.NEW_NODE, new InetSocketAddress(host, port));
        }

        public static TopologyChange removedNode(InetAddress host, int port) {
            return new TopologyChange(Change.REMOVED_NODE, new InetSocketAddress(host, port));
        }

        public static TopologyChange movedNode(InetAddress host, int port) {
            return new TopologyChange(Change.MOVED_NODE, new InetSocketAddress(host, port));
        }

        private static TopologyChange deserializeEvent(ByteBuf cb, int version) {
            Change change = CBUtil.readEnumValue(Change.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new TopologyChange(change, node);
        }

        @Override
        protected void serializeEvent(ByteBuf dest, int version) {
            CBUtil.writeEnumValue(this.change, dest);
            CBUtil.writeInet(this.node, dest);
        }

        @Override
        protected int eventSerializedSize(int version) {
            return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfInet(this.node);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.node;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.change, this.node});
        }

        public boolean equals(Object other) {
            if (!(other instanceof TopologyChange)) {
                return false;
            }
            TopologyChange tpc = (TopologyChange)other;
            return Objects.equal((Object)((Object)this.change), (Object)((Object)tpc.change)) && Objects.equal((Object)this.node, (Object)tpc.node);
        }

        public static enum Change {
            NEW_NODE,
            REMOVED_NODE,
            MOVED_NODE;

        }
    }

    public static enum Type {
        TOPOLOGY_CHANGE(1),
        STATUS_CHANGE(1),
        SCHEMA_CHANGE(1),
        TRACE_COMPLETE(4);

        public final int minimumVersion;

        private Type(int minimumVersion) {
            this.minimumVersion = minimumVersion;
        }
    }
}

