/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.cassandra.db.BlacklistedDirectoriesMBean;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistedDirectories
implements BlacklistedDirectoriesMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=BlacklistedDirectories";
    private static final Logger logger = LoggerFactory.getLogger(BlacklistedDirectories.class);
    private static final BlacklistedDirectories instance = new BlacklistedDirectories();
    private final Set<File> unreadableDirectories = new CopyOnWriteArraySet<File>();
    private final Set<File> unwritableDirectories = new CopyOnWriteArraySet<File>();

    private BlacklistedDirectories() {
        MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME, MBeanWrapper.OnException.LOG);
    }

    @Override
    public Set<File> getUnreadableDirectories() {
        return Collections.unmodifiableSet(this.unreadableDirectories);
    }

    @Override
    public Set<File> getUnwritableDirectories() {
        return Collections.unmodifiableSet(this.unwritableDirectories);
    }

    public static File maybeMarkUnreadable(File path) {
        File directory = BlacklistedDirectories.getDirectory(path);
        if (BlacklistedDirectories.instance.unreadableDirectories.add(directory)) {
            logger.warn("Blacklisting {} for reads", (Object)directory);
            return directory;
        }
        return null;
    }

    public static File maybeMarkUnwritable(File path) {
        File directory = BlacklistedDirectories.getDirectory(path);
        if (BlacklistedDirectories.instance.unwritableDirectories.add(directory)) {
            logger.warn("Blacklisting {} for writes", (Object)directory);
            return directory;
        }
        return null;
    }

    public static boolean isUnreadable(File directory) {
        return BlacklistedDirectories.instance.unreadableDirectories.contains(directory);
    }

    public static boolean isUnwritable(File directory) {
        return BlacklistedDirectories.instance.unwritableDirectories.contains(directory);
    }

    private static File getDirectory(File file) {
        if (file.isDirectory()) {
            return file;
        }
        if (file.isFile()) {
            return file.getParentFile();
        }
        if (file.getPath().endsWith(".db")) {
            return file.getParentFile();
        }
        return file;
    }
}

