/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;

public class RangeNamesQueryPager
extends AbstractQueryPager {
    private volatile DecoratedKey lastReturnedKey;

    public RangeNamesQueryPager(PartitionRangeReadCommand command, PagingState state, int protocolVersion) {
        super(command, protocolVersion);
        assert (command.isNamesQuery());
        if (state != null) {
            this.lastReturnedKey = command.metadata().decorateKey(state.partitionKey);
            this.restoreState(this.lastReturnedKey, state.remaining, state.remainingInPartition);
        }
    }

    @Override
    public PagingState state() {
        return this.lastReturnedKey == null ? null : new PagingState(this.lastReturnedKey.getKey(), null, this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    protected ReadCommand nextPageReadCommand(int pageSize) throws RequestExecutionException {
        PartitionRangeReadCommand pageCmd = ((PartitionRangeReadCommand)this.command).withUpdatedLimit(this.command.limits().forPaging(pageSize));
        if (this.lastReturnedKey != null) {
            pageCmd = pageCmd.forSubRange(this.makeExcludingKeyBounds(this.lastReturnedKey));
        }
        return pageCmd;
    }

    @Override
    protected void recordLast(DecoratedKey key, Row last) {
        this.lastReturnedKey = key;
    }

    @Override
    protected boolean isPreviouslyReturnedPartition(DecoratedKey key) {
        return key.equals(this.lastReturnedKey);
    }

    private AbstractBounds<PartitionPosition> makeExcludingKeyBounds(PartitionPosition lastReturnedKey) {
        AbstractBounds<PartitionPosition> bounds = ((PartitionRangeReadCommand)this.command).dataRange().keyRange();
        if (bounds instanceof Range || bounds instanceof Bounds) {
            return new Range<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right);
        }
        return new ExcludingBounds<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right);
    }
}

