/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TokenRange;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.utils.FBUtilities;

public class NativeSSTableLoaderClient
extends SSTableLoader.Client {
    protected final Map<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
    private final Collection<InetAddress> hosts;
    private final int port;
    private final String username;
    private final String password;
    private final SSLOptions sslOptions;

    public NativeSSTableLoaderClient(Collection<InetAddress> hosts, int port, String username, String password, SSLOptions sslOptions) {
        this.hosts = hosts;
        this.port = port;
        this.username = username;
        this.password = password;
        this.sslOptions = sslOptions;
    }

    @Override
    public void init(String keyspace) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(this.hosts).withPort(this.port);
        if (this.sslOptions != null) {
            builder.withSSL(this.sslOptions);
        }
        if (this.username != null && this.password != null) {
            builder = builder.withCredentials(this.username, this.password);
        }
        try (Cluster cluster = builder.build();
             Session session = cluster.connect();){
            Metadata metadata = cluster.getMetadata();
            Set tokenRanges = metadata.getTokenRanges();
            IPartitioner partitioner = FBUtilities.newPartitioner(metadata.getPartitioner());
            Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
            for (TokenRange tokenRange : tokenRanges) {
                Set endpoints = metadata.getReplicas(keyspace, tokenRange);
                Range<Token> range = new Range<Token>(tokenFactory.fromString(tokenRange.getStart().getValue().toString()), tokenFactory.fromString(tokenRange.getEnd().getValue().toString()));
                for (Host endpoint : endpoints) {
                    this.addRangeForEndpoint(range, endpoint.getAddress());
                }
            }
            this.tables.putAll(NativeSSTableLoaderClient.fetchTablesMetadata(keyspace, session, partitioner));
            this.tables.putAll(NativeSSTableLoaderClient.fetchViewMetadata(keyspace, session, partitioner));
        }
    }

    @Override
    public CFMetaData getTableMetadata(String tableName) {
        return this.tables.get(tableName);
    }

    @Override
    public void setTableMetadata(CFMetaData cfm) {
        this.tables.put(cfm.cfName, cfm);
    }

    private static Map<String, CFMetaData> fetchTablesMetadata(String keyspace, Session session, IPartitioner partitioner) {
        HashMap<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "tables");
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("table_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, false, row, name));
        }
        return tables;
    }

    private static Map<String, CFMetaData> fetchViewMetadata(String keyspace, Session session, IPartitioner partitioner) {
        HashMap<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "views");
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("view_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, true, row, name));
        }
        return tables;
    }

    private static CFMetaData createTableMetadata(String keyspace, Session session, IPartitioner partitioner, boolean isView, Row row, String name) {
        UUID id = row.getUUID("id");
        Set flags = row.isNull("flags") ? Collections.emptySet() : CFMetaData.flagsFromStrings(row.getSet("flags", String.class));
        boolean isSuper = flags.contains((Object)CFMetaData.Flag.SUPER);
        boolean isCounter = flags.contains((Object)CFMetaData.Flag.COUNTER);
        boolean isDense = flags.contains((Object)CFMetaData.Flag.DENSE);
        boolean isCompound = flags.contains((Object)CFMetaData.Flag.COMPOUND);
        String columnsQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", "columns");
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>();
        for (Row colRow : session.execute(columnsQuery, new Object[]{keyspace, name})) {
            defs.add(NativeSSTableLoaderClient.createDefinitionFromRow(colRow, keyspace, name));
        }
        return CFMetaData.create(keyspace, name, id, isDense, isCompound, isSuper, isCounter, isView, defs, partitioner);
    }

    private static ColumnDefinition createDefinitionFromRow(Row row, String keyspace, String table) {
        ColumnIdentifier name = ColumnIdentifier.getInterned(row.getBytes("column_name_bytes"), row.getString("column_name"));
        AbstractType<?> type = TypeParser.parse(row.getString("type"));
        int position = row.getInt("position");
        ColumnDefinition.Kind kind = ColumnDefinition.Kind.valueOf(row.getString("kind").toUpperCase());
        return new ColumnDefinition(keyspace, table, name, type, position, kind);
    }
}

