/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class RowFilter
implements Iterable<Expression> {
    public static final Serializer serializer = new Serializer();
    public static final RowFilter NONE = new CQLFilter(Collections.emptyList());
    protected final List<Expression> expressions;

    protected RowFilter(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public static RowFilter create() {
        return new CQLFilter(new ArrayList());
    }

    public static RowFilter create(int capacity) {
        return new CQLFilter(new ArrayList(capacity));
    }

    public static RowFilter forThrift(int capacity) {
        return new ThriftFilter(new ArrayList(capacity));
    }

    public void add(ColumnDefinition def, Operator op, ByteBuffer value) {
        this.add(new SimpleExpression(def, op, value));
    }

    public void addMapEquality(ColumnDefinition def, ByteBuffer key, Operator op, ByteBuffer value) {
        this.add(new MapEqualityExpression(def, key, op, value));
    }

    public void addThriftExpression(CFMetaData metadata, ByteBuffer name, Operator op, ByteBuffer value) {
        assert (this instanceof ThriftFilter);
        this.add(new ThriftExpression(metadata, name, op, value));
    }

    public void addCustomIndexExpression(CFMetaData cfm, IndexMetadata targetIndex, ByteBuffer value) {
        this.add(new CustomExpression(cfm, targetIndex, value));
    }

    private void add(Expression expression) {
        expression.validate();
        this.expressions.add(expression);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public boolean hasExpressionOnClusteringOrRegularColumns() {
        for (Expression expression : this.expressions) {
            ColumnDefinition column = expression.column();
            if (!column.isClusteringColumn() && !column.isRegular()) continue;
            return true;
        }
        return false;
    }

    public abstract UnfilteredPartitionIterator filter(UnfilteredPartitionIterator var1, int var2);

    public boolean isSatisfiedBy(CFMetaData metadata, DecoratedKey partitionKey, Row row, int nowInSec) {
        Row purged = row.purge(DeletionPurger.PURGE_ALL, nowInSec, metadata.enforceStrictLiveness());
        if (purged == null) {
            return this.expressions.isEmpty();
        }
        for (Expression e : this.expressions) {
            if (e.isSatisfiedBy(metadata, partitionKey, purged)) continue;
            return false;
        }
        return true;
    }

    public boolean partitionKeyRestrictionsAreSatisfiedBy(DecoratedKey key, AbstractType<?> keyValidator) {
        for (Expression e : this.expressions) {
            ByteBuffer value;
            if (!e.column.isPartitionKey()) continue;
            ByteBuffer byteBuffer = value = keyValidator instanceof CompositeType ? ((CompositeType)keyValidator).split(key.getKey())[e.column.position()] : key.getKey();
            if (e.operator().isSatisfiedBy(e.column.type, value, e.value)) continue;
            return false;
        }
        return true;
    }

    public boolean clusteringKeyRestrictionsAreSatisfiedBy(Clustering clustering) {
        for (Expression e : this.expressions) {
            if (!e.column.isClusteringColumn() || e.operator().isSatisfiedBy(e.column.type, clustering.get(e.column.position()), e.value)) continue;
            return false;
        }
        return true;
    }

    public RowFilter without(Expression expression) {
        assert (this.expressions.contains(expression));
        if (this.expressions.size() == 1) {
            return NONE;
        }
        ArrayList<Expression> newExpressions = new ArrayList<Expression>(this.expressions.size() - 1);
        for (Expression e : this.expressions) {
            if (e.equals(expression)) continue;
            newExpressions.add(e);
        }
        return this.withNewExpressions(newExpressions);
    }

    protected abstract RowFilter withNewExpressions(List<Expression> var1);

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    public Iterator<Expression> iterator() {
        return this.expressions.iterator();
    }

    private static Clustering makeCompactClustering(CFMetaData metadata, ByteBuffer name) {
        assert (metadata.isCompactTable());
        if (metadata.isCompound()) {
            List<ByteBuffer> values = CompositeType.splitName(name);
            return new Clustering(values.toArray(new ByteBuffer[metadata.comparator.size()]));
        }
        return new Clustering(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.expressions.size(); ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(this.expressions.get(i));
        }
        return sb.toString();
    }

    public static class Serializer {
        public void serialize(RowFilter filter, DataOutputPlus out, int version) throws IOException {
            out.writeBoolean(filter instanceof ThriftFilter);
            out.writeUnsignedVInt(filter.expressions.size());
            for (Expression expr : filter.expressions) {
                Expression.serializer.serialize(expr, out, version);
            }
        }

        public RowFilter deserialize(DataInputPlus in, int version, CFMetaData metadata) throws IOException {
            boolean forThrift = in.readBoolean();
            int size = (int)in.readUnsignedVInt();
            ArrayList<Expression> expressions = new ArrayList<Expression>(size);
            for (int i = 0; i < size; ++i) {
                expressions.add(Expression.serializer.deserialize(in, version, metadata));
            }
            return forThrift ? new ThriftFilter(expressions) : new CQLFilter(expressions);
        }

        public long serializedSize(RowFilter filter, int version) {
            long size = 1 + TypeSizes.sizeofUnsignedVInt(filter.expressions.size());
            for (Expression expr : filter.expressions) {
                size += Expression.serializer.serializedSize(expr, version);
            }
            return size;
        }
    }

    public static final class CustomExpression
    extends Expression {
        private final IndexMetadata targetIndex;
        private final CFMetaData cfm;

        public CustomExpression(CFMetaData cfm, IndexMetadata targetIndex, ByteBuffer value) {
            super(CustomExpression.makeDefinition(cfm, targetIndex), Operator.EQ, value);
            this.targetIndex = targetIndex;
            this.cfm = cfm;
        }

        private static ColumnDefinition makeDefinition(CFMetaData cfm, IndexMetadata index) {
            return ColumnDefinition.regularDef(cfm, ByteBuffer.wrap(index.name.getBytes()), BytesType.instance);
        }

        public IndexMetadata getTargetIndex() {
            return this.targetIndex;
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("expr(%s, %s)", this.targetIndex.name, Keyspace.openAndGetStore((CFMetaData)this.cfm).indexManager.getIndex(this.targetIndex).customExpressionValueType());
        }

        @Override
        Expression.Kind kind() {
            return Expression.Kind.CUSTOM;
        }

        @Override
        public boolean isSatisfiedBy(CFMetaData metadata, DecoratedKey partitionKey, Row row) {
            return true;
        }
    }

    private static class ThriftExpression
    extends Expression {
        public ThriftExpression(CFMetaData metadata, ByteBuffer name, Operator operator, ByteBuffer value) {
            super(ThriftExpression.makeDefinition(metadata, name), operator, value);
            assert (metadata.isCompactTable());
        }

        private static ColumnDefinition makeDefinition(CFMetaData metadata, ByteBuffer name) {
            ColumnDefinition def = metadata.getColumnDefinition(name);
            if (def != null) {
                return def;
            }
            return ColumnDefinition.regularDef(metadata, name, metadata.compactValueColumn().type);
        }

        @Override
        public boolean isSatisfiedBy(CFMetaData metadata, DecoratedKey partitionKey, Row row) {
            assert (this.value != null);
            assert (row.clustering().equals(RowFilter.makeCompactClustering(metadata, this.column.name.bytes)));
            Cell cell = row.getCell(metadata.compactValueColumn());
            return cell != null && this.operator.isSatisfiedBy(this.column.type, cell.value(), this.value);
        }

        public String toString() {
            return String.format("%s %s %s", new Object[]{this.column.name, this.operator, this.column.type.getString(this.value)});
        }

        @Override
        Expression.Kind kind() {
            return Expression.Kind.THRIFT_DYN_EXPR;
        }
    }

    private static class MapEqualityExpression
    extends Expression {
        private final ByteBuffer key;

        public MapEqualityExpression(ColumnDefinition column, ByteBuffer key, Operator operator, ByteBuffer value) {
            super(column, operator, value);
            assert (column.type instanceof MapType && operator == Operator.EQ);
            this.key = key;
        }

        @Override
        public void validate() throws InvalidRequestException {
            RequestValidations.checkNotNull(this.key, "Unsupported null map key for column %s", this.column.name);
            RequestValidations.checkBindValueSet(this.key, "Unsupported unset map key for column %s", this.column.name);
            RequestValidations.checkNotNull(this.value, "Unsupported null map value for column %s", this.column.name);
            RequestValidations.checkBindValueSet(this.value, "Unsupported unset map value for column %s", this.column.name);
        }

        @Override
        public ByteBuffer getIndexValue() {
            return CompositeType.build(this.key, this.value);
        }

        @Override
        public boolean isSatisfiedBy(CFMetaData metadata, DecoratedKey partitionKey, Row row) {
            assert (this.key != null);
            assert (this.value != null);
            if (row.isStatic() != this.column.isStatic()) {
                return true;
            }
            MapType mt = (MapType)this.column.type;
            if (this.column.isComplex()) {
                Cell cell = row.getCell(this.column, CellPath.create(this.key));
                return cell != null && mt.valueComparator().compare(cell.value(), this.value) == 0;
            }
            ByteBuffer serializedMap = this.getValue(metadata, partitionKey, row);
            if (serializedMap == null) {
                return false;
            }
            ByteBuffer foundValue = ((MapSerializer)mt.getSerializer()).getSerializedValue(serializedMap, this.key, mt.getKeysType());
            return foundValue != null && mt.valueComparator().compare(foundValue, this.value) == 0;
        }

        public String toString() {
            MapType mt = (MapType)this.column.type;
            return String.format("%s[%s] = %s", this.column.name, mt.nameComparator().getString(this.key), mt.valueComparator().getString(this.value));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapEqualityExpression)) {
                return false;
            }
            MapEqualityExpression that = (MapEqualityExpression)o;
            return Objects.equal((Object)this.column.name, (Object)that.column.name) && Objects.equal((Object)((Object)this.operator), (Object)((Object)that.operator)) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.value, (Object)that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column.name, this.operator, this.key, this.value});
        }

        @Override
        Expression.Kind kind() {
            return Expression.Kind.MAP_EQUALITY;
        }
    }

    private static class SimpleExpression
    extends Expression {
        public SimpleExpression(ColumnDefinition column, Operator operator, ByteBuffer value) {
            super(column, operator, value);
        }

        @Override
        public boolean isSatisfiedBy(CFMetaData metadata, DecoratedKey partitionKey, Row row) {
            assert (this.value != null);
            if (row.isStatic() != this.column.isStatic()) {
                return true;
            }
            switch (this.operator) {
                case EQ: 
                case LT: 
                case LTE: 
                case GTE: 
                case GT: {
                    assert (!this.column.isComplex()) : "Only CONTAINS and CONTAINS_KEY are supported for 'complex' types";
                    if (this.column.type.isCounter()) {
                        ByteBuffer foundValue = this.getValue(metadata, partitionKey, row);
                        if (foundValue == null) {
                            return false;
                        }
                        ByteBuffer counterValue = LongType.instance.decompose(CounterContext.instance().total(foundValue));
                        return this.operator.isSatisfiedBy(LongType.instance, counterValue, this.value);
                    }
                    ByteBuffer foundValue = this.getValue(metadata, partitionKey, row);
                    return foundValue != null && this.operator.isSatisfiedBy(this.column.type, foundValue, this.value);
                }
                case NEQ: {
                    assert (!this.column.isComplex()) : "Only CONTAINS and CONTAINS_KEY are supported for 'complex' types";
                    ByteBuffer foundValue = this.getValue(metadata, partitionKey, row);
                    return foundValue != null && this.operator.isSatisfiedBy(this.column.type, foundValue, this.value);
                }
                case CONTAINS: {
                    assert (this.column.type.isCollection());
                    CollectionType type = (CollectionType)this.column.type;
                    if (this.column.isComplex()) {
                        ComplexColumnData complexData = row.getComplexColumnData(this.column);
                        if (complexData != null) {
                            for (Cell cell : complexData) {
                                if (!(type.kind == CollectionType.Kind.SET ? type.nameComparator().compare(cell.path().get(0), this.value) == 0 : type.valueComparator().compare(cell.value(), this.value) == 0)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    ByteBuffer foundValue = this.getValue(metadata, partitionKey, row);
                    if (foundValue == null) {
                        return false;
                    }
                    switch (type.kind) {
                        case LIST: {
                            ListType listType = (ListType)type;
                            return ((List)listType.compose(foundValue)).contains(listType.getElementsType().compose(this.value));
                        }
                        case SET: {
                            SetType setType = (SetType)type;
                            return ((Set)setType.compose(foundValue)).contains(setType.getElementsType().compose(this.value));
                        }
                        case MAP: {
                            MapType mapType = (MapType)type;
                            return ((Map)mapType.compose(foundValue)).containsValue(mapType.getValuesType().compose(this.value));
                        }
                    }
                    throw new AssertionError();
                }
                case CONTAINS_KEY: {
                    assert (this.column.type.isCollection() && this.column.type instanceof MapType);
                    MapType mapType = (MapType)this.column.type;
                    if (this.column.isComplex()) {
                        return row.getCell(this.column, CellPath.create(this.value)) != null;
                    }
                    ByteBuffer foundValue = this.getValue(metadata, partitionKey, row);
                    return foundValue != null && ((MapSerializer)mapType.getSerializer()).getSerializedValue(foundValue, this.value, mapType.getKeysType()) != null;
                }
                case IN: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            AbstractType type = this.column.type;
            switch (this.operator) {
                case CONTAINS: {
                    assert (type instanceof CollectionType);
                    CollectionType ct = (CollectionType)type;
                    type = ct.kind == CollectionType.Kind.SET ? ct.nameComparator() : ct.valueComparator();
                    break;
                }
                case CONTAINS_KEY: {
                    assert (type instanceof MapType);
                    type = ((MapType)type).nameComparator();
                    break;
                }
                case IN: {
                    type = ListType.getInstance(type, false);
                    break;
                }
            }
            return String.format("%s %s %s", new Object[]{this.column.name, this.operator, type.getString(this.value)});
        }

        @Override
        Expression.Kind kind() {
            return Expression.Kind.SIMPLE;
        }
    }

    public static abstract class Expression {
        private static final Serializer serializer = new Serializer();
        protected final ColumnDefinition column;
        protected final Operator operator;
        protected final ByteBuffer value;

        abstract Kind kind();

        protected Expression(ColumnDefinition column, Operator operator, ByteBuffer value) {
            this.column = column;
            this.operator = operator;
            this.value = value;
        }

        public boolean isCustom() {
            return this.kind() == Kind.CUSTOM;
        }

        public ColumnDefinition column() {
            return this.column;
        }

        public Operator operator() {
            return this.operator;
        }

        public boolean isContains() {
            return Operator.CONTAINS == this.operator;
        }

        public boolean isContainsKey() {
            return Operator.CONTAINS_KEY == this.operator;
        }

        public ByteBuffer getIndexValue() {
            return this.value;
        }

        public void validate() {
            RequestValidations.checkNotNull(this.value, "Unsupported null value for column %s", this.column.name);
            RequestValidations.checkBindValueSet(this.value, "Unsupported unset value for column %s", this.column.name);
        }

        @Deprecated
        public void validateForIndexing() {
            RequestValidations.checkFalse(this.value.remaining() > 65535, "Index expression values may not be larger than 64K");
        }

        public abstract boolean isSatisfiedBy(CFMetaData var1, DecoratedKey var2, Row var3);

        protected ByteBuffer getValue(CFMetaData metadata, DecoratedKey partitionKey, Row row) {
            switch (this.column.kind) {
                case PARTITION_KEY: {
                    return metadata.getKeyValidator() instanceof CompositeType ? CompositeType.extractComponent(partitionKey.getKey(), this.column.position()) : partitionKey.getKey();
                }
                case CLUSTERING: {
                    return row.clustering().get(this.column.position());
                }
            }
            Cell cell = row.getCell(this.column);
            return cell == null ? null : cell.value();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Expression)) {
                return false;
            }
            Expression that = (Expression)o;
            return Objects.equal((Object)((Object)this.kind()), (Object)((Object)that.kind())) && Objects.equal((Object)this.column.name, (Object)that.column.name) && Objects.equal((Object)((Object)this.operator), (Object)((Object)that.operator)) && Objects.equal((Object)this.value, (Object)that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column.name, this.operator, this.value});
        }

        private static class Serializer {
            private Serializer() {
            }

            public void serialize(Expression expression, DataOutputPlus out, int version) throws IOException {
                if (version >= 10) {
                    out.writeByte(expression.kind().ordinal());
                }
                if (expression.kind() == Kind.CUSTOM) {
                    assert (version >= 10);
                    IndexMetadata.serializer.serialize(((CustomExpression)expression).targetIndex, out, version);
                    ByteBufferUtil.writeWithShortLength(expression.value, out);
                    return;
                }
                ByteBufferUtil.writeWithShortLength(expression.column.name.bytes, out);
                expression.operator.writeTo(out);
                switch (expression.kind()) {
                    case SIMPLE: {
                        ByteBufferUtil.writeWithShortLength(((SimpleExpression)expression).value, out);
                        break;
                    }
                    case MAP_EQUALITY: {
                        MapEqualityExpression mexpr = (MapEqualityExpression)expression;
                        if (version < 10) {
                            ByteBufferUtil.writeWithShortLength(mexpr.getIndexValue(), out);
                            break;
                        }
                        ByteBufferUtil.writeWithShortLength(mexpr.key, out);
                        ByteBufferUtil.writeWithShortLength(mexpr.value, out);
                        break;
                    }
                    case THRIFT_DYN_EXPR: {
                        ByteBufferUtil.writeWithShortLength(((ThriftExpression)expression).value, out);
                    }
                }
            }

            public Expression deserialize(DataInputPlus in, int version, CFMetaData metadata) throws IOException {
                Kind kind = null;
                if (version >= 10 && (kind = Kind.values()[in.readByte()]) == Kind.CUSTOM) {
                    return new CustomExpression(metadata, IndexMetadata.serializer.deserialize(in, version, metadata), ByteBufferUtil.readWithShortLength(in));
                }
                ByteBuffer name = ByteBufferUtil.readWithShortLength(in);
                Operator operator = Operator.readFrom(in);
                ColumnDefinition column = metadata.getColumnDefinition(name);
                if (!metadata.isCompactTable() && column == null) {
                    throw new RuntimeException("Unknown (or dropped) column " + UTF8Type.instance.getString(name) + " during deserialization");
                }
                if (version < 10) {
                    kind = column == null ? Kind.THRIFT_DYN_EXPR : (column.type instanceof MapType && operator == Operator.EQ ? Kind.MAP_EQUALITY : Kind.SIMPLE);
                }
                assert (kind != null);
                switch (kind) {
                    case SIMPLE: {
                        return new SimpleExpression(column, operator, ByteBufferUtil.readWithShortLength(in));
                    }
                    case MAP_EQUALITY: {
                        ByteBuffer value;
                        ByteBuffer key;
                        if (version < 10) {
                            ByteBuffer composite = ByteBufferUtil.readWithShortLength(in);
                            key = CompositeType.extractComponent(composite, 0);
                            value = CompositeType.extractComponent(composite, 0);
                        } else {
                            key = ByteBufferUtil.readWithShortLength(in);
                            value = ByteBufferUtil.readWithShortLength(in);
                        }
                        return new MapEqualityExpression(column, key, operator, value);
                    }
                    case THRIFT_DYN_EXPR: {
                        return new ThriftExpression(metadata, name, operator, ByteBufferUtil.readWithShortLength(in));
                    }
                }
                throw new AssertionError();
            }

            public long serializedSize(Expression expression, int version) {
                long size;
                long l = size = version >= 10 ? 1L : 0L;
                if (expression.kind() != Kind.CUSTOM) {
                    size += (long)(ByteBufferUtil.serializedSizeWithShortLength(expression.column().name.bytes) + expression.operator.serializedSize());
                }
                switch (expression.kind()) {
                    case SIMPLE: {
                        size += (long)ByteBufferUtil.serializedSizeWithShortLength(((SimpleExpression)expression).value);
                        break;
                    }
                    case MAP_EQUALITY: {
                        MapEqualityExpression mexpr = (MapEqualityExpression)expression;
                        if (version < 10) {
                            size += (long)ByteBufferUtil.serializedSizeWithShortLength(mexpr.getIndexValue());
                            break;
                        }
                        size += (long)(ByteBufferUtil.serializedSizeWithShortLength(mexpr.key) + ByteBufferUtil.serializedSizeWithShortLength(mexpr.value));
                        break;
                    }
                    case THRIFT_DYN_EXPR: {
                        size += (long)ByteBufferUtil.serializedSizeWithShortLength(((ThriftExpression)expression).value);
                        break;
                    }
                    case CUSTOM: {
                        if (version < 10) break;
                        size += IndexMetadata.serializer.serializedSize(((CustomExpression)expression).targetIndex, version) + (long)ByteBufferUtil.serializedSizeWithShortLength(expression.value);
                    }
                }
                return size;
            }
        }

        protected static enum Kind {
            SIMPLE,
            MAP_EQUALITY,
            THRIFT_DYN_EXPR,
            CUSTOM;

        }
    }

    private static class ThriftFilter
    extends RowFilter {
        private ThriftFilter(List<Expression> expressions) {
            super(expressions);
        }

        @Override
        public UnfilteredPartitionIterator filter(UnfilteredPartitionIterator iter, int nowInSec) {
            if (this.expressions.isEmpty()) {
                return iter;
            }
            class IsSatisfiedThriftFilter
            extends Transformation<UnfilteredRowIterator> {
                IsSatisfiedThriftFilter() {
                }

                @Override
                public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator iter) {
                    ImmutableBTreePartition result = ImmutableBTreePartition.create(iter);
                    iter.close();
                    for (Expression expr : ThriftFilter.this.expressions) {
                        assert (expr instanceof ThriftExpression);
                        Row row = result.getRow(RowFilter.makeCompactClustering(iter.metadata(), expr.column().name.bytes));
                        if (row != null && expr.isSatisfiedBy(iter.metadata(), iter.partitionKey(), row)) continue;
                        return null;
                    }
                    return result.unfilteredIterator();
                }
            }
            return Transformation.apply(iter, new IsSatisfiedThriftFilter());
        }

        @Override
        protected RowFilter withNewExpressions(List<Expression> expressions) {
            return new ThriftFilter(expressions);
        }
    }

    private static class CQLFilter
    extends RowFilter {
        private CQLFilter(List<Expression> expressions) {
            super(expressions);
        }

        @Override
        public UnfilteredPartitionIterator filter(UnfilteredPartitionIterator iter, final int nowInSec) {
            if (this.expressions.isEmpty()) {
                return iter;
            }
            final CFMetaData metadata = iter.metadata();
            long numberOfStaticColumnExpressions = this.expressions.stream().filter(e -> e.column.isStatic()).count();
            final boolean filterStaticColumns = numberOfStaticColumnExpressions != 0L;
            final boolean filterNonStaticColumns = (long)this.expressions.size() - numberOfStaticColumnExpressions > 0L;
            class IsSatisfiedFilter
            extends Transformation<UnfilteredRowIterator> {
                DecoratedKey pk;

                IsSatisfiedFilter() {
                }

                @Override
                public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
                    if (filterStaticColumns && this.applyToRow(partition.staticRow()) == null) {
                        return null;
                    }
                    this.pk = partition.partitionKey();
                    UnfilteredRowIterator iterator = Transformation.apply(partition, this);
                    return filterNonStaticColumns && !iterator.hasNext() ? null : iterator;
                }

                @Override
                public Row applyToRow(Row row) {
                    Row purged = row.purge(DeletionPurger.PURGE_ALL, nowInSec, metadata.enforceStrictLiveness());
                    if (purged == null) {
                        return null;
                    }
                    for (Expression e : CQLFilter.this.expressions) {
                        if (e.isSatisfiedBy(metadata, this.pk, purged)) continue;
                        return null;
                    }
                    return row;
                }
            }
            return Transformation.apply(iter, new IsSatisfiedFilter());
        }

        @Override
        protected RowFilter withNewExpressions(List<Expression> expressions) {
            return new CQLFilter(expressions);
        }
    }
}

