/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionResolver;
import org.apache.cassandra.cql3.functions.ToJsonFct;
import org.apache.cassandra.cql3.selection.AbstractFunctionSelector;
import org.apache.cassandra.cql3.selection.FieldSelector;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.cql3.selection.WritetimeOrTTLSelector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class Selectable {
    public abstract Selector.Factory newSelectorFactory(CFMetaData var1, List<ColumnDefinition> var2) throws InvalidRequestException;

    protected static int addAndGetIndex(ColumnDefinition def, List<ColumnDefinition> l) {
        int idx = l.indexOf(def);
        if (idx < 0) {
            idx = l.size();
            l.add(def);
        }
        return idx;
    }

    public static class WithFieldSelection
    extends Selectable {
        public final Selectable selected;
        public final ColumnIdentifier field;

        public WithFieldSelection(Selectable selected, ColumnIdentifier field) {
            this.selected = selected;
            this.field = field;
        }

        public String toString() {
            return String.format("%s.%s", this.selected, this.field);
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
            Selector.Factory factory = this.selected.newSelectorFactory(cfm, defs);
            AbstractType<?> type = factory.newInstance().getType();
            if (!(type instanceof UserType)) {
                throw new InvalidRequestException(String.format("Invalid field selection: %s of type %s is not a user type", this.selected, type.asCQL3Type()));
            }
            UserType ut = (UserType)type;
            for (int i = 0; i < ut.size(); ++i) {
                if (!ut.fieldName(i).equals(this.field.bytes)) continue;
                return FieldSelector.newFactory(ut, i, factory);
            }
            throw new InvalidRequestException(String.format("%s of type %s has no field %s", this.selected, type.asCQL3Type(), this.field));
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final org.apache.cassandra.cql3.selection.Selectable$Raw selected;
            private final ColumnIdentifier.Raw field;

            public Raw(org.apache.cassandra.cql3.selection.Selectable$Raw selected, ColumnIdentifier.Raw field) {
                this.selected = selected;
                this.field = field;
            }

            @Override
            public WithFieldSelection prepare(CFMetaData cfm) {
                return new WithFieldSelection(this.selected.prepare(cfm), this.field.prepare(cfm));
            }

            @Override
            public boolean processesSelection() {
                return true;
            }
        }
    }

    public static class WithFunction
    extends Selectable {
        public final FunctionName functionName;
        public final List<Selectable> args;

        public WithFunction(FunctionName functionName, List<Selectable> args) {
            this.functionName = functionName;
            this.args = args;
        }

        public String toString() {
            return new StrBuilder().append((Object)this.functionName).append("(").appendWithSeparators(this.args, ", ").append(")").toString();
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.args, cfm, defs);
            Function fun = this.functionName.equalsNativeFunction(ToJsonFct.NAME) ? ToJsonFct.getInstance(factories.getReturnTypes()) : FunctionResolver.get(cfm.ksName, this.functionName, factories.newInstances(), cfm.ksName, cfm.cfName, null);
            if (fun == null) {
                throw new InvalidRequestException(String.format("Unknown function '%s'", this.functionName));
            }
            if (fun.returnType() == null) {
                throw new InvalidRequestException(String.format("Unknown function %s called in selection clause", this.functionName));
            }
            return AbstractFunctionSelector.newFactory(fun, factories);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final FunctionName functionName;
            private final List<org.apache.cassandra.cql3.selection.Selectable$Raw> args;

            public Raw(FunctionName functionName, List<org.apache.cassandra.cql3.selection.Selectable$Raw> args) {
                this.functionName = functionName;
                this.args = args;
            }

            @Override
            public WithFunction prepare(CFMetaData cfm) {
                ArrayList<Selectable> preparedArgs = new ArrayList<Selectable>(this.args.size());
                for (org.apache.cassandra.cql3.selection.Selectable$Raw arg : this.args) {
                    preparedArgs.add(arg.prepare(cfm));
                }
                return new WithFunction(this.functionName, preparedArgs);
            }

            @Override
            public boolean processesSelection() {
                return true;
            }
        }
    }

    public static class WritetimeOrTTL
    extends Selectable {
        public final ColumnIdentifier id;
        public final boolean isWritetime;

        public WritetimeOrTTL(ColumnIdentifier id, boolean isWritetime) {
            this.id = id;
            this.isWritetime = isWritetime;
        }

        public String toString() {
            return (this.isWritetime ? "writetime" : "ttl") + "(" + this.id + ")";
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
            ColumnDefinition def = cfm.getColumnDefinitionForCQL(this.id);
            if (def == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", this.id));
            }
            if (def.isPrimaryKeyColumn()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on PRIMARY KEY part %s", this.isWritetime ? "writeTime" : "ttl", def.name));
            }
            if (def.type.isCollection()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on collections", this.isWritetime ? "writeTime" : "ttl"));
            }
            return WritetimeOrTTLSelector.newFactory(def, WritetimeOrTTL.addAndGetIndex(def, defs), this.isWritetime);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final ColumnIdentifier.Raw id;
            private final boolean isWritetime;

            public Raw(ColumnIdentifier.Raw id, boolean isWritetime) {
                this.id = id;
                this.isWritetime = isWritetime;
            }

            @Override
            public WritetimeOrTTL prepare(CFMetaData cfm) {
                return new WritetimeOrTTL(this.id.prepare(cfm), this.isWritetime);
            }

            @Override
            public boolean processesSelection() {
                return true;
            }
        }
    }

    public static interface Raw {
        public Selectable prepare(CFMetaData var1);

        public boolean processesSelection();
    }
}

