/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.ArrivalWindow;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureDetector
implements IFailureDetector,
FailureDetectorMBean {
    private static final Logger logger = LoggerFactory.getLogger(FailureDetector.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=FailureDetector";
    private static final int SAMPLE_SIZE = 1000;
    protected static final long INITIAL_VALUE_NANOS = TimeUnit.NANOSECONDS.convert(FailureDetector.getInitialValue(), TimeUnit.MILLISECONDS);
    private static final int DEBUG_PERCENTAGE = 80;
    private static final long DEFAULT_MAX_PAUSE = 5000000000L;
    private static final long MAX_LOCAL_PAUSE_IN_NANOS = FailureDetector.getMaxLocalPause();
    private long lastInterpret = Clock.instance.nanoTime();
    private long lastPause = 0L;
    public static final IFailureDetector instance = new FailureDetector();
    private final double PHI_FACTOR = 1.0 / Math.log(10.0);
    private final ConcurrentHashMap<InetAddress, ArrivalWindow> arrivalSamples = new ConcurrentHashMap();
    private final List<IFailureDetectionEventListener> fdEvntListeners = new CopyOnWriteArrayList<IFailureDetectionEventListener>();

    private static long getMaxLocalPause() {
        if (System.getProperty("cassandra.max_local_pause_in_ms") != null) {
            long pause = Long.parseLong(System.getProperty("cassandra.max_local_pause_in_ms"));
            logger.warn("Overriding max local pause time to {}ms", (Object)pause);
            return pause * 1000000L;
        }
        return 5000000000L;
    }

    public FailureDetector() {
        MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
    }

    private static long getInitialValue() {
        String newvalue = System.getProperty("cassandra.fd_initial_value_ms");
        if (newvalue == null) {
            return 2000L;
        }
        logger.info("Overriding FD INITIAL_VALUE to {}ms", (Object)newvalue);
        return Integer.parseInt(newvalue);
    }

    @Override
    public String getAllEndpointStates() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            sb.append(entry.getKey()).append("\n");
            this.appendEndpointState(sb, (EndpointState)entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> getSimpleStates() {
        HashMap<String, String> nodesStatus = new HashMap<String, String>(Gossiper.instance.endpointStateMap.size());
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            if (((EndpointState)entry.getValue()).isAlive()) {
                nodesStatus.put(((InetAddress)entry.getKey()).toString(), "UP");
                continue;
            }
            nodesStatus.put(((InetAddress)entry.getKey()).toString(), "DOWN");
        }
        return nodesStatus;
    }

    @Override
    public int getDownEndpointCount() {
        int count = 0;
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            if (((EndpointState)entry.getValue()).isAlive()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getUpEndpointCount() {
        int count = 0;
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            if (!((EndpointState)entry.getValue()).isAlive()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public TabularData getPhiValues() throws OpenDataException {
        CompositeType ct = new CompositeType("Node", "Node", new String[]{"Endpoint", "PHI"}, new String[]{"IP of the endpoint", "PHI value"}, new OpenType[]{SimpleType.STRING, SimpleType.DOUBLE});
        TabularDataSupport results = new TabularDataSupport(new TabularType("PhiList", "PhiList", ct, new String[]{"Endpoint"}));
        for (Map.Entry<InetAddress, ArrivalWindow> entry : this.arrivalSamples.entrySet()) {
            double phi;
            ArrivalWindow window = entry.getValue();
            if (!(window.mean() > 0.0) || (phi = window.getLastReportedPhi()) == Double.MIN_VALUE) continue;
            CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"Endpoint", "PHI"}, new Object[]{entry.getKey().toString(), phi * this.PHI_FACTOR});
            results.put(data);
        }
        return results;
    }

    @Override
    public String getEndpointState(String address) throws UnknownHostException {
        StringBuilder sb = new StringBuilder();
        EndpointState endpointState = Gossiper.instance.getEndpointStateForEndpoint(InetAddress.getByName(address));
        this.appendEndpointState(sb, endpointState);
        return sb.toString();
    }

    private void appendEndpointState(StringBuilder sb, EndpointState endpointState) {
        sb.append("  generation:").append(endpointState.getHeartBeatState().getGeneration()).append("\n");
        sb.append("  heartbeat:").append(endpointState.getHeartBeatState().getHeartBeatVersion()).append("\n");
        for (Map.Entry<ApplicationState, VersionedValue> state : endpointState.states()) {
            if (state.getKey() == ApplicationState.TOKENS) continue;
            sb.append("  ").append((Object)state.getKey()).append(":").append(state.getValue().version).append(":").append(state.getValue().value).append("\n");
        }
        VersionedValue tokens = endpointState.getApplicationState(ApplicationState.TOKENS);
        if (tokens != null) {
            sb.append("  TOKENS:").append(tokens.version).append(":<hidden>\n");
        } else {
            sb.append("  TOKENS: not present\n");
        }
    }

    @Override
    public void dumpInterArrivalTimes() {
        File file = FileUtils.createTempFile("failuredetector-", ".dat");
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, true));){
            ((OutputStream)os).write(this.toString().getBytes());
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, file);
        }
    }

    @Override
    public void setPhiConvictThreshold(double phi) {
        DatabaseDescriptor.setPhiConvictThreshold(phi);
    }

    @Override
    public double getPhiConvictThreshold() {
        return DatabaseDescriptor.getPhiConvictThreshold();
    }

    @Override
    public boolean isAlive(InetAddress ep) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            return true;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(ep);
        if (epState == null) {
            logger.error("unknown endpoint {}", (Object)ep);
        }
        return epState != null && epState.isAlive();
    }

    @Override
    public void report(InetAddress ep) {
        long now = Clock.instance.nanoTime();
        ArrivalWindow heartbeatWindow = this.arrivalSamples.get(ep);
        if (heartbeatWindow == null) {
            heartbeatWindow = new ArrivalWindow(1000);
            heartbeatWindow.add(now, ep);
            heartbeatWindow = this.arrivalSamples.putIfAbsent(ep, heartbeatWindow);
            if (heartbeatWindow != null) {
                heartbeatWindow.add(now, ep);
            }
        } else {
            heartbeatWindow.add(now, ep);
        }
        if (logger.isTraceEnabled() && heartbeatWindow != null) {
            logger.trace("Average for {} is {}", (Object)ep, (Object)heartbeatWindow.mean());
        }
    }

    @Override
    public void interpret(InetAddress ep) {
        ArrivalWindow hbWnd = this.arrivalSamples.get(ep);
        if (hbWnd == null) {
            return;
        }
        long now = Clock.instance.nanoTime();
        long diff = now - this.lastInterpret;
        this.lastInterpret = now;
        if (diff > MAX_LOCAL_PAUSE_IN_NANOS) {
            logger.warn("Not marking nodes down due to local pause of {} > {}", (Object)diff, (Object)MAX_LOCAL_PAUSE_IN_NANOS);
            this.lastPause = now;
            return;
        }
        if (Clock.instance.nanoTime() - this.lastPause < MAX_LOCAL_PAUSE_IN_NANOS) {
            logger.debug("Still not marking nodes down due to local pause");
            return;
        }
        double phi = hbWnd.phi(now);
        if (logger.isTraceEnabled()) {
            logger.trace("PHI for {} : {}", (Object)ep, (Object)phi);
        }
        if (this.PHI_FACTOR * phi > this.getPhiConvictThreshold()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Node {} phi {} > {}; intervals: {} mean: {}", new Object[]{ep, this.PHI_FACTOR * phi, this.getPhiConvictThreshold(), hbWnd, hbWnd.mean()});
            }
            for (IFailureDetectionEventListener listener : this.fdEvntListeners) {
                listener.convict(ep, phi);
            }
        } else if (logger.isDebugEnabled() && this.PHI_FACTOR * phi * 80.0 / 100.0 > this.getPhiConvictThreshold()) {
            logger.debug("PHI for {} : {}", (Object)ep, (Object)phi);
        } else if (logger.isTraceEnabled()) {
            logger.trace("PHI for {} : {}", (Object)ep, (Object)phi);
            logger.trace("mean for {} : {}", (Object)ep, (Object)hbWnd.mean());
        }
    }

    @Override
    public void forceConviction(InetAddress ep) {
        logger.debug("Forcing conviction of {}", (Object)ep);
        for (IFailureDetectionEventListener listener : this.fdEvntListeners) {
            listener.convict(ep, this.getPhiConvictThreshold());
        }
    }

    @Override
    public void remove(InetAddress ep) {
        this.arrivalSamples.remove(ep);
    }

    @Override
    public void registerFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners.add(listener);
    }

    @Override
    public void unregisterFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners.remove(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set eps = this.arrivalSamples.keySet();
        sb.append("-----------------------------------------------------------------------");
        for (InetAddress ep : eps) {
            ArrivalWindow hWnd = this.arrivalSamples.get(ep);
            sb.append(ep + " : ");
            sb.append(hWnd);
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("-----------------------------------------------------------------------");
        return sb.toString();
    }
}

