/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.concurrent.Transactional;

public abstract class SSTableWriter
extends SSTable
implements Transactional {
    protected long repairedAt;
    protected long maxDataAge = -1L;
    protected final long keyCount;
    protected final MetadataCollector metadataCollector;
    protected final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    protected final SerializationHeader header;
    protected final TransactionalProxy txnProxy = this.txnProxy();

    protected abstract TransactionalProxy txnProxy();

    protected SSTableWriter(Descriptor descriptor, long keyCount, long repairedAt, CFMetaData metadata, MetadataCollector metadataCollector, SerializationHeader header) {
        super(descriptor, SSTableWriter.components(metadata), metadata);
        this.keyCount = keyCount;
        this.repairedAt = repairedAt;
        this.metadataCollector = metadataCollector;
        this.header = header != null ? header : SerializationHeader.makeWithoutStats(metadata);
        this.rowIndexEntrySerializer = descriptor.version.getSSTableFormat().getIndexSerializer(metadata, descriptor.version, header);
    }

    public static SSTableWriter create(Descriptor descriptor, Long keyCount, Long repairedAt, CFMetaData metadata, MetadataCollector metadataCollector, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        Factory writerFactory = descriptor.getFormat().getWriterFactory();
        return writerFactory.open(descriptor, keyCount, repairedAt, metadata, metadataCollector, header, lifecycleNewTracker);
    }

    public static SSTableWriter create(Descriptor descriptor, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        CFMetaData metadata = Schema.instance.getCFMetaData(descriptor);
        return SSTableWriter.create(metadata, descriptor, keyCount, repairedAt, sstableLevel, header, lifecycleNewTracker);
    }

    public static SSTableWriter create(CFMetaData metadata, Descriptor descriptor, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        MetadataCollector collector = new MetadataCollector(metadata.comparator).sstableLevel(sstableLevel);
        return SSTableWriter.create(descriptor, keyCount, (Long)repairedAt, metadata, collector, header, lifecycleNewTracker);
    }

    public static SSTableWriter create(String filename, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        return SSTableWriter.create(Descriptor.fromFilename(filename), keyCount, repairedAt, sstableLevel, header, lifecycleNewTracker);
    }

    @VisibleForTesting
    public static SSTableWriter create(String filename, long keyCount, long repairedAt, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        return SSTableWriter.create(Descriptor.fromFilename(filename), keyCount, repairedAt, 0, header, lifecycleNewTracker);
    }

    private static Set<Component> components(CFMetaData metadata) {
        HashSet<Component> components = new HashSet<Component>(Arrays.asList(Component.DATA, Component.PRIMARY_INDEX, Component.STATS, Component.SUMMARY, Component.TOC, Component.digestFor(BigFormat.latestVersion.uncompressedChecksumType())));
        if (metadata.params.bloomFilterFpChance < 1.0) {
            components.add(Component.FILTER);
        }
        if (metadata.params.compression.isEnabled()) {
            components.add(Component.COMPRESSION_INFO);
        } else {
            components.add(Component.CRC);
        }
        return components;
    }

    public abstract void mark();

    public abstract RowIndexEntry append(UnfilteredRowIterator var1);

    public abstract long getFilePointer();

    public abstract long getOnDiskFilePointer();

    public abstract void resetAndTruncate();

    public SSTableWriter setRepairedAt(long repairedAt) {
        if (repairedAt > 0L) {
            this.repairedAt = repairedAt;
        }
        return this;
    }

    public SSTableWriter setMaxDataAge(long maxDataAge) {
        this.maxDataAge = maxDataAge;
        return this;
    }

    public SSTableWriter setOpenResult(boolean openResult) {
        this.txnProxy.openResult = openResult;
        return this;
    }

    public abstract SSTableReader openEarly();

    public abstract SSTableReader openFinalEarly();

    public SSTableReader finish(long repairedAt, long maxDataAge, boolean openResult) {
        if (repairedAt > 0L) {
            this.repairedAt = repairedAt;
        }
        this.maxDataAge = maxDataAge;
        return this.finish(openResult);
    }

    public SSTableReader finish(boolean openResult) {
        this.setOpenResult(openResult);
        this.txnProxy.finish();
        return this.finished();
    }

    public SSTableReader finished() {
        return this.txnProxy.finalReader;
    }

    @Override
    public final void prepareToCommit() {
        this.txnProxy.prepareToCommit();
    }

    @Override
    public final Throwable commit(Throwable accumulate) {
        return this.txnProxy.commit(accumulate);
    }

    @Override
    public final Throwable abort(Throwable accumulate) {
        return this.txnProxy.abort(accumulate);
    }

    @Override
    public final void close() {
        this.txnProxy.close();
    }

    public final void abort() {
        this.txnProxy.abort();
    }

    protected Map<MetadataType, MetadataComponent> finalizeMetadata() {
        return this.metadataCollector.finalizeMetadata(this.getPartitioner().getClass().getCanonicalName(), this.metadata.params.bloomFilterFpChance, this.repairedAt, this.header);
    }

    protected StatsMetadata statsMetadata() {
        return (StatsMetadata)this.finalizeMetadata().get((Object)MetadataType.STATS);
    }

    public static void rename(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, (Set)Sets.newHashSet((Object[])new Component[]{Component.DATA, Component.SUMMARY}))) {
            FileUtils.renameWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.renameWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.renameWithOutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public static abstract class Factory {
        public abstract SSTableWriter open(Descriptor var1, long var2, long var4, CFMetaData var6, MetadataCollector var7, SerializationHeader var8, LifecycleNewTracker var9);
    }

    protected abstract class TransactionalProxy
    extends Transactional.AbstractTransactional {
        protected SSTableReader finalReader;
        protected boolean openResult;

        protected TransactionalProxy() {
        }
    }
}

