/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="listsnapshots", description="Lists all the snapshots along with the size on disk and true size.")
public class ListSnapshots
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        try {
            out.println("Snapshot Details: ");
            Map<String, TabularData> snapshotDetails = probe.getSnapshotDetails();
            if (snapshotDetails.isEmpty()) {
                out.println("There are no snapshots");
                return;
            }
            long trueSnapshotsSize = probe.trueSnapshotsSize();
            String format = "%-40s %-29s %-29s %-19s %-19s%n";
            List<String> indexNames = snapshotDetails.entrySet().iterator().next().getValue().getTabularType().getIndexNames();
            out.printf("%-40s %-29s %-29s %-19s %-19s%n", indexNames.toArray(new String[indexNames.size()]));
            for (Map.Entry<String, TabularData> snapshotDetail : snapshotDetails.entrySet()) {
                Set<?> values = snapshotDetail.getValue().keySet();
                for (Object eachValue : values) {
                    List value = (List)eachValue;
                    out.printf("%-40s %-29s %-29s %-19s %-19s%n", value.toArray(new Object[value.size()]));
                }
            }
            out.println("\nTotal TrueDiskSpaceUsed: " + FileUtils.stringifyFileSize(trueSnapshotsSize) + "\n");
        }
        catch (Exception e) {
            throw new RuntimeException("Error during list snapshot", e);
        }
    }
}

