/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static volatile String globalPrefix;
    public final String id;
    private final int priority;
    private final ClassLoader contextClassLoader;
    private final ThreadGroup threadGroup;
    protected final AtomicInteger n = new AtomicInteger(1);

    public static void setGlobalPrefix(String prefix) {
        globalPrefix = prefix;
    }

    public NamedThreadFactory(String id) {
        this(id, 5);
    }

    public NamedThreadFactory(String id, int priority) {
        this(id, priority, null, null);
    }

    public NamedThreadFactory(String id, int priority, ClassLoader contextClassLoader, ThreadGroup threadGroup) {
        this.id = id;
        this.priority = priority;
        this.contextClassLoader = contextClassLoader;
        this.threadGroup = threadGroup;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.id + ':' + this.n.getAndIncrement();
        String prefix = globalPrefix;
        FastThreadLocalThread thread = new FastThreadLocalThread(this.threadGroup, NamedThreadFactory.threadLocalDeallocator(runnable), prefix != null ? prefix + name : name);
        thread.setPriority(this.priority);
        thread.setDaemon(true);
        if (this.contextClassLoader != null) {
            thread.setContextClassLoader(this.contextClassLoader);
        }
        return thread;
    }

    public static Runnable threadLocalDeallocator(Runnable r) {
        return () -> {
            try {
                r.run();
            }
            finally {
                FastThreadLocal.removeAll();
            }
        };
    }
}

