/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.utils.UUIDGen;

public class SecondaryIndexBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore cfs;
    private final Set<Index> indexers;
    private final ReducingKeyIterator iter;
    private final UUID compactionId;

    public SecondaryIndexBuilder(ColumnFamilyStore cfs, Set<Index> indexers, ReducingKeyIterator iter) {
        this.cfs = cfs;
        this.indexers = indexers;
        this.iter = iter;
        this.compactionId = UUIDGen.getTimeUUID();
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.cfs.metadata, OperationType.INDEX_BUILD, this.iter.getBytesRead(), this.iter.getTotalBytes(), this.compactionId);
    }

    public void build() {
        try {
            int pageSize = this.cfs.indexManager.calculateIndexingPageSize();
            while (this.iter.hasNext()) {
                if (this.isStopRequested()) {
                    throw new CompactionInterruptedException(this.getCompactionInfo());
                }
                DecoratedKey key = this.iter.next();
                this.cfs.indexManager.indexPartition(key, this.indexers, pageSize);
            }
        }
        finally {
            this.iter.close();
        }
    }

    @Override
    public boolean isGlobal() {
        return false;
    }
}

