/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import java.io.PrintStream;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="proxyhistograms", description="Print statistic histograms for network operations")
public class ProxyHistograms
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        String[] percentiles = new String[]{"50%", "75%", "95%", "98%", "99%", "Min", "Max"};
        double[] readLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("Read"));
        double[] writeLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("Write"));
        double[] rangeLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("RangeSlice"));
        PrintStream out = probe.output().out;
        out.println("proxy histograms");
        out.println(String.format("%-10s%18s%18s%18s", "Percentile", "Read Latency", "Write Latency", "Range Latency"));
        out.println(String.format("%-10s%18s%18s%18s", "", "(micros)", "(micros)", "(micros)"));
        for (int i = 0; i < percentiles.length; ++i) {
            out.println(String.format("%-10s%18.2f%18.2f%18.2f", percentiles[i], readLatency[i], writeLatency[i], rangeLatency[i]));
        }
        out.println();
    }
}

