/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.PriorityQueue;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocator;

class ReplicationAwareTokenAllocator<Unit>
implements TokenAllocator<Unit> {
    final NavigableMap<Token, Unit> sortedTokens;
    final Multimap<Unit, Token> unitToTokens;
    final ReplicationStrategy<Unit> strategy;
    final IPartitioner partitioner;
    final int replicas;

    ReplicationAwareTokenAllocator(NavigableMap<Token, Unit> sortedTokens, ReplicationStrategy<Unit> strategy, IPartitioner partitioner) {
        this.sortedTokens = sortedTokens;
        this.unitToTokens = HashMultimap.create();
        for (Map.Entry en : sortedTokens.entrySet()) {
            this.unitToTokens.put(en.getValue(), en.getKey());
        }
        this.strategy = strategy;
        this.replicas = strategy.replicas();
        this.partitioner = partitioner;
    }

    @Override
    public Collection<Token> addUnit(Unit newUnit, int numTokens) {
        assert (!this.unitToTokens.containsKey(newUnit));
        if (this.unitCount() < this.replicas) {
            return this.generateRandomTokens(newUnit, numTokens);
        }
        if (numTokens > this.sortedTokens.size()) {
            return this.generateRandomTokens(newUnit, numTokens);
        }
        double optTokenOwnership = this.optimalTokenOwnership(numTokens);
        HashMap groups = Maps.newHashMap();
        Map<Unit, UnitInfo<Unit>> unitInfos = this.createUnitInfos(groups);
        if (groups.size() < this.replicas) {
            return this.generateRandomTokens(newUnit, numTokens);
        }
        UnitInfo<Unit> newUnitInfo = new UnitInfo<Unit>(newUnit, (double)numTokens * optTokenOwnership, groups, this.strategy);
        TokenInfo<Unit> tokens = this.createTokenInfos(unitInfos, newUnitInfo.group);
        newUnitInfo.tokenCount = numTokens;
        CandidateInfo candidates = this.createCandidates(tokens, newUnitInfo, optTokenOwnership);
        PriorityQueue<Weighted<CandidateInfo<Unit>>> improvements = new PriorityQueue<Weighted<CandidateInfo<Unit>>>(this.sortedTokens.size());
        CandidateInfo candidate = candidates;
        do {
            double impr = this.evaluateImprovement(candidate, optTokenOwnership, 1.0 / (double)numTokens);
            improvements.add(new Weighted<CandidateInfo<Unit>>(impr, candidate));
        } while ((candidate = (CandidateInfo)candidate.next) != candidates);
        CandidateInfo bestToken = (CandidateInfo)((Weighted)improvements.remove()).value;
        int vn = 1;
        while (true) {
            candidates = bestToken.removeFrom(candidates);
            this.confirmCandidate(bestToken);
            if (vn == numTokens) break;
            while (true) {
                bestToken = (CandidateInfo)((Weighted)improvements.remove()).value;
                double impr = this.evaluateImprovement(bestToken, optTokenOwnership, ((double)vn + 1.0) / (double)numTokens);
                Weighted next = (Weighted)improvements.peek();
                if (next == null || impr >= next.weight) break;
                improvements.add(new Weighted<CandidateInfo>(impr, bestToken));
            }
            ++vn;
        }
        return ImmutableList.copyOf((Collection)this.unitToTokens.get(newUnit));
    }

    private Collection<Token> generateRandomTokens(Unit newUnit, int numTokens) {
        HashSet<Token> tokens = new HashSet<Token>(numTokens);
        while (tokens.size() < numTokens) {
            Token token = this.partitioner.getRandomToken();
            if (this.sortedTokens.containsKey(token)) continue;
            tokens.add(token);
            this.sortedTokens.put(token, newUnit);
            this.unitToTokens.put(newUnit, (Object)token);
        }
        return tokens;
    }

    private Map<Unit, UnitInfo<Unit>> createUnitInfos(Map<Object, GroupInfo> groups) {
        HashMap map = Maps.newHashMap();
        for (Object n : this.sortedTokens.values()) {
            UnitInfo ni = (UnitInfo)map.get(n);
            if (ni == null) {
                ni = new UnitInfo(n, 0.0, groups, this.strategy);
                map.put(n, ni);
            }
            ++ni.tokenCount;
        }
        return map;
    }

    private TokenInfo<Unit> createTokenInfos(Map<Unit, UnitInfo<Unit>> units, GroupInfo newUnitGroup) {
        TokenInfo<Unit> prev = null;
        TokenInfo first = null;
        for (Map.Entry en : this.sortedTokens.entrySet()) {
            Token t = (Token)en.getKey();
            UnitInfo<Unit> ni = units.get(en.getValue());
            TokenInfo<Unit> ti = new TokenInfo<Unit>(t, ni);
            first = ti.insertAfter(first, prev);
            prev = ti;
        }
        TokenInfo curr = first;
        do {
            this.populateTokenInfoAndAdjustUnit(curr, newUnitGroup);
        } while ((curr = (TokenInfo)curr.next) != first);
        return first;
    }

    private CandidateInfo<Unit> createCandidates(TokenInfo<Unit> tokens, UnitInfo<Unit> newUnitInfo, double initialTokenOwnership) {
        TokenInfo curr = tokens;
        CandidateInfo first = null;
        CandidateInfo<Unit> prev = null;
        do {
            CandidateInfo<Unit> candidate = new CandidateInfo<Unit>(this.partitioner.midpoint(((TokenInfo)curr.prev).token, curr.token), curr, newUnitInfo);
            first = candidate.insertAfter(first, prev);
            candidate.replicatedOwnership = initialTokenOwnership;
            this.populateCandidate(candidate);
            prev = candidate;
        } while ((curr = (TokenInfo)curr.next) != tokens);
        prev.next = first;
        return first;
    }

    private void populateCandidate(CandidateInfo<Unit> candidate) {
        this.populateTokenInfo(candidate, candidate.owningUnit.group);
    }

    private void confirmCandidate(CandidateInfo<Unit> candidate) {
        UnitInfo newUnit = candidate.owningUnit;
        Token newToken = candidate.token;
        this.sortedTokens.put(newToken, newUnit.unit);
        this.unitToTokens.put(newUnit.unit, (Object)newToken);
        TokenInfo<Unit> prev = candidate.prevInRing();
        TokenInfo newTokenInfo = new TokenInfo(newToken, newUnit);
        newTokenInfo.replicatedOwnership = candidate.replicatedOwnership;
        newTokenInfo.insertAfter(prev, prev);
        this.populateTokenInfoAndAdjustUnit(newTokenInfo, newUnit.group);
        ReplicationVisitor replicationVisitor = new ReplicationVisitor();
        assert (newTokenInfo.next == candidate.split);
        TokenInfo curr = (TokenInfo)newTokenInfo.next;
        while (!replicationVisitor.visitedAll()) {
            candidate = (CandidateInfo)candidate.next;
            this.populateCandidate(candidate);
            if (replicationVisitor.add(curr.owningUnit.group)) {
                this.populateTokenInfoAndAdjustUnit(curr, newUnit.group);
            }
            curr = (TokenInfo)curr.next;
        }
        replicationVisitor.clean();
    }

    private Token populateTokenInfo(BaseTokenInfo<Unit, ?> token, GroupInfo newUnitGroup) {
        GroupInfo currGroup;
        Token replicationStart;
        GroupInfo tokenGroup = token.owningUnit.group;
        PopulateVisitor visitor = new PopulateVisitor();
        Token replicationThreshold = token.token;
        TokenInfo curr = token.prevInRing();
        while (true) {
            replicationStart = curr.token;
            currGroup = curr.owningUnit.group;
            if (visitor.add(currGroup)) {
                if (visitor.visitedAll()) break;
                replicationThreshold = replicationStart;
                if (currGroup == tokenGroup) break;
            }
            curr = (TokenInfo)curr.prev;
        }
        if (newUnitGroup == tokenGroup) {
            replicationThreshold = token.token;
        } else if (newUnitGroup != currGroup && visitor.seen(newUnitGroup)) {
            replicationThreshold = replicationStart;
        }
        visitor.clean();
        token.replicationThreshold = replicationThreshold;
        token.replicationStart = replicationStart;
        return replicationStart;
    }

    private void populateTokenInfoAndAdjustUnit(TokenInfo<Unit> populate, GroupInfo newUnitGroup) {
        Token replicationStart = this.populateTokenInfo(populate, newUnitGroup);
        double newOwnership = replicationStart.size(populate.token);
        double oldOwnership = populate.replicatedOwnership;
        populate.replicatedOwnership = newOwnership;
        populate.owningUnit.ownership += newOwnership - oldOwnership;
    }

    private double evaluateImprovement(CandidateInfo<Unit> candidate, double optTokenOwnership, double newUnitMult) {
        double tokenChange = 0.0;
        UnitInfo candidateUnit = candidate.owningUnit;
        Token candidateEnd = candidate.token;
        UnitAdjustmentTracker unitTracker = new UnitAdjustmentTracker(candidateUnit);
        tokenChange += this.applyOwnershipAdjustment(candidate, candidateUnit, candidate.replicationStart, candidateEnd, optTokenOwnership, unitTracker);
        ReplicationVisitor replicationVisitor = new ReplicationVisitor();
        TokenInfo curr = candidate.split;
        while (!replicationVisitor.visitedAll()) {
            UnitInfo currUnit = curr.owningUnit;
            if (replicationVisitor.add(currUnit.group)) {
                Token replicationEnd = curr.token;
                Token replicationStart = this.findUpdatedReplicationStart(curr, candidate);
                tokenChange += this.applyOwnershipAdjustment(curr, currUnit, replicationStart, replicationEnd, optTokenOwnership, unitTracker);
            }
            curr = (TokenInfo)curr.next;
        }
        replicationVisitor.clean();
        double nodeChange = unitTracker.calculateUnitChange(newUnitMult, optTokenOwnership);
        return -(tokenChange + nodeChange);
    }

    private Token findUpdatedReplicationStart(TokenInfo<Unit> curr, CandidateInfo<Unit> candidate) {
        return ReplicationAwareTokenAllocator.furtherStartToken(curr.replicationThreshold, candidate.token, curr.token);
    }

    private double applyOwnershipAdjustment(BaseTokenInfo<Unit, ?> curr, UnitInfo<Unit> currUnit, Token replicationStart, Token replicationEnd, double optTokenOwnership, UnitAdjustmentTracker<Unit> unitTracker) {
        double oldOwnership = curr.replicatedOwnership;
        double newOwnership = replicationStart.size(replicationEnd);
        double tokenCount = currUnit.tokenCount;
        assert (tokenCount > 0.0);
        unitTracker.add(currUnit, newOwnership - oldOwnership);
        return (ReplicationAwareTokenAllocator.sq(newOwnership - optTokenOwnership) - ReplicationAwareTokenAllocator.sq(oldOwnership - optTokenOwnership)) / ReplicationAwareTokenAllocator.sq(tokenCount);
    }

    private Map.Entry<Token, Unit> mapEntryFor(Token t) {
        Map.Entry<Token, Unit> en = this.sortedTokens.floorEntry(t);
        if (en == null) {
            en = this.sortedTokens.lastEntry();
        }
        return en;
    }

    Unit unitFor(Token t) {
        return this.mapEntryFor(t).getValue();
    }

    private double optimalTokenOwnership(int tokensToAdd) {
        return 1.0 * (double)this.replicas / (double)(this.sortedTokens.size() + tokensToAdd);
    }

    private static Token furtherStartToken(Token t1, Token t2, Token towards) {
        if (t1.equals(towards)) {
            return t2;
        }
        if (t2.equals(towards)) {
            return t1;
        }
        return t1.size(towards) > t2.size(towards) ? t1 : t2;
    }

    private static double sq(double d) {
        return d * d;
    }

    void removeUnit(Unit n) {
        Collection tokens = this.unitToTokens.removeAll(n);
        this.sortedTokens.keySet().removeAll(tokens);
    }

    int unitCount() {
        return this.unitToTokens.asMap().size();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static <Unit> GroupInfo getGroup(Unit unit, Map<Object, GroupInfo> groupMap, ReplicationStrategy<Unit> strategy) {
        Object groupClass = strategy.getGroup(unit);
        GroupInfo group = groupMap.get(groupClass);
        if (group == null) {
            group = new GroupInfo(groupClass);
            groupMap.put(groupClass, group);
        }
        return group;
    }

    static void dumpTokens(String lead, BaseTokenInfo<?, ?> tokens) {
        BaseTokenInfo token = tokens;
        do {
            System.out.format("%s%s: rs %s rt %s size %.2e\n", lead, token, token.replicationStart, token.replicationThreshold, token.replicatedOwnership);
        } while ((token = (BaseTokenInfo)token.next) != null && token != tokens);
    }

    static class Weighted<T>
    implements Comparable<Weighted<T>> {
        final double weight;
        final T value;

        public Weighted(double weight, T value) {
            this.weight = weight;
            this.value = value;
        }

        @Override
        public int compareTo(Weighted<T> o) {
            int cmp = Double.compare(o.weight, this.weight);
            return cmp;
        }

        public String toString() {
            return String.format("%s<%s>", this.value, this.weight);
        }
    }

    private static class CandidateInfo<Unit>
    extends BaseTokenInfo<Unit, CandidateInfo<Unit>> {
        final TokenInfo<Unit> split;

        public CandidateInfo(Token token, TokenInfo<Unit> split, UnitInfo<Unit> owningUnit) {
            super(token, owningUnit);
            this.split = split;
        }

        @Override
        TokenInfo<Unit> prevInRing() {
            return (TokenInfo)this.split.prev;
        }
    }

    private static class TokenInfo<Unit>
    extends BaseTokenInfo<Unit, TokenInfo<Unit>> {
        public TokenInfo(Token token, UnitInfo<Unit> owningUnit) {
            super(token, owningUnit);
        }

        @Override
        TokenInfo<Unit> prevInRing() {
            return (TokenInfo)this.prev;
        }
    }

    private static class BaseTokenInfo<Unit, T extends BaseTokenInfo<Unit, T>>
    extends CircularList<T> {
        final Token token;
        final UnitInfo<Unit> owningUnit;
        Token replicationStart;
        Token replicationThreshold;
        double replicatedOwnership = 0.0;

        public BaseTokenInfo(Token token, UnitInfo<Unit> owningUnit) {
            this.token = token;
            this.owningUnit = owningUnit;
        }

        public String toString() {
            return String.format("%s(%s)", this.token, this.owningUnit);
        }

        TokenInfo<Unit> prevInRing() {
            return null;
        }
    }

    private static class CircularList<T extends CircularList<T>> {
        T prev;
        T next;

        private CircularList() {
        }

        T insertAfter(T head, T unit) {
            if (head == null) {
                this.next = this;
                this.prev = this.next;
                return this.next;
            }
            assert (unit != null);
            assert (((CircularList)unit).next != null);
            this.prev = unit;
            this.next = ((CircularList)unit).next;
            ((CircularList)this.prev).next = this;
            ((CircularList)this.next).prev = this;
            return head;
        }

        T removeFrom(T head) {
            ((CircularList)this.next).prev = this.prev;
            ((CircularList)this.prev).next = this.next;
            return (T)(this == head ? (this == this.next ? null : this.next) : head);
        }
    }

    static class UnitInfo<Unit> {
        final Unit unit;
        final GroupInfo group;
        double ownership;
        int tokenCount;
        UnitInfo<Unit> prevUsed;
        double adjustedOwnership;

        private UnitInfo(Unit unit, GroupInfo group) {
            this.unit = unit;
            this.group = group;
            this.tokenCount = 0;
        }

        public UnitInfo(Unit unit, double ownership, Map<Object, GroupInfo> groupMap, ReplicationStrategy<Unit> strategy) {
            this(unit, ReplicationAwareTokenAllocator.getGroup(unit, groupMap, strategy));
            this.ownership = ownership;
        }

        public String toString() {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.unit;
            objectArray[1] = this.unit == this.group.group ? (this.group.prevSeen != null ? "*" : "") : ":" + this.group.toString();
            objectArray[2] = this.ownership;
            objectArray[3] = this.prevUsed != null ? (this.prevUsed == this ? "#" : "->" + this.prevUsed.toString()) : "";
            return String.format("%s%s(%.2e)%s", objectArray);
        }
    }

    private static class GroupInfo {
        final Object group;
        GroupInfo prevSeen = null;
        GroupInfo prevPopulate = null;
        static GroupInfo TERMINATOR = new GroupInfo(null);

        public GroupInfo(Object group) {
            this.group = group;
        }

        public String toString() {
            return this.group.toString() + (this.prevSeen != null ? "*" : "");
        }
    }

    private class PopulateVisitor
    extends GroupVisitor {
        private PopulateVisitor() {
        }

        @Override
        GroupInfo prevSeen(GroupInfo group) {
            return group.prevPopulate;
        }

        @Override
        void setPrevSeen(GroupInfo group, GroupInfo prevSeen) {
            group.prevPopulate = prevSeen;
        }
    }

    private class ReplicationVisitor
    extends GroupVisitor {
        private ReplicationVisitor() {
        }

        @Override
        GroupInfo prevSeen(GroupInfo group) {
            return group.prevSeen;
        }

        @Override
        void setPrevSeen(GroupInfo group, GroupInfo prevSeen) {
            group.prevSeen = prevSeen;
        }
    }

    private abstract class GroupVisitor {
        GroupInfo groupChain = GroupInfo.TERMINATOR;
        int seen = 0;

        private GroupVisitor() {
        }

        abstract GroupInfo prevSeen(GroupInfo var1);

        abstract void setPrevSeen(GroupInfo var1, GroupInfo var2);

        boolean add(GroupInfo group) {
            if (this.prevSeen(group) != null) {
                return false;
            }
            ++this.seen;
            this.setPrevSeen(group, this.groupChain);
            this.groupChain = group;
            return true;
        }

        boolean visitedAll() {
            return this.seen >= ReplicationAwareTokenAllocator.this.replicas;
        }

        boolean seen(GroupInfo group) {
            return this.prevSeen(group) != null;
        }

        void clean() {
            GroupInfo groupChain = this.groupChain;
            while (groupChain != GroupInfo.TERMINATOR) {
                GroupInfo prev = this.prevSeen(groupChain);
                this.setPrevSeen(groupChain, null);
                groupChain = prev;
            }
            this.groupChain = GroupInfo.TERMINATOR;
        }
    }

    private static class UnitAdjustmentTracker<Unit> {
        UnitInfo<Unit> unitsChain;

        UnitAdjustmentTracker(UnitInfo<Unit> newUnit) {
            this.unitsChain = newUnit;
        }

        void add(UnitInfo<Unit> currUnit, double diff) {
            if (currUnit.prevUsed == null) {
                assert (this.unitsChain.prevUsed != null || currUnit == this.unitsChain);
                currUnit.adjustedOwnership = currUnit.ownership + diff;
                currUnit.prevUsed = this.unitsChain;
                this.unitsChain = currUnit;
            } else {
                currUnit.adjustedOwnership += diff;
            }
        }

        double calculateUnitChange(double newUnitMult, double optTokenOwnership) {
            double diff;
            double unitChange = 0.0;
            UnitInfo<Unit> unitsChain = this.unitsChain;
            while (true) {
                double newOwnership = unitsChain.adjustedOwnership;
                double oldOwnership = unitsChain.ownership;
                double tokenCount = unitsChain.tokenCount;
                diff = ReplicationAwareTokenAllocator.sq(newOwnership / tokenCount - optTokenOwnership) - ReplicationAwareTokenAllocator.sq(oldOwnership / tokenCount - optTokenOwnership);
                UnitInfo prev = unitsChain.prevUsed;
                unitsChain.prevUsed = null;
                if (unitsChain == prev) break;
                unitChange += diff;
                unitsChain = prev;
            }
            this.unitsChain = unitsChain;
            return unitChange += diff * newUnitMult;
        }
    }
}

