/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EntryWeigher;
import java.util.Iterator;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IMeasurableMemory;

public class ConcurrentLinkedHashCache<K extends IMeasurableMemory, V extends IMeasurableMemory>
implements ICache<K, V> {
    public static final int DEFAULT_CONCURENCY_LEVEL = 64;
    private final ConcurrentLinkedHashMap<K, V> map;

    private ConcurrentLinkedHashCache(ConcurrentLinkedHashMap<K, V> map) {
        this.map = map;
    }

    public static <K extends IMeasurableMemory, V extends IMeasurableMemory> ConcurrentLinkedHashCache<K, V> create(long weightedCapacity, EntryWeigher<K, V> entryWeiger) {
        ConcurrentLinkedHashMap map = new ConcurrentLinkedHashMap.Builder().weigher(entryWeiger).maximumWeightedCapacity(weightedCapacity).concurrencyLevel(64).build();
        return new ConcurrentLinkedHashCache<K, V>(map);
    }

    public static <K extends IMeasurableMemory, V extends IMeasurableMemory> ConcurrentLinkedHashCache<K, V> create(long weightedCapacity) {
        return ConcurrentLinkedHashCache.create(weightedCapacity, new EntryWeigher<K, V>(){

            public int weightOf(K key, V value) {
                long size = key.unsharedHeapSize() + value.unsharedHeapSize();
                assert (size <= Integer.MAX_VALUE) : "Serialized size cannot be more than 2GB/Integer.MAX_VALUE";
                return (int)size;
            }
        });
    }

    @Override
    public long capacity() {
        return this.map.capacity();
    }

    @Override
    public void setCapacity(long capacity) {
        this.map.setCapacity(capacity);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public long weightedSize() {
        return this.map.weightedSize();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V get(K key) {
        return (V)((IMeasurableMemory)this.map.get(key));
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value) == null;
    }

    @Override
    public boolean replace(K key, V old, V value) {
        return this.map.replace(key, old, value);
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Iterator<K> hotKeyIterator(int n) {
        return this.map.descendingKeySetWithLimit(n).iterator();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }
}

