/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.SuperColumnCompatibility;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.aggregation.AggregationSpecification;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.AggregationQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    public static final int DEFAULT_PAGE_SIZE = 10000;
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final Term perPartitionLimit;
    private final StatementRestrictions restrictions;
    private final boolean isReversed;
    private final AggregationSpecification aggregationSpec;
    private final Comparator<List<ByteBuffer>> orderingComparator;
    private final ColumnFilter queriedColumns;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), Collections.emptyList(), false, false, false);

    public SelectStatement(CFMetaData cfm, int boundTerms, Parameters parameters, Selection selection, StatementRestrictions restrictions, boolean isReversed, AggregationSpecification aggregationSpec, Comparator<List<ByteBuffer>> orderingComparator, Term limit, Term perPartitionLimit) {
        this.cfm = cfm;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.restrictions = restrictions;
        this.isReversed = isReversed;
        this.aggregationSpec = aggregationSpec;
        this.orderingComparator = orderingComparator;
        this.parameters = parameters;
        this.limit = limit;
        this.perPartitionLimit = perPartitionLimit;
        this.queriedColumns = this.gatherQueriedColumns();
    }

    @Override
    public Iterable<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        this.addFunctionsTo(functions);
        return functions;
    }

    private void addFunctionsTo(List<Function> functions) {
        this.selection.addFunctionsTo(functions);
        this.restrictions.addFunctionsTo(functions);
        if (this.limit != null) {
            this.limit.addFunctionsTo(functions);
        }
        if (this.perPartitionLimit != null) {
            this.perPartitionLimit.addFunctionsTo(functions);
        }
    }

    private ColumnFilter gatherQueriedColumns() {
        if (this.selection.isWildcard()) {
            return ColumnFilter.all(this.cfm);
        }
        ColumnFilter.Builder builder = ColumnFilter.allColumnsBuilder(this.cfm);
        for (ColumnDefinition def : this.selection.getColumns()) {
            if (def.isPrimaryKeyColumn()) continue;
            builder.add(def);
        }
        builder.addAll(this.restrictions.nonPKRestrictedColumns(true));
        return builder.build();
    }

    public ColumnFilter queriedColumns() {
        return this.queriedColumns;
    }

    static SelectStatement forSelection(CFMetaData cfm, Selection selection) {
        return new SelectStatement(cfm, 0, defaultParameters, selection, StatementRestrictions.empty(StatementType.SELECT, cfm), false, null, null, null, null);
    }

    public ResultSet.ResultMetadata getResultMetadata() {
        return this.selection.getResultMetadata(this.parameters.isJson);
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        if (this.cfm.isView()) {
            CFMetaData baseTable = View.findBaseTable(this.keyspace(), this.columnFamily());
            if (baseTable != null) {
                state.hasColumnFamilyAccess(baseTable, Permission.SELECT);
            }
        } else {
            state.hasColumnFamilyAccess(this.cfm, Permission.SELECT);
        }
        for (Function function : this.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        RequestValidations.checkNotNull(cl, "Invalid empty consistency level", new Object[0]);
        cl.validateForRead(this.keyspace());
        int nowInSec = FBUtilities.nowInSeconds();
        int userLimit = this.getLimit(options);
        int userPerPartitionLimit = this.getPerPartitionLimit(options);
        int pageSize = options.getPageSize();
        ReadQuery query = this.getQuery(options, nowInSec, userLimit, userPerPartitionLimit, pageSize);
        if (this.aggregationSpec == null && (pageSize <= 0 || query.limits().count() <= pageSize)) {
            return this.execute(query, options, state, nowInSec, userLimit, queryStartNanoTime);
        }
        QueryPager pager = this.getPager(query, options);
        return this.execute(Pager.forDistributedQuery(pager, cl, state.getClientState()), options, pageSize, nowInSec, userLimit, queryStartNanoTime);
    }

    public ReadQuery getQuery(QueryOptions options, int nowInSec) throws RequestValidationException {
        return this.getQuery(options, nowInSec, this.getLimit(options), this.getPerPartitionLimit(options), options.getPageSize());
    }

    public ReadQuery getQuery(QueryOptions options, int nowInSec, int userLimit, int perPartitionLimit, int pageSize) {
        boolean isPartitionRangeQuery = this.restrictions.isKeyRange() || this.restrictions.usesSecondaryIndexing();
        DataLimits limit = this.getDataLimits(userLimit, perPartitionLimit, pageSize);
        if (isPartitionRangeQuery) {
            return this.getRangeCommand(options, limit, nowInSec);
        }
        return this.getSliceCommands(options, limit, nowInSec);
    }

    private ResultMessage.Rows execute(ReadQuery query, QueryOptions options, QueryState state, int nowInSec, int userLimit, long queryStartNanoTime) throws RequestValidationException, RequestExecutionException {
        try (PartitionIterator data = query.execute(options.getConsistency(), state.getClientState(), queryStartNanoTime);){
            ResultMessage.Rows rows = this.processResults(data, options, nowInSec, userLimit);
            return rows;
        }
    }

    private ResultMessage.Rows execute(Pager pager, QueryOptions options, int pageSize, int nowInSec, int userLimit, long queryStartNanoTime) throws RequestValidationException, RequestExecutionException {
        ResultMessage.Rows msg;
        if (this.aggregationSpec != null) {
            if (!this.restrictions.hasPartitionKeyRestrictions()) {
                this.warn("Aggregation query used without partition key");
            } else if (this.restrictions.keyIsInRelation()) {
                this.warn("Aggregation query used on multiple partition keys (IN restriction)");
            }
        }
        RequestValidations.checkFalse(pageSize > 0 && this.needsPostQueryOrdering(), "Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        try (PartitionIterator page = pager.fetchPage(pageSize, queryStartNanoTime);){
            msg = this.processResults(page, options, nowInSec, userLimit);
        }
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private void warn(String msg) {
        logger.warn(msg);
        ClientWarn.instance.warn(msg);
    }

    private ResultMessage.Rows processResults(PartitionIterator partitions, QueryOptions options, int nowInSec, int userLimit) throws RequestValidationException {
        ResultSet rset = this.process(partitions, options, nowInSec, userLimit);
        return new ResultMessage.Rows(rset);
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.executeInternal(state, options, FBUtilities.nowInSeconds(), System.nanoTime());
    }

    public ResultMessage.Rows executeInternal(QueryState state, QueryOptions options, int nowInSec, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        QueryPager pager;
        int userLimit = this.getLimit(options);
        int userPerPartitionLimit = this.getPerPartitionLimit(options);
        int pageSize = options.getPageSize();
        ReadQuery query = this.getQuery(options, nowInSec, userLimit, userPerPartitionLimit, pageSize);
        try (ReadExecutionController executionController = query.executionController();){
            if (this.aggregationSpec == null && (pageSize <= 0 || query.limits().count() <= pageSize)) {
                try (PartitionIterator data = query.executeInternal(executionController);){
                    ResultMessage.Rows rows = this.processResults(data, options, nowInSec, userLimit);
                    return rows;
                }
            }
            pager = this.getPager(query, options);
        }
        ResultMessage.Rows rows = this.execute(Pager.forInternalQuery(pager, executionController), options, pageSize, nowInSec, userLimit, queryStartNanoTime);
        return rows;
    }

    private QueryPager getPager(ReadQuery query, QueryOptions options) {
        QueryPager pager = query.getPager(options.getPagingState(), options.getProtocolVersion());
        if (this.aggregationSpec == null || query == ReadQuery.EMPTY) {
            return pager;
        }
        return new AggregationQueryPager(pager, query.limits());
    }

    public ResultSet process(PartitionIterator partitions, int nowInSec) throws InvalidRequestException {
        return this.process(partitions, QueryOptions.DEFAULT, nowInSec, this.getLimit(QueryOptions.DEFAULT));
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public StatementRestrictions getRestrictions() {
        return this.restrictions;
    }

    private ReadQuery getSliceCommands(QueryOptions options, DataLimits limit, int nowInSec) throws RequestValidationException {
        List<ByteBuffer> keys = this.restrictions.getPartitionKeys(options);
        if (keys.isEmpty()) {
            return ReadQuery.EMPTY;
        }
        ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options);
        if (filter == null) {
            return ReadQuery.EMPTY;
        }
        RowFilter rowFilter = this.getRowFilter(options);
        ArrayList<SinglePartitionReadCommand> commands = new ArrayList<SinglePartitionReadCommand>(keys.size());
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            DecoratedKey dk = this.cfm.decorateKey(ByteBufferUtil.clone(key));
            ColumnFilter cf = this.cfm.isSuper() && this.cfm.isDense() ? SuperColumnCompatibility.getColumnFilter(this.cfm, options, this.restrictions.getSuperColumnRestrictions()) : this.queriedColumns;
            commands.add(SinglePartitionReadCommand.create(this.cfm, nowInSec, cf, rowFilter, limit, dk, filter));
        }
        return new SinglePartitionReadCommand.Group(commands, limit);
    }

    public Slices clusteringIndexFilterAsSlices() {
        QueryOptions options = QueryOptions.forInternalCalls(Collections.emptyList());
        ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options);
        if (filter instanceof ClusteringIndexSliceFilter) {
            return ((ClusteringIndexSliceFilter)filter).requestedSlices();
        }
        Slices.Builder builder = new Slices.Builder(this.cfm.comparator);
        for (Clustering clustering : ((ClusteringIndexNamesFilter)filter).requestedRows()) {
            builder.add(Slice.make(clustering));
        }
        return builder.build();
    }

    public SinglePartitionReadCommand internalReadForView(DecoratedKey key, int nowInSec) {
        QueryOptions options = QueryOptions.forInternalCalls(Collections.emptyList());
        ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options);
        RowFilter rowFilter = this.getRowFilter(options);
        return SinglePartitionReadCommand.create(this.cfm, nowInSec, this.queriedColumns, rowFilter, DataLimits.NONE, key, filter);
    }

    public RowFilter rowFilterForInternalCalls() {
        return this.getRowFilter(QueryOptions.forInternalCalls(Collections.emptyList()));
    }

    private ReadQuery getRangeCommand(QueryOptions options, DataLimits limit, int nowInSec) throws RequestValidationException {
        ClusteringIndexFilter clusteringIndexFilter = this.makeClusteringIndexFilter(options);
        if (clusteringIndexFilter == null) {
            return ReadQuery.EMPTY;
        }
        RowFilter rowFilter = this.getRowFilter(options);
        AbstractBounds<PartitionPosition> keyBounds = this.restrictions.getPartitionKeyBounds(options);
        if (keyBounds == null) {
            return ReadQuery.EMPTY;
        }
        PartitionRangeReadCommand command = PartitionRangeReadCommand.create(false, this.cfm, nowInSec, this.queriedColumns, rowFilter, limit, new DataRange(keyBounds, clusteringIndexFilter));
        command.maybeValidateIndex();
        return command;
    }

    private ClusteringIndexFilter makeClusteringIndexFilter(QueryOptions options) throws InvalidRequestException {
        if (this.parameters.isDistinct) {
            return new ClusteringIndexSliceFilter(Slices.ALL, false);
        }
        if (this.restrictions.isColumnRange()) {
            Slices slices = this.makeSlices(options);
            if (slices == Slices.NONE && !this.selection.containsStaticColumns()) {
                return null;
            }
            return new ClusteringIndexSliceFilter(slices, this.isReversed);
        }
        NavigableSet<Clustering> clusterings = this.getRequestedRows(options);
        if (clusterings.isEmpty() && this.queriedColumns.fetchedColumns().statics.isEmpty()) {
            return null;
        }
        return new ClusteringIndexNamesFilter(clusterings, this.isReversed);
    }

    private Slices makeSlices(QueryOptions options) throws InvalidRequestException {
        NavigableSet<ClusteringBound> startBounds = this.restrictions.getClusteringColumnsBounds(Bound.START, options);
        NavigableSet<ClusteringBound> endBounds = this.restrictions.getClusteringColumnsBounds(Bound.END, options);
        assert (startBounds.size() == endBounds.size());
        if (startBounds.size() == 1) {
            ClusteringBound end;
            ClusteringBound start = (ClusteringBound)startBounds.first();
            return this.cfm.comparator.compare(start, end = (ClusteringBound)endBounds.first()) > 0 ? Slices.NONE : Slices.with(this.cfm.comparator, Slice.make(start, end));
        }
        Slices.Builder builder = new Slices.Builder(this.cfm.comparator, startBounds.size());
        Iterator startIter = startBounds.iterator();
        Iterator endIter = endBounds.iterator();
        while (startIter.hasNext() && endIter.hasNext()) {
            ClusteringBound end;
            ClusteringBound start = (ClusteringBound)startIter.next();
            if (this.cfm.comparator.compare(start, end = (ClusteringBound)endIter.next()) > 0) continue;
            builder.add(start, end);
        }
        return builder.build();
    }

    private DataLimits getDataLimits(int userLimit, int perPartitionLimit, int pageSize) {
        int cqlRowLimit = Integer.MAX_VALUE;
        int cqlPerPartitionLimit = Integer.MAX_VALUE;
        if (this.aggregationSpec != AggregationSpecification.AGGREGATE_EVERYTHING) {
            if (!this.needsPostQueryOrdering()) {
                cqlRowLimit = userLimit;
            }
            cqlPerPartitionLimit = perPartitionLimit;
        }
        if (pageSize <= 0) {
            pageSize = 10000;
        }
        if (this.aggregationSpec != null && this.aggregationSpec != AggregationSpecification.AGGREGATE_EVERYTHING) {
            if (this.parameters.isDistinct) {
                return DataLimits.distinctLimits(cqlRowLimit);
            }
            return DataLimits.groupByLimits(cqlRowLimit, cqlPerPartitionLimit, pageSize, this.aggregationSpec);
        }
        if (this.parameters.isDistinct) {
            return cqlRowLimit == Integer.MAX_VALUE ? DataLimits.DISTINCT_NONE : DataLimits.distinctLimits(cqlRowLimit);
        }
        return DataLimits.cqlLimits(cqlRowLimit, cqlPerPartitionLimit);
    }

    public int getLimit(QueryOptions options) {
        return this.getLimit(this.limit, options);
    }

    public int getPerPartitionLimit(QueryOptions options) {
        return this.getLimit(this.perPartitionLimit, options);
    }

    private int getLimit(Term limit, QueryOptions options) {
        ByteBuffer b;
        int userLimit = Integer.MAX_VALUE;
        if (limit != null && (b = RequestValidations.checkNotNull(limit.bindAndGet(options), "Invalid null value of limit", new Object[0])) != ByteBufferUtil.UNSET_BYTE_BUFFER) {
            try {
                Int32Type.instance.validate(b);
                userLimit = (Integer)Int32Type.instance.compose(b);
                RequestValidations.checkTrue(userLimit > 0, "LIMIT must be strictly positive");
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        return userLimit;
    }

    private NavigableSet<Clustering> getRequestedRows(QueryOptions options) throws InvalidRequestException {
        assert (!this.restrictions.isColumnRange());
        return this.restrictions.getClusteringColumns(options);
    }

    public RowFilter getRowFilter(QueryOptions options) throws InvalidRequestException {
        ColumnFamilyStore cfs = Keyspace.open(this.keyspace()).getColumnFamilyStore(this.columnFamily());
        SecondaryIndexManager secondaryIndexManager = cfs.indexManager;
        RowFilter filter = this.restrictions.getRowFilter(secondaryIndexManager, options);
        return filter;
    }

    private ResultSet process(PartitionIterator partitions, QueryOptions options, int nowInSec, int userLimit) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(options, this.parameters.isJson, this.aggregationSpec);
        while (partitions.hasNext()) {
            RowIterator partition = (RowIterator)partitions.next();
            Throwable throwable = null;
            try {
                this.processPartition(partition, options, result, nowInSec);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
        ResultSet cqlRows = result.build();
        this.orderResults(cqlRows);
        cqlRows.trim(userLimit);
        return cqlRows;
    }

    public static ByteBuffer[] getComponents(CFMetaData cfm, DecoratedKey dk) {
        ByteBuffer key = dk.getKey();
        if (cfm.getKeyValidator() instanceof CompositeType) {
            return ((CompositeType)cfm.getKeyValidator()).split(key);
        }
        return new ByteBuffer[]{key};
    }

    void processPartition(RowIterator partition, QueryOptions options, Selection.ResultSetBuilder result, int nowInSec) throws InvalidRequestException {
        if (this.cfm.isSuper() && this.cfm.isDense()) {
            SuperColumnCompatibility.processPartition(this.cfm, this.selection, partition, result, options.getProtocolVersion(), this.restrictions.getSuperColumnRestrictions(), options);
            return;
        }
        ProtocolVersion protocolVersion = options.getProtocolVersion();
        ByteBuffer[] keyComponents = SelectStatement.getComponents(this.cfm, partition.partitionKey());
        Row staticRow = partition.staticRow();
        if (!partition.hasNext()) {
            if (!staticRow.isEmpty() && (this.queriesFullPartitions() || this.cfm.isStaticCompactTable())) {
                result.newRow(partition.partitionKey(), staticRow.clustering());
                block10: for (ColumnDefinition def : this.selection.getColumns()) {
                    switch (def.kind) {
                        case PARTITION_KEY: {
                            result.add(keyComponents[def.position()]);
                            continue block10;
                        }
                        case STATIC: {
                            SelectStatement.addValue(result, def, staticRow, nowInSec, protocolVersion);
                            continue block10;
                        }
                    }
                    result.add(null);
                }
            }
            return;
        }
        while (partition.hasNext()) {
            Row row = (Row)partition.next();
            result.newRow(partition.partitionKey(), row.clustering());
            for (ColumnDefinition def : this.selection.getColumns()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        break;
                    }
                    case CLUSTERING: {
                        result.add(row.clustering().get(def.position()));
                        break;
                    }
                    case REGULAR: {
                        SelectStatement.addValue(result, def, row, nowInSec, protocolVersion);
                        break;
                    }
                    case STATIC: {
                        SelectStatement.addValue(result, def, staticRow, nowInSec, protocolVersion);
                    }
                }
            }
        }
    }

    private boolean queriesFullPartitions() {
        return !this.restrictions.hasClusteringColumnsRestrictions() && !this.restrictions.hasRegularColumnsRestrictions();
    }

    private static void addValue(Selection.ResultSetBuilder result, ColumnDefinition def, Row row, int nowInSec, ProtocolVersion protocolVersion) {
        if (def.isComplex()) {
            assert (def.type.isMultiCell());
            ComplexColumnData complexData = row.getComplexColumnData(def);
            if (complexData == null) {
                result.add(null);
            } else if (def.type.isCollection()) {
                result.add(((CollectionType)def.type).serializeForNativeProtocol(complexData.iterator(), protocolVersion));
            } else {
                result.add(((UserType)def.type).serializeForNativeProtocol(complexData.iterator(), protocolVersion));
            }
        } else {
            result.add(row.getCell(def), nowInSec);
        }
    }

    private boolean needsPostQueryOrdering() {
        return this.restrictions.keyIsInRelation() && !this.parameters.orderings.isEmpty();
    }

    private void orderResults(ResultSet cqlRows) {
        if (cqlRows.size() == 0 || !this.needsPostQueryOrdering()) {
            return;
        }
        Collections.sort(cqlRows.rows, this.orderingComparator);
    }

    private static class CompositeComparator
    extends ColumnComparator<List<ByteBuffer>> {
        private final List<Comparator<ByteBuffer>> orderTypes;
        private final List<Integer> positions;

        private CompositeComparator(List<Comparator<ByteBuffer>> orderTypes, List<Integer> positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.size(); ++i) {
                int columnPos;
                Comparator<ByteBuffer> type = this.orderTypes.get(i);
                int comparison = this.compare(type, a.get(columnPos = this.positions.get(i).intValue()), b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    extends ColumnComparator<List<ByteBuffer>> {
        private final int index;
        private final Comparator<ByteBuffer> comparator;

        public SingleColumnComparator(int columnIndex, Comparator<ByteBuffer> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.compare(this.comparator, a.get(this.index), b.get(this.index));
        }
    }

    private static abstract class ColumnComparator<T>
    implements Comparator<T> {
        private ColumnComparator() {
        }

        protected final int compare(Comparator<ByteBuffer> comparator, ByteBuffer aValue, ByteBuffer bValue) {
            if (aValue == null) {
                return bValue == null ? 0 : -1;
            }
            return bValue == null ? 1 : comparator.compare(aValue, bValue);
        }
    }

    public static class Parameters {
        public final Map<ColumnDefinition.Raw, Boolean> orderings;
        public final List<ColumnDefinition.Raw> groups;
        public final boolean isDistinct;
        public final boolean allowFiltering;
        public final boolean isJson;

        public Parameters(Map<ColumnDefinition.Raw, Boolean> orderings, List<ColumnDefinition.Raw> groups, boolean isDistinct, boolean allowFiltering, boolean isJson) {
            this.orderings = orderings;
            this.groups = groups;
            this.isDistinct = isDistinct;
            this.allowFiltering = allowFiltering;
            this.isJson = isJson;
        }
    }

    public static class RawStatement
    extends CFStatement {
        public final Parameters parameters;
        public final List<RawSelector> selectClause;
        public final WhereClause whereClause;
        public final Term.Raw limit;
        public final Term.Raw perPartitionLimit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, WhereClause whereClause, Term.Raw limit, Term.Raw perPartitionLimit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause;
            this.limit = limit;
            this.perPartitionLimit = perPartitionLimit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            return this.prepare(false);
        }

        public ParsedStatement.Prepared prepare(boolean forView) throws InvalidRequestException {
            AggregationSpecification aggregationSpec;
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            VariableSpecifications boundNames = this.getBoundVariables();
            Selection selection = this.selectClause.isEmpty() ? Selection.wildcard(cfm) : Selection.fromSelectors(cfm, this.selectClause, boundNames, !this.parameters.groups.isEmpty());
            StatementRestrictions restrictions = this.prepareRestrictions(cfm, boundNames, selection, forView);
            if (this.parameters.isDistinct) {
                RequestValidations.checkNull(this.perPartitionLimit, "PER PARTITION LIMIT is not allowed with SELECT DISTINCT queries");
                RawStatement.validateDistinctSelection(cfm, selection, restrictions);
            }
            RequestValidations.checkFalse((aggregationSpec = this.getAggregationSpecification(cfm, selection, restrictions, this.parameters.isDistinct)) == AggregationSpecification.AGGREGATE_EVERYTHING && this.perPartitionLimit != null, "PER PARTITION LIMIT is not allowed with aggregate queries.");
            Comparator<List<ByteBuffer>> orderingComparator = null;
            boolean isReversed = false;
            if (!this.parameters.orderings.isEmpty()) {
                assert (!forView);
                RawStatement.verifyOrderingIsAllowed(restrictions);
                orderingComparator = this.getOrderingComparator(cfm, selection, restrictions);
                isReversed = this.isReversed(cfm);
                if (isReversed) {
                    orderingComparator = Collections.reverseOrder(orderingComparator);
                }
            }
            this.checkNeedsFiltering(restrictions);
            SelectStatement stmt = new SelectStatement(cfm, boundNames.size(), this.parameters, selection, restrictions, isReversed, aggregationSpec, orderingComparator, this.prepareLimit(boundNames, this.limit, this.keyspace(), this.limitReceiver()), this.prepareLimit(boundNames, this.perPartitionLimit, this.keyspace(), this.perPartitionLimitReceiver()));
            return new ParsedStatement.Prepared((CQLStatement)stmt, boundNames, boundNames.getPartitionKeyBindIndexes(cfm));
        }

        private StatementRestrictions prepareRestrictions(CFMetaData cfm, VariableSpecifications boundNames, Selection selection, boolean forView) throws InvalidRequestException {
            return new StatementRestrictions(StatementType.SELECT, cfm, this.whereClause, boundNames, selection.containsOnlyStaticColumns(), selection.containsAComplexColumn(), this.parameters.allowFiltering, forView);
        }

        private Term prepareLimit(VariableSpecifications boundNames, Term.Raw limit, String keyspace, ColumnSpecification limitReceiver) throws InvalidRequestException {
            if (limit == null) {
                return null;
            }
            Term prepLimit = limit.prepare(keyspace, limitReceiver);
            prepLimit.collectMarkerSpecification(boundNames);
            return prepLimit;
        }

        private static void verifyOrderingIsAllowed(StatementRestrictions restrictions) throws InvalidRequestException {
            RequestValidations.checkFalse(restrictions.usesSecondaryIndexing(), "ORDER BY with 2ndary indexes is not supported.");
            RequestValidations.checkFalse(restrictions.isKeyRange(), "ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
        }

        private static void validateDistinctSelection(CFMetaData cfm, Selection selection, StatementRestrictions restrictions) throws InvalidRequestException {
            RequestValidations.checkFalse(restrictions.hasClusteringColumnsRestrictions() || restrictions.hasNonPrimaryKeyRestrictions() && !restrictions.nonPKRestrictedColumns(true).stream().allMatch(ColumnDefinition::isStatic), "SELECT DISTINCT with WHERE clause only supports restriction by partition key and/or static columns.");
            List<ColumnDefinition> requestedColumns = selection.getColumns();
            for (ColumnDefinition def : requestedColumns) {
                RequestValidations.checkFalse(!def.isPartitionKey() && !def.isStatic(), "SELECT DISTINCT queries must only request partition key columns and/or static columns (not %s)", def.name);
            }
            if (!restrictions.isKeyRange()) {
                return;
            }
            for (ColumnDefinition def : cfm.partitionKeyColumns()) {
                RequestValidations.checkTrue(requestedColumns.contains(def), "SELECT DISTINCT queries must request all the partition key columns (missing %s)", def.name);
            }
        }

        private AggregationSpecification getAggregationSpecification(CFMetaData cfm, Selection selection, StatementRestrictions restrictions, boolean isDistinct) {
            if (this.parameters.groups.isEmpty()) {
                return selection.isAggregate() ? AggregationSpecification.AGGREGATE_EVERYTHING : null;
            }
            int clusteringPrefixSize = 0;
            Iterator<ColumnDefinition> pkColumns = cfm.primaryKeyColumns().iterator();
            block0: for (ColumnDefinition.Raw raw : this.parameters.groups) {
                ColumnDefinition def = raw.prepare(cfm);
                RequestValidations.checkTrue(def.isPartitionKey() || def.isClusteringColumn(), "Group by is currently only supported on the columns of the PRIMARY KEY, got %s", def.name);
                while (true) {
                    RequestValidations.checkTrue(pkColumns.hasNext(), "Group by currently only support groups of columns following their declared order in the PRIMARY KEY");
                    ColumnDefinition pkColumn = pkColumns.next();
                    if (pkColumn.isClusteringColumn()) {
                        ++clusteringPrefixSize;
                    }
                    if (pkColumn.equals(def)) continue block0;
                    RequestValidations.checkTrue(restrictions.isColumnRestrictedByEq(pkColumn), "Group by currently only support groups of columns following their declared order in the PRIMARY KEY");
                }
            }
            RequestValidations.checkFalse(pkColumns.hasNext() && pkColumns.next().isPartitionKey(), "Group by is not supported on only a part of the partition key");
            RequestValidations.checkFalse(clusteringPrefixSize > 0 && isDistinct, "Grouping on clustering columns is not allowed for SELECT DISTINCT queries");
            return AggregationSpecification.aggregatePkPrefix(cfm.comparator, clusteringPrefixSize);
        }

        private Comparator<List<ByteBuffer>> getOrderingComparator(CFMetaData cfm, Selection selection, StatementRestrictions restrictions) throws InvalidRequestException {
            if (!restrictions.keyIsInRelation()) {
                return null;
            }
            Map<ColumnIdentifier, Integer> orderingIndexes = this.getOrderingIndex(cfm, selection);
            ArrayList<Integer> idToSort = new ArrayList<Integer>();
            ArrayList<AbstractType> sorters = new ArrayList<AbstractType>();
            for (ColumnDefinition.Raw raw : this.parameters.orderings.keySet()) {
                ColumnDefinition orderingColumn = raw.prepare(cfm);
                idToSort.add(orderingIndexes.get(orderingColumn.name));
                sorters.add(orderingColumn.type);
            }
            return idToSort.size() == 1 ? new SingleColumnComparator((Integer)idToSort.get(0), (Comparator)sorters.get(0)) : new CompositeComparator(sorters, idToSort);
        }

        private Map<ColumnIdentifier, Integer> getOrderingIndex(CFMetaData cfm, Selection selection) throws InvalidRequestException {
            HashMap<ColumnIdentifier, Integer> orderingIndexes = new HashMap<ColumnIdentifier, Integer>();
            for (ColumnDefinition.Raw raw : this.parameters.orderings.keySet()) {
                ColumnDefinition def = raw.prepare(cfm);
                int index = selection.getResultSetIndex(def);
                if (index < 0) {
                    index = selection.addColumnForOrdering(def);
                }
                orderingIndexes.put(def.name, index);
            }
            return orderingIndexes;
        }

        private boolean isReversed(CFMetaData cfm) throws InvalidRequestException {
            Boolean[] reversedMap = new Boolean[cfm.clusteringColumns().size()];
            int i = 0;
            for (Map.Entry<ColumnDefinition.Raw, Boolean> entry : this.parameters.orderings.entrySet()) {
                ColumnDefinition def = entry.getKey().prepare(cfm);
                boolean reversed = entry.getValue();
                RequestValidations.checkTrue(def.isClusteringColumn(), "Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", def.name);
                RequestValidations.checkTrue(i++ == def.position(), "Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY");
                reversedMap[def.position()] = reversed != def.isReversedType();
            }
            Boolean isReversed = null;
            for (Boolean b : reversedMap) {
                if (b == null) continue;
                if (isReversed == null) {
                    isReversed = b;
                    continue;
                }
                RequestValidations.checkTrue(isReversed.equals(b), "Unsupported order by relation");
            }
            assert (isReversed != null);
            return isReversed;
        }

        private void checkNeedsFiltering(StatementRestrictions restrictions) throws InvalidRequestException {
            if (!this.parameters.allowFiltering && (restrictions.isKeyRange() || restrictions.usesSecondaryIndexing())) {
                RequestValidations.checkFalse(restrictions.needFiltering(), "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        private ColumnSpecification perPartitionLimitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[per_partition_limit]", true), Int32Type.instance);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.cfName).add("selectClause", this.selectClause).add("whereClause", (Object)this.whereClause).add("isDistinct", this.parameters.isDistinct).toString();
        }
    }

    private static abstract class Pager {
        protected QueryPager pager;

        protected Pager(QueryPager pager) {
            this.pager = pager;
        }

        public static Pager forInternalQuery(QueryPager pager, ReadExecutionController executionController) {
            return new InternalPager(pager, executionController);
        }

        public static Pager forDistributedQuery(QueryPager pager, ConsistencyLevel consistency, ClientState clientState) {
            return new NormalPager(pager, consistency, clientState);
        }

        public boolean isExhausted() {
            return this.pager.isExhausted();
        }

        public PagingState state() {
            return this.pager.state();
        }

        public abstract PartitionIterator fetchPage(int var1, long var2);

        public static class InternalPager
        extends Pager {
            private final ReadExecutionController executionController;

            private InternalPager(QueryPager pager, ReadExecutionController executionController) {
                super(pager);
                this.executionController = executionController;
            }

            @Override
            public PartitionIterator fetchPage(int pageSize, long queryStartNanoTime) {
                return this.pager.fetchPageInternal(pageSize, this.executionController);
            }
        }

        public static class NormalPager
        extends Pager {
            private final ConsistencyLevel consistency;
            private final ClientState clientState;

            private NormalPager(QueryPager pager, ConsistencyLevel consistency, ClientState clientState) {
                super(pager);
                this.consistency = consistency;
                this.clientState = clientState;
            }

            @Override
            public PartitionIterator fetchPage(int pageSize, long queryStartNanoTime) {
                return this.pager.fetchPage(pageSize, this.consistency, this.clientState, queryStartNanoTime);
            }
        }
    }
}

