/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.RateLimiter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.SchemaConstants;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.BloomFilterTracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.metrics.RestorableMeter;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SelfRefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableReader
extends SSTable
implements SelfRefCounted<SSTableReader> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReader.class);
    private static final ScheduledThreadPoolExecutor syncExecutor = SSTableReader.initSyncExecutor();
    private static final RateLimiter meterSyncThrottle = RateLimiter.create((double)100.0);
    public static final Comparator<SSTableReader> maxTimestampDescending = (o1, o2) -> Long.compare(o2.getMaxTimestamp(), o1.getMaxTimestamp());
    public static final Comparator<SSTableReader> maxTimestampAscending = (o1, o2) -> Long.compare(o1.getMaxTimestamp(), o2.getMaxTimestamp());
    public static final Comparator<SSTableReader> sstableComparator = (o1, o2) -> o1.first.compareTo(o2.first);
    public static final Comparator<SSTableReader> generationReverseComparator = (o1, o2) -> -Integer.compare(o1.descriptor.generation, o2.descriptor.generation);
    public static final Ordering<SSTableReader> sstableOrdering = Ordering.from(sstableComparator);
    public static final Comparator<SSTableReader> sizeComparator = new Comparator<SSTableReader>(){

        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            return Longs.compare((long)o1.onDiskLength(), (long)o2.onDiskLength());
        }
    };
    public final long maxDataAge;
    public final OpenReason openReason;
    public final UniqueIdentifier instanceId = new UniqueIdentifier();
    protected FileHandle ifile;
    protected FileHandle dfile;
    protected IndexSummary indexSummary;
    protected IFilter bf;
    protected final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    protected InstrumentingCache<KeyCacheKey, RowIndexEntry> keyCache;
    protected final BloomFilterTracker bloomFilterTracker = new BloomFilterTracker();
    protected final AtomicBoolean isSuspect = new AtomicBoolean(false);
    protected volatile StatsMetadata sstableMetadata;
    public final SerializationHeader header;
    protected final AtomicLong keyCacheHit = new AtomicLong(0L);
    protected final AtomicLong keyCacheRequest = new AtomicLong(0L);
    private final InstanceTidier tidy = new InstanceTidier(this.descriptor, this.metadata);
    private final Ref<SSTableReader> selfRef = new Ref<SSTableReader>(this, this.tidy);
    private RestorableMeter readMeter;
    private volatile double crcCheckChance;

    private static ScheduledThreadPoolExecutor initSyncExecutor() {
        if (DatabaseDescriptor.isClientOrToolInitialized()) {
            return null;
        }
        ScheduledThreadPoolExecutor syncExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("read-hotness-tracker"));
        syncExecutor.setRemoveOnCancelPolicy(true);
        return syncExecutor;
    }

    public static long getApproximateKeyCount(Iterable<SSTableReader> sstables) {
        boolean cardinalityAvailable;
        long count = -1L;
        boolean bl = cardinalityAvailable = !Iterables.isEmpty(sstables) && Iterables.all(sstables, (Predicate)new Predicate<SSTableReader>(){

            public boolean apply(SSTableReader sstable) {
                return sstable.descriptor.version.hasNewStatsFile();
            }
        });
        if (cardinalityAvailable) {
            boolean failed = false;
            ICardinality cardinality = null;
            for (SSTableReader sstable : sstables) {
                if (sstable.openReason == OpenReason.EARLY) continue;
                try {
                    CompactionMetadata metadata = (CompactionMetadata)sstable.descriptor.getMetadataSerializer().deserialize(sstable.descriptor, MetadataType.COMPACTION);
                    if (metadata == null) {
                        logger.warn("Reading cardinality from Statistics.db failed for {}", (Object)sstable.getFilename());
                        failed = true;
                        break;
                    }
                    if (cardinality == null) {
                        cardinality = metadata.cardinalityEstimator;
                        continue;
                    }
                    cardinality = cardinality.merge(new ICardinality[]{metadata.cardinalityEstimator});
                }
                catch (IOException e) {
                    logger.warn("Reading cardinality from Statistics.db failed.", (Throwable)e);
                    failed = true;
                    break;
                }
                catch (CardinalityMergeException e) {
                    logger.warn("Cardinality merge failed.", (Throwable)e);
                    failed = true;
                    break;
                }
            }
            if (cardinality != null && !failed) {
                count = cardinality.cardinality();
            }
        }
        if (count < 0L) {
            for (SSTableReader sstable : sstables) {
                count += sstable.estimatedKeys();
            }
        }
        return count;
    }

    public static double estimateCompactionGain(Set<SSTableReader> overlapping) {
        HashSet<ICardinality> cardinalities = new HashSet<ICardinality>(overlapping.size());
        for (SSTableReader sstable : overlapping) {
            try {
                ICardinality cardinality = ((CompactionMetadata)sstable.descriptor.getMetadataSerializer().deserialize((Descriptor)sstable.descriptor, (MetadataType)MetadataType.COMPACTION)).cardinalityEstimator;
                if (cardinality != null) {
                    cardinalities.add(cardinality);
                    continue;
                }
                logger.trace("Got a null cardinality estimator in: {}", (Object)sstable.getFilename());
            }
            catch (IOException e) {
                logger.warn("Could not read up compaction metadata for {}", (Object)sstable, (Object)e);
            }
        }
        long totalKeyCountBefore = 0L;
        for (ICardinality cardinality : cardinalities) {
            totalKeyCountBefore += cardinality.cardinality();
        }
        if (totalKeyCountBefore == 0L) {
            return 1.0;
        }
        long totalKeyCountAfter = SSTableReader.mergeCardinalities(cardinalities).cardinality();
        logger.trace("Estimated compaction gain: {}/{}={}", new Object[]{totalKeyCountAfter, totalKeyCountBefore, (double)totalKeyCountAfter / (double)totalKeyCountBefore});
        return (double)totalKeyCountAfter / (double)totalKeyCountBefore;
    }

    private static ICardinality mergeCardinalities(Collection<ICardinality> cardinalities) {
        HyperLogLogPlus base = new HyperLogLogPlus(13, 25);
        try {
            base = base.merge(cardinalities.toArray(new ICardinality[cardinalities.size()]));
        }
        catch (CardinalityMergeException e) {
            logger.warn("Could not merge cardinalities", (Throwable)e);
        }
        return base;
    }

    public static SSTableReader open(Descriptor descriptor) throws IOException {
        CFMetaData metadata;
        if (descriptor.cfname.contains(".")) {
            int i = descriptor.cfname.indexOf(".");
            String parentName = descriptor.cfname.substring(0, i);
            String indexName = descriptor.cfname.substring(i + 1);
            CFMetaData parent = Schema.instance.getCFMetaData(descriptor.ksname, parentName);
            IndexMetadata def = parent.getIndexes().get(indexName).orElseThrow(() -> new AssertionError((Object)("Could not find index metadata for index cf " + i)));
            metadata = CassandraIndex.indexCfsMetadata(parent, def);
        } else {
            metadata = Schema.instance.getCFMetaData(descriptor.ksname, descriptor.cfname);
        }
        return SSTableReader.open(descriptor, metadata);
    }

    public static SSTableReader open(Descriptor desc, CFMetaData metadata) throws IOException {
        return SSTableReader.open(desc, SSTableReader.componentsFor(desc), metadata);
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata) throws IOException {
        return SSTableReader.open(descriptor, components, metadata, true, false);
    }

    public static SSTableReader openNoValidation(Descriptor descriptor, Set<Component> components, ColumnFamilyStore cfs) throws IOException {
        return SSTableReader.open(descriptor, components, cfs.metadata, false, true);
    }

    public static SSTableReader openNoValidation(Descriptor descriptor, CFMetaData metadata) throws IOException {
        return SSTableReader.open(descriptor, SSTableReader.componentsFor(descriptor), metadata, false, true);
    }

    /*
     * Exception decompiling
     */
    public static SSTableReader openForBatch(Descriptor descriptor, Set<Component> components, CFMetaData metadata) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, boolean validate, boolean isOffline) throws IOException {
        Map<MetadataType, MetadataComponent> sstableMetadata;
        assert (components.contains(Component.DATA)) : "Data component is missing for sstable " + descriptor;
        assert (!validate || components.contains(Component.PRIMARY_INDEX)) : "Primary index component is missing for sstable " + descriptor;
        assert (!descriptor.version.storeRows() || components.contains(Component.STATS)) : "Stats component is missing for sstable " + descriptor;
        EnumSet<MetadataType> types = EnumSet.of(MetadataType.VALIDATION, MetadataType.STATS, MetadataType.HEADER);
        try {
            sstableMetadata = descriptor.getMetadataSerializer().deserialize(descriptor, types);
        }
        catch (Throwable t) {
            throw new CorruptSSTableException(t, descriptor.filenameFor(Component.STATS));
        }
        ValidationMetadata validationMetadata = (ValidationMetadata)sstableMetadata.get((Object)MetadataType.VALIDATION);
        StatsMetadata statsMetadata = (StatsMetadata)sstableMetadata.get((Object)MetadataType.STATS);
        SerializationHeader.Component header = (SerializationHeader.Component)sstableMetadata.get((Object)MetadataType.HEADER);
        assert (!descriptor.version.storeRows() || header != null);
        String partitionerName = metadata.partitioner.getClass().getCanonicalName();
        if (validationMetadata != null && !partitionerName.equals(validationMetadata.partitioner)) {
            logger.error("Cannot open {}; partitioner {} does not match system partitioner {}.  Note that the default partitioner starting with Cassandra 1.2 is Murmur3Partitioner, so you will need to edit that to match your old partitioner if upgrading.", new Object[]{descriptor, validationMetadata.partitioner, partitionerName});
            System.exit(1);
        }
        long fileLength = new File(descriptor.filenameFor(Component.DATA)).length();
        logger.debug("Opening {} ({})", (Object)descriptor, (Object)FBUtilities.prettyPrintMemory(fileLength));
        SSTableReader sstable = SSTableReader.internalOpen(descriptor, components, metadata, System.currentTimeMillis(), statsMetadata, OpenReason.NORMAL, header == null ? null : header.toHeader(metadata));
        try {
            long start = System.nanoTime();
            sstable.load(validationMetadata, isOffline);
            logger.trace("INDEX LOAD TIME for {}: {} ms.", (Object)descriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            sstable.setup(!isOffline);
            if (validate) {
                sstable.validate();
            }
            if (sstable.getKeyCache() != null) {
                logger.trace("key cache contains {}/{} keys", (Object)sstable.getKeyCache().size(), (Object)sstable.getKeyCache().getCapacity());
            }
            return sstable;
        }
        catch (Throwable t) {
            sstable.selfRef().release();
            throw new CorruptSSTableException(t, sstable.getFilename());
        }
    }

    public static void logOpenException(Descriptor descriptor, IOException e) {
        if (e instanceof FileNotFoundException) {
            logger.error("Missing sstable component in {}; skipped because of {}", (Object)descriptor, (Object)e.getMessage());
        } else {
            logger.error("Corrupt sstable {}; skipped", (Object)descriptor, (Object)e);
        }
    }

    public static Collection<SSTableReader> openAll(Set<Map.Entry<Descriptor, Set<Component>>> entries, final CFMetaData metadata) {
        final LinkedBlockingQueue<SSTableReader> sstables = new LinkedBlockingQueue<SSTableReader>();
        DebuggableThreadPoolExecutor executor = DebuggableThreadPoolExecutor.createWithFixedPoolSize("SSTableBatchOpen", FBUtilities.getAvailableProcessors());
        for (final Map.Entry<Descriptor, Set<Component>> entry : entries) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SSTableReader sstable;
                    try {
                        sstable = SSTableReader.open((Descriptor)entry.getKey(), (Set)entry.getValue(), metadata);
                    }
                    catch (CorruptSSTableException ex) {
                        FileUtils.handleCorruptSSTable(ex);
                        logger.error("Corrupt sstable {}; skipping table", (Object)entry, (Object)ex);
                        return;
                    }
                    catch (FSError ex) {
                        FileUtils.handleFSError(ex);
                        logger.error("Cannot read sstable {}; file system error, skipping table", (Object)entry, (Object)ex);
                        return;
                    }
                    catch (IOException ex) {
                        FileUtils.handleCorruptSSTable(new CorruptSSTableException((Throwable)ex, ((Descriptor)entry.getKey()).filenameFor(Component.DATA)));
                        logger.error("Cannot read sstable {}; other IO error, skipping table", (Object)entry, (Object)ex);
                        return;
                    }
                    sstables.add(sstable);
                }
            };
            executor.submit(runnable);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return sstables;
    }

    public static SSTableReader internalOpen(Descriptor desc, Set<Component> components, CFMetaData metadata, FileHandle ifile, FileHandle dfile, IndexSummary isummary, IFilter bf, long maxDataAge, StatsMetadata sstableMetadata, OpenReason openReason, SerializationHeader header) {
        assert (desc != null && ifile != null && dfile != null && isummary != null && bf != null && sstableMetadata != null);
        SSTableReader reader = SSTableReader.internalOpen(desc, components, metadata, maxDataAge, sstableMetadata, openReason, header);
        reader.bf = bf;
        reader.ifile = ifile;
        reader.dfile = dfile;
        reader.indexSummary = isummary;
        reader.setup(true);
        return reader;
    }

    private static SSTableReader internalOpen(Descriptor descriptor, Set<Component> components, CFMetaData metadata, Long maxDataAge, StatsMetadata sstableMetadata, OpenReason openReason, SerializationHeader header) {
        Factory readerFactory = descriptor.getFormat().getReaderFactory();
        return readerFactory.open(descriptor, components, metadata, maxDataAge, sstableMetadata, openReason, header);
    }

    protected SSTableReader(Descriptor desc, Set<Component> components, CFMetaData metadata, long maxDataAge, StatsMetadata sstableMetadata, OpenReason openReason, SerializationHeader header) {
        super(desc, components, metadata, DatabaseDescriptor.getDiskOptimizationStrategy());
        this.sstableMetadata = sstableMetadata;
        this.header = header;
        this.maxDataAge = maxDataAge;
        this.openReason = openReason;
        this.rowIndexEntrySerializer = this.descriptor.version.getSSTableFormat().getIndexSerializer(metadata, desc.version, header);
    }

    public static long getTotalBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.onDiskLength();
        }
        return sum;
    }

    public static long getTotalUncompressedBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.uncompressedLength();
        }
        return sum;
    }

    public boolean equals(Object that) {
        return that instanceof SSTableReader && ((SSTableReader)that).descriptor.equals(this.descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public String getFilename() {
        return this.dfile.path();
    }

    public void setupOnline() {
        this.keyCache = CacheService.instance.keyCache;
        ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(this.metadata.cfId);
        if (cfs != null) {
            this.setCrcCheckChance(cfs.getCrcCheckChance());
        }
    }

    public boolean isKeyCacheSetup() {
        return this.keyCache != null;
    }

    private void load(ValidationMetadata validation, boolean isOffline) throws IOException {
        if (this.metadata.params.bloomFilterFpChance == 1.0) {
            this.load(false, !isOffline);
            this.bf = FilterFactory.AlwaysPresent;
        } else if (!this.components.contains(Component.PRIMARY_INDEX)) {
            this.load(false, !isOffline);
        } else if (!this.components.contains(Component.FILTER) || validation == null) {
            this.load(!isOffline, !isOffline);
            if (isOffline) {
                this.bf = FilterFactory.AlwaysPresent;
            }
        } else {
            this.load(false, !isOffline);
            this.loadBloomFilter(this.descriptor.version.hasOldBfHashOrder());
        }
    }

    private void loadBloomFilter(boolean oldBfHashOrder) throws IOException {
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.descriptor.filenameFor(Component.FILTER))));){
            this.bf = FilterFactory.deserialize(stream, true, oldBfHashOrder);
        }
    }

    private void load(boolean recreateBloomFilter, boolean saveSummaryIfCreated) throws IOException {
        try (FileHandle.Builder ibuilder = new FileHandle.Builder(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).mmapped(DatabaseDescriptor.getIndexAccessMode() == Config.DiskAccessMode.mmap).withChunkCache(ChunkCache.instance);
             FileHandle.Builder dbuilder = new FileHandle.Builder(this.descriptor.filenameFor(Component.DATA)).compressed(this.compression).mmapped(DatabaseDescriptor.getDiskAccessMode() == Config.DiskAccessMode.mmap).withChunkCache(ChunkCache.instance);){
            boolean buildSummary;
            boolean summaryLoaded = this.loadSummary();
            boolean bl = buildSummary = !summaryLoaded || recreateBloomFilter;
            if (buildSummary) {
                this.buildSummary(recreateBloomFilter, summaryLoaded, 128);
            }
            int dataBufferSize = this.optimizationStrategy.bufferSize(this.sstableMetadata.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
            if (this.components.contains(Component.PRIMARY_INDEX)) {
                long indexFileLength = new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).length();
                int indexBufferSize = this.optimizationStrategy.bufferSize(indexFileLength / (long)this.indexSummary.size());
                this.ifile = ibuilder.bufferSize(indexBufferSize).complete();
            }
            this.dfile = dbuilder.bufferSize(dataBufferSize).complete();
            if (buildSummary) {
                if (saveSummaryIfCreated) {
                    this.saveSummary();
                }
                if (recreateBloomFilter) {
                    this.saveBloomFilter();
                }
            }
        }
        catch (Throwable t) {
            if (this.ifile != null) {
                this.ifile.close();
                this.ifile = null;
            }
            if (this.dfile != null) {
                this.dfile.close();
                this.dfile = null;
            }
            if (this.indexSummary != null) {
                this.indexSummary.close();
                this.indexSummary = null;
            }
            throw t;
        }
    }

    private void buildSummary(boolean recreateBloomFilter, boolean summaryLoaded, int samplingLevel) throws IOException {
        if (!this.components.contains(Component.PRIMARY_INDEX)) {
            return;
        }
        try (RandomAccessReader primaryIndex = RandomAccessReader.open(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)));){
            long estimatedKeys;
            long indexSize = primaryIndex.length();
            long histogramCount = this.sstableMetadata.estimatedPartitionSize.count();
            long l = estimatedKeys = histogramCount > 0L && !this.sstableMetadata.estimatedPartitionSize.isOverflowed() ? histogramCount : this.estimateRowsFromIndex(primaryIndex);
            if (recreateBloomFilter) {
                this.bf = FilterFactory.getFilter(estimatedKeys, this.metadata.params.bloomFilterFpChance, true, this.descriptor.version.hasOldBfHashOrder());
            }
            try (IndexSummaryBuilder summaryBuilder = summaryLoaded ? null : new IndexSummaryBuilder(estimatedKeys, this.metadata.params.minIndexInterval, samplingLevel);){
                long indexPosition;
                while ((indexPosition = primaryIndex.getFilePointer()) != indexSize) {
                    ByteBuffer key = ByteBufferUtil.readWithShortLength(primaryIndex);
                    RowIndexEntry.Serializer.skip(primaryIndex, this.descriptor.version);
                    DecoratedKey decoratedKey = this.decorateKey(key);
                    if (this.first == null) {
                        this.first = decoratedKey;
                    }
                    this.last = decoratedKey;
                    if (recreateBloomFilter) {
                        this.bf.add(decoratedKey);
                    }
                    if (summaryLoaded) continue;
                    summaryBuilder.maybeAddEntry(decoratedKey, indexPosition);
                }
                if (!summaryLoaded) {
                    this.indexSummary = summaryBuilder.build(this.getPartitioner());
                }
            }
        }
        this.first = SSTableReader.getMinimalKey(this.first);
        this.last = SSTableReader.getMinimalKey(this.last);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSummary() {
        File summariesFile = new File(this.descriptor.filenameFor(Component.SUMMARY));
        if (!summariesFile.exists()) {
            return false;
        }
        DataInputStream iStream = null;
        try {
            iStream = new DataInputStream(new FileInputStream(summariesFile));
            this.indexSummary = IndexSummary.serializer.deserialize(iStream, this.getPartitioner(), this.descriptor.version.hasSamplingLevel(), this.metadata.params.minIndexInterval, this.metadata.params.maxIndexInterval);
            this.first = this.decorateKey(ByteBufferUtil.readWithLength(iStream));
            this.last = this.decorateKey(ByteBufferUtil.readWithLength(iStream));
        }
        catch (IOException e) {
            boolean bl;
            try {
                if (this.indexSummary != null) {
                    this.indexSummary.close();
                }
                logger.trace("Cannot deserialize SSTable Summary File {}: {}", (Object)summariesFile.getPath(), (Object)e.getMessage());
                FileUtils.closeQuietly(iStream);
                FileUtils.deleteWithConfirm(summariesFile);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(iStream);
                throw throwable;
            }
            FileUtils.closeQuietly(iStream);
            return bl;
        }
        FileUtils.closeQuietly(iStream);
        return true;
    }

    public void saveSummary() {
        SSTableReader.saveSummary(this.descriptor, this.first, this.last, this.indexSummary);
    }

    private void saveSummary(IndexSummary newSummary) {
        SSTableReader.saveSummary(this.descriptor, this.first, this.last, newSummary);
    }

    public static void saveSummary(Descriptor descriptor, DecoratedKey first, DecoratedKey last, IndexSummary summary) {
        block15: {
            File summariesFile = new File(descriptor.filenameFor(Component.SUMMARY));
            if (summariesFile.exists()) {
                FileUtils.deleteWithConfirm(summariesFile);
            }
            try (BufferedDataOutputStreamPlus oStream = new BufferedDataOutputStreamPlus(new FileOutputStream(summariesFile));){
                IndexSummary.serializer.serialize(summary, oStream, descriptor.version.hasSamplingLevel());
                ByteBufferUtil.writeWithLength(first.getKey(), oStream);
                ByteBufferUtil.writeWithLength(last.getKey(), oStream);
            }
            catch (IOException e) {
                logger.trace("Cannot save SSTable Summary: ", (Throwable)e);
                if (!summariesFile.exists()) break block15;
                FileUtils.deleteWithConfirm(summariesFile);
            }
        }
    }

    public void saveBloomFilter() {
        SSTableReader.saveBloomFilter(this.descriptor, this.bf);
    }

    public static void saveBloomFilter(Descriptor descriptor, IFilter filter) {
        block14: {
            File filterFile = new File(descriptor.filenameFor(Component.FILTER));
            try (BufferedDataOutputStreamPlus stream = new BufferedDataOutputStreamPlus(new FileOutputStream(filterFile));){
                FilterFactory.serialize(filter, stream);
                ((OutputStream)stream).flush();
            }
            catch (IOException e) {
                logger.trace("Cannot save SSTable bloomfilter: ", (Throwable)e);
                if (!filterFile.exists()) break block14;
                FileUtils.deleteWithConfirm(filterFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplaced() {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (!this.tidy.isReplaced);
            this.tidy.isReplaced = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplaced() {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            return this.tidy.isReplaced;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnClose(Runnable runOnClose) {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            Runnable existing = this.tidy.runOnClose;
            this.tidy.runOnClose = AndThen.get(existing, runOnClose);
        }
    }

    private SSTableReader cloneAndReplace(DecoratedKey newFirst, OpenReason reason) {
        return this.cloneAndReplace(newFirst, reason, this.indexSummary.sharedCopy());
    }

    private SSTableReader cloneAndReplace(DecoratedKey newFirst, OpenReason reason, IndexSummary newSummary) {
        SSTableReader replacement = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, this.ifile != null ? this.ifile.sharedCopy() : null, this.dfile.sharedCopy(), newSummary, this.bf.sharedCopy(), this.maxDataAge, this.sstableMetadata, reason, this.header);
        replacement.first = newFirst;
        replacement.last = this.last;
        replacement.isSuspect.set(this.isSuspect.get());
        return replacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableReader cloneWithRestoredStart(DecoratedKey restoredStart) {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            return this.cloneAndReplace(restoredStart, OpenReason.NORMAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableReader cloneWithNewStart(DecoratedKey newStart, Runnable runOnClose) {
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (this.openReason != OpenReason.EARLY);
            if (newStart.compareTo(this.first) > 0) {
                long dataStart = this.getPosition((PartitionPosition)newStart, (Operator)Operator.EQ).position;
                long indexStart = this.getIndexScanPosition(newStart);
                this.tidy.runOnClose = new DropPageCache(this.dfile, dataStart, this.ifile, indexStart, runOnClose);
            }
            return this.cloneAndReplace(newStart, OpenReason.MOVED_START);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableReader cloneWithNewSummarySamplingLevel(ColumnFamilyStore parent, int samplingLevel) throws IOException {
        assert (this.descriptor.version.hasSamplingLevel());
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            IndexSummary newSummary;
            assert (this.openReason != OpenReason.EARLY);
            int minIndexInterval = this.metadata.params.minIndexInterval;
            int maxIndexInterval = this.metadata.params.maxIndexInterval;
            double effectiveInterval = this.indexSummary.getEffectiveIndexInterval();
            if (samplingLevel > this.indexSummary.getSamplingLevel() || this.indexSummary.getMinIndexInterval() != minIndexInterval || effectiveInterval > (double)maxIndexInterval) {
                newSummary = this.buildSummaryAtLevel(samplingLevel);
            } else if (samplingLevel < this.indexSummary.getSamplingLevel()) {
                newSummary = IndexSummaryBuilder.downsample(this.indexSummary, samplingLevel, minIndexInterval, this.getPartitioner());
            } else {
                throw new AssertionError((Object)"Attempted to clone SSTableReader with the same index summary sampling level and no adjustments to min/max_index_interval");
            }
            this.saveSummary(newSummary);
            return this.cloneAndReplace(this.first, OpenReason.METADATA_CHANGE, newSummary);
        }
    }

    /*
     * Loose catch block
     */
    private IndexSummary buildSummaryAtLevel(int newSamplingLevel) throws IOException {
        RandomAccessReader primaryIndex = RandomAccessReader.open(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)));
        try {
            long indexSize = primaryIndex.length();
            try (IndexSummaryBuilder summaryBuilder = new IndexSummaryBuilder(this.estimatedKeys(), this.metadata.params.minIndexInterval, newSamplingLevel);){
                long indexPosition;
                while ((indexPosition = primaryIndex.getFilePointer()) != indexSize) {
                    summaryBuilder.maybeAddEntry(this.decorateKey(ByteBufferUtil.readWithShortLength(primaryIndex)), indexPosition);
                    RowIndexEntry.Serializer.skip(primaryIndex, this.descriptor.version);
                }
                IndexSummary indexSummary = summaryBuilder.build(this.getPartitioner());
                return indexSummary;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtils.closeQuietly(primaryIndex);
        }
    }

    public RestorableMeter getReadMeter() {
        return this.readMeter;
    }

    public int getIndexSummarySamplingLevel() {
        return this.indexSummary.getSamplingLevel();
    }

    public long getIndexSummaryOffHeapSize() {
        return this.indexSummary.getOffHeapSize();
    }

    public int getMinIndexInterval() {
        return this.indexSummary.getMinIndexInterval();
    }

    public double getEffectiveIndexInterval() {
        return this.indexSummary.getEffectiveIndexInterval();
    }

    public void releaseSummary() {
        this.tidy.releaseSummary();
        this.indexSummary = null;
    }

    private void validate() {
        if (this.first.compareTo(this.last) > 0) {
            throw new CorruptSSTableException((Throwable)new IllegalStateException(String.format("SSTable first key %s > last key %s", this.first, this.last)), this.getFilename());
        }
    }

    public long getIndexScanPosition(PartitionPosition key) {
        if (this.openReason == OpenReason.MOVED_START && key.compareTo(this.first) < 0) {
            key = this.first;
        }
        return SSTableReader.getIndexScanPositionFromBinarySearchResult(this.indexSummary.binarySearch(key), this.indexSummary);
    }

    @VisibleForTesting
    public static long getIndexScanPositionFromBinarySearchResult(int binarySearchResult, IndexSummary referencedIndexSummary) {
        if (binarySearchResult == -1) {
            return 0L;
        }
        return referencedIndexSummary.getPosition(SSTableReader.getIndexSummaryIndexFromBinarySearchResult(binarySearchResult));
    }

    public static int getIndexSummaryIndexFromBinarySearchResult(int binarySearchResult) {
        if (binarySearchResult < 0) {
            int greaterThan = (binarySearchResult + 1) * -1;
            if (greaterThan == 0) {
                return -1;
            }
            return greaterThan - 1;
        }
        return binarySearchResult;
    }

    public CompressionMetadata getCompressionMetadata() {
        if (!this.compression) {
            throw new IllegalStateException(this + " is not compressed");
        }
        return this.dfile.compressionMetadata().get();
    }

    public long getCompressionMetadataOffHeapSize() {
        if (!this.compression) {
            return 0L;
        }
        return this.getCompressionMetadata().offHeapSize();
    }

    public void forceFilterFailures() {
        this.bf = FilterFactory.AlwaysPresent;
    }

    public IFilter getBloomFilter() {
        return this.bf;
    }

    public long getBloomFilterSerializedSize() {
        return this.bf.serializedSize();
    }

    public long getBloomFilterOffHeapSize() {
        return this.bf.offHeapSize();
    }

    public long estimatedKeys() {
        return this.indexSummary.getEstimatedKeyCount();
    }

    public long estimatedKeysForRanges(Collection<Range<Token>> ranges) {
        long sampleKeyCount = 0L;
        List<Pair<Integer, Integer>> sampleIndexes = SSTableReader.getSampleIndexesForRanges(this.indexSummary, ranges);
        for (Pair<Integer, Integer> sampleIndexRange : sampleIndexes) {
            sampleKeyCount += (long)((Integer)sampleIndexRange.right - (Integer)sampleIndexRange.left + 1);
        }
        long estimatedKeys = sampleKeyCount * (128L * (long)this.indexSummary.getMinIndexInterval()) / (long)this.indexSummary.getSamplingLevel();
        return Math.max(1L, estimatedKeys);
    }

    public int getIndexSummarySize() {
        return this.indexSummary.size();
    }

    public int getMaxIndexSummarySize() {
        return this.indexSummary.getMaxNumberOfEntries();
    }

    public byte[] getIndexSummaryKey(int index) {
        return this.indexSummary.getKey(index);
    }

    private static List<Pair<Integer, Integer>> getSampleIndexesForRanges(IndexSummary summary, Collection<Range<Token>> ranges) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        for (Range range : Range.normalize(ranges)) {
            int right;
            Token.KeyBound leftPosition = ((Token)range.left).maxKeyBound();
            Token.KeyBound rightPosition = ((Token)range.right).maxKeyBound();
            int left = summary.binarySearch(leftPosition);
            left = left < 0 ? (left + 1) * -1 : ++left;
            if (left == summary.size()) continue;
            int n = right = Range.isWrapAround(range.left, range.right) ? summary.size() - 1 : summary.binarySearch(rightPosition);
            if (right < 0) {
                if ((right = (right + 1) * -1) == 0) continue;
                --right;
            }
            if (left > right) continue;
            positions.add(Pair.create(left, right));
        }
        return positions;
    }

    public Iterable<DecoratedKey> getKeySamples(Range<Token> range) {
        final List<Pair<Integer, Integer>> indexRanges = SSTableReader.getSampleIndexesForRanges(this.indexSummary, Collections.singletonList(range));
        if (indexRanges.isEmpty()) {
            return Collections.emptyList();
        }
        return new Iterable<DecoratedKey>(){

            @Override
            public Iterator<DecoratedKey> iterator() {
                return new Iterator<DecoratedKey>(){
                    private Iterator<Pair<Integer, Integer>> rangeIter;
                    private Pair<Integer, Integer> current;
                    private int idx;
                    {
                        this.rangeIter = indexRanges.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current == null || this.idx > (Integer)this.current.right) {
                            if (this.rangeIter.hasNext()) {
                                this.current = this.rangeIter.next();
                                this.idx = (Integer)this.current.left;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public DecoratedKey next() {
                        byte[] bytes = SSTableReader.this.indexSummary.getKey(this.idx++);
                        return SSTableReader.this.decorateKey(ByteBuffer.wrap(bytes));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<Pair<Long, Long>> getPositionsForRanges(Collection<Range<Token>> ranges) {
        ArrayList<Pair<Long, Long>> positions = new ArrayList<Pair<Long, Long>>();
        for (Range<Token> range : Range.normalize(ranges)) {
            PartitionPosition rightBound;
            assert (!range.isWrapAround() || ((Token)range.right).isMinimum());
            Range<PartitionPosition> bounds = Range.makeRowRange(range);
            PartitionPosition leftBound = ((PartitionPosition)bounds.left).compareTo(this.first) > 0 ? (PartitionPosition)bounds.left : this.first.getToken().minKeyBound();
            PartitionPosition partitionPosition = rightBound = ((PartitionPosition)bounds.right).isMinimum() ? this.last.getToken().maxKeyBound() : (PartitionPosition)bounds.right;
            if (leftBound.compareTo(this.last) > 0 || rightBound.compareTo(this.first) < 0) continue;
            long left = this.getPosition((PartitionPosition)leftBound, (Operator)Operator.GT).position;
            long right = rightBound.compareTo(this.last) > 0 ? this.uncompressedLength() : this.getPosition((PartitionPosition)rightBound, (Operator)Operator.GT).position;
            if (left == right) continue;
            assert (left < right) : String.format("Range=%s openReason=%s first=%s last=%s left=%d right=%d", new Object[]{range, this.openReason, this.first, this.last, left, right});
            positions.add(Pair.create(left, right));
        }
        return positions;
    }

    public KeyCacheKey getCacheKey(DecoratedKey key) {
        return new KeyCacheKey(this.metadata.ksAndCFName, this.descriptor, key.getKey());
    }

    public void cacheKey(DecoratedKey key, RowIndexEntry info) {
        CachingParams caching = this.metadata.params.caching;
        if (!caching.cacheKeys() || this.keyCache == null || this.keyCache.getCapacity() == 0L) {
            return;
        }
        KeyCacheKey cacheKey = new KeyCacheKey(this.metadata.ksAndCFName, this.descriptor, key.getKey());
        logger.trace("Adding cache entry for {} -> {}", (Object)cacheKey, (Object)info);
        this.keyCache.put(cacheKey, info);
    }

    public RowIndexEntry getCachedPosition(DecoratedKey key, boolean updateStats) {
        return this.getCachedPosition(new KeyCacheKey(this.metadata.ksAndCFName, this.descriptor, key.getKey()), updateStats);
    }

    protected RowIndexEntry getCachedPosition(KeyCacheKey unifiedKey, boolean updateStats) {
        if (this.keyCache != null && this.keyCache.getCapacity() > 0L && this.metadata.params.caching.cacheKeys()) {
            if (updateStats) {
                RowIndexEntry cachedEntry = this.keyCache.get(unifiedKey);
                this.keyCacheRequest.incrementAndGet();
                if (cachedEntry != null) {
                    this.keyCacheHit.incrementAndGet();
                    this.bloomFilterTracker.addTruePositive();
                }
                return cachedEntry;
            }
            return this.keyCache.getInternal(unifiedKey);
        }
        return null;
    }

    public final RowIndexEntry getPosition(PartitionPosition key, Operator op) {
        return this.getPosition(key, op, SSTableReadsListener.NOOP_LISTENER);
    }

    public final RowIndexEntry getPosition(PartitionPosition key, Operator op, SSTableReadsListener listener) {
        return this.getPosition(key, op, true, false, listener);
    }

    public final RowIndexEntry getPosition(PartitionPosition key, Operator op, boolean updateCacheAndStats) {
        return this.getPosition(key, op, updateCacheAndStats, false, SSTableReadsListener.NOOP_LISTENER);
    }

    protected abstract RowIndexEntry getPosition(PartitionPosition var1, Operator var2, boolean var3, boolean var4, SSTableReadsListener var5);

    public abstract UnfilteredRowIterator iterator(DecoratedKey var1, Slices var2, ColumnFilter var3, boolean var4, boolean var5, SSTableReadsListener var6);

    public abstract UnfilteredRowIterator iterator(FileDataInput var1, DecoratedKey var2, RowIndexEntry var3, Slices var4, ColumnFilter var5, boolean var6, boolean var7);

    public abstract UnfilteredRowIterator simpleIterator(FileDataInput var1, DecoratedKey var2, RowIndexEntry var3, boolean var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DecoratedKey firstKeyBeyond(PartitionPosition token) {
        if (token.compareTo(this.first) < 0) {
            return this.first;
        }
        long sampledPosition = this.getIndexScanPosition(token);
        if (this.ifile == null) {
            return null;
        }
        String path = null;
        try (FileDataInput in = this.ifile.createReader(sampledPosition);){
            path = in.getPath();
            while (!in.isEOF()) {
                ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                DecoratedKey indexDecoratedKey = this.decorateKey(indexKey);
                if (indexDecoratedKey.compareTo(token) > 0) {
                    DecoratedKey decoratedKey = indexDecoratedKey;
                    return decoratedKey;
                }
                RowIndexEntry.Serializer.skip(in, this.descriptor.version);
            }
            return null;
        }
        catch (IOException e) {
            this.markSuspect();
            throw new CorruptSSTableException((Throwable)e, path);
        }
    }

    public long uncompressedLength() {
        return this.dfile.dataLength();
    }

    public long onDiskLength() {
        return this.dfile.onDiskLength;
    }

    @VisibleForTesting
    public double getCrcCheckChance() {
        return this.crcCheckChance;
    }

    public void setCrcCheckChance(double crcCheckChance) {
        this.crcCheckChance = crcCheckChance;
        this.dfile.compressionMetadata().ifPresent(metadata -> metadata.parameters.setCrcCheckChance(crcCheckChance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markObsolete(Runnable tidier) {
        if (logger.isTraceEnabled()) {
            logger.trace("Marking {} compacted", (Object)this.getFilename());
        }
        GlobalTidy globalTidy = this.tidy.global;
        synchronized (globalTidy) {
            assert (!this.tidy.isReplaced);
            assert (this.tidy.global.obsoletion == null) : this + " was already marked compacted";
            this.tidy.global.obsoletion = tidier;
            this.tidy.global.stopReadMeterPersistence();
        }
    }

    public boolean isMarkedCompacted() {
        return this.tidy.global.obsoletion != null;
    }

    public void markSuspect() {
        if (logger.isTraceEnabled()) {
            logger.trace("Marking {} as a suspect to be excluded from reads.", (Object)this.getFilename());
        }
        this.isSuspect.getAndSet(true);
    }

    public boolean isMarkedSuspect() {
        return this.isSuspect.get();
    }

    public ISSTableScanner getScanner() {
        return this.getScanner((RateLimiter)null);
    }

    public ISSTableScanner getScanner(ColumnFilter columns, DataRange dataRange, boolean isForThrift, SSTableReadsListener listener) {
        return this.getScanner(columns, dataRange, null, isForThrift, listener);
    }

    public ISSTableScanner getScanner(Range<Token> range, RateLimiter limiter) {
        if (range == null) {
            return this.getScanner(limiter);
        }
        return this.getScanner(Collections.singletonList(range), limiter);
    }

    public abstract ISSTableScanner getScanner(RateLimiter var1);

    public abstract ISSTableScanner getScanner(Collection<Range<Token>> var1, RateLimiter var2);

    public abstract ISSTableScanner getScanner(Iterator<AbstractBounds<PartitionPosition>> var1);

    public abstract ISSTableScanner getScanner(ColumnFilter var1, DataRange var2, RateLimiter var3, boolean var4, SSTableReadsListener var5);

    public FileDataInput getFileDataInput(long position) {
        return this.dfile.createReader(position);
    }

    public boolean newSince(long age) {
        return this.maxDataAge > age;
    }

    public void createLinks(String snapshotDirectoryPath) {
        SSTableReader.createLinks(this.descriptor, this.components, snapshotDirectoryPath);
    }

    public static void createLinks(Descriptor descriptor, Set<Component> components, String snapshotDirectoryPath) {
        for (Component component : components) {
            File sourceFile = new File(descriptor.filenameFor(component));
            if (!sourceFile.exists()) continue;
            File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            FileUtils.createHardLink(sourceFile, targetLink);
        }
    }

    public boolean isRepaired() {
        return this.sstableMetadata.repairedAt != 0L;
    }

    public DecoratedKey keyAt(long indexPosition) throws IOException {
        DecoratedKey key;
        try (FileDataInput in = this.ifile.createReader(indexPosition);){
            if (in.isEOF()) {
                DecoratedKey decoratedKey = null;
                return decoratedKey;
            }
            key = this.decorateKey(ByteBufferUtil.readWithShortLength(in));
            if (this.isKeyCacheSetup()) {
                this.cacheKey(key, this.rowIndexEntrySerializer.deserialize(in, in.getFilePointer()));
            }
        }
        return key;
    }

    public long getBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getFalsePositiveCount();
    }

    public long getRecentBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getRecentFalsePositiveCount();
    }

    public long getBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getTruePositiveCount();
    }

    public long getRecentBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getRecentTruePositiveCount();
    }

    public InstrumentingCache<KeyCacheKey, RowIndexEntry> getKeyCache() {
        return this.keyCache;
    }

    public EstimatedHistogram getEstimatedPartitionSize() {
        return this.sstableMetadata.estimatedPartitionSize;
    }

    public EstimatedHistogram getEstimatedColumnCount() {
        return this.sstableMetadata.estimatedColumnCount;
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        return this.sstableMetadata.getEstimatedDroppableTombstoneRatio(gcBefore);
    }

    public double getDroppableTombstonesBefore(int gcBefore) {
        return this.sstableMetadata.getDroppableTombstonesBefore(gcBefore);
    }

    public double getCompressionRatio() {
        return this.sstableMetadata.compressionRatio;
    }

    public long getMinTimestamp() {
        return this.sstableMetadata.minTimestamp;
    }

    public long getMaxTimestamp() {
        return this.sstableMetadata.maxTimestamp;
    }

    public int getMinLocalDeletionTime() {
        return this.sstableMetadata.minLocalDeletionTime;
    }

    public int getMaxLocalDeletionTime() {
        return this.sstableMetadata.maxLocalDeletionTime;
    }

    public boolean mayHaveTombstones() {
        return !this.descriptor.version.storeRows() || this.getMinLocalDeletionTime() != Integer.MAX_VALUE;
    }

    public int getMinTTL() {
        return this.sstableMetadata.minTTL;
    }

    public int getMaxTTL() {
        return this.sstableMetadata.maxTTL;
    }

    public long getTotalColumnsSet() {
        return this.sstableMetadata.totalColumnsSet;
    }

    public long getTotalRows() {
        return this.sstableMetadata.totalRows;
    }

    public int getAvgColumnSetPerRow() {
        return this.sstableMetadata.totalRows < 0L ? -1 : (this.sstableMetadata.totalRows == 0L ? 0 : (int)(this.sstableMetadata.totalColumnsSet / this.sstableMetadata.totalRows));
    }

    public int getSSTableLevel() {
        return this.sstableMetadata.sstableLevel;
    }

    public void reloadSSTableMetadata() throws IOException {
        this.sstableMetadata = (StatsMetadata)this.descriptor.getMetadataSerializer().deserialize(this.descriptor, MetadataType.STATS);
    }

    public StatsMetadata getSSTableMetadata() {
        return this.sstableMetadata;
    }

    public RandomAccessReader openDataReader(RateLimiter limiter) {
        assert (limiter != null);
        return this.dfile.createReader(limiter);
    }

    public RandomAccessReader openDataReader() {
        return this.dfile.createReader();
    }

    public RandomAccessReader openIndexReader() {
        if (this.ifile != null) {
            return this.ifile.createReader();
        }
        return null;
    }

    public ChannelProxy getDataChannel() {
        return this.dfile.channel;
    }

    public ChannelProxy getIndexChannel() {
        return this.ifile.channel;
    }

    public FileHandle getIndexFile() {
        return this.ifile;
    }

    public long getCreationTimeFor(Component component) {
        return new File(this.descriptor.filenameFor(component)).lastModified();
    }

    public long getKeyCacheHit() {
        return this.keyCacheHit.get();
    }

    public long getKeyCacheRequest() {
        return this.keyCacheRequest.get();
    }

    public void incrementReadCount() {
        if (this.readMeter != null) {
            this.readMeter.mark();
        }
    }

    public EncodingStats stats() {
        return new EncodingStats(this.getMinTimestamp(), this.getMinLocalDeletionTime(), this.getMinTTL());
    }

    @Override
    public Ref<SSTableReader> tryRef() {
        return this.selfRef.tryRef();
    }

    @Override
    public Ref<SSTableReader> selfRef() {
        return this.selfRef;
    }

    @Override
    public Ref<SSTableReader> ref() {
        return this.selfRef.ref();
    }

    void setup(boolean trackHotness) {
        this.tidy.setup(this, trackHotness);
        this.readMeter = this.tidy.global.readMeter;
    }

    @VisibleForTesting
    public void overrideReadMeter(RestorableMeter readMeter) {
        this.readMeter = this.tidy.global.readMeter = readMeter;
    }

    public void addTo(Ref.IdentityCollection identities) {
        identities.add(this);
        identities.add(this.tidy.globalRef);
        this.dfile.addTo(identities);
        this.ifile.addTo(identities);
        this.bf.addTo(identities);
        this.indexSummary.addTo(identities);
    }

    @VisibleForTesting
    public static void resetTidying() {
        GlobalTidy.lookup.clear();
    }

    public static void shutdownBlocking(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, syncExecutor);
        SSTableReader.resetTidying();
    }

    public static abstract class Factory {
        public abstract SSTableReader open(Descriptor var1, Set<Component> var2, CFMetaData var3, Long var4, StatsMetadata var5, OpenReason var6, SerializationHeader var7);
    }

    static final class GlobalTidy
    implements RefCounted.Tidy {
        static WeakReference<ScheduledFuture<?>> NULL = new WeakReference<Object>(null);
        static final ConcurrentMap<Descriptor, Ref<GlobalTidy>> lookup = new ConcurrentHashMap<Descriptor, Ref<GlobalTidy>>();
        private final Descriptor desc;
        private RestorableMeter readMeter;
        private WeakReference<ScheduledFuture<?>> readMeterSyncFuture = NULL;
        private volatile Runnable obsoletion;

        GlobalTidy(SSTableReader reader) {
            this.desc = reader.descriptor;
        }

        void ensureReadMeter() {
            if (this.readMeter != null) {
                return;
            }
            if (SchemaConstants.isLocalSystemKeyspace(this.desc.ksname) || DatabaseDescriptor.isClientOrToolInitialized()) {
                this.readMeter = null;
                this.readMeterSyncFuture = NULL;
                return;
            }
            this.readMeter = SystemKeyspace.getSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.generation);
            this.readMeterSyncFuture = new WeakReference(syncExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (obsoletion == null) {
                        meterSyncThrottle.acquire();
                        SystemKeyspace.persistSSTableReadMeter(((GlobalTidy)this).desc.ksname, ((GlobalTidy)this).desc.cfname, ((GlobalTidy)this).desc.generation, readMeter);
                    }
                }
            }, 1L, 5L, TimeUnit.MINUTES));
        }

        private void stopReadMeterPersistence() {
            ScheduledFuture readMeterSyncFutureLocal = (ScheduledFuture)this.readMeterSyncFuture.get();
            if (readMeterSyncFutureLocal != null) {
                readMeterSyncFutureLocal.cancel(true);
                this.readMeterSyncFuture = NULL;
            }
        }

        @Override
        public void tidy() {
            lookup.remove(this.desc);
            if (this.obsoletion != null) {
                this.obsoletion.run();
            }
            NativeLibrary.trySkipCache(this.desc.filenameFor(Component.DATA), 0L, 0L);
            NativeLibrary.trySkipCache(this.desc.filenameFor(Component.PRIMARY_INDEX), 0L, 0L);
        }

        @Override
        public String name() {
            return this.desc.toString();
        }

        public static Ref<GlobalTidy> get(SSTableReader sstable) {
            Descriptor descriptor = sstable.descriptor;
            Ref<GlobalTidy> refc = (Ref<GlobalTidy>)lookup.get(descriptor);
            if (refc != null) {
                return refc.ref();
            }
            GlobalTidy tidy = new GlobalTidy(sstable);
            refc = new Ref<GlobalTidy>(tidy, tidy);
            Ref<GlobalTidy> ex = lookup.putIfAbsent(descriptor, refc);
            if (ex != null) {
                refc.close();
                throw new AssertionError();
            }
            return refc;
        }
    }

    private static final class InstanceTidier
    implements RefCounted.Tidy {
        private final Descriptor descriptor;
        private final CFMetaData metadata;
        private IFilter bf;
        private IndexSummary summary;
        private FileHandle dfile;
        private FileHandle ifile;
        private Runnable runOnClose;
        private boolean isReplaced = false;
        private Ref<GlobalTidy> globalRef;
        private GlobalTidy global;
        private volatile boolean setup;

        void setup(SSTableReader reader, boolean trackHotness) {
            this.setup = true;
            this.bf = reader.bf;
            this.summary = reader.indexSummary;
            this.dfile = reader.dfile;
            this.ifile = reader.ifile;
            this.globalRef = GlobalTidy.get(reader);
            this.global = this.globalRef.get();
            if (trackHotness) {
                this.global.ensureReadMeter();
            }
        }

        InstanceTidier(Descriptor descriptor, CFMetaData metadata) {
            this.descriptor = descriptor;
            this.metadata = metadata;
        }

        @Override
        public void tidy() {
            OpOrder.Barrier barrier;
            if (logger.isTraceEnabled()) {
                logger.trace("Running instance tidier for {} with setup {}", (Object)this.descriptor, (Object)this.setup);
            }
            if (!this.setup) {
                return;
            }
            ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(this.metadata.cfId);
            if (cfs != null) {
                barrier = cfs.readOrdering.newBarrier();
                barrier.issue();
            } else {
                barrier = null;
            }
            ScheduledExecutors.nonPeriodicTasks.execute(new Runnable(){

                @Override
                public void run() {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Async instance tidier for {}, before barrier", (Object)descriptor);
                    }
                    if (barrier != null) {
                        barrier.await();
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Async instance tidier for {}, after barrier", (Object)descriptor);
                    }
                    if (bf != null) {
                        bf.close();
                    }
                    if (summary != null) {
                        summary.close();
                    }
                    if (runOnClose != null) {
                        runOnClose.run();
                    }
                    if (dfile != null) {
                        dfile.close();
                    }
                    if (ifile != null) {
                        ifile.close();
                    }
                    globalRef.release();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Async instance tidier for {}, completed", (Object)descriptor);
                    }
                }
            });
        }

        @Override
        public String name() {
            return this.descriptor.toString();
        }

        void releaseSummary() {
            this.summary.close();
            assert (this.summary.isCleanedUp());
            this.summary = null;
        }
    }

    public static abstract class Operator {
        public static final Operator EQ = new Equals();
        public static final Operator GE = new GreaterThanOrEqualTo();
        public static final Operator GT = new GreaterThan();

        public abstract int apply(int var1);

        static final class GreaterThan
        extends Operator {
            GreaterThan() {
            }

            @Override
            public int apply(int comparison) {
                return comparison > 0 ? 0 : 1;
            }
        }

        static final class GreaterThanOrEqualTo
        extends Operator {
            GreaterThanOrEqualTo() {
            }

            @Override
            public int apply(int comparison) {
                return comparison >= 0 ? 0 : 1;
            }
        }

        static final class Equals
        extends Operator {
            Equals() {
            }

            @Override
            public int apply(int comparison) {
                return -comparison;
            }
        }
    }

    private static class DropPageCache
    implements Runnable {
        final FileHandle dfile;
        final long dfilePosition;
        final FileHandle ifile;
        final long ifilePosition;
        final Runnable andThen;

        private DropPageCache(FileHandle dfile, long dfilePosition, FileHandle ifile, long ifilePosition, Runnable andThen) {
            this.dfile = dfile;
            this.dfilePosition = dfilePosition;
            this.ifile = ifile;
            this.ifilePosition = ifilePosition;
            this.andThen = andThen;
        }

        @Override
        public void run() {
            this.dfile.dropPageCache(this.dfilePosition);
            if (this.ifile != null) {
                this.ifile.dropPageCache(this.ifilePosition);
            }
            if (this.andThen != null) {
                this.andThen.run();
            }
        }
    }

    private static class AndThen
    implements Runnable {
        final Runnable runFirst;
        final Runnable runSecond;

        private AndThen(Runnable runFirst, Runnable runSecond) {
            this.runFirst = runFirst;
            this.runSecond = runSecond;
        }

        @Override
        public void run() {
            this.runFirst.run();
            this.runSecond.run();
        }

        static Runnable get(Runnable runFirst, Runnable runSecond) {
            if (runFirst == null) {
                return runSecond;
            }
            return new AndThen(runFirst, runSecond);
        }
    }

    public static enum OpenReason {
        NORMAL,
        EARLY,
        METADATA_CHANGE,
        MOVED_START;

    }

    public static final class UniqueIdentifier {
    }
}

