/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

public abstract class Lists {
    private Lists() {
    }

    public static ColumnSpecification indexSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("idx(" + column.name + ")", true), Int32Type.instance);
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), Lists.elementsType(column.type));
    }

    private static AbstractType<?> unwrap(AbstractType<?> type) {
        return type.isReversed() ? Lists.unwrap(((ReversedType)type).baseType) : type;
    }

    private static AbstractType<?> elementsType(AbstractType<?> type) {
        return ((ListType)Lists.unwrap(type)).getElementsType();
    }

    private static int existingSize(Row row, ColumnDefinition column) {
        if (row == null) {
            return 0;
        }
        ComplexColumnData complexData = row.getComplexColumnData(column);
        return complexData == null ? 0 : complexData.cellsCount();
    }

    public static class DiscarderByIndex
    extends Operation {
        public DiscarderByIndex(ColumnDefinition column, Term idx) {
            super(column, idx);
        }

        @Override
        public boolean requiresRead() {
            return true;
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to delete an item by index from a frozen list";
            Term.Terminal index = this.t.bind(params.options);
            if (index == null) {
                throw new InvalidRequestException("Invalid null value for list index");
            }
            if (index == Constants.UNSET_VALUE) {
                return;
            }
            Row existingRow = params.getPrefetchedRow(partitionKey, params.currentClustering());
            int existingSize = Lists.existingSize(existingRow, this.column);
            int idx = ByteBufferUtil.toInt(index.get(params.options.getProtocolVersion()));
            if (existingSize == 0) {
                throw new InvalidRequestException("Attempted to delete an element from a list which is null");
            }
            if (idx < 0 || idx >= existingSize) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, existingSize));
            }
            params.addTombstone(this.column, existingRow.getComplexColumnData(this.column).getCellByIndex(idx).path());
        }
    }

    public static class Discarder
    extends Operation {
        public Discarder(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public boolean requiresRead() {
            return true;
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            ComplexColumnData complexData;
            assert (this.column.type.isMultiCell()) : "Attempted to delete from a frozen list";
            Term.Terminal value = this.t.bind(params.options);
            Row existingRow = params.getPrefetchedRow(partitionKey, params.currentClustering());
            ComplexColumnData complexColumnData = complexData = existingRow == null ? null : existingRow.getComplexColumnData(this.column);
            if (value == null || value == Constants.UNSET_VALUE || complexData == null) {
                return;
            }
            List<ByteBuffer> toDiscard = ((Value)value).elements;
            for (Cell cell : complexData) {
                if (!toDiscard.contains(cell.value())) continue;
                params.addTombstone(this.column, cell.path());
            }
        }
    }

    public static class Prepender
    extends Operation {
        public Prepender(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to prepend to a frozen list";
            Term.Terminal value = this.t.bind(params.options);
            if (value == null || value == Constants.UNSET_VALUE) {
                return;
            }
            List<ByteBuffer> toAdd = ((Value)value).elements;
            int totalCount = toAdd.size();
            PrecisionTime pt = null;
            int remainingInBatch = 0;
            for (int i = totalCount - 1; i >= 0; --i) {
                if (remainingInBatch == 0) {
                    long time = 1262304000000L - (System.currentTimeMillis() - 1262304000000L);
                    remainingInBatch = Math.min(9999, i) + 1;
                    pt = PrecisionTime.getNext(time, remainingInBatch);
                }
                ByteBuffer uuid = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(pt.millis, pt.nanos + remainingInBatch--));
                params.addCell(this.column, CellPath.create(uuid), toAdd.get(i));
            }
        }
    }

    public static class Appender
    extends Operation {
        public Appender(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to append to a frozen list";
            Term.Terminal value = this.t.bind(params.options);
            Appender.doAppend(value, this.column, params);
        }

        static void doAppend(Term.Terminal value, ColumnDefinition column, UpdateParameters params) throws InvalidRequestException {
            if (column.type.isMultiCell()) {
                if (value == null) {
                    return;
                }
                for (ByteBuffer buffer : ((Value)value).elements) {
                    ByteBuffer uuid = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
                    params.addCell(column, CellPath.create(uuid), buffer);
                }
            } else if (value == null) {
                params.addTombstone(column);
            } else {
                params.addCell(column, value.get(ProtocolVersion.CURRENT));
            }
        }
    }

    public static class SetterByIndex
    extends Operation {
        private final Term idx;

        public SetterByIndex(ColumnDefinition column, Term idx, Term t) {
            super(column, t);
            this.idx = idx;
        }

        @Override
        public boolean requiresRead() {
            return true;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            super.collectMarkerSpecification(boundNames);
            this.idx.collectMarkerSpecification(boundNames);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to set an individual element on a frozen list";
            ByteBuffer index = this.idx.bindAndGet(params.options);
            ByteBuffer value = this.t.bindAndGet(params.options);
            if (index == null) {
                throw new InvalidRequestException("Invalid null value for list index");
            }
            if (index == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw new InvalidRequestException("Invalid unset value for list index");
            }
            Row existingRow = params.getPrefetchedRow(partitionKey, params.currentClustering());
            int existingSize = Lists.existingSize(existingRow, this.column);
            int idx = ByteBufferUtil.toInt(index);
            if (existingSize == 0) {
                throw new InvalidRequestException("Attempted to set an element on a list which is null");
            }
            if (idx < 0 || idx >= existingSize) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, existingSize));
            }
            CellPath elementPath = existingRow.getComplexColumnData(this.column).getCellByIndex(idx).path();
            if (value == null) {
                params.addTombstone(this.column, elementPath);
            } else if (value != ByteBufferUtil.UNSET_BYTE_BUFFER) {
                params.addCell(this.column, elementPath, value);
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = this.t.bind(params.options);
            if (value == Constants.UNSET_VALUE) {
                return;
            }
            if (this.column.type.isMultiCell()) {
                params.setComplexDeletionTimeForOverwrite(this.column);
            }
            Appender.doAppend(value, this.column, params);
        }
    }

    static class PrecisionTime {
        private static final long REFERENCE_TIME = 1262304000000L;
        static final int MAX_NANOS = 9999;
        private static final AtomicReference<PrecisionTime> last = new AtomicReference<PrecisionTime>(new PrecisionTime(Long.MAX_VALUE, 0));
        public final long millis;
        public final int nanos;

        PrecisionTime(long millis, int nanos) {
            this.millis = millis;
            this.nanos = nanos;
        }

        static PrecisionTime getNext(long millis, int count) {
            PrecisionTime next;
            PrecisionTime current;
            if (count == 0) {
                return last.get();
            }
            do {
                int nanosToUse;
                long millisToUse;
                current = last.get();
                if (millis < current.millis) {
                    next = new PrecisionTime(millis, 9999 - count);
                    continue;
                }
                long l = millisToUse = millis <= current.millis ? millis : current.millis;
                if (current.nanos - count >= 0) {
                    nanosToUse = current.nanos - count;
                } else {
                    nanosToUse = 9999 - count;
                    --millisToUse;
                }
                next = new PrecisionTime(millisToUse, nanosToUse);
            } while (!last.compareAndSet(current, next));
            return next;
        }

        @VisibleForTesting
        static void set(long millis, int nanos) {
            last.set(new PrecisionTime(millis, nanos));
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof ListType);
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            if (value == null) {
                return null;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return Constants.UNSET_VALUE;
            }
            return Value.fromSerialized(value, (ListType)this.receiver.type, options.getProtocolVersion());
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final List<Term> elements;

        public DelayedValue(List<Term> elements) {
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.elements.size());
            for (Term t : this.elements) {
                ByteBuffer bytes = t.bindAndGet(options);
                if (bytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (bytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    return Constants.UNSET_VALUE;
                }
                buffers.add(bytes);
            }
            return new Value(buffers);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.elements, functions);
        }
    }

    public static class Value
    extends Term.MultiItemTerminal {
        public final List<ByteBuffer> elements;

        public Value(List<ByteBuffer> elements) {
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer value, ListType type, ProtocolVersion version) throws InvalidRequestException {
            try {
                Object l = ((ListSerializer)type.getSerializer()).deserializeForNativeProtocol(value, version);
                ArrayList<ByteBuffer> elements = new ArrayList<ByteBuffer>(l.size());
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    elements.add(element == null ? null : type.getElementsType().decompose(element));
                }
                return new Value(elements);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get(ProtocolVersion protocolVersion) {
            return CollectionSerializer.pack(this.elements, this.elements.size(), protocolVersion);
        }

        public boolean equals(ListType lt, Value v) {
            if (this.elements.size() != v.elements.size()) {
                return false;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                if (lt.getElementsType().compare(this.elements.get(i), v.elements.get(i)) == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<ByteBuffer> getElements() {
            return this.elements;
        }
    }

    public static class Literal
    extends Term.Raw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            ColumnSpecification valueSpec = Lists.valueSpecOf(receiver);
            ArrayList<Term> values = new ArrayList<Term>(this.elements.size());
            boolean allTerminal = true;
            for (Term.Raw rt : this.elements) {
                Term t = rt.prepare(keyspace, valueSpec);
                if (t.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid list literal for %s: bind variables are not supported inside collection literals", receiver.name));
                }
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(t);
            }
            DelayedValue value = new DelayedValue(values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            AbstractType type = Lists.unwrap(receiver.type);
            if (!(type instanceof ListType)) {
                throw new InvalidRequestException(String.format("Invalid list literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            ColumnSpecification valueSpec = Lists.valueSpecOf(receiver);
            for (Term.Raw rt : this.elements) {
                if (rt.testAssignment(keyspace, valueSpec).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid list literal for %s: value %s is not of type %s", receiver.name, rt, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            if (!(receiver.type instanceof ListType)) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (this.elements.isEmpty()) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            ColumnSpecification valueSpec = Lists.valueSpecOf(receiver);
            return AssignmentTestable.TestResult.testAll(keyspace, valueSpec, this.elements);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            for (Term.Raw term : this.elements) {
                AbstractType<?> type = term.getExactTypeIfKnown(keyspace);
                if (type == null) continue;
                return ListType.getInstance(type, false);
            }
            return null;
        }

        @Override
        public String getText() {
            return this.elements.stream().map(Term.Raw::getText).collect(Collectors.joining(", ", "[", "]"));
        }
    }
}

