/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.ProtocolVersionLimit;
import org.apache.cassandra.utils.CassandraVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfiguredLimit
implements ProtocolVersionLimit {
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredLimit.class);
    static final String DISABLE_MAX_PROTOCOL_AUTO_OVERRIDE = "cassandra.disable_max_protocol_auto_override";
    static final CassandraVersion MIN_VERSION_FOR_V4 = new CassandraVersion("3.0.0");

    @Override
    public abstract ProtocolVersion getMaxVersion();

    public abstract void updateMaxSupportedVersion();

    public static ConfiguredLimit newLimit() {
        if (Boolean.getBoolean(DISABLE_MAX_PROTOCOL_AUTO_OVERRIDE)) {
            return new StaticLimit(ProtocolVersion.MAX_SUPPORTED_VERSION);
        }
        int fromConfig = DatabaseDescriptor.getNativeProtocolMaxVersionOverride();
        return fromConfig != Integer.MIN_VALUE ? new StaticLimit(ProtocolVersion.decode(fromConfig, ProtocolVersionLimit.SERVER_DEFAULT)) : new DynamicLimit(ProtocolVersion.MAX_SUPPORTED_VERSION);
    }

    private static class DynamicLimit
    extends ConfiguredLimit {
        private volatile ProtocolVersion maxVersion;

        private DynamicLimit(ProtocolVersion initialLimit) {
            this.maxVersion = initialLimit;
            this.maybeUpdateVersion(true);
        }

        @Override
        public ProtocolVersion getMaxVersion() {
            return this.maxVersion;
        }

        @Override
        public void updateMaxSupportedVersion() {
            this.maybeUpdateVersion(false);
        }

        private void maybeUpdateVersion(boolean allowLowering) {
            boolean enforceV3Cap = SystemKeyspace.loadPeerVersions().values().stream().anyMatch(v -> v.compareTo(MIN_VERSION_FOR_V4) < 0);
            if (!enforceV3Cap) {
                this.maxVersion = ProtocolVersion.MAX_SUPPORTED_VERSION;
                return;
            }
            if (ProtocolVersion.V3.isSmallerThan(this.maxVersion) && !allowLowering) {
                logger.info("Detected peers which do not fully support protocol V4, but V4 was previously negotiable. Not enforcing cap as this can cause issues for older client versions. After the next restart the server will apply the cap");
                return;
            }
            logger.info("Detected peers which do not fully support protocol V4. Capping max negotiable version to V3");
            this.maxVersion = ProtocolVersion.V3;
        }
    }

    private static class StaticLimit
    extends ConfiguredLimit {
        private final ProtocolVersion maxVersion;

        private StaticLimit(ProtocolVersion maxVersion) {
            this.maxVersion = maxVersion;
            logger.info("Native transport max negotiable version statically limited to {}", (Object)maxVersion);
        }

        @Override
        public ProtocolVersion getMaxVersion() {
            return this.maxVersion;
        }

        @Override
        public void updateMaxSupportedVersion() {
        }
    }
}

