/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.monitoring;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproximateTime {
    private static final Logger logger = LoggerFactory.getLogger(ApproximateTime.class);
    private static final int CHECK_INTERVAL_MS = Math.max(5, Integer.valueOf(System.getProperty("cassandra.approximate_time_precision_ms", "10")));
    private static volatile long time = System.currentTimeMillis();

    public static long currentTimeMillis() {
        return time;
    }

    public static long precision() {
        return 2 * CHECK_INTERVAL_MS;
    }

    static {
        logger.info("Scheduling approximate time-check task with a precision of {} milliseconds", (Object)CHECK_INTERVAL_MS);
        ScheduledExecutors.scheduledFastTasks.scheduleWithFixedDelay(() -> {
            time = System.currentTimeMillis();
        }, CHECK_INTERVAL_MS, CHECK_INTERVAL_MS, TimeUnit.MILLISECONDS);
    }
}

