/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.FileDirectSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.security.EncryptionContext;
import org.apache.cassandra.security.EncryptionUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.SyncUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedSegment
extends FileDirectSegment {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedSegment.class);
    private static final int ENCRYPTED_SECTION_HEADER_SIZE = 12;
    private final EncryptionContext encryptionContext;
    private final Cipher cipher;

    public EncryptedSegment(CommitLog commitLog, EncryptionContext encryptionContext, Runnable onClose) {
        super(commitLog, onClose);
        this.encryptionContext = encryptionContext;
        try {
            this.cipher = encryptionContext.getEncryptor();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.logFile);
        }
        logger.debug("created a new encrypted commit log segment: {}", (Object)this.logFile);
    }

    @Override
    protected Map<String, String> additionalHeaderParameters() {
        Map<String, String> map = this.encryptionContext.toHeaderParameters();
        map.put("encIV", Hex.bytesToHex(this.cipher.getIV()));
        return map;
    }

    @Override
    ByteBuffer createBuffer(CommitLog commitLog) {
        return this.createBuffer(BufferType.ON_HEAP);
    }

    @Override
    void write(int startMarker, int nextMarker) {
        int contentStart;
        int length = nextMarker - contentStart;
        assert (length > 0 || length == 0 && !this.isStillAllocating());
        ICompressor compressor = this.encryptionContext.getCompressor();
        int blockSize = this.encryptionContext.getChunkLength();
        try {
            int nextBlockSize;
            ByteBuffer inputBuffer = this.buffer.duplicate();
            inputBuffer.limit(contentStart + length).position(contentStart);
            ByteBuffer buffer = (ByteBuffer)reusableBufferHolder.get();
            long syncMarkerPosition = this.lastWrittenPos;
            this.channel.position(syncMarkerPosition + 12L);
            for (contentStart = startMarker + 8; contentStart < nextMarker; contentStart += nextBlockSize) {
                nextBlockSize = nextMarker - blockSize > contentStart ? blockSize : nextMarker - contentStart;
                ByteBuffer slice = inputBuffer.duplicate();
                slice.limit(contentStart + nextBlockSize).position(contentStart);
                buffer = EncryptionUtils.compress(slice, buffer, true, compressor);
                buffer = EncryptionUtils.encryptAndWrite(buffer, this.channel, true, this.cipher);
                this.commitLog.allocator.addSize(buffer.limit() + 8);
            }
            this.lastWrittenPos = this.channel.position();
            buffer = ByteBufferUtil.ensureCapacity(buffer, 12, true);
            this.writeSyncMarker(buffer, 0, (int)syncMarkerPosition, (int)this.lastWrittenPos);
            buffer.putInt(8, length);
            buffer.position(0).limit(12);
            this.commitLog.allocator.addSize(buffer.limit());
            this.channel.position(syncMarkerPosition);
            this.channel.write(buffer);
            SyncUtil.force(this.channel, true);
            if (((ByteBuffer)reusableBufferHolder.get()).capacity() < buffer.capacity()) {
                reusableBufferHolder.set(buffer);
            }
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public long onDiskSize() {
        return this.lastWrittenPos;
    }
}

